/*
MIT License

Copyright (c) 2018 - 2024 Advanced Micro Devices, Inc. All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/* This file is generated by nnir2openvx.py on 2018-11-12T08:03:54.828545-08:00 */

#include "caffeModels.h"
#include <VX/vx_khr_nn.h>
#include <vx_amd_nn.h>
#include <vx_ext_amd.h>
#include <stdio.h>

#define ERROR_CHECK_OBJECT(obj) { vx_status status = vxGetStatus((vx_reference)(obj)); if(status != VX_SUCCESS) { vxAddLogEntry((vx_reference)context, status     , "ERROR: failed with status = (%d) at " __FILE__ "#%d\n", status, __LINE__); return status; } }
#define ERROR_CHECK_STATUS(call) { vx_status status = (call); if(status != VX_SUCCESS) { vxAddLogEntry((vx_reference)context, status, "ERROR: failed with status = (%d) at " __FILE__ "#%d\n", status, __LINE__); return status; } }

static vx_status initializeTensor(vx_context context, vx_tensor tensor, FILE * fp, const char * binaryFilename)
{
    vx_enum data_type = VX_TYPE_FLOAT32;
    vx_size num_of_dims = 4, dims[4] = { 1, 1, 1, 1 }, stride[4];
    ERROR_CHECK_STATUS(vxQueryTensor(tensor, VX_TENSOR_DATA_TYPE, &data_type, sizeof(vx_enum)));
    ERROR_CHECK_STATUS(vxQueryTensor(tensor, VX_TENSOR_NUMBER_OF_DIMS, &num_of_dims, sizeof(vx_size)));
    ERROR_CHECK_STATUS(vxQueryTensor(tensor, VX_TENSOR_DIMS, &dims, num_of_dims * sizeof(vx_size)));
    vx_size itemsize = sizeof(float);
    if(data_type == VX_TYPE_UINT8 || data_type == VX_TYPE_INT8) {
        itemsize = sizeof(vx_uint8);
    }
    else if(data_type == VX_TYPE_UINT16 || data_type == VX_TYPE_INT16 || data_type == VX_TYPE_FLOAT16) {
        itemsize = sizeof(vx_uint16);
    }
    vx_size count = dims[0] * dims[1] * dims[2] * dims[3];

    vx_uint32 h[2] = { 0 };
    fread(h, 1, sizeof(h), fp);
    if(h[0] != 0xf00dd1e1 || (vx_size)h[1] != (count*itemsize)) {
      vxAddLogEntry((vx_reference)tensor, VX_FAILURE, "ERROR: invalid data (magic,size)=(0x%x,%d) in %s at byte position %d -- expected size is %ld\n", h[0], h[1], binaryFilename, ftell(fp)-sizeof(h), count*itemsize);
      return VX_FAILURE;
    }

    vx_map_id map_id;
    void * ptr;
    ERROR_CHECK_STATUS(vxMapTensorPatch(tensor, num_of_dims, nullptr, nullptr, &map_id, stride, (void **)&ptr, VX_WRITE_ONLY, VX_MEMORY_TYPE_HOST));
    vx_size n = fread(ptr, itemsize, count, fp);
    if(n != count) {
        vxAddLogEntry((vx_reference)tensor, VX_FAILURE, "ERROR: expected char[%ld], but got char[%ld] in %s\n", count*itemsize, n*itemsize, binaryFilename);
        return VX_FAILURE;
    }
    ERROR_CHECK_STATUS(vxUnmapTensorPatch(tensor, map_id));

    return VX_SUCCESS;
}

VX_API_ENTRY vx_status VX_API_CALL annAddToGraph_inception(vx_graph graph, vx_tensor data, vx_tensor softmax_prob, const char * binaryFilename)
{
    vx_context context = vxGetContext((vx_reference)graph);
    ERROR_CHECK_OBJECT(context);

    // create variables
    vx_size dims_conv1_3x3_s2_w[4] = { 3, 3, 3, 32 };
    vx_tensor conv1_3x3_s2_w = vxCreateTensor(context, 4, dims_conv1_3x3_s2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv1_3x3_s2_w);
    vx_size dims_conv1_3x3_s2_bn_w[2] = { 32, 1 };
    vx_tensor conv1_3x3_s2_bn_w = vxCreateTensor(context, 2, dims_conv1_3x3_s2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv1_3x3_s2_bn_w);
    vx_size dims_conv1_3x3_s2_bn_b[2] = { 32, 1 };
    vx_tensor conv1_3x3_s2_bn_b = vxCreateTensor(context, 2, dims_conv1_3x3_s2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv1_3x3_s2_bn_b);
    vx_size dims_conv1_3x3_s2_scale_w[2] = { 32, 1 };
    vx_tensor conv1_3x3_s2_scale_w = vxCreateTensor(context, 2, dims_conv1_3x3_s2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv1_3x3_s2_scale_w);
    vx_size dims_conv1_3x3_s2_scale_b[2] = { 32, 1 };
    vx_tensor conv1_3x3_s2_scale_b = vxCreateTensor(context, 2, dims_conv1_3x3_s2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv1_3x3_s2_scale_b);
    vx_size dims_conv2_3x3_s1_w[4] = { 3, 3, 32, 32 };
    vx_tensor conv2_3x3_s1_w = vxCreateTensor(context, 4, dims_conv2_3x3_s1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv2_3x3_s1_w);
    vx_size dims_conv2_3x3_s1_bn_w[2] = { 32, 1 };
    vx_tensor conv2_3x3_s1_bn_w = vxCreateTensor(context, 2, dims_conv2_3x3_s1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv2_3x3_s1_bn_w);
    vx_size dims_conv2_3x3_s1_bn_b[2] = { 32, 1 };
    vx_tensor conv2_3x3_s1_bn_b = vxCreateTensor(context, 2, dims_conv2_3x3_s1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv2_3x3_s1_bn_b);
    vx_size dims_conv2_3x3_s1_scale_w[2] = { 32, 1 };
    vx_tensor conv2_3x3_s1_scale_w = vxCreateTensor(context, 2, dims_conv2_3x3_s1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv2_3x3_s1_scale_w);
    vx_size dims_conv2_3x3_s1_scale_b[2] = { 32, 1 };
    vx_tensor conv2_3x3_s1_scale_b = vxCreateTensor(context, 2, dims_conv2_3x3_s1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv2_3x3_s1_scale_b);
    vx_size dims_conv3_3x3_s1_w[4] = { 3, 3, 32, 64 };
    vx_tensor conv3_3x3_s1_w = vxCreateTensor(context, 4, dims_conv3_3x3_s1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv3_3x3_s1_w);
    vx_size dims_conv3_3x3_s1_bn_w[2] = { 64, 1 };
    vx_tensor conv3_3x3_s1_bn_w = vxCreateTensor(context, 2, dims_conv3_3x3_s1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv3_3x3_s1_bn_w);
    vx_size dims_conv3_3x3_s1_bn_b[2] = { 64, 1 };
    vx_tensor conv3_3x3_s1_bn_b = vxCreateTensor(context, 2, dims_conv3_3x3_s1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv3_3x3_s1_bn_b);
    vx_size dims_conv3_3x3_s1_scale_w[2] = { 64, 1 };
    vx_tensor conv3_3x3_s1_scale_w = vxCreateTensor(context, 2, dims_conv3_3x3_s1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv3_3x3_s1_scale_w);
    vx_size dims_conv3_3x3_s1_scale_b[2] = { 64, 1 };
    vx_tensor conv3_3x3_s1_scale_b = vxCreateTensor(context, 2, dims_conv3_3x3_s1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv3_3x3_s1_scale_b);
    vx_size dims_inception_stem1_3x3_s2_w[4] = { 3, 3, 64, 96 };
    vx_tensor inception_stem1_3x3_s2_w = vxCreateTensor(context, 4, dims_inception_stem1_3x3_s2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem1_3x3_s2_w);
    vx_size dims_inception_stem1_3x3_s2_bn_w[2] = { 96, 1 };
    vx_tensor inception_stem1_3x3_s2_bn_w = vxCreateTensor(context, 2, dims_inception_stem1_3x3_s2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem1_3x3_s2_bn_w);
    vx_size dims_inception_stem1_3x3_s2_bn_b[2] = { 96, 1 };
    vx_tensor inception_stem1_3x3_s2_bn_b = vxCreateTensor(context, 2, dims_inception_stem1_3x3_s2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem1_3x3_s2_bn_b);
    vx_size dims_inception_stem1_3x3_s2_scale_w[2] = { 96, 1 };
    vx_tensor inception_stem1_3x3_s2_scale_w = vxCreateTensor(context, 2, dims_inception_stem1_3x3_s2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem1_3x3_s2_scale_w);
    vx_size dims_inception_stem1_3x3_s2_scale_b[2] = { 96, 1 };
    vx_tensor inception_stem1_3x3_s2_scale_b = vxCreateTensor(context, 2, dims_inception_stem1_3x3_s2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem1_3x3_s2_scale_b);
    vx_size dims_inception_stem2_3x3_reduce_w[4] = { 1, 1, 160, 64 };
    vx_tensor inception_stem2_3x3_reduce_w = vxCreateTensor(context, 4, dims_inception_stem2_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_reduce_w);
    vx_size dims_inception_stem2_3x3_reduce_bn_w[2] = { 64, 1 };
    vx_tensor inception_stem2_3x3_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_stem2_3x3_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_reduce_bn_w);
    vx_size dims_inception_stem2_3x3_reduce_bn_b[2] = { 64, 1 };
    vx_tensor inception_stem2_3x3_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_stem2_3x3_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_reduce_bn_b);
    vx_size dims_inception_stem2_3x3_reduce_scale_w[2] = { 64, 1 };
    vx_tensor inception_stem2_3x3_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_stem2_3x3_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_reduce_scale_w);
    vx_size dims_inception_stem2_3x3_reduce_scale_b[2] = { 64, 1 };
    vx_tensor inception_stem2_3x3_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_stem2_3x3_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_reduce_scale_b);
    vx_size dims_inception_stem2_3x3_w[4] = { 3, 3, 64, 96 };
    vx_tensor inception_stem2_3x3_w = vxCreateTensor(context, 4, dims_inception_stem2_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_w);
    vx_size dims_inception_stem2_3x3_bn_w[2] = { 96, 1 };
    vx_tensor inception_stem2_3x3_bn_w = vxCreateTensor(context, 2, dims_inception_stem2_3x3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_bn_w);
    vx_size dims_inception_stem2_3x3_bn_b[2] = { 96, 1 };
    vx_tensor inception_stem2_3x3_bn_b = vxCreateTensor(context, 2, dims_inception_stem2_3x3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_bn_b);
    vx_size dims_inception_stem2_3x3_scale_w[2] = { 96, 1 };
    vx_tensor inception_stem2_3x3_scale_w = vxCreateTensor(context, 2, dims_inception_stem2_3x3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_scale_w);
    vx_size dims_inception_stem2_3x3_scale_b[2] = { 96, 1 };
    vx_tensor inception_stem2_3x3_scale_b = vxCreateTensor(context, 2, dims_inception_stem2_3x3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_scale_b);
    vx_size dims_inception_stem2_1x7_reduce_w[4] = { 1, 1, 160, 64 };
    vx_tensor inception_stem2_1x7_reduce_w = vxCreateTensor(context, 4, dims_inception_stem2_1x7_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_1x7_reduce_w);
    vx_size dims_inception_stem2_1x7_reduce_bn_w[2] = { 64, 1 };
    vx_tensor inception_stem2_1x7_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_stem2_1x7_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_1x7_reduce_bn_w);
    vx_size dims_inception_stem2_1x7_reduce_bn_b[2] = { 64, 1 };
    vx_tensor inception_stem2_1x7_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_stem2_1x7_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_1x7_reduce_bn_b);
    vx_size dims_inception_stem2_1x7_reduce_scale_w[2] = { 64, 1 };
    vx_tensor inception_stem2_1x7_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_stem2_1x7_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_1x7_reduce_scale_w);
    vx_size dims_inception_stem2_1x7_reduce_scale_b[2] = { 64, 1 };
    vx_tensor inception_stem2_1x7_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_stem2_1x7_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_1x7_reduce_scale_b);
    vx_size dims_inception_stem2_1x7_w[4] = { 7, 1, 64, 64 };
    vx_tensor inception_stem2_1x7_w = vxCreateTensor(context, 4, dims_inception_stem2_1x7_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_1x7_w);
    vx_size dims_inception_stem2_1x7_bn_w[2] = { 64, 1 };
    vx_tensor inception_stem2_1x7_bn_w = vxCreateTensor(context, 2, dims_inception_stem2_1x7_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_1x7_bn_w);
    vx_size dims_inception_stem2_1x7_bn_b[2] = { 64, 1 };
    vx_tensor inception_stem2_1x7_bn_b = vxCreateTensor(context, 2, dims_inception_stem2_1x7_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_1x7_bn_b);
    vx_size dims_inception_stem2_1x7_scale_w[2] = { 64, 1 };
    vx_tensor inception_stem2_1x7_scale_w = vxCreateTensor(context, 2, dims_inception_stem2_1x7_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_1x7_scale_w);
    vx_size dims_inception_stem2_1x7_scale_b[2] = { 64, 1 };
    vx_tensor inception_stem2_1x7_scale_b = vxCreateTensor(context, 2, dims_inception_stem2_1x7_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_1x7_scale_b);
    vx_size dims_inception_stem2_7x1_w[4] = { 1, 7, 64, 64 };
    vx_tensor inception_stem2_7x1_w = vxCreateTensor(context, 4, dims_inception_stem2_7x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_7x1_w);
    vx_size dims_inception_stem2_7x1_bn_w[2] = { 64, 1 };
    vx_tensor inception_stem2_7x1_bn_w = vxCreateTensor(context, 2, dims_inception_stem2_7x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_7x1_bn_w);
    vx_size dims_inception_stem2_7x1_bn_b[2] = { 64, 1 };
    vx_tensor inception_stem2_7x1_bn_b = vxCreateTensor(context, 2, dims_inception_stem2_7x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_7x1_bn_b);
    vx_size dims_inception_stem2_7x1_scale_w[2] = { 64, 1 };
    vx_tensor inception_stem2_7x1_scale_w = vxCreateTensor(context, 2, dims_inception_stem2_7x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_7x1_scale_w);
    vx_size dims_inception_stem2_7x1_scale_b[2] = { 64, 1 };
    vx_tensor inception_stem2_7x1_scale_b = vxCreateTensor(context, 2, dims_inception_stem2_7x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_7x1_scale_b);
    vx_size dims_inception_stem2_3x3_2_w[4] = { 3, 3, 64, 96 };
    vx_tensor inception_stem2_3x3_2_w = vxCreateTensor(context, 4, dims_inception_stem2_3x3_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_2_w);
    vx_size dims_inception_stem2_3x3_2_bn_w[2] = { 96, 1 };
    vx_tensor inception_stem2_3x3_2_bn_w = vxCreateTensor(context, 2, dims_inception_stem2_3x3_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_2_bn_w);
    vx_size dims_inception_stem2_3x3_2_bn_b[2] = { 96, 1 };
    vx_tensor inception_stem2_3x3_2_bn_b = vxCreateTensor(context, 2, dims_inception_stem2_3x3_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_2_bn_b);
    vx_size dims_inception_stem2_3x3_2_scale_w[2] = { 96, 1 };
    vx_tensor inception_stem2_3x3_2_scale_w = vxCreateTensor(context, 2, dims_inception_stem2_3x3_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_2_scale_w);
    vx_size dims_inception_stem2_3x3_2_scale_b[2] = { 96, 1 };
    vx_tensor inception_stem2_3x3_2_scale_b = vxCreateTensor(context, 2, dims_inception_stem2_3x3_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem2_3x3_2_scale_b);
    vx_size dims_inception_stem3_3x3_s2_w[4] = { 3, 3, 192, 192 };
    vx_tensor inception_stem3_3x3_s2_w = vxCreateTensor(context, 4, dims_inception_stem3_3x3_s2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem3_3x3_s2_w);
    vx_size dims_inception_stem3_3x3_s2_bn_w[2] = { 192, 1 };
    vx_tensor inception_stem3_3x3_s2_bn_w = vxCreateTensor(context, 2, dims_inception_stem3_3x3_s2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem3_3x3_s2_bn_w);
    vx_size dims_inception_stem3_3x3_s2_bn_b[2] = { 192, 1 };
    vx_tensor inception_stem3_3x3_s2_bn_b = vxCreateTensor(context, 2, dims_inception_stem3_3x3_s2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem3_3x3_s2_bn_b);
    vx_size dims_inception_stem3_3x3_s2_scale_w[2] = { 192, 1 };
    vx_tensor inception_stem3_3x3_s2_scale_w = vxCreateTensor(context, 2, dims_inception_stem3_3x3_s2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem3_3x3_s2_scale_w);
    vx_size dims_inception_stem3_3x3_s2_scale_b[2] = { 192, 1 };
    vx_tensor inception_stem3_3x3_s2_scale_b = vxCreateTensor(context, 2, dims_inception_stem3_3x3_s2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_stem3_3x3_s2_scale_b);
    vx_size dims_inception_a1_1x1_2_w[4] = { 1, 1, 384, 96 };
    vx_tensor inception_a1_1x1_2_w = vxCreateTensor(context, 4, dims_inception_a1_1x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_1x1_2_w);
    vx_size dims_inception_a1_1x1_2_bn_w[2] = { 96, 1 };
    vx_tensor inception_a1_1x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_a1_1x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_1x1_2_bn_w);
    vx_size dims_inception_a1_1x1_2_bn_b[2] = { 96, 1 };
    vx_tensor inception_a1_1x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_a1_1x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_1x1_2_bn_b);
    vx_size dims_inception_a1_1x1_2_scale_w[2] = { 96, 1 };
    vx_tensor inception_a1_1x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_a1_1x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_1x1_2_scale_w);
    vx_size dims_inception_a1_1x1_2_scale_b[2] = { 96, 1 };
    vx_tensor inception_a1_1x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_a1_1x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_1x1_2_scale_b);
    vx_size dims_inception_a1_3x3_reduce_w[4] = { 1, 1, 384, 64 };
    vx_tensor inception_a1_3x3_reduce_w = vxCreateTensor(context, 4, dims_inception_a1_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_reduce_w);
    vx_size dims_inception_a1_3x3_reduce_bn_w[2] = { 64, 1 };
    vx_tensor inception_a1_3x3_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_a1_3x3_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_reduce_bn_w);
    vx_size dims_inception_a1_3x3_reduce_bn_b[2] = { 64, 1 };
    vx_tensor inception_a1_3x3_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_a1_3x3_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_reduce_bn_b);
    vx_size dims_inception_a1_3x3_reduce_scale_w[2] = { 64, 1 };
    vx_tensor inception_a1_3x3_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_a1_3x3_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_reduce_scale_w);
    vx_size dims_inception_a1_3x3_reduce_scale_b[2] = { 64, 1 };
    vx_tensor inception_a1_3x3_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_a1_3x3_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_reduce_scale_b);
    vx_size dims_inception_a1_3x3_w[4] = { 3, 3, 64, 96 };
    vx_tensor inception_a1_3x3_w = vxCreateTensor(context, 4, dims_inception_a1_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_w);
    vx_size dims_inception_a1_3x3_bn_w[2] = { 96, 1 };
    vx_tensor inception_a1_3x3_bn_w = vxCreateTensor(context, 2, dims_inception_a1_3x3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_bn_w);
    vx_size dims_inception_a1_3x3_bn_b[2] = { 96, 1 };
    vx_tensor inception_a1_3x3_bn_b = vxCreateTensor(context, 2, dims_inception_a1_3x3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_bn_b);
    vx_size dims_inception_a1_3x3_scale_w[2] = { 96, 1 };
    vx_tensor inception_a1_3x3_scale_w = vxCreateTensor(context, 2, dims_inception_a1_3x3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_scale_w);
    vx_size dims_inception_a1_3x3_scale_b[2] = { 96, 1 };
    vx_tensor inception_a1_3x3_scale_b = vxCreateTensor(context, 2, dims_inception_a1_3x3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_scale_b);
    vx_size dims_inception_a1_3x3_2_reduce_w[4] = { 1, 1, 384, 64 };
    vx_tensor inception_a1_3x3_2_reduce_w = vxCreateTensor(context, 4, dims_inception_a1_3x3_2_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_2_reduce_w);
    vx_size dims_inception_a1_3x3_2_reduce_bn_w[2] = { 64, 1 };
    vx_tensor inception_a1_3x3_2_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_a1_3x3_2_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_2_reduce_bn_w);
    vx_size dims_inception_a1_3x3_2_reduce_bn_b[2] = { 64, 1 };
    vx_tensor inception_a1_3x3_2_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_a1_3x3_2_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_2_reduce_bn_b);
    vx_size dims_inception_a1_3x3_2_reduce_scale_w[2] = { 64, 1 };
    vx_tensor inception_a1_3x3_2_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_a1_3x3_2_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_2_reduce_scale_w);
    vx_size dims_inception_a1_3x3_2_reduce_scale_b[2] = { 64, 1 };
    vx_tensor inception_a1_3x3_2_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_a1_3x3_2_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_2_reduce_scale_b);
    vx_size dims_inception_a1_3x3_2_w[4] = { 3, 3, 64, 96 };
    vx_tensor inception_a1_3x3_2_w = vxCreateTensor(context, 4, dims_inception_a1_3x3_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_2_w);
    vx_size dims_inception_a1_3x3_2_bn_w[2] = { 96, 1 };
    vx_tensor inception_a1_3x3_2_bn_w = vxCreateTensor(context, 2, dims_inception_a1_3x3_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_2_bn_w);
    vx_size dims_inception_a1_3x3_2_bn_b[2] = { 96, 1 };
    vx_tensor inception_a1_3x3_2_bn_b = vxCreateTensor(context, 2, dims_inception_a1_3x3_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_2_bn_b);
    vx_size dims_inception_a1_3x3_2_scale_w[2] = { 96, 1 };
    vx_tensor inception_a1_3x3_2_scale_w = vxCreateTensor(context, 2, dims_inception_a1_3x3_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_2_scale_w);
    vx_size dims_inception_a1_3x3_2_scale_b[2] = { 96, 1 };
    vx_tensor inception_a1_3x3_2_scale_b = vxCreateTensor(context, 2, dims_inception_a1_3x3_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_2_scale_b);
    vx_size dims_inception_a1_3x3_3_w[4] = { 3, 3, 96, 96 };
    vx_tensor inception_a1_3x3_3_w = vxCreateTensor(context, 4, dims_inception_a1_3x3_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_3_w);
    vx_size dims_inception_a1_3x3_3_bn_w[2] = { 96, 1 };
    vx_tensor inception_a1_3x3_3_bn_w = vxCreateTensor(context, 2, dims_inception_a1_3x3_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_3_bn_w);
    vx_size dims_inception_a1_3x3_3_bn_b[2] = { 96, 1 };
    vx_tensor inception_a1_3x3_3_bn_b = vxCreateTensor(context, 2, dims_inception_a1_3x3_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_3_bn_b);
    vx_size dims_inception_a1_3x3_3_scale_w[2] = { 96, 1 };
    vx_tensor inception_a1_3x3_3_scale_w = vxCreateTensor(context, 2, dims_inception_a1_3x3_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_3_scale_w);
    vx_size dims_inception_a1_3x3_3_scale_b[2] = { 96, 1 };
    vx_tensor inception_a1_3x3_3_scale_b = vxCreateTensor(context, 2, dims_inception_a1_3x3_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_3x3_3_scale_b);
    vx_size dims_inception_a1_1x1_w[4] = { 1, 1, 384, 96 };
    vx_tensor inception_a1_1x1_w = vxCreateTensor(context, 4, dims_inception_a1_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_1x1_w);
    vx_size dims_inception_a1_1x1_bn_w[2] = { 96, 1 };
    vx_tensor inception_a1_1x1_bn_w = vxCreateTensor(context, 2, dims_inception_a1_1x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_1x1_bn_w);
    vx_size dims_inception_a1_1x1_bn_b[2] = { 96, 1 };
    vx_tensor inception_a1_1x1_bn_b = vxCreateTensor(context, 2, dims_inception_a1_1x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_1x1_bn_b);
    vx_size dims_inception_a1_1x1_scale_w[2] = { 96, 1 };
    vx_tensor inception_a1_1x1_scale_w = vxCreateTensor(context, 2, dims_inception_a1_1x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_1x1_scale_w);
    vx_size dims_inception_a1_1x1_scale_b[2] = { 96, 1 };
    vx_tensor inception_a1_1x1_scale_b = vxCreateTensor(context, 2, dims_inception_a1_1x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a1_1x1_scale_b);
    vx_size dims_inception_a2_1x1_2_w[4] = { 1, 1, 384, 96 };
    vx_tensor inception_a2_1x1_2_w = vxCreateTensor(context, 4, dims_inception_a2_1x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_1x1_2_w);
    vx_size dims_inception_a2_1x1_2_bn_w[2] = { 96, 1 };
    vx_tensor inception_a2_1x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_a2_1x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_1x1_2_bn_w);
    vx_size dims_inception_a2_1x1_2_bn_b[2] = { 96, 1 };
    vx_tensor inception_a2_1x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_a2_1x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_1x1_2_bn_b);
    vx_size dims_inception_a2_1x1_2_scale_w[2] = { 96, 1 };
    vx_tensor inception_a2_1x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_a2_1x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_1x1_2_scale_w);
    vx_size dims_inception_a2_1x1_2_scale_b[2] = { 96, 1 };
    vx_tensor inception_a2_1x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_a2_1x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_1x1_2_scale_b);
    vx_size dims_inception_a2_3x3_reduce_w[4] = { 1, 1, 384, 64 };
    vx_tensor inception_a2_3x3_reduce_w = vxCreateTensor(context, 4, dims_inception_a2_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_reduce_w);
    vx_size dims_inception_a2_3x3_reduce_bn_w[2] = { 64, 1 };
    vx_tensor inception_a2_3x3_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_a2_3x3_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_reduce_bn_w);
    vx_size dims_inception_a2_3x3_reduce_bn_b[2] = { 64, 1 };
    vx_tensor inception_a2_3x3_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_a2_3x3_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_reduce_bn_b);
    vx_size dims_inception_a2_3x3_reduce_scale_w[2] = { 64, 1 };
    vx_tensor inception_a2_3x3_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_a2_3x3_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_reduce_scale_w);
    vx_size dims_inception_a2_3x3_reduce_scale_b[2] = { 64, 1 };
    vx_tensor inception_a2_3x3_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_a2_3x3_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_reduce_scale_b);
    vx_size dims_inception_a2_3x3_w[4] = { 3, 3, 64, 96 };
    vx_tensor inception_a2_3x3_w = vxCreateTensor(context, 4, dims_inception_a2_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_w);
    vx_size dims_inception_a2_3x3_bn_w[2] = { 96, 1 };
    vx_tensor inception_a2_3x3_bn_w = vxCreateTensor(context, 2, dims_inception_a2_3x3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_bn_w);
    vx_size dims_inception_a2_3x3_bn_b[2] = { 96, 1 };
    vx_tensor inception_a2_3x3_bn_b = vxCreateTensor(context, 2, dims_inception_a2_3x3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_bn_b);
    vx_size dims_inception_a2_3x3_scale_w[2] = { 96, 1 };
    vx_tensor inception_a2_3x3_scale_w = vxCreateTensor(context, 2, dims_inception_a2_3x3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_scale_w);
    vx_size dims_inception_a2_3x3_scale_b[2] = { 96, 1 };
    vx_tensor inception_a2_3x3_scale_b = vxCreateTensor(context, 2, dims_inception_a2_3x3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_scale_b);
    vx_size dims_inception_a2_3x3_2_reduce_w[4] = { 1, 1, 384, 64 };
    vx_tensor inception_a2_3x3_2_reduce_w = vxCreateTensor(context, 4, dims_inception_a2_3x3_2_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_2_reduce_w);
    vx_size dims_inception_a2_3x3_2_reduce_bn_w[2] = { 64, 1 };
    vx_tensor inception_a2_3x3_2_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_a2_3x3_2_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_2_reduce_bn_w);
    vx_size dims_inception_a2_3x3_2_reduce_bn_b[2] = { 64, 1 };
    vx_tensor inception_a2_3x3_2_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_a2_3x3_2_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_2_reduce_bn_b);
    vx_size dims_inception_a2_3x3_2_reduce_scale_w[2] = { 64, 1 };
    vx_tensor inception_a2_3x3_2_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_a2_3x3_2_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_2_reduce_scale_w);
    vx_size dims_inception_a2_3x3_2_reduce_scale_b[2] = { 64, 1 };
    vx_tensor inception_a2_3x3_2_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_a2_3x3_2_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_2_reduce_scale_b);
    vx_size dims_inception_a2_3x3_2_w[4] = { 3, 3, 64, 96 };
    vx_tensor inception_a2_3x3_2_w = vxCreateTensor(context, 4, dims_inception_a2_3x3_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_2_w);
    vx_size dims_inception_a2_3x3_2_bn_w[2] = { 96, 1 };
    vx_tensor inception_a2_3x3_2_bn_w = vxCreateTensor(context, 2, dims_inception_a2_3x3_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_2_bn_w);
    vx_size dims_inception_a2_3x3_2_bn_b[2] = { 96, 1 };
    vx_tensor inception_a2_3x3_2_bn_b = vxCreateTensor(context, 2, dims_inception_a2_3x3_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_2_bn_b);
    vx_size dims_inception_a2_3x3_2_scale_w[2] = { 96, 1 };
    vx_tensor inception_a2_3x3_2_scale_w = vxCreateTensor(context, 2, dims_inception_a2_3x3_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_2_scale_w);
    vx_size dims_inception_a2_3x3_2_scale_b[2] = { 96, 1 };
    vx_tensor inception_a2_3x3_2_scale_b = vxCreateTensor(context, 2, dims_inception_a2_3x3_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_2_scale_b);
    vx_size dims_inception_a2_3x3_3_w[4] = { 3, 3, 96, 96 };
    vx_tensor inception_a2_3x3_3_w = vxCreateTensor(context, 4, dims_inception_a2_3x3_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_3_w);
    vx_size dims_inception_a2_3x3_3_bn_w[2] = { 96, 1 };
    vx_tensor inception_a2_3x3_3_bn_w = vxCreateTensor(context, 2, dims_inception_a2_3x3_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_3_bn_w);
    vx_size dims_inception_a2_3x3_3_bn_b[2] = { 96, 1 };
    vx_tensor inception_a2_3x3_3_bn_b = vxCreateTensor(context, 2, dims_inception_a2_3x3_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_3_bn_b);
    vx_size dims_inception_a2_3x3_3_scale_w[2] = { 96, 1 };
    vx_tensor inception_a2_3x3_3_scale_w = vxCreateTensor(context, 2, dims_inception_a2_3x3_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_3_scale_w);
    vx_size dims_inception_a2_3x3_3_scale_b[2] = { 96, 1 };
    vx_tensor inception_a2_3x3_3_scale_b = vxCreateTensor(context, 2, dims_inception_a2_3x3_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_3x3_3_scale_b);
    vx_size dims_inception_a2_1x1_w[4] = { 1, 1, 384, 96 };
    vx_tensor inception_a2_1x1_w = vxCreateTensor(context, 4, dims_inception_a2_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_1x1_w);
    vx_size dims_inception_a2_1x1_bn_w[2] = { 96, 1 };
    vx_tensor inception_a2_1x1_bn_w = vxCreateTensor(context, 2, dims_inception_a2_1x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_1x1_bn_w);
    vx_size dims_inception_a2_1x1_bn_b[2] = { 96, 1 };
    vx_tensor inception_a2_1x1_bn_b = vxCreateTensor(context, 2, dims_inception_a2_1x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_1x1_bn_b);
    vx_size dims_inception_a2_1x1_scale_w[2] = { 96, 1 };
    vx_tensor inception_a2_1x1_scale_w = vxCreateTensor(context, 2, dims_inception_a2_1x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_1x1_scale_w);
    vx_size dims_inception_a2_1x1_scale_b[2] = { 96, 1 };
    vx_tensor inception_a2_1x1_scale_b = vxCreateTensor(context, 2, dims_inception_a2_1x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a2_1x1_scale_b);
    vx_size dims_inception_a3_1x1_2_w[4] = { 1, 1, 384, 96 };
    vx_tensor inception_a3_1x1_2_w = vxCreateTensor(context, 4, dims_inception_a3_1x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_1x1_2_w);
    vx_size dims_inception_a3_1x1_2_bn_w[2] = { 96, 1 };
    vx_tensor inception_a3_1x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_a3_1x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_1x1_2_bn_w);
    vx_size dims_inception_a3_1x1_2_bn_b[2] = { 96, 1 };
    vx_tensor inception_a3_1x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_a3_1x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_1x1_2_bn_b);
    vx_size dims_inception_a3_1x1_2_scale_w[2] = { 96, 1 };
    vx_tensor inception_a3_1x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_a3_1x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_1x1_2_scale_w);
    vx_size dims_inception_a3_1x1_2_scale_b[2] = { 96, 1 };
    vx_tensor inception_a3_1x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_a3_1x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_1x1_2_scale_b);
    vx_size dims_inception_a3_3x3_reduce_w[4] = { 1, 1, 384, 64 };
    vx_tensor inception_a3_3x3_reduce_w = vxCreateTensor(context, 4, dims_inception_a3_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_reduce_w);
    vx_size dims_inception_a3_3x3_reduce_bn_w[2] = { 64, 1 };
    vx_tensor inception_a3_3x3_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_a3_3x3_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_reduce_bn_w);
    vx_size dims_inception_a3_3x3_reduce_bn_b[2] = { 64, 1 };
    vx_tensor inception_a3_3x3_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_a3_3x3_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_reduce_bn_b);
    vx_size dims_inception_a3_3x3_reduce_scale_w[2] = { 64, 1 };
    vx_tensor inception_a3_3x3_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_a3_3x3_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_reduce_scale_w);
    vx_size dims_inception_a3_3x3_reduce_scale_b[2] = { 64, 1 };
    vx_tensor inception_a3_3x3_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_a3_3x3_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_reduce_scale_b);
    vx_size dims_inception_a3_3x3_w[4] = { 3, 3, 64, 96 };
    vx_tensor inception_a3_3x3_w = vxCreateTensor(context, 4, dims_inception_a3_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_w);
    vx_size dims_inception_a3_3x3_bn_w[2] = { 96, 1 };
    vx_tensor inception_a3_3x3_bn_w = vxCreateTensor(context, 2, dims_inception_a3_3x3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_bn_w);
    vx_size dims_inception_a3_3x3_bn_b[2] = { 96, 1 };
    vx_tensor inception_a3_3x3_bn_b = vxCreateTensor(context, 2, dims_inception_a3_3x3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_bn_b);
    vx_size dims_inception_a3_3x3_scale_w[2] = { 96, 1 };
    vx_tensor inception_a3_3x3_scale_w = vxCreateTensor(context, 2, dims_inception_a3_3x3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_scale_w);
    vx_size dims_inception_a3_3x3_scale_b[2] = { 96, 1 };
    vx_tensor inception_a3_3x3_scale_b = vxCreateTensor(context, 2, dims_inception_a3_3x3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_scale_b);
    vx_size dims_inception_a3_3x3_2_reduce_w[4] = { 1, 1, 384, 64 };
    vx_tensor inception_a3_3x3_2_reduce_w = vxCreateTensor(context, 4, dims_inception_a3_3x3_2_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_2_reduce_w);
    vx_size dims_inception_a3_3x3_2_reduce_bn_w[2] = { 64, 1 };
    vx_tensor inception_a3_3x3_2_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_a3_3x3_2_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_2_reduce_bn_w);
    vx_size dims_inception_a3_3x3_2_reduce_bn_b[2] = { 64, 1 };
    vx_tensor inception_a3_3x3_2_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_a3_3x3_2_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_2_reduce_bn_b);
    vx_size dims_inception_a3_3x3_2_reduce_scale_w[2] = { 64, 1 };
    vx_tensor inception_a3_3x3_2_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_a3_3x3_2_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_2_reduce_scale_w);
    vx_size dims_inception_a3_3x3_2_reduce_scale_b[2] = { 64, 1 };
    vx_tensor inception_a3_3x3_2_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_a3_3x3_2_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_2_reduce_scale_b);
    vx_size dims_inception_a3_3x3_2_w[4] = { 3, 3, 64, 96 };
    vx_tensor inception_a3_3x3_2_w = vxCreateTensor(context, 4, dims_inception_a3_3x3_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_2_w);
    vx_size dims_inception_a3_3x3_2_bn_w[2] = { 96, 1 };
    vx_tensor inception_a3_3x3_2_bn_w = vxCreateTensor(context, 2, dims_inception_a3_3x3_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_2_bn_w);
    vx_size dims_inception_a3_3x3_2_bn_b[2] = { 96, 1 };
    vx_tensor inception_a3_3x3_2_bn_b = vxCreateTensor(context, 2, dims_inception_a3_3x3_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_2_bn_b);
    vx_size dims_inception_a3_3x3_2_scale_w[2] = { 96, 1 };
    vx_tensor inception_a3_3x3_2_scale_w = vxCreateTensor(context, 2, dims_inception_a3_3x3_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_2_scale_w);
    vx_size dims_inception_a3_3x3_2_scale_b[2] = { 96, 1 };
    vx_tensor inception_a3_3x3_2_scale_b = vxCreateTensor(context, 2, dims_inception_a3_3x3_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_2_scale_b);
    vx_size dims_inception_a3_3x3_3_w[4] = { 3, 3, 96, 96 };
    vx_tensor inception_a3_3x3_3_w = vxCreateTensor(context, 4, dims_inception_a3_3x3_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_3_w);
    vx_size dims_inception_a3_3x3_3_bn_w[2] = { 96, 1 };
    vx_tensor inception_a3_3x3_3_bn_w = vxCreateTensor(context, 2, dims_inception_a3_3x3_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_3_bn_w);
    vx_size dims_inception_a3_3x3_3_bn_b[2] = { 96, 1 };
    vx_tensor inception_a3_3x3_3_bn_b = vxCreateTensor(context, 2, dims_inception_a3_3x3_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_3_bn_b);
    vx_size dims_inception_a3_3x3_3_scale_w[2] = { 96, 1 };
    vx_tensor inception_a3_3x3_3_scale_w = vxCreateTensor(context, 2, dims_inception_a3_3x3_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_3_scale_w);
    vx_size dims_inception_a3_3x3_3_scale_b[2] = { 96, 1 };
    vx_tensor inception_a3_3x3_3_scale_b = vxCreateTensor(context, 2, dims_inception_a3_3x3_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_3x3_3_scale_b);
    vx_size dims_inception_a3_1x1_w[4] = { 1, 1, 384, 96 };
    vx_tensor inception_a3_1x1_w = vxCreateTensor(context, 4, dims_inception_a3_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_1x1_w);
    vx_size dims_inception_a3_1x1_bn_w[2] = { 96, 1 };
    vx_tensor inception_a3_1x1_bn_w = vxCreateTensor(context, 2, dims_inception_a3_1x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_1x1_bn_w);
    vx_size dims_inception_a3_1x1_bn_b[2] = { 96, 1 };
    vx_tensor inception_a3_1x1_bn_b = vxCreateTensor(context, 2, dims_inception_a3_1x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_1x1_bn_b);
    vx_size dims_inception_a3_1x1_scale_w[2] = { 96, 1 };
    vx_tensor inception_a3_1x1_scale_w = vxCreateTensor(context, 2, dims_inception_a3_1x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_1x1_scale_w);
    vx_size dims_inception_a3_1x1_scale_b[2] = { 96, 1 };
    vx_tensor inception_a3_1x1_scale_b = vxCreateTensor(context, 2, dims_inception_a3_1x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a3_1x1_scale_b);
    vx_size dims_inception_a4_1x1_2_w[4] = { 1, 1, 384, 96 };
    vx_tensor inception_a4_1x1_2_w = vxCreateTensor(context, 4, dims_inception_a4_1x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_1x1_2_w);
    vx_size dims_inception_a4_1x1_2_bn_w[2] = { 96, 1 };
    vx_tensor inception_a4_1x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_a4_1x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_1x1_2_bn_w);
    vx_size dims_inception_a4_1x1_2_bn_b[2] = { 96, 1 };
    vx_tensor inception_a4_1x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_a4_1x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_1x1_2_bn_b);
    vx_size dims_inception_a4_1x1_2_scale_w[2] = { 96, 1 };
    vx_tensor inception_a4_1x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_a4_1x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_1x1_2_scale_w);
    vx_size dims_inception_a4_1x1_2_scale_b[2] = { 96, 1 };
    vx_tensor inception_a4_1x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_a4_1x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_1x1_2_scale_b);
    vx_size dims_inception_a4_3x3_reduce_w[4] = { 1, 1, 384, 64 };
    vx_tensor inception_a4_3x3_reduce_w = vxCreateTensor(context, 4, dims_inception_a4_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_reduce_w);
    vx_size dims_inception_a4_3x3_reduce_bn_w[2] = { 64, 1 };
    vx_tensor inception_a4_3x3_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_a4_3x3_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_reduce_bn_w);
    vx_size dims_inception_a4_3x3_reduce_bn_b[2] = { 64, 1 };
    vx_tensor inception_a4_3x3_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_a4_3x3_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_reduce_bn_b);
    vx_size dims_inception_a4_3x3_reduce_scale_w[2] = { 64, 1 };
    vx_tensor inception_a4_3x3_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_a4_3x3_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_reduce_scale_w);
    vx_size dims_inception_a4_3x3_reduce_scale_b[2] = { 64, 1 };
    vx_tensor inception_a4_3x3_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_a4_3x3_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_reduce_scale_b);
    vx_size dims_inception_a4_3x3_w[4] = { 3, 3, 64, 96 };
    vx_tensor inception_a4_3x3_w = vxCreateTensor(context, 4, dims_inception_a4_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_w);
    vx_size dims_inception_a4_3x3_bn_w[2] = { 96, 1 };
    vx_tensor inception_a4_3x3_bn_w = vxCreateTensor(context, 2, dims_inception_a4_3x3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_bn_w);
    vx_size dims_inception_a4_3x3_bn_b[2] = { 96, 1 };
    vx_tensor inception_a4_3x3_bn_b = vxCreateTensor(context, 2, dims_inception_a4_3x3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_bn_b);
    vx_size dims_inception_a4_3x3_scale_w[2] = { 96, 1 };
    vx_tensor inception_a4_3x3_scale_w = vxCreateTensor(context, 2, dims_inception_a4_3x3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_scale_w);
    vx_size dims_inception_a4_3x3_scale_b[2] = { 96, 1 };
    vx_tensor inception_a4_3x3_scale_b = vxCreateTensor(context, 2, dims_inception_a4_3x3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_scale_b);
    vx_size dims_inception_a4_3x3_2_reduce_w[4] = { 1, 1, 384, 64 };
    vx_tensor inception_a4_3x3_2_reduce_w = vxCreateTensor(context, 4, dims_inception_a4_3x3_2_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_2_reduce_w);
    vx_size dims_inception_a4_3x3_2_reduce_bn_w[2] = { 64, 1 };
    vx_tensor inception_a4_3x3_2_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_a4_3x3_2_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_2_reduce_bn_w);
    vx_size dims_inception_a4_3x3_2_reduce_bn_b[2] = { 64, 1 };
    vx_tensor inception_a4_3x3_2_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_a4_3x3_2_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_2_reduce_bn_b);
    vx_size dims_inception_a4_3x3_2_reduce_scale_w[2] = { 64, 1 };
    vx_tensor inception_a4_3x3_2_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_a4_3x3_2_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_2_reduce_scale_w);
    vx_size dims_inception_a4_3x3_2_reduce_scale_b[2] = { 64, 1 };
    vx_tensor inception_a4_3x3_2_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_a4_3x3_2_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_2_reduce_scale_b);
    vx_size dims_inception_a4_3x3_2_w[4] = { 3, 3, 64, 96 };
    vx_tensor inception_a4_3x3_2_w = vxCreateTensor(context, 4, dims_inception_a4_3x3_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_2_w);
    vx_size dims_inception_a4_3x3_2_bn_w[2] = { 96, 1 };
    vx_tensor inception_a4_3x3_2_bn_w = vxCreateTensor(context, 2, dims_inception_a4_3x3_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_2_bn_w);
    vx_size dims_inception_a4_3x3_2_bn_b[2] = { 96, 1 };
    vx_tensor inception_a4_3x3_2_bn_b = vxCreateTensor(context, 2, dims_inception_a4_3x3_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_2_bn_b);
    vx_size dims_inception_a4_3x3_2_scale_w[2] = { 96, 1 };
    vx_tensor inception_a4_3x3_2_scale_w = vxCreateTensor(context, 2, dims_inception_a4_3x3_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_2_scale_w);
    vx_size dims_inception_a4_3x3_2_scale_b[2] = { 96, 1 };
    vx_tensor inception_a4_3x3_2_scale_b = vxCreateTensor(context, 2, dims_inception_a4_3x3_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_2_scale_b);
    vx_size dims_inception_a4_3x3_3_w[4] = { 3, 3, 96, 96 };
    vx_tensor inception_a4_3x3_3_w = vxCreateTensor(context, 4, dims_inception_a4_3x3_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_3_w);
    vx_size dims_inception_a4_3x3_3_bn_w[2] = { 96, 1 };
    vx_tensor inception_a4_3x3_3_bn_w = vxCreateTensor(context, 2, dims_inception_a4_3x3_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_3_bn_w);
    vx_size dims_inception_a4_3x3_3_bn_b[2] = { 96, 1 };
    vx_tensor inception_a4_3x3_3_bn_b = vxCreateTensor(context, 2, dims_inception_a4_3x3_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_3_bn_b);
    vx_size dims_inception_a4_3x3_3_scale_w[2] = { 96, 1 };
    vx_tensor inception_a4_3x3_3_scale_w = vxCreateTensor(context, 2, dims_inception_a4_3x3_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_3_scale_w);
    vx_size dims_inception_a4_3x3_3_scale_b[2] = { 96, 1 };
    vx_tensor inception_a4_3x3_3_scale_b = vxCreateTensor(context, 2, dims_inception_a4_3x3_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_3x3_3_scale_b);
    vx_size dims_inception_a4_1x1_w[4] = { 1, 1, 384, 96 };
    vx_tensor inception_a4_1x1_w = vxCreateTensor(context, 4, dims_inception_a4_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_1x1_w);
    vx_size dims_inception_a4_1x1_bn_w[2] = { 96, 1 };
    vx_tensor inception_a4_1x1_bn_w = vxCreateTensor(context, 2, dims_inception_a4_1x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_1x1_bn_w);
    vx_size dims_inception_a4_1x1_bn_b[2] = { 96, 1 };
    vx_tensor inception_a4_1x1_bn_b = vxCreateTensor(context, 2, dims_inception_a4_1x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_1x1_bn_b);
    vx_size dims_inception_a4_1x1_scale_w[2] = { 96, 1 };
    vx_tensor inception_a4_1x1_scale_w = vxCreateTensor(context, 2, dims_inception_a4_1x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_1x1_scale_w);
    vx_size dims_inception_a4_1x1_scale_b[2] = { 96, 1 };
    vx_tensor inception_a4_1x1_scale_b = vxCreateTensor(context, 2, dims_inception_a4_1x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_a4_1x1_scale_b);
    vx_size dims_reduction_a_3x3_w[4] = { 3, 3, 384, 384 };
    vx_tensor reduction_a_3x3_w = vxCreateTensor(context, 4, dims_reduction_a_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_w);
    vx_size dims_reduction_a_3x3_bn_w[2] = { 384, 1 };
    vx_tensor reduction_a_3x3_bn_w = vxCreateTensor(context, 2, dims_reduction_a_3x3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_bn_w);
    vx_size dims_reduction_a_3x3_bn_b[2] = { 384, 1 };
    vx_tensor reduction_a_3x3_bn_b = vxCreateTensor(context, 2, dims_reduction_a_3x3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_bn_b);
    vx_size dims_reduction_a_3x3_scale_w[2] = { 384, 1 };
    vx_tensor reduction_a_3x3_scale_w = vxCreateTensor(context, 2, dims_reduction_a_3x3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_scale_w);
    vx_size dims_reduction_a_3x3_scale_b[2] = { 384, 1 };
    vx_tensor reduction_a_3x3_scale_b = vxCreateTensor(context, 2, dims_reduction_a_3x3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_scale_b);
    vx_size dims_reduction_a_3x3_2_reduce_w[4] = { 1, 1, 384, 192 };
    vx_tensor reduction_a_3x3_2_reduce_w = vxCreateTensor(context, 4, dims_reduction_a_3x3_2_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_2_reduce_w);
    vx_size dims_reduction_a_3x3_2_reduce_bn_w[2] = { 192, 1 };
    vx_tensor reduction_a_3x3_2_reduce_bn_w = vxCreateTensor(context, 2, dims_reduction_a_3x3_2_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_2_reduce_bn_w);
    vx_size dims_reduction_a_3x3_2_reduce_bn_b[2] = { 192, 1 };
    vx_tensor reduction_a_3x3_2_reduce_bn_b = vxCreateTensor(context, 2, dims_reduction_a_3x3_2_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_2_reduce_bn_b);
    vx_size dims_reduction_a_3x3_2_reduce_scale_w[2] = { 192, 1 };
    vx_tensor reduction_a_3x3_2_reduce_scale_w = vxCreateTensor(context, 2, dims_reduction_a_3x3_2_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_2_reduce_scale_w);
    vx_size dims_reduction_a_3x3_2_reduce_scale_b[2] = { 192, 1 };
    vx_tensor reduction_a_3x3_2_reduce_scale_b = vxCreateTensor(context, 2, dims_reduction_a_3x3_2_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_2_reduce_scale_b);
    vx_size dims_reduction_a_3x3_2_w[4] = { 3, 3, 192, 224 };
    vx_tensor reduction_a_3x3_2_w = vxCreateTensor(context, 4, dims_reduction_a_3x3_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_2_w);
    vx_size dims_reduction_a_3x3_2_bn_w[2] = { 224, 1 };
    vx_tensor reduction_a_3x3_2_bn_w = vxCreateTensor(context, 2, dims_reduction_a_3x3_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_2_bn_w);
    vx_size dims_reduction_a_3x3_2_bn_b[2] = { 224, 1 };
    vx_tensor reduction_a_3x3_2_bn_b = vxCreateTensor(context, 2, dims_reduction_a_3x3_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_2_bn_b);
    vx_size dims_reduction_a_3x3_2_scale_w[2] = { 224, 1 };
    vx_tensor reduction_a_3x3_2_scale_w = vxCreateTensor(context, 2, dims_reduction_a_3x3_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_2_scale_w);
    vx_size dims_reduction_a_3x3_2_scale_b[2] = { 224, 1 };
    vx_tensor reduction_a_3x3_2_scale_b = vxCreateTensor(context, 2, dims_reduction_a_3x3_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_2_scale_b);
    vx_size dims_reduction_a_3x3_3_w[4] = { 3, 3, 224, 256 };
    vx_tensor reduction_a_3x3_3_w = vxCreateTensor(context, 4, dims_reduction_a_3x3_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_3_w);
    vx_size dims_reduction_a_3x3_3_bn_w[2] = { 256, 1 };
    vx_tensor reduction_a_3x3_3_bn_w = vxCreateTensor(context, 2, dims_reduction_a_3x3_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_3_bn_w);
    vx_size dims_reduction_a_3x3_3_bn_b[2] = { 256, 1 };
    vx_tensor reduction_a_3x3_3_bn_b = vxCreateTensor(context, 2, dims_reduction_a_3x3_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_3_bn_b);
    vx_size dims_reduction_a_3x3_3_scale_w[2] = { 256, 1 };
    vx_tensor reduction_a_3x3_3_scale_w = vxCreateTensor(context, 2, dims_reduction_a_3x3_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_3_scale_w);
    vx_size dims_reduction_a_3x3_3_scale_b[2] = { 256, 1 };
    vx_tensor reduction_a_3x3_3_scale_b = vxCreateTensor(context, 2, dims_reduction_a_3x3_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_a_3x3_3_scale_b);
    vx_size dims_inception_b1_1x1_2_w[4] = { 1, 1, 1024, 384 };
    vx_tensor inception_b1_1x1_2_w = vxCreateTensor(context, 4, dims_inception_b1_1x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x1_2_w);
    vx_size dims_inception_b1_1x1_2_bn_w[2] = { 384, 1 };
    vx_tensor inception_b1_1x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_b1_1x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x1_2_bn_w);
    vx_size dims_inception_b1_1x1_2_bn_b[2] = { 384, 1 };
    vx_tensor inception_b1_1x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_b1_1x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x1_2_bn_b);
    vx_size dims_inception_b1_1x1_2_scale_w[2] = { 384, 1 };
    vx_tensor inception_b1_1x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_b1_1x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x1_2_scale_w);
    vx_size dims_inception_b1_1x1_2_scale_b[2] = { 384, 1 };
    vx_tensor inception_b1_1x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_b1_1x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x1_2_scale_b);
    vx_size dims_inception_b1_1x7_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor inception_b1_1x7_reduce_w = vxCreateTensor(context, 4, dims_inception_b1_1x7_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_reduce_w);
    vx_size dims_inception_b1_1x7_reduce_bn_w[2] = { 192, 1 };
    vx_tensor inception_b1_1x7_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_b1_1x7_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_reduce_bn_w);
    vx_size dims_inception_b1_1x7_reduce_bn_b[2] = { 192, 1 };
    vx_tensor inception_b1_1x7_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_b1_1x7_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_reduce_bn_b);
    vx_size dims_inception_b1_1x7_reduce_scale_w[2] = { 192, 1 };
    vx_tensor inception_b1_1x7_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_b1_1x7_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_reduce_scale_w);
    vx_size dims_inception_b1_1x7_reduce_scale_b[2] = { 192, 1 };
    vx_tensor inception_b1_1x7_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_b1_1x7_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_reduce_scale_b);
    vx_size dims_inception_b1_1x7_w[4] = { 7, 1, 192, 224 };
    vx_tensor inception_b1_1x7_w = vxCreateTensor(context, 4, dims_inception_b1_1x7_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_w);
    vx_size dims_inception_b1_1x7_bn_w[2] = { 224, 1 };
    vx_tensor inception_b1_1x7_bn_w = vxCreateTensor(context, 2, dims_inception_b1_1x7_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_bn_w);
    vx_size dims_inception_b1_1x7_bn_b[2] = { 224, 1 };
    vx_tensor inception_b1_1x7_bn_b = vxCreateTensor(context, 2, dims_inception_b1_1x7_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_bn_b);
    vx_size dims_inception_b1_1x7_scale_w[2] = { 224, 1 };
    vx_tensor inception_b1_1x7_scale_w = vxCreateTensor(context, 2, dims_inception_b1_1x7_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_scale_w);
    vx_size dims_inception_b1_1x7_scale_b[2] = { 224, 1 };
    vx_tensor inception_b1_1x7_scale_b = vxCreateTensor(context, 2, dims_inception_b1_1x7_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_scale_b);
    vx_size dims_inception_b1_7x1_w[4] = { 1, 7, 224, 256 };
    vx_tensor inception_b1_7x1_w = vxCreateTensor(context, 4, dims_inception_b1_7x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_w);
    vx_size dims_inception_b1_7x1_bn_w[2] = { 256, 1 };
    vx_tensor inception_b1_7x1_bn_w = vxCreateTensor(context, 2, dims_inception_b1_7x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_bn_w);
    vx_size dims_inception_b1_7x1_bn_b[2] = { 256, 1 };
    vx_tensor inception_b1_7x1_bn_b = vxCreateTensor(context, 2, dims_inception_b1_7x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_bn_b);
    vx_size dims_inception_b1_7x1_scale_w[2] = { 256, 1 };
    vx_tensor inception_b1_7x1_scale_w = vxCreateTensor(context, 2, dims_inception_b1_7x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_scale_w);
    vx_size dims_inception_b1_7x1_scale_b[2] = { 256, 1 };
    vx_tensor inception_b1_7x1_scale_b = vxCreateTensor(context, 2, dims_inception_b1_7x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_scale_b);
    vx_size dims_inception_b1_7x1_2_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor inception_b1_7x1_2_reduce_w = vxCreateTensor(context, 4, dims_inception_b1_7x1_2_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_2_reduce_w);
    vx_size dims_inception_b1_7x1_2_reduce_bn_w[2] = { 192, 1 };
    vx_tensor inception_b1_7x1_2_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_b1_7x1_2_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_2_reduce_bn_w);
    vx_size dims_inception_b1_7x1_2_reduce_bn_b[2] = { 192, 1 };
    vx_tensor inception_b1_7x1_2_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_b1_7x1_2_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_2_reduce_bn_b);
    vx_size dims_inception_b1_7x1_2_reduce_scale_w[2] = { 192, 1 };
    vx_tensor inception_b1_7x1_2_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_b1_7x1_2_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_2_reduce_scale_w);
    vx_size dims_inception_b1_7x1_2_reduce_scale_b[2] = { 192, 1 };
    vx_tensor inception_b1_7x1_2_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_b1_7x1_2_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_2_reduce_scale_b);
    vx_size dims_inception_b1_7x1_2_w[4] = { 1, 7, 192, 192 };
    vx_tensor inception_b1_7x1_2_w = vxCreateTensor(context, 4, dims_inception_b1_7x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_2_w);
    vx_size dims_inception_b1_7x1_2_bn_w[2] = { 192, 1 };
    vx_tensor inception_b1_7x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_b1_7x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_2_bn_w);
    vx_size dims_inception_b1_7x1_2_bn_b[2] = { 192, 1 };
    vx_tensor inception_b1_7x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_b1_7x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_2_bn_b);
    vx_size dims_inception_b1_7x1_2_scale_w[2] = { 192, 1 };
    vx_tensor inception_b1_7x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_b1_7x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_2_scale_w);
    vx_size dims_inception_b1_7x1_2_scale_b[2] = { 192, 1 };
    vx_tensor inception_b1_7x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_b1_7x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_2_scale_b);
    vx_size dims_inception_b1_1x7_2_w[4] = { 7, 1, 192, 224 };
    vx_tensor inception_b1_1x7_2_w = vxCreateTensor(context, 4, dims_inception_b1_1x7_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_2_w);
    vx_size dims_inception_b1_1x7_2_bn_w[2] = { 224, 1 };
    vx_tensor inception_b1_1x7_2_bn_w = vxCreateTensor(context, 2, dims_inception_b1_1x7_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_2_bn_w);
    vx_size dims_inception_b1_1x7_2_bn_b[2] = { 224, 1 };
    vx_tensor inception_b1_1x7_2_bn_b = vxCreateTensor(context, 2, dims_inception_b1_1x7_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_2_bn_b);
    vx_size dims_inception_b1_1x7_2_scale_w[2] = { 224, 1 };
    vx_tensor inception_b1_1x7_2_scale_w = vxCreateTensor(context, 2, dims_inception_b1_1x7_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_2_scale_w);
    vx_size dims_inception_b1_1x7_2_scale_b[2] = { 224, 1 };
    vx_tensor inception_b1_1x7_2_scale_b = vxCreateTensor(context, 2, dims_inception_b1_1x7_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_2_scale_b);
    vx_size dims_inception_b1_7x1_3_w[4] = { 1, 7, 224, 224 };
    vx_tensor inception_b1_7x1_3_w = vxCreateTensor(context, 4, dims_inception_b1_7x1_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_3_w);
    vx_size dims_inception_b1_7x1_3_bn_w[2] = { 224, 1 };
    vx_tensor inception_b1_7x1_3_bn_w = vxCreateTensor(context, 2, dims_inception_b1_7x1_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_3_bn_w);
    vx_size dims_inception_b1_7x1_3_bn_b[2] = { 224, 1 };
    vx_tensor inception_b1_7x1_3_bn_b = vxCreateTensor(context, 2, dims_inception_b1_7x1_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_3_bn_b);
    vx_size dims_inception_b1_7x1_3_scale_w[2] = { 224, 1 };
    vx_tensor inception_b1_7x1_3_scale_w = vxCreateTensor(context, 2, dims_inception_b1_7x1_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_3_scale_w);
    vx_size dims_inception_b1_7x1_3_scale_b[2] = { 224, 1 };
    vx_tensor inception_b1_7x1_3_scale_b = vxCreateTensor(context, 2, dims_inception_b1_7x1_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_7x1_3_scale_b);
    vx_size dims_inception_b1_1x7_3_w[4] = { 7, 1, 224, 256 };
    vx_tensor inception_b1_1x7_3_w = vxCreateTensor(context, 4, dims_inception_b1_1x7_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_3_w);
    vx_size dims_inception_b1_1x7_3_bn_w[2] = { 256, 1 };
    vx_tensor inception_b1_1x7_3_bn_w = vxCreateTensor(context, 2, dims_inception_b1_1x7_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_3_bn_w);
    vx_size dims_inception_b1_1x7_3_bn_b[2] = { 256, 1 };
    vx_tensor inception_b1_1x7_3_bn_b = vxCreateTensor(context, 2, dims_inception_b1_1x7_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_3_bn_b);
    vx_size dims_inception_b1_1x7_3_scale_w[2] = { 256, 1 };
    vx_tensor inception_b1_1x7_3_scale_w = vxCreateTensor(context, 2, dims_inception_b1_1x7_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_3_scale_w);
    vx_size dims_inception_b1_1x7_3_scale_b[2] = { 256, 1 };
    vx_tensor inception_b1_1x7_3_scale_b = vxCreateTensor(context, 2, dims_inception_b1_1x7_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x7_3_scale_b);
    vx_size dims_inception_b1_1x1_w[4] = { 1, 1, 1024, 128 };
    vx_tensor inception_b1_1x1_w = vxCreateTensor(context, 4, dims_inception_b1_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x1_w);
    vx_size dims_inception_b1_1x1_bn_w[2] = { 128, 1 };
    vx_tensor inception_b1_1x1_bn_w = vxCreateTensor(context, 2, dims_inception_b1_1x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x1_bn_w);
    vx_size dims_inception_b1_1x1_bn_b[2] = { 128, 1 };
    vx_tensor inception_b1_1x1_bn_b = vxCreateTensor(context, 2, dims_inception_b1_1x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x1_bn_b);
    vx_size dims_inception_b1_1x1_scale_w[2] = { 128, 1 };
    vx_tensor inception_b1_1x1_scale_w = vxCreateTensor(context, 2, dims_inception_b1_1x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x1_scale_w);
    vx_size dims_inception_b1_1x1_scale_b[2] = { 128, 1 };
    vx_tensor inception_b1_1x1_scale_b = vxCreateTensor(context, 2, dims_inception_b1_1x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b1_1x1_scale_b);
    vx_size dims_inception_b2_1x1_2_w[4] = { 1, 1, 1024, 384 };
    vx_tensor inception_b2_1x1_2_w = vxCreateTensor(context, 4, dims_inception_b2_1x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x1_2_w);
    vx_size dims_inception_b2_1x1_2_bn_w[2] = { 384, 1 };
    vx_tensor inception_b2_1x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_b2_1x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x1_2_bn_w);
    vx_size dims_inception_b2_1x1_2_bn_b[2] = { 384, 1 };
    vx_tensor inception_b2_1x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_b2_1x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x1_2_bn_b);
    vx_size dims_inception_b2_1x1_2_scale_w[2] = { 384, 1 };
    vx_tensor inception_b2_1x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_b2_1x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x1_2_scale_w);
    vx_size dims_inception_b2_1x1_2_scale_b[2] = { 384, 1 };
    vx_tensor inception_b2_1x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_b2_1x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x1_2_scale_b);
    vx_size dims_inception_b2_1x7_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor inception_b2_1x7_reduce_w = vxCreateTensor(context, 4, dims_inception_b2_1x7_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_reduce_w);
    vx_size dims_inception_b2_1x7_reduce_bn_w[2] = { 192, 1 };
    vx_tensor inception_b2_1x7_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_b2_1x7_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_reduce_bn_w);
    vx_size dims_inception_b2_1x7_reduce_bn_b[2] = { 192, 1 };
    vx_tensor inception_b2_1x7_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_b2_1x7_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_reduce_bn_b);
    vx_size dims_inception_b2_1x7_reduce_scale_w[2] = { 192, 1 };
    vx_tensor inception_b2_1x7_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_b2_1x7_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_reduce_scale_w);
    vx_size dims_inception_b2_1x7_reduce_scale_b[2] = { 192, 1 };
    vx_tensor inception_b2_1x7_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_b2_1x7_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_reduce_scale_b);
    vx_size dims_inception_b2_1x7_w[4] = { 7, 1, 192, 224 };
    vx_tensor inception_b2_1x7_w = vxCreateTensor(context, 4, dims_inception_b2_1x7_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_w);
    vx_size dims_inception_b2_1x7_bn_w[2] = { 224, 1 };
    vx_tensor inception_b2_1x7_bn_w = vxCreateTensor(context, 2, dims_inception_b2_1x7_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_bn_w);
    vx_size dims_inception_b2_1x7_bn_b[2] = { 224, 1 };
    vx_tensor inception_b2_1x7_bn_b = vxCreateTensor(context, 2, dims_inception_b2_1x7_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_bn_b);
    vx_size dims_inception_b2_1x7_scale_w[2] = { 224, 1 };
    vx_tensor inception_b2_1x7_scale_w = vxCreateTensor(context, 2, dims_inception_b2_1x7_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_scale_w);
    vx_size dims_inception_b2_1x7_scale_b[2] = { 224, 1 };
    vx_tensor inception_b2_1x7_scale_b = vxCreateTensor(context, 2, dims_inception_b2_1x7_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_scale_b);
    vx_size dims_inception_b2_7x1_w[4] = { 1, 7, 224, 256 };
    vx_tensor inception_b2_7x1_w = vxCreateTensor(context, 4, dims_inception_b2_7x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_w);
    vx_size dims_inception_b2_7x1_bn_w[2] = { 256, 1 };
    vx_tensor inception_b2_7x1_bn_w = vxCreateTensor(context, 2, dims_inception_b2_7x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_bn_w);
    vx_size dims_inception_b2_7x1_bn_b[2] = { 256, 1 };
    vx_tensor inception_b2_7x1_bn_b = vxCreateTensor(context, 2, dims_inception_b2_7x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_bn_b);
    vx_size dims_inception_b2_7x1_scale_w[2] = { 256, 1 };
    vx_tensor inception_b2_7x1_scale_w = vxCreateTensor(context, 2, dims_inception_b2_7x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_scale_w);
    vx_size dims_inception_b2_7x1_scale_b[2] = { 256, 1 };
    vx_tensor inception_b2_7x1_scale_b = vxCreateTensor(context, 2, dims_inception_b2_7x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_scale_b);
    vx_size dims_inception_b2_7x1_2_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor inception_b2_7x1_2_reduce_w = vxCreateTensor(context, 4, dims_inception_b2_7x1_2_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_2_reduce_w);
    vx_size dims_inception_b2_7x1_2_reduce_bn_w[2] = { 192, 1 };
    vx_tensor inception_b2_7x1_2_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_b2_7x1_2_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_2_reduce_bn_w);
    vx_size dims_inception_b2_7x1_2_reduce_bn_b[2] = { 192, 1 };
    vx_tensor inception_b2_7x1_2_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_b2_7x1_2_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_2_reduce_bn_b);
    vx_size dims_inception_b2_7x1_2_reduce_scale_w[2] = { 192, 1 };
    vx_tensor inception_b2_7x1_2_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_b2_7x1_2_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_2_reduce_scale_w);
    vx_size dims_inception_b2_7x1_2_reduce_scale_b[2] = { 192, 1 };
    vx_tensor inception_b2_7x1_2_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_b2_7x1_2_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_2_reduce_scale_b);
    vx_size dims_inception_b2_7x1_2_w[4] = { 1, 7, 192, 192 };
    vx_tensor inception_b2_7x1_2_w = vxCreateTensor(context, 4, dims_inception_b2_7x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_2_w);
    vx_size dims_inception_b2_7x1_2_bn_w[2] = { 192, 1 };
    vx_tensor inception_b2_7x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_b2_7x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_2_bn_w);
    vx_size dims_inception_b2_7x1_2_bn_b[2] = { 192, 1 };
    vx_tensor inception_b2_7x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_b2_7x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_2_bn_b);
    vx_size dims_inception_b2_7x1_2_scale_w[2] = { 192, 1 };
    vx_tensor inception_b2_7x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_b2_7x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_2_scale_w);
    vx_size dims_inception_b2_7x1_2_scale_b[2] = { 192, 1 };
    vx_tensor inception_b2_7x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_b2_7x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_2_scale_b);
    vx_size dims_inception_b2_1x7_2_w[4] = { 7, 1, 192, 224 };
    vx_tensor inception_b2_1x7_2_w = vxCreateTensor(context, 4, dims_inception_b2_1x7_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_2_w);
    vx_size dims_inception_b2_1x7_2_bn_w[2] = { 224, 1 };
    vx_tensor inception_b2_1x7_2_bn_w = vxCreateTensor(context, 2, dims_inception_b2_1x7_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_2_bn_w);
    vx_size dims_inception_b2_1x7_2_bn_b[2] = { 224, 1 };
    vx_tensor inception_b2_1x7_2_bn_b = vxCreateTensor(context, 2, dims_inception_b2_1x7_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_2_bn_b);
    vx_size dims_inception_b2_1x7_2_scale_w[2] = { 224, 1 };
    vx_tensor inception_b2_1x7_2_scale_w = vxCreateTensor(context, 2, dims_inception_b2_1x7_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_2_scale_w);
    vx_size dims_inception_b2_1x7_2_scale_b[2] = { 224, 1 };
    vx_tensor inception_b2_1x7_2_scale_b = vxCreateTensor(context, 2, dims_inception_b2_1x7_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_2_scale_b);
    vx_size dims_inception_b2_7x1_3_w[4] = { 1, 7, 224, 224 };
    vx_tensor inception_b2_7x1_3_w = vxCreateTensor(context, 4, dims_inception_b2_7x1_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_3_w);
    vx_size dims_inception_b2_7x1_3_bn_w[2] = { 224, 1 };
    vx_tensor inception_b2_7x1_3_bn_w = vxCreateTensor(context, 2, dims_inception_b2_7x1_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_3_bn_w);
    vx_size dims_inception_b2_7x1_3_bn_b[2] = { 224, 1 };
    vx_tensor inception_b2_7x1_3_bn_b = vxCreateTensor(context, 2, dims_inception_b2_7x1_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_3_bn_b);
    vx_size dims_inception_b2_7x1_3_scale_w[2] = { 224, 1 };
    vx_tensor inception_b2_7x1_3_scale_w = vxCreateTensor(context, 2, dims_inception_b2_7x1_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_3_scale_w);
    vx_size dims_inception_b2_7x1_3_scale_b[2] = { 224, 1 };
    vx_tensor inception_b2_7x1_3_scale_b = vxCreateTensor(context, 2, dims_inception_b2_7x1_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_7x1_3_scale_b);
    vx_size dims_inception_b2_1x7_3_w[4] = { 7, 1, 224, 256 };
    vx_tensor inception_b2_1x7_3_w = vxCreateTensor(context, 4, dims_inception_b2_1x7_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_3_w);
    vx_size dims_inception_b2_1x7_3_bn_w[2] = { 256, 1 };
    vx_tensor inception_b2_1x7_3_bn_w = vxCreateTensor(context, 2, dims_inception_b2_1x7_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_3_bn_w);
    vx_size dims_inception_b2_1x7_3_bn_b[2] = { 256, 1 };
    vx_tensor inception_b2_1x7_3_bn_b = vxCreateTensor(context, 2, dims_inception_b2_1x7_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_3_bn_b);
    vx_size dims_inception_b2_1x7_3_scale_w[2] = { 256, 1 };
    vx_tensor inception_b2_1x7_3_scale_w = vxCreateTensor(context, 2, dims_inception_b2_1x7_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_3_scale_w);
    vx_size dims_inception_b2_1x7_3_scale_b[2] = { 256, 1 };
    vx_tensor inception_b2_1x7_3_scale_b = vxCreateTensor(context, 2, dims_inception_b2_1x7_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x7_3_scale_b);
    vx_size dims_inception_b2_1x1_w[4] = { 1, 1, 1024, 128 };
    vx_tensor inception_b2_1x1_w = vxCreateTensor(context, 4, dims_inception_b2_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x1_w);
    vx_size dims_inception_b2_1x1_bn_w[2] = { 128, 1 };
    vx_tensor inception_b2_1x1_bn_w = vxCreateTensor(context, 2, dims_inception_b2_1x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x1_bn_w);
    vx_size dims_inception_b2_1x1_bn_b[2] = { 128, 1 };
    vx_tensor inception_b2_1x1_bn_b = vxCreateTensor(context, 2, dims_inception_b2_1x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x1_bn_b);
    vx_size dims_inception_b2_1x1_scale_w[2] = { 128, 1 };
    vx_tensor inception_b2_1x1_scale_w = vxCreateTensor(context, 2, dims_inception_b2_1x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x1_scale_w);
    vx_size dims_inception_b2_1x1_scale_b[2] = { 128, 1 };
    vx_tensor inception_b2_1x1_scale_b = vxCreateTensor(context, 2, dims_inception_b2_1x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b2_1x1_scale_b);
    vx_size dims_inception_b3_1x1_2_w[4] = { 1, 1, 1024, 384 };
    vx_tensor inception_b3_1x1_2_w = vxCreateTensor(context, 4, dims_inception_b3_1x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x1_2_w);
    vx_size dims_inception_b3_1x1_2_bn_w[2] = { 384, 1 };
    vx_tensor inception_b3_1x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_b3_1x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x1_2_bn_w);
    vx_size dims_inception_b3_1x1_2_bn_b[2] = { 384, 1 };
    vx_tensor inception_b3_1x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_b3_1x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x1_2_bn_b);
    vx_size dims_inception_b3_1x1_2_scale_w[2] = { 384, 1 };
    vx_tensor inception_b3_1x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_b3_1x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x1_2_scale_w);
    vx_size dims_inception_b3_1x1_2_scale_b[2] = { 384, 1 };
    vx_tensor inception_b3_1x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_b3_1x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x1_2_scale_b);
    vx_size dims_inception_b3_1x7_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor inception_b3_1x7_reduce_w = vxCreateTensor(context, 4, dims_inception_b3_1x7_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_reduce_w);
    vx_size dims_inception_b3_1x7_reduce_bn_w[2] = { 192, 1 };
    vx_tensor inception_b3_1x7_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_b3_1x7_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_reduce_bn_w);
    vx_size dims_inception_b3_1x7_reduce_bn_b[2] = { 192, 1 };
    vx_tensor inception_b3_1x7_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_b3_1x7_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_reduce_bn_b);
    vx_size dims_inception_b3_1x7_reduce_scale_w[2] = { 192, 1 };
    vx_tensor inception_b3_1x7_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_b3_1x7_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_reduce_scale_w);
    vx_size dims_inception_b3_1x7_reduce_scale_b[2] = { 192, 1 };
    vx_tensor inception_b3_1x7_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_b3_1x7_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_reduce_scale_b);
    vx_size dims_inception_b3_1x7_w[4] = { 7, 1, 192, 224 };
    vx_tensor inception_b3_1x7_w = vxCreateTensor(context, 4, dims_inception_b3_1x7_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_w);
    vx_size dims_inception_b3_1x7_bn_w[2] = { 224, 1 };
    vx_tensor inception_b3_1x7_bn_w = vxCreateTensor(context, 2, dims_inception_b3_1x7_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_bn_w);
    vx_size dims_inception_b3_1x7_bn_b[2] = { 224, 1 };
    vx_tensor inception_b3_1x7_bn_b = vxCreateTensor(context, 2, dims_inception_b3_1x7_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_bn_b);
    vx_size dims_inception_b3_1x7_scale_w[2] = { 224, 1 };
    vx_tensor inception_b3_1x7_scale_w = vxCreateTensor(context, 2, dims_inception_b3_1x7_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_scale_w);
    vx_size dims_inception_b3_1x7_scale_b[2] = { 224, 1 };
    vx_tensor inception_b3_1x7_scale_b = vxCreateTensor(context, 2, dims_inception_b3_1x7_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_scale_b);
    vx_size dims_inception_b3_7x1_w[4] = { 1, 7, 224, 256 };
    vx_tensor inception_b3_7x1_w = vxCreateTensor(context, 4, dims_inception_b3_7x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_w);
    vx_size dims_inception_b3_7x1_bn_w[2] = { 256, 1 };
    vx_tensor inception_b3_7x1_bn_w = vxCreateTensor(context, 2, dims_inception_b3_7x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_bn_w);
    vx_size dims_inception_b3_7x1_bn_b[2] = { 256, 1 };
    vx_tensor inception_b3_7x1_bn_b = vxCreateTensor(context, 2, dims_inception_b3_7x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_bn_b);
    vx_size dims_inception_b3_7x1_scale_w[2] = { 256, 1 };
    vx_tensor inception_b3_7x1_scale_w = vxCreateTensor(context, 2, dims_inception_b3_7x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_scale_w);
    vx_size dims_inception_b3_7x1_scale_b[2] = { 256, 1 };
    vx_tensor inception_b3_7x1_scale_b = vxCreateTensor(context, 2, dims_inception_b3_7x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_scale_b);
    vx_size dims_inception_b3_7x1_2_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor inception_b3_7x1_2_reduce_w = vxCreateTensor(context, 4, dims_inception_b3_7x1_2_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_2_reduce_w);
    vx_size dims_inception_b3_7x1_2_reduce_bn_w[2] = { 192, 1 };
    vx_tensor inception_b3_7x1_2_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_b3_7x1_2_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_2_reduce_bn_w);
    vx_size dims_inception_b3_7x1_2_reduce_bn_b[2] = { 192, 1 };
    vx_tensor inception_b3_7x1_2_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_b3_7x1_2_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_2_reduce_bn_b);
    vx_size dims_inception_b3_7x1_2_reduce_scale_w[2] = { 192, 1 };
    vx_tensor inception_b3_7x1_2_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_b3_7x1_2_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_2_reduce_scale_w);
    vx_size dims_inception_b3_7x1_2_reduce_scale_b[2] = { 192, 1 };
    vx_tensor inception_b3_7x1_2_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_b3_7x1_2_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_2_reduce_scale_b);
    vx_size dims_inception_b3_7x1_2_w[4] = { 1, 7, 192, 192 };
    vx_tensor inception_b3_7x1_2_w = vxCreateTensor(context, 4, dims_inception_b3_7x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_2_w);
    vx_size dims_inception_b3_7x1_2_bn_w[2] = { 192, 1 };
    vx_tensor inception_b3_7x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_b3_7x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_2_bn_w);
    vx_size dims_inception_b3_7x1_2_bn_b[2] = { 192, 1 };
    vx_tensor inception_b3_7x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_b3_7x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_2_bn_b);
    vx_size dims_inception_b3_7x1_2_scale_w[2] = { 192, 1 };
    vx_tensor inception_b3_7x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_b3_7x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_2_scale_w);
    vx_size dims_inception_b3_7x1_2_scale_b[2] = { 192, 1 };
    vx_tensor inception_b3_7x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_b3_7x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_2_scale_b);
    vx_size dims_inception_b3_1x7_2_w[4] = { 7, 1, 192, 224 };
    vx_tensor inception_b3_1x7_2_w = vxCreateTensor(context, 4, dims_inception_b3_1x7_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_2_w);
    vx_size dims_inception_b3_1x7_2_bn_w[2] = { 224, 1 };
    vx_tensor inception_b3_1x7_2_bn_w = vxCreateTensor(context, 2, dims_inception_b3_1x7_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_2_bn_w);
    vx_size dims_inception_b3_1x7_2_bn_b[2] = { 224, 1 };
    vx_tensor inception_b3_1x7_2_bn_b = vxCreateTensor(context, 2, dims_inception_b3_1x7_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_2_bn_b);
    vx_size dims_inception_b3_1x7_2_scale_w[2] = { 224, 1 };
    vx_tensor inception_b3_1x7_2_scale_w = vxCreateTensor(context, 2, dims_inception_b3_1x7_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_2_scale_w);
    vx_size dims_inception_b3_1x7_2_scale_b[2] = { 224, 1 };
    vx_tensor inception_b3_1x7_2_scale_b = vxCreateTensor(context, 2, dims_inception_b3_1x7_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_2_scale_b);
    vx_size dims_inception_b3_7x1_3_w[4] = { 1, 7, 224, 224 };
    vx_tensor inception_b3_7x1_3_w = vxCreateTensor(context, 4, dims_inception_b3_7x1_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_3_w);
    vx_size dims_inception_b3_7x1_3_bn_w[2] = { 224, 1 };
    vx_tensor inception_b3_7x1_3_bn_w = vxCreateTensor(context, 2, dims_inception_b3_7x1_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_3_bn_w);
    vx_size dims_inception_b3_7x1_3_bn_b[2] = { 224, 1 };
    vx_tensor inception_b3_7x1_3_bn_b = vxCreateTensor(context, 2, dims_inception_b3_7x1_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_3_bn_b);
    vx_size dims_inception_b3_7x1_3_scale_w[2] = { 224, 1 };
    vx_tensor inception_b3_7x1_3_scale_w = vxCreateTensor(context, 2, dims_inception_b3_7x1_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_3_scale_w);
    vx_size dims_inception_b3_7x1_3_scale_b[2] = { 224, 1 };
    vx_tensor inception_b3_7x1_3_scale_b = vxCreateTensor(context, 2, dims_inception_b3_7x1_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_7x1_3_scale_b);
    vx_size dims_inception_b3_1x7_3_w[4] = { 7, 1, 224, 256 };
    vx_tensor inception_b3_1x7_3_w = vxCreateTensor(context, 4, dims_inception_b3_1x7_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_3_w);
    vx_size dims_inception_b3_1x7_3_bn_w[2] = { 256, 1 };
    vx_tensor inception_b3_1x7_3_bn_w = vxCreateTensor(context, 2, dims_inception_b3_1x7_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_3_bn_w);
    vx_size dims_inception_b3_1x7_3_bn_b[2] = { 256, 1 };
    vx_tensor inception_b3_1x7_3_bn_b = vxCreateTensor(context, 2, dims_inception_b3_1x7_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_3_bn_b);
    vx_size dims_inception_b3_1x7_3_scale_w[2] = { 256, 1 };
    vx_tensor inception_b3_1x7_3_scale_w = vxCreateTensor(context, 2, dims_inception_b3_1x7_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_3_scale_w);
    vx_size dims_inception_b3_1x7_3_scale_b[2] = { 256, 1 };
    vx_tensor inception_b3_1x7_3_scale_b = vxCreateTensor(context, 2, dims_inception_b3_1x7_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x7_3_scale_b);
    vx_size dims_inception_b3_1x1_w[4] = { 1, 1, 1024, 128 };
    vx_tensor inception_b3_1x1_w = vxCreateTensor(context, 4, dims_inception_b3_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x1_w);
    vx_size dims_inception_b3_1x1_bn_w[2] = { 128, 1 };
    vx_tensor inception_b3_1x1_bn_w = vxCreateTensor(context, 2, dims_inception_b3_1x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x1_bn_w);
    vx_size dims_inception_b3_1x1_bn_b[2] = { 128, 1 };
    vx_tensor inception_b3_1x1_bn_b = vxCreateTensor(context, 2, dims_inception_b3_1x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x1_bn_b);
    vx_size dims_inception_b3_1x1_scale_w[2] = { 128, 1 };
    vx_tensor inception_b3_1x1_scale_w = vxCreateTensor(context, 2, dims_inception_b3_1x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x1_scale_w);
    vx_size dims_inception_b3_1x1_scale_b[2] = { 128, 1 };
    vx_tensor inception_b3_1x1_scale_b = vxCreateTensor(context, 2, dims_inception_b3_1x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b3_1x1_scale_b);
    vx_size dims_inception_b4_1x1_2_w[4] = { 1, 1, 1024, 384 };
    vx_tensor inception_b4_1x1_2_w = vxCreateTensor(context, 4, dims_inception_b4_1x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x1_2_w);
    vx_size dims_inception_b4_1x1_2_bn_w[2] = { 384, 1 };
    vx_tensor inception_b4_1x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_b4_1x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x1_2_bn_w);
    vx_size dims_inception_b4_1x1_2_bn_b[2] = { 384, 1 };
    vx_tensor inception_b4_1x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_b4_1x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x1_2_bn_b);
    vx_size dims_inception_b4_1x1_2_scale_w[2] = { 384, 1 };
    vx_tensor inception_b4_1x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_b4_1x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x1_2_scale_w);
    vx_size dims_inception_b4_1x1_2_scale_b[2] = { 384, 1 };
    vx_tensor inception_b4_1x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_b4_1x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x1_2_scale_b);
    vx_size dims_inception_b4_1x7_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor inception_b4_1x7_reduce_w = vxCreateTensor(context, 4, dims_inception_b4_1x7_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_reduce_w);
    vx_size dims_inception_b4_1x7_reduce_bn_w[2] = { 192, 1 };
    vx_tensor inception_b4_1x7_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_b4_1x7_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_reduce_bn_w);
    vx_size dims_inception_b4_1x7_reduce_bn_b[2] = { 192, 1 };
    vx_tensor inception_b4_1x7_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_b4_1x7_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_reduce_bn_b);
    vx_size dims_inception_b4_1x7_reduce_scale_w[2] = { 192, 1 };
    vx_tensor inception_b4_1x7_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_b4_1x7_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_reduce_scale_w);
    vx_size dims_inception_b4_1x7_reduce_scale_b[2] = { 192, 1 };
    vx_tensor inception_b4_1x7_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_b4_1x7_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_reduce_scale_b);
    vx_size dims_inception_b4_1x7_w[4] = { 7, 1, 192, 224 };
    vx_tensor inception_b4_1x7_w = vxCreateTensor(context, 4, dims_inception_b4_1x7_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_w);
    vx_size dims_inception_b4_1x7_bn_w[2] = { 224, 1 };
    vx_tensor inception_b4_1x7_bn_w = vxCreateTensor(context, 2, dims_inception_b4_1x7_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_bn_w);
    vx_size dims_inception_b4_1x7_bn_b[2] = { 224, 1 };
    vx_tensor inception_b4_1x7_bn_b = vxCreateTensor(context, 2, dims_inception_b4_1x7_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_bn_b);
    vx_size dims_inception_b4_1x7_scale_w[2] = { 224, 1 };
    vx_tensor inception_b4_1x7_scale_w = vxCreateTensor(context, 2, dims_inception_b4_1x7_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_scale_w);
    vx_size dims_inception_b4_1x7_scale_b[2] = { 224, 1 };
    vx_tensor inception_b4_1x7_scale_b = vxCreateTensor(context, 2, dims_inception_b4_1x7_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_scale_b);
    vx_size dims_inception_b4_7x1_w[4] = { 1, 7, 224, 256 };
    vx_tensor inception_b4_7x1_w = vxCreateTensor(context, 4, dims_inception_b4_7x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_w);
    vx_size dims_inception_b4_7x1_bn_w[2] = { 256, 1 };
    vx_tensor inception_b4_7x1_bn_w = vxCreateTensor(context, 2, dims_inception_b4_7x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_bn_w);
    vx_size dims_inception_b4_7x1_bn_b[2] = { 256, 1 };
    vx_tensor inception_b4_7x1_bn_b = vxCreateTensor(context, 2, dims_inception_b4_7x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_bn_b);
    vx_size dims_inception_b4_7x1_scale_w[2] = { 256, 1 };
    vx_tensor inception_b4_7x1_scale_w = vxCreateTensor(context, 2, dims_inception_b4_7x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_scale_w);
    vx_size dims_inception_b4_7x1_scale_b[2] = { 256, 1 };
    vx_tensor inception_b4_7x1_scale_b = vxCreateTensor(context, 2, dims_inception_b4_7x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_scale_b);
    vx_size dims_inception_b4_7x1_2_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor inception_b4_7x1_2_reduce_w = vxCreateTensor(context, 4, dims_inception_b4_7x1_2_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_2_reduce_w);
    vx_size dims_inception_b4_7x1_2_reduce_bn_w[2] = { 192, 1 };
    vx_tensor inception_b4_7x1_2_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_b4_7x1_2_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_2_reduce_bn_w);
    vx_size dims_inception_b4_7x1_2_reduce_bn_b[2] = { 192, 1 };
    vx_tensor inception_b4_7x1_2_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_b4_7x1_2_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_2_reduce_bn_b);
    vx_size dims_inception_b4_7x1_2_reduce_scale_w[2] = { 192, 1 };
    vx_tensor inception_b4_7x1_2_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_b4_7x1_2_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_2_reduce_scale_w);
    vx_size dims_inception_b4_7x1_2_reduce_scale_b[2] = { 192, 1 };
    vx_tensor inception_b4_7x1_2_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_b4_7x1_2_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_2_reduce_scale_b);
    vx_size dims_inception_b4_7x1_2_w[4] = { 1, 7, 192, 192 };
    vx_tensor inception_b4_7x1_2_w = vxCreateTensor(context, 4, dims_inception_b4_7x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_2_w);
    vx_size dims_inception_b4_7x1_2_bn_w[2] = { 192, 1 };
    vx_tensor inception_b4_7x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_b4_7x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_2_bn_w);
    vx_size dims_inception_b4_7x1_2_bn_b[2] = { 192, 1 };
    vx_tensor inception_b4_7x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_b4_7x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_2_bn_b);
    vx_size dims_inception_b4_7x1_2_scale_w[2] = { 192, 1 };
    vx_tensor inception_b4_7x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_b4_7x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_2_scale_w);
    vx_size dims_inception_b4_7x1_2_scale_b[2] = { 192, 1 };
    vx_tensor inception_b4_7x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_b4_7x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_2_scale_b);
    vx_size dims_inception_b4_1x7_2_w[4] = { 7, 1, 192, 224 };
    vx_tensor inception_b4_1x7_2_w = vxCreateTensor(context, 4, dims_inception_b4_1x7_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_2_w);
    vx_size dims_inception_b4_1x7_2_bn_w[2] = { 224, 1 };
    vx_tensor inception_b4_1x7_2_bn_w = vxCreateTensor(context, 2, dims_inception_b4_1x7_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_2_bn_w);
    vx_size dims_inception_b4_1x7_2_bn_b[2] = { 224, 1 };
    vx_tensor inception_b4_1x7_2_bn_b = vxCreateTensor(context, 2, dims_inception_b4_1x7_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_2_bn_b);
    vx_size dims_inception_b4_1x7_2_scale_w[2] = { 224, 1 };
    vx_tensor inception_b4_1x7_2_scale_w = vxCreateTensor(context, 2, dims_inception_b4_1x7_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_2_scale_w);
    vx_size dims_inception_b4_1x7_2_scale_b[2] = { 224, 1 };
    vx_tensor inception_b4_1x7_2_scale_b = vxCreateTensor(context, 2, dims_inception_b4_1x7_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_2_scale_b);
    vx_size dims_inception_b4_7x1_3_w[4] = { 1, 7, 224, 224 };
    vx_tensor inception_b4_7x1_3_w = vxCreateTensor(context, 4, dims_inception_b4_7x1_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_3_w);
    vx_size dims_inception_b4_7x1_3_bn_w[2] = { 224, 1 };
    vx_tensor inception_b4_7x1_3_bn_w = vxCreateTensor(context, 2, dims_inception_b4_7x1_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_3_bn_w);
    vx_size dims_inception_b4_7x1_3_bn_b[2] = { 224, 1 };
    vx_tensor inception_b4_7x1_3_bn_b = vxCreateTensor(context, 2, dims_inception_b4_7x1_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_3_bn_b);
    vx_size dims_inception_b4_7x1_3_scale_w[2] = { 224, 1 };
    vx_tensor inception_b4_7x1_3_scale_w = vxCreateTensor(context, 2, dims_inception_b4_7x1_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_3_scale_w);
    vx_size dims_inception_b4_7x1_3_scale_b[2] = { 224, 1 };
    vx_tensor inception_b4_7x1_3_scale_b = vxCreateTensor(context, 2, dims_inception_b4_7x1_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_7x1_3_scale_b);
    vx_size dims_inception_b4_1x7_3_w[4] = { 7, 1, 224, 256 };
    vx_tensor inception_b4_1x7_3_w = vxCreateTensor(context, 4, dims_inception_b4_1x7_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_3_w);
    vx_size dims_inception_b4_1x7_3_bn_w[2] = { 256, 1 };
    vx_tensor inception_b4_1x7_3_bn_w = vxCreateTensor(context, 2, dims_inception_b4_1x7_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_3_bn_w);
    vx_size dims_inception_b4_1x7_3_bn_b[2] = { 256, 1 };
    vx_tensor inception_b4_1x7_3_bn_b = vxCreateTensor(context, 2, dims_inception_b4_1x7_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_3_bn_b);
    vx_size dims_inception_b4_1x7_3_scale_w[2] = { 256, 1 };
    vx_tensor inception_b4_1x7_3_scale_w = vxCreateTensor(context, 2, dims_inception_b4_1x7_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_3_scale_w);
    vx_size dims_inception_b4_1x7_3_scale_b[2] = { 256, 1 };
    vx_tensor inception_b4_1x7_3_scale_b = vxCreateTensor(context, 2, dims_inception_b4_1x7_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x7_3_scale_b);
    vx_size dims_inception_b4_1x1_w[4] = { 1, 1, 1024, 128 };
    vx_tensor inception_b4_1x1_w = vxCreateTensor(context, 4, dims_inception_b4_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x1_w);
    vx_size dims_inception_b4_1x1_bn_w[2] = { 128, 1 };
    vx_tensor inception_b4_1x1_bn_w = vxCreateTensor(context, 2, dims_inception_b4_1x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x1_bn_w);
    vx_size dims_inception_b4_1x1_bn_b[2] = { 128, 1 };
    vx_tensor inception_b4_1x1_bn_b = vxCreateTensor(context, 2, dims_inception_b4_1x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x1_bn_b);
    vx_size dims_inception_b4_1x1_scale_w[2] = { 128, 1 };
    vx_tensor inception_b4_1x1_scale_w = vxCreateTensor(context, 2, dims_inception_b4_1x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x1_scale_w);
    vx_size dims_inception_b4_1x1_scale_b[2] = { 128, 1 };
    vx_tensor inception_b4_1x1_scale_b = vxCreateTensor(context, 2, dims_inception_b4_1x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b4_1x1_scale_b);
    vx_size dims_inception_b5_1x1_2_w[4] = { 1, 1, 1024, 384 };
    vx_tensor inception_b5_1x1_2_w = vxCreateTensor(context, 4, dims_inception_b5_1x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x1_2_w);
    vx_size dims_inception_b5_1x1_2_bn_w[2] = { 384, 1 };
    vx_tensor inception_b5_1x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_b5_1x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x1_2_bn_w);
    vx_size dims_inception_b5_1x1_2_bn_b[2] = { 384, 1 };
    vx_tensor inception_b5_1x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_b5_1x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x1_2_bn_b);
    vx_size dims_inception_b5_1x1_2_scale_w[2] = { 384, 1 };
    vx_tensor inception_b5_1x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_b5_1x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x1_2_scale_w);
    vx_size dims_inception_b5_1x1_2_scale_b[2] = { 384, 1 };
    vx_tensor inception_b5_1x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_b5_1x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x1_2_scale_b);
    vx_size dims_inception_b5_1x7_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor inception_b5_1x7_reduce_w = vxCreateTensor(context, 4, dims_inception_b5_1x7_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_reduce_w);
    vx_size dims_inception_b5_1x7_reduce_bn_w[2] = { 192, 1 };
    vx_tensor inception_b5_1x7_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_b5_1x7_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_reduce_bn_w);
    vx_size dims_inception_b5_1x7_reduce_bn_b[2] = { 192, 1 };
    vx_tensor inception_b5_1x7_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_b5_1x7_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_reduce_bn_b);
    vx_size dims_inception_b5_1x7_reduce_scale_w[2] = { 192, 1 };
    vx_tensor inception_b5_1x7_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_b5_1x7_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_reduce_scale_w);
    vx_size dims_inception_b5_1x7_reduce_scale_b[2] = { 192, 1 };
    vx_tensor inception_b5_1x7_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_b5_1x7_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_reduce_scale_b);
    vx_size dims_inception_b5_1x7_w[4] = { 7, 1, 192, 224 };
    vx_tensor inception_b5_1x7_w = vxCreateTensor(context, 4, dims_inception_b5_1x7_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_w);
    vx_size dims_inception_b5_1x7_bn_w[2] = { 224, 1 };
    vx_tensor inception_b5_1x7_bn_w = vxCreateTensor(context, 2, dims_inception_b5_1x7_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_bn_w);
    vx_size dims_inception_b5_1x7_bn_b[2] = { 224, 1 };
    vx_tensor inception_b5_1x7_bn_b = vxCreateTensor(context, 2, dims_inception_b5_1x7_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_bn_b);
    vx_size dims_inception_b5_1x7_scale_w[2] = { 224, 1 };
    vx_tensor inception_b5_1x7_scale_w = vxCreateTensor(context, 2, dims_inception_b5_1x7_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_scale_w);
    vx_size dims_inception_b5_1x7_scale_b[2] = { 224, 1 };
    vx_tensor inception_b5_1x7_scale_b = vxCreateTensor(context, 2, dims_inception_b5_1x7_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_scale_b);
    vx_size dims_inception_b5_7x1_w[4] = { 1, 7, 224, 256 };
    vx_tensor inception_b5_7x1_w = vxCreateTensor(context, 4, dims_inception_b5_7x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_w);
    vx_size dims_inception_b5_7x1_bn_w[2] = { 256, 1 };
    vx_tensor inception_b5_7x1_bn_w = vxCreateTensor(context, 2, dims_inception_b5_7x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_bn_w);
    vx_size dims_inception_b5_7x1_bn_b[2] = { 256, 1 };
    vx_tensor inception_b5_7x1_bn_b = vxCreateTensor(context, 2, dims_inception_b5_7x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_bn_b);
    vx_size dims_inception_b5_7x1_scale_w[2] = { 256, 1 };
    vx_tensor inception_b5_7x1_scale_w = vxCreateTensor(context, 2, dims_inception_b5_7x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_scale_w);
    vx_size dims_inception_b5_7x1_scale_b[2] = { 256, 1 };
    vx_tensor inception_b5_7x1_scale_b = vxCreateTensor(context, 2, dims_inception_b5_7x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_scale_b);
    vx_size dims_inception_b5_7x1_2_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor inception_b5_7x1_2_reduce_w = vxCreateTensor(context, 4, dims_inception_b5_7x1_2_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_2_reduce_w);
    vx_size dims_inception_b5_7x1_2_reduce_bn_w[2] = { 192, 1 };
    vx_tensor inception_b5_7x1_2_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_b5_7x1_2_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_2_reduce_bn_w);
    vx_size dims_inception_b5_7x1_2_reduce_bn_b[2] = { 192, 1 };
    vx_tensor inception_b5_7x1_2_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_b5_7x1_2_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_2_reduce_bn_b);
    vx_size dims_inception_b5_7x1_2_reduce_scale_w[2] = { 192, 1 };
    vx_tensor inception_b5_7x1_2_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_b5_7x1_2_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_2_reduce_scale_w);
    vx_size dims_inception_b5_7x1_2_reduce_scale_b[2] = { 192, 1 };
    vx_tensor inception_b5_7x1_2_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_b5_7x1_2_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_2_reduce_scale_b);
    vx_size dims_inception_b5_7x1_2_w[4] = { 1, 7, 192, 192 };
    vx_tensor inception_b5_7x1_2_w = vxCreateTensor(context, 4, dims_inception_b5_7x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_2_w);
    vx_size dims_inception_b5_7x1_2_bn_w[2] = { 192, 1 };
    vx_tensor inception_b5_7x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_b5_7x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_2_bn_w);
    vx_size dims_inception_b5_7x1_2_bn_b[2] = { 192, 1 };
    vx_tensor inception_b5_7x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_b5_7x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_2_bn_b);
    vx_size dims_inception_b5_7x1_2_scale_w[2] = { 192, 1 };
    vx_tensor inception_b5_7x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_b5_7x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_2_scale_w);
    vx_size dims_inception_b5_7x1_2_scale_b[2] = { 192, 1 };
    vx_tensor inception_b5_7x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_b5_7x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_2_scale_b);
    vx_size dims_inception_b5_1x7_2_w[4] = { 7, 1, 192, 224 };
    vx_tensor inception_b5_1x7_2_w = vxCreateTensor(context, 4, dims_inception_b5_1x7_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_2_w);
    vx_size dims_inception_b5_1x7_2_bn_w[2] = { 224, 1 };
    vx_tensor inception_b5_1x7_2_bn_w = vxCreateTensor(context, 2, dims_inception_b5_1x7_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_2_bn_w);
    vx_size dims_inception_b5_1x7_2_bn_b[2] = { 224, 1 };
    vx_tensor inception_b5_1x7_2_bn_b = vxCreateTensor(context, 2, dims_inception_b5_1x7_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_2_bn_b);
    vx_size dims_inception_b5_1x7_2_scale_w[2] = { 224, 1 };
    vx_tensor inception_b5_1x7_2_scale_w = vxCreateTensor(context, 2, dims_inception_b5_1x7_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_2_scale_w);
    vx_size dims_inception_b5_1x7_2_scale_b[2] = { 224, 1 };
    vx_tensor inception_b5_1x7_2_scale_b = vxCreateTensor(context, 2, dims_inception_b5_1x7_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_2_scale_b);
    vx_size dims_inception_b5_7x1_3_w[4] = { 1, 7, 224, 224 };
    vx_tensor inception_b5_7x1_3_w = vxCreateTensor(context, 4, dims_inception_b5_7x1_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_3_w);
    vx_size dims_inception_b5_7x1_3_bn_w[2] = { 224, 1 };
    vx_tensor inception_b5_7x1_3_bn_w = vxCreateTensor(context, 2, dims_inception_b5_7x1_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_3_bn_w);
    vx_size dims_inception_b5_7x1_3_bn_b[2] = { 224, 1 };
    vx_tensor inception_b5_7x1_3_bn_b = vxCreateTensor(context, 2, dims_inception_b5_7x1_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_3_bn_b);
    vx_size dims_inception_b5_7x1_3_scale_w[2] = { 224, 1 };
    vx_tensor inception_b5_7x1_3_scale_w = vxCreateTensor(context, 2, dims_inception_b5_7x1_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_3_scale_w);
    vx_size dims_inception_b5_7x1_3_scale_b[2] = { 224, 1 };
    vx_tensor inception_b5_7x1_3_scale_b = vxCreateTensor(context, 2, dims_inception_b5_7x1_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_7x1_3_scale_b);
    vx_size dims_inception_b5_1x7_3_w[4] = { 7, 1, 224, 256 };
    vx_tensor inception_b5_1x7_3_w = vxCreateTensor(context, 4, dims_inception_b5_1x7_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_3_w);
    vx_size dims_inception_b5_1x7_3_bn_w[2] = { 256, 1 };
    vx_tensor inception_b5_1x7_3_bn_w = vxCreateTensor(context, 2, dims_inception_b5_1x7_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_3_bn_w);
    vx_size dims_inception_b5_1x7_3_bn_b[2] = { 256, 1 };
    vx_tensor inception_b5_1x7_3_bn_b = vxCreateTensor(context, 2, dims_inception_b5_1x7_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_3_bn_b);
    vx_size dims_inception_b5_1x7_3_scale_w[2] = { 256, 1 };
    vx_tensor inception_b5_1x7_3_scale_w = vxCreateTensor(context, 2, dims_inception_b5_1x7_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_3_scale_w);
    vx_size dims_inception_b5_1x7_3_scale_b[2] = { 256, 1 };
    vx_tensor inception_b5_1x7_3_scale_b = vxCreateTensor(context, 2, dims_inception_b5_1x7_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x7_3_scale_b);
    vx_size dims_inception_b5_1x1_w[4] = { 1, 1, 1024, 128 };
    vx_tensor inception_b5_1x1_w = vxCreateTensor(context, 4, dims_inception_b5_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x1_w);
    vx_size dims_inception_b5_1x1_bn_w[2] = { 128, 1 };
    vx_tensor inception_b5_1x1_bn_w = vxCreateTensor(context, 2, dims_inception_b5_1x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x1_bn_w);
    vx_size dims_inception_b5_1x1_bn_b[2] = { 128, 1 };
    vx_tensor inception_b5_1x1_bn_b = vxCreateTensor(context, 2, dims_inception_b5_1x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x1_bn_b);
    vx_size dims_inception_b5_1x1_scale_w[2] = { 128, 1 };
    vx_tensor inception_b5_1x1_scale_w = vxCreateTensor(context, 2, dims_inception_b5_1x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x1_scale_w);
    vx_size dims_inception_b5_1x1_scale_b[2] = { 128, 1 };
    vx_tensor inception_b5_1x1_scale_b = vxCreateTensor(context, 2, dims_inception_b5_1x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b5_1x1_scale_b);
    vx_size dims_inception_b6_1x1_2_w[4] = { 1, 1, 1024, 384 };
    vx_tensor inception_b6_1x1_2_w = vxCreateTensor(context, 4, dims_inception_b6_1x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x1_2_w);
    vx_size dims_inception_b6_1x1_2_bn_w[2] = { 384, 1 };
    vx_tensor inception_b6_1x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_b6_1x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x1_2_bn_w);
    vx_size dims_inception_b6_1x1_2_bn_b[2] = { 384, 1 };
    vx_tensor inception_b6_1x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_b6_1x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x1_2_bn_b);
    vx_size dims_inception_b6_1x1_2_scale_w[2] = { 384, 1 };
    vx_tensor inception_b6_1x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_b6_1x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x1_2_scale_w);
    vx_size dims_inception_b6_1x1_2_scale_b[2] = { 384, 1 };
    vx_tensor inception_b6_1x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_b6_1x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x1_2_scale_b);
    vx_size dims_inception_b6_1x7_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor inception_b6_1x7_reduce_w = vxCreateTensor(context, 4, dims_inception_b6_1x7_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_reduce_w);
    vx_size dims_inception_b6_1x7_reduce_bn_w[2] = { 192, 1 };
    vx_tensor inception_b6_1x7_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_b6_1x7_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_reduce_bn_w);
    vx_size dims_inception_b6_1x7_reduce_bn_b[2] = { 192, 1 };
    vx_tensor inception_b6_1x7_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_b6_1x7_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_reduce_bn_b);
    vx_size dims_inception_b6_1x7_reduce_scale_w[2] = { 192, 1 };
    vx_tensor inception_b6_1x7_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_b6_1x7_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_reduce_scale_w);
    vx_size dims_inception_b6_1x7_reduce_scale_b[2] = { 192, 1 };
    vx_tensor inception_b6_1x7_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_b6_1x7_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_reduce_scale_b);
    vx_size dims_inception_b6_1x7_w[4] = { 7, 1, 192, 224 };
    vx_tensor inception_b6_1x7_w = vxCreateTensor(context, 4, dims_inception_b6_1x7_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_w);
    vx_size dims_inception_b6_1x7_bn_w[2] = { 224, 1 };
    vx_tensor inception_b6_1x7_bn_w = vxCreateTensor(context, 2, dims_inception_b6_1x7_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_bn_w);
    vx_size dims_inception_b6_1x7_bn_b[2] = { 224, 1 };
    vx_tensor inception_b6_1x7_bn_b = vxCreateTensor(context, 2, dims_inception_b6_1x7_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_bn_b);
    vx_size dims_inception_b6_1x7_scale_w[2] = { 224, 1 };
    vx_tensor inception_b6_1x7_scale_w = vxCreateTensor(context, 2, dims_inception_b6_1x7_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_scale_w);
    vx_size dims_inception_b6_1x7_scale_b[2] = { 224, 1 };
    vx_tensor inception_b6_1x7_scale_b = vxCreateTensor(context, 2, dims_inception_b6_1x7_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_scale_b);
    vx_size dims_inception_b6_7x1_w[4] = { 1, 7, 224, 256 };
    vx_tensor inception_b6_7x1_w = vxCreateTensor(context, 4, dims_inception_b6_7x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_w);
    vx_size dims_inception_b6_7x1_bn_w[2] = { 256, 1 };
    vx_tensor inception_b6_7x1_bn_w = vxCreateTensor(context, 2, dims_inception_b6_7x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_bn_w);
    vx_size dims_inception_b6_7x1_bn_b[2] = { 256, 1 };
    vx_tensor inception_b6_7x1_bn_b = vxCreateTensor(context, 2, dims_inception_b6_7x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_bn_b);
    vx_size dims_inception_b6_7x1_scale_w[2] = { 256, 1 };
    vx_tensor inception_b6_7x1_scale_w = vxCreateTensor(context, 2, dims_inception_b6_7x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_scale_w);
    vx_size dims_inception_b6_7x1_scale_b[2] = { 256, 1 };
    vx_tensor inception_b6_7x1_scale_b = vxCreateTensor(context, 2, dims_inception_b6_7x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_scale_b);
    vx_size dims_inception_b6_7x1_2_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor inception_b6_7x1_2_reduce_w = vxCreateTensor(context, 4, dims_inception_b6_7x1_2_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_2_reduce_w);
    vx_size dims_inception_b6_7x1_2_reduce_bn_w[2] = { 192, 1 };
    vx_tensor inception_b6_7x1_2_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_b6_7x1_2_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_2_reduce_bn_w);
    vx_size dims_inception_b6_7x1_2_reduce_bn_b[2] = { 192, 1 };
    vx_tensor inception_b6_7x1_2_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_b6_7x1_2_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_2_reduce_bn_b);
    vx_size dims_inception_b6_7x1_2_reduce_scale_w[2] = { 192, 1 };
    vx_tensor inception_b6_7x1_2_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_b6_7x1_2_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_2_reduce_scale_w);
    vx_size dims_inception_b6_7x1_2_reduce_scale_b[2] = { 192, 1 };
    vx_tensor inception_b6_7x1_2_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_b6_7x1_2_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_2_reduce_scale_b);
    vx_size dims_inception_b6_7x1_2_w[4] = { 1, 7, 192, 192 };
    vx_tensor inception_b6_7x1_2_w = vxCreateTensor(context, 4, dims_inception_b6_7x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_2_w);
    vx_size dims_inception_b6_7x1_2_bn_w[2] = { 192, 1 };
    vx_tensor inception_b6_7x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_b6_7x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_2_bn_w);
    vx_size dims_inception_b6_7x1_2_bn_b[2] = { 192, 1 };
    vx_tensor inception_b6_7x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_b6_7x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_2_bn_b);
    vx_size dims_inception_b6_7x1_2_scale_w[2] = { 192, 1 };
    vx_tensor inception_b6_7x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_b6_7x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_2_scale_w);
    vx_size dims_inception_b6_7x1_2_scale_b[2] = { 192, 1 };
    vx_tensor inception_b6_7x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_b6_7x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_2_scale_b);
    vx_size dims_inception_b6_1x7_2_w[4] = { 7, 1, 192, 224 };
    vx_tensor inception_b6_1x7_2_w = vxCreateTensor(context, 4, dims_inception_b6_1x7_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_2_w);
    vx_size dims_inception_b6_1x7_2_bn_w[2] = { 224, 1 };
    vx_tensor inception_b6_1x7_2_bn_w = vxCreateTensor(context, 2, dims_inception_b6_1x7_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_2_bn_w);
    vx_size dims_inception_b6_1x7_2_bn_b[2] = { 224, 1 };
    vx_tensor inception_b6_1x7_2_bn_b = vxCreateTensor(context, 2, dims_inception_b6_1x7_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_2_bn_b);
    vx_size dims_inception_b6_1x7_2_scale_w[2] = { 224, 1 };
    vx_tensor inception_b6_1x7_2_scale_w = vxCreateTensor(context, 2, dims_inception_b6_1x7_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_2_scale_w);
    vx_size dims_inception_b6_1x7_2_scale_b[2] = { 224, 1 };
    vx_tensor inception_b6_1x7_2_scale_b = vxCreateTensor(context, 2, dims_inception_b6_1x7_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_2_scale_b);
    vx_size dims_inception_b6_7x1_3_w[4] = { 1, 7, 224, 224 };
    vx_tensor inception_b6_7x1_3_w = vxCreateTensor(context, 4, dims_inception_b6_7x1_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_3_w);
    vx_size dims_inception_b6_7x1_3_bn_w[2] = { 224, 1 };
    vx_tensor inception_b6_7x1_3_bn_w = vxCreateTensor(context, 2, dims_inception_b6_7x1_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_3_bn_w);
    vx_size dims_inception_b6_7x1_3_bn_b[2] = { 224, 1 };
    vx_tensor inception_b6_7x1_3_bn_b = vxCreateTensor(context, 2, dims_inception_b6_7x1_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_3_bn_b);
    vx_size dims_inception_b6_7x1_3_scale_w[2] = { 224, 1 };
    vx_tensor inception_b6_7x1_3_scale_w = vxCreateTensor(context, 2, dims_inception_b6_7x1_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_3_scale_w);
    vx_size dims_inception_b6_7x1_3_scale_b[2] = { 224, 1 };
    vx_tensor inception_b6_7x1_3_scale_b = vxCreateTensor(context, 2, dims_inception_b6_7x1_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_7x1_3_scale_b);
    vx_size dims_inception_b6_1x7_3_w[4] = { 7, 1, 224, 256 };
    vx_tensor inception_b6_1x7_3_w = vxCreateTensor(context, 4, dims_inception_b6_1x7_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_3_w);
    vx_size dims_inception_b6_1x7_3_bn_w[2] = { 256, 1 };
    vx_tensor inception_b6_1x7_3_bn_w = vxCreateTensor(context, 2, dims_inception_b6_1x7_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_3_bn_w);
    vx_size dims_inception_b6_1x7_3_bn_b[2] = { 256, 1 };
    vx_tensor inception_b6_1x7_3_bn_b = vxCreateTensor(context, 2, dims_inception_b6_1x7_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_3_bn_b);
    vx_size dims_inception_b6_1x7_3_scale_w[2] = { 256, 1 };
    vx_tensor inception_b6_1x7_3_scale_w = vxCreateTensor(context, 2, dims_inception_b6_1x7_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_3_scale_w);
    vx_size dims_inception_b6_1x7_3_scale_b[2] = { 256, 1 };
    vx_tensor inception_b6_1x7_3_scale_b = vxCreateTensor(context, 2, dims_inception_b6_1x7_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x7_3_scale_b);
    vx_size dims_inception_b6_1x1_w[4] = { 1, 1, 1024, 128 };
    vx_tensor inception_b6_1x1_w = vxCreateTensor(context, 4, dims_inception_b6_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x1_w);
    vx_size dims_inception_b6_1x1_bn_w[2] = { 128, 1 };
    vx_tensor inception_b6_1x1_bn_w = vxCreateTensor(context, 2, dims_inception_b6_1x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x1_bn_w);
    vx_size dims_inception_b6_1x1_bn_b[2] = { 128, 1 };
    vx_tensor inception_b6_1x1_bn_b = vxCreateTensor(context, 2, dims_inception_b6_1x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x1_bn_b);
    vx_size dims_inception_b6_1x1_scale_w[2] = { 128, 1 };
    vx_tensor inception_b6_1x1_scale_w = vxCreateTensor(context, 2, dims_inception_b6_1x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x1_scale_w);
    vx_size dims_inception_b6_1x1_scale_b[2] = { 128, 1 };
    vx_tensor inception_b6_1x1_scale_b = vxCreateTensor(context, 2, dims_inception_b6_1x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b6_1x1_scale_b);
    vx_size dims_inception_b7_1x1_2_w[4] = { 1, 1, 1024, 384 };
    vx_tensor inception_b7_1x1_2_w = vxCreateTensor(context, 4, dims_inception_b7_1x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x1_2_w);
    vx_size dims_inception_b7_1x1_2_bn_w[2] = { 384, 1 };
    vx_tensor inception_b7_1x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_b7_1x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x1_2_bn_w);
    vx_size dims_inception_b7_1x1_2_bn_b[2] = { 384, 1 };
    vx_tensor inception_b7_1x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_b7_1x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x1_2_bn_b);
    vx_size dims_inception_b7_1x1_2_scale_w[2] = { 384, 1 };
    vx_tensor inception_b7_1x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_b7_1x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x1_2_scale_w);
    vx_size dims_inception_b7_1x1_2_scale_b[2] = { 384, 1 };
    vx_tensor inception_b7_1x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_b7_1x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x1_2_scale_b);
    vx_size dims_inception_b7_1x7_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor inception_b7_1x7_reduce_w = vxCreateTensor(context, 4, dims_inception_b7_1x7_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_reduce_w);
    vx_size dims_inception_b7_1x7_reduce_bn_w[2] = { 192, 1 };
    vx_tensor inception_b7_1x7_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_b7_1x7_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_reduce_bn_w);
    vx_size dims_inception_b7_1x7_reduce_bn_b[2] = { 192, 1 };
    vx_tensor inception_b7_1x7_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_b7_1x7_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_reduce_bn_b);
    vx_size dims_inception_b7_1x7_reduce_scale_w[2] = { 192, 1 };
    vx_tensor inception_b7_1x7_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_b7_1x7_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_reduce_scale_w);
    vx_size dims_inception_b7_1x7_reduce_scale_b[2] = { 192, 1 };
    vx_tensor inception_b7_1x7_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_b7_1x7_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_reduce_scale_b);
    vx_size dims_inception_b7_1x7_w[4] = { 7, 1, 192, 224 };
    vx_tensor inception_b7_1x7_w = vxCreateTensor(context, 4, dims_inception_b7_1x7_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_w);
    vx_size dims_inception_b7_1x7_bn_w[2] = { 224, 1 };
    vx_tensor inception_b7_1x7_bn_w = vxCreateTensor(context, 2, dims_inception_b7_1x7_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_bn_w);
    vx_size dims_inception_b7_1x7_bn_b[2] = { 224, 1 };
    vx_tensor inception_b7_1x7_bn_b = vxCreateTensor(context, 2, dims_inception_b7_1x7_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_bn_b);
    vx_size dims_inception_b7_1x7_scale_w[2] = { 224, 1 };
    vx_tensor inception_b7_1x7_scale_w = vxCreateTensor(context, 2, dims_inception_b7_1x7_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_scale_w);
    vx_size dims_inception_b7_1x7_scale_b[2] = { 224, 1 };
    vx_tensor inception_b7_1x7_scale_b = vxCreateTensor(context, 2, dims_inception_b7_1x7_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_scale_b);
    vx_size dims_inception_b7_7x1_w[4] = { 1, 7, 224, 256 };
    vx_tensor inception_b7_7x1_w = vxCreateTensor(context, 4, dims_inception_b7_7x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_w);
    vx_size dims_inception_b7_7x1_bn_w[2] = { 256, 1 };
    vx_tensor inception_b7_7x1_bn_w = vxCreateTensor(context, 2, dims_inception_b7_7x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_bn_w);
    vx_size dims_inception_b7_7x1_bn_b[2] = { 256, 1 };
    vx_tensor inception_b7_7x1_bn_b = vxCreateTensor(context, 2, dims_inception_b7_7x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_bn_b);
    vx_size dims_inception_b7_7x1_scale_w[2] = { 256, 1 };
    vx_tensor inception_b7_7x1_scale_w = vxCreateTensor(context, 2, dims_inception_b7_7x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_scale_w);
    vx_size dims_inception_b7_7x1_scale_b[2] = { 256, 1 };
    vx_tensor inception_b7_7x1_scale_b = vxCreateTensor(context, 2, dims_inception_b7_7x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_scale_b);
    vx_size dims_inception_b7_7x1_2_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor inception_b7_7x1_2_reduce_w = vxCreateTensor(context, 4, dims_inception_b7_7x1_2_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_2_reduce_w);
    vx_size dims_inception_b7_7x1_2_reduce_bn_w[2] = { 192, 1 };
    vx_tensor inception_b7_7x1_2_reduce_bn_w = vxCreateTensor(context, 2, dims_inception_b7_7x1_2_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_2_reduce_bn_w);
    vx_size dims_inception_b7_7x1_2_reduce_bn_b[2] = { 192, 1 };
    vx_tensor inception_b7_7x1_2_reduce_bn_b = vxCreateTensor(context, 2, dims_inception_b7_7x1_2_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_2_reduce_bn_b);
    vx_size dims_inception_b7_7x1_2_reduce_scale_w[2] = { 192, 1 };
    vx_tensor inception_b7_7x1_2_reduce_scale_w = vxCreateTensor(context, 2, dims_inception_b7_7x1_2_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_2_reduce_scale_w);
    vx_size dims_inception_b7_7x1_2_reduce_scale_b[2] = { 192, 1 };
    vx_tensor inception_b7_7x1_2_reduce_scale_b = vxCreateTensor(context, 2, dims_inception_b7_7x1_2_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_2_reduce_scale_b);
    vx_size dims_inception_b7_7x1_2_w[4] = { 1, 7, 192, 192 };
    vx_tensor inception_b7_7x1_2_w = vxCreateTensor(context, 4, dims_inception_b7_7x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_2_w);
    vx_size dims_inception_b7_7x1_2_bn_w[2] = { 192, 1 };
    vx_tensor inception_b7_7x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_b7_7x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_2_bn_w);
    vx_size dims_inception_b7_7x1_2_bn_b[2] = { 192, 1 };
    vx_tensor inception_b7_7x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_b7_7x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_2_bn_b);
    vx_size dims_inception_b7_7x1_2_scale_w[2] = { 192, 1 };
    vx_tensor inception_b7_7x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_b7_7x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_2_scale_w);
    vx_size dims_inception_b7_7x1_2_scale_b[2] = { 192, 1 };
    vx_tensor inception_b7_7x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_b7_7x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_2_scale_b);
    vx_size dims_inception_b7_1x7_2_w[4] = { 7, 1, 192, 224 };
    vx_tensor inception_b7_1x7_2_w = vxCreateTensor(context, 4, dims_inception_b7_1x7_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_2_w);
    vx_size dims_inception_b7_1x7_2_bn_w[2] = { 224, 1 };
    vx_tensor inception_b7_1x7_2_bn_w = vxCreateTensor(context, 2, dims_inception_b7_1x7_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_2_bn_w);
    vx_size dims_inception_b7_1x7_2_bn_b[2] = { 224, 1 };
    vx_tensor inception_b7_1x7_2_bn_b = vxCreateTensor(context, 2, dims_inception_b7_1x7_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_2_bn_b);
    vx_size dims_inception_b7_1x7_2_scale_w[2] = { 224, 1 };
    vx_tensor inception_b7_1x7_2_scale_w = vxCreateTensor(context, 2, dims_inception_b7_1x7_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_2_scale_w);
    vx_size dims_inception_b7_1x7_2_scale_b[2] = { 224, 1 };
    vx_tensor inception_b7_1x7_2_scale_b = vxCreateTensor(context, 2, dims_inception_b7_1x7_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_2_scale_b);
    vx_size dims_inception_b7_7x1_3_w[4] = { 1, 7, 224, 224 };
    vx_tensor inception_b7_7x1_3_w = vxCreateTensor(context, 4, dims_inception_b7_7x1_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_3_w);
    vx_size dims_inception_b7_7x1_3_bn_w[2] = { 224, 1 };
    vx_tensor inception_b7_7x1_3_bn_w = vxCreateTensor(context, 2, dims_inception_b7_7x1_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_3_bn_w);
    vx_size dims_inception_b7_7x1_3_bn_b[2] = { 224, 1 };
    vx_tensor inception_b7_7x1_3_bn_b = vxCreateTensor(context, 2, dims_inception_b7_7x1_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_3_bn_b);
    vx_size dims_inception_b7_7x1_3_scale_w[2] = { 224, 1 };
    vx_tensor inception_b7_7x1_3_scale_w = vxCreateTensor(context, 2, dims_inception_b7_7x1_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_3_scale_w);
    vx_size dims_inception_b7_7x1_3_scale_b[2] = { 224, 1 };
    vx_tensor inception_b7_7x1_3_scale_b = vxCreateTensor(context, 2, dims_inception_b7_7x1_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_7x1_3_scale_b);
    vx_size dims_inception_b7_1x7_3_w[4] = { 7, 1, 224, 256 };
    vx_tensor inception_b7_1x7_3_w = vxCreateTensor(context, 4, dims_inception_b7_1x7_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_3_w);
    vx_size dims_inception_b7_1x7_3_bn_w[2] = { 256, 1 };
    vx_tensor inception_b7_1x7_3_bn_w = vxCreateTensor(context, 2, dims_inception_b7_1x7_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_3_bn_w);
    vx_size dims_inception_b7_1x7_3_bn_b[2] = { 256, 1 };
    vx_tensor inception_b7_1x7_3_bn_b = vxCreateTensor(context, 2, dims_inception_b7_1x7_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_3_bn_b);
    vx_size dims_inception_b7_1x7_3_scale_w[2] = { 256, 1 };
    vx_tensor inception_b7_1x7_3_scale_w = vxCreateTensor(context, 2, dims_inception_b7_1x7_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_3_scale_w);
    vx_size dims_inception_b7_1x7_3_scale_b[2] = { 256, 1 };
    vx_tensor inception_b7_1x7_3_scale_b = vxCreateTensor(context, 2, dims_inception_b7_1x7_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x7_3_scale_b);
    vx_size dims_inception_b7_1x1_w[4] = { 1, 1, 1024, 128 };
    vx_tensor inception_b7_1x1_w = vxCreateTensor(context, 4, dims_inception_b7_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x1_w);
    vx_size dims_inception_b7_1x1_bn_w[2] = { 128, 1 };
    vx_tensor inception_b7_1x1_bn_w = vxCreateTensor(context, 2, dims_inception_b7_1x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x1_bn_w);
    vx_size dims_inception_b7_1x1_bn_b[2] = { 128, 1 };
    vx_tensor inception_b7_1x1_bn_b = vxCreateTensor(context, 2, dims_inception_b7_1x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x1_bn_b);
    vx_size dims_inception_b7_1x1_scale_w[2] = { 128, 1 };
    vx_tensor inception_b7_1x1_scale_w = vxCreateTensor(context, 2, dims_inception_b7_1x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x1_scale_w);
    vx_size dims_inception_b7_1x1_scale_b[2] = { 128, 1 };
    vx_tensor inception_b7_1x1_scale_b = vxCreateTensor(context, 2, dims_inception_b7_1x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_b7_1x1_scale_b);
    vx_size dims_reduction_b_3x3_reduce_w[4] = { 1, 1, 1024, 192 };
    vx_tensor reduction_b_3x3_reduce_w = vxCreateTensor(context, 4, dims_reduction_b_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_reduce_w);
    vx_size dims_reduction_b_3x3_reduce_bn_w[2] = { 192, 1 };
    vx_tensor reduction_b_3x3_reduce_bn_w = vxCreateTensor(context, 2, dims_reduction_b_3x3_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_reduce_bn_w);
    vx_size dims_reduction_b_3x3_reduce_bn_b[2] = { 192, 1 };
    vx_tensor reduction_b_3x3_reduce_bn_b = vxCreateTensor(context, 2, dims_reduction_b_3x3_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_reduce_bn_b);
    vx_size dims_reduction_b_3x3_reduce_scale_w[2] = { 192, 1 };
    vx_tensor reduction_b_3x3_reduce_scale_w = vxCreateTensor(context, 2, dims_reduction_b_3x3_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_reduce_scale_w);
    vx_size dims_reduction_b_3x3_reduce_scale_b[2] = { 192, 1 };
    vx_tensor reduction_b_3x3_reduce_scale_b = vxCreateTensor(context, 2, dims_reduction_b_3x3_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_reduce_scale_b);
    vx_size dims_reduction_b_3x3_w[4] = { 3, 3, 192, 192 };
    vx_tensor reduction_b_3x3_w = vxCreateTensor(context, 4, dims_reduction_b_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_w);
    vx_size dims_reduction_b_3x3_bn_w[2] = { 192, 1 };
    vx_tensor reduction_b_3x3_bn_w = vxCreateTensor(context, 2, dims_reduction_b_3x3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_bn_w);
    vx_size dims_reduction_b_3x3_bn_b[2] = { 192, 1 };
    vx_tensor reduction_b_3x3_bn_b = vxCreateTensor(context, 2, dims_reduction_b_3x3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_bn_b);
    vx_size dims_reduction_b_3x3_scale_w[2] = { 192, 1 };
    vx_tensor reduction_b_3x3_scale_w = vxCreateTensor(context, 2, dims_reduction_b_3x3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_scale_w);
    vx_size dims_reduction_b_3x3_scale_b[2] = { 192, 1 };
    vx_tensor reduction_b_3x3_scale_b = vxCreateTensor(context, 2, dims_reduction_b_3x3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_scale_b);
    vx_size dims_reduction_b_1x7_reduce_w[4] = { 1, 1, 1024, 256 };
    vx_tensor reduction_b_1x7_reduce_w = vxCreateTensor(context, 4, dims_reduction_b_1x7_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_1x7_reduce_w);
    vx_size dims_reduction_b_1x7_reduce_bn_w[2] = { 256, 1 };
    vx_tensor reduction_b_1x7_reduce_bn_w = vxCreateTensor(context, 2, dims_reduction_b_1x7_reduce_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_1x7_reduce_bn_w);
    vx_size dims_reduction_b_1x7_reduce_bn_b[2] = { 256, 1 };
    vx_tensor reduction_b_1x7_reduce_bn_b = vxCreateTensor(context, 2, dims_reduction_b_1x7_reduce_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_1x7_reduce_bn_b);
    vx_size dims_reduction_b_1x7_reduce_scale_w[2] = { 256, 1 };
    vx_tensor reduction_b_1x7_reduce_scale_w = vxCreateTensor(context, 2, dims_reduction_b_1x7_reduce_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_1x7_reduce_scale_w);
    vx_size dims_reduction_b_1x7_reduce_scale_b[2] = { 256, 1 };
    vx_tensor reduction_b_1x7_reduce_scale_b = vxCreateTensor(context, 2, dims_reduction_b_1x7_reduce_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_1x7_reduce_scale_b);
    vx_size dims_reduction_b_1x7_w[4] = { 7, 1, 256, 256 };
    vx_tensor reduction_b_1x7_w = vxCreateTensor(context, 4, dims_reduction_b_1x7_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_1x7_w);
    vx_size dims_reduction_b_1x7_bn_w[2] = { 256, 1 };
    vx_tensor reduction_b_1x7_bn_w = vxCreateTensor(context, 2, dims_reduction_b_1x7_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_1x7_bn_w);
    vx_size dims_reduction_b_1x7_bn_b[2] = { 256, 1 };
    vx_tensor reduction_b_1x7_bn_b = vxCreateTensor(context, 2, dims_reduction_b_1x7_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_1x7_bn_b);
    vx_size dims_reduction_b_1x7_scale_w[2] = { 256, 1 };
    vx_tensor reduction_b_1x7_scale_w = vxCreateTensor(context, 2, dims_reduction_b_1x7_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_1x7_scale_w);
    vx_size dims_reduction_b_1x7_scale_b[2] = { 256, 1 };
    vx_tensor reduction_b_1x7_scale_b = vxCreateTensor(context, 2, dims_reduction_b_1x7_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_1x7_scale_b);
    vx_size dims_reduction_b_7x1_w[4] = { 1, 7, 256, 320 };
    vx_tensor reduction_b_7x1_w = vxCreateTensor(context, 4, dims_reduction_b_7x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_7x1_w);
    vx_size dims_reduction_b_7x1_bn_w[2] = { 320, 1 };
    vx_tensor reduction_b_7x1_bn_w = vxCreateTensor(context, 2, dims_reduction_b_7x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_7x1_bn_w);
    vx_size dims_reduction_b_7x1_bn_b[2] = { 320, 1 };
    vx_tensor reduction_b_7x1_bn_b = vxCreateTensor(context, 2, dims_reduction_b_7x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_7x1_bn_b);
    vx_size dims_reduction_b_7x1_scale_w[2] = { 320, 1 };
    vx_tensor reduction_b_7x1_scale_w = vxCreateTensor(context, 2, dims_reduction_b_7x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_7x1_scale_w);
    vx_size dims_reduction_b_7x1_scale_b[2] = { 320, 1 };
    vx_tensor reduction_b_7x1_scale_b = vxCreateTensor(context, 2, dims_reduction_b_7x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_7x1_scale_b);
    vx_size dims_reduction_b_3x3_2_w[4] = { 3, 3, 320, 320 };
    vx_tensor reduction_b_3x3_2_w = vxCreateTensor(context, 4, dims_reduction_b_3x3_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_2_w);
    vx_size dims_reduction_b_3x3_2_bn_w[2] = { 320, 1 };
    vx_tensor reduction_b_3x3_2_bn_w = vxCreateTensor(context, 2, dims_reduction_b_3x3_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_2_bn_w);
    vx_size dims_reduction_b_3x3_2_bn_b[2] = { 320, 1 };
    vx_tensor reduction_b_3x3_2_bn_b = vxCreateTensor(context, 2, dims_reduction_b_3x3_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_2_bn_b);
    vx_size dims_reduction_b_3x3_2_scale_w[2] = { 320, 1 };
    vx_tensor reduction_b_3x3_2_scale_w = vxCreateTensor(context, 2, dims_reduction_b_3x3_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_2_scale_w);
    vx_size dims_reduction_b_3x3_2_scale_b[2] = { 320, 1 };
    vx_tensor reduction_b_3x3_2_scale_b = vxCreateTensor(context, 2, dims_reduction_b_3x3_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(reduction_b_3x3_2_scale_b);
    vx_size dims_inception_c1_1x1_2_w[4] = { 1, 1, 1536, 256 };
    vx_tensor inception_c1_1x1_2_w = vxCreateTensor(context, 4, dims_inception_c1_1x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_2_w);
    vx_size dims_inception_c1_1x1_2_bn_w[2] = { 256, 1 };
    vx_tensor inception_c1_1x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_c1_1x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_2_bn_w);
    vx_size dims_inception_c1_1x1_2_bn_b[2] = { 256, 1 };
    vx_tensor inception_c1_1x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_c1_1x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_2_bn_b);
    vx_size dims_inception_c1_1x1_2_scale_w[2] = { 256, 1 };
    vx_tensor inception_c1_1x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_c1_1x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_2_scale_w);
    vx_size dims_inception_c1_1x1_2_scale_b[2] = { 256, 1 };
    vx_tensor inception_c1_1x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_c1_1x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_2_scale_b);
    vx_size dims_inception_c1_1x1_3_w[4] = { 1, 1, 1536, 384 };
    vx_tensor inception_c1_1x1_3_w = vxCreateTensor(context, 4, dims_inception_c1_1x1_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_3_w);
    vx_size dims_inception_c1_1x1_3_bn_w[2] = { 384, 1 };
    vx_tensor inception_c1_1x1_3_bn_w = vxCreateTensor(context, 2, dims_inception_c1_1x1_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_3_bn_w);
    vx_size dims_inception_c1_1x1_3_bn_b[2] = { 384, 1 };
    vx_tensor inception_c1_1x1_3_bn_b = vxCreateTensor(context, 2, dims_inception_c1_1x1_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_3_bn_b);
    vx_size dims_inception_c1_1x1_3_scale_w[2] = { 384, 1 };
    vx_tensor inception_c1_1x1_3_scale_w = vxCreateTensor(context, 2, dims_inception_c1_1x1_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_3_scale_w);
    vx_size dims_inception_c1_1x1_3_scale_b[2] = { 384, 1 };
    vx_tensor inception_c1_1x1_3_scale_b = vxCreateTensor(context, 2, dims_inception_c1_1x1_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_3_scale_b);
    vx_size dims_inception_c1_1x3_w[4] = { 3, 1, 384, 256 };
    vx_tensor inception_c1_1x3_w = vxCreateTensor(context, 4, dims_inception_c1_1x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_w);
    vx_size dims_inception_c1_1x3_bn_w[2] = { 256, 1 };
    vx_tensor inception_c1_1x3_bn_w = vxCreateTensor(context, 2, dims_inception_c1_1x3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_bn_w);
    vx_size dims_inception_c1_1x3_bn_b[2] = { 256, 1 };
    vx_tensor inception_c1_1x3_bn_b = vxCreateTensor(context, 2, dims_inception_c1_1x3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_bn_b);
    vx_size dims_inception_c1_1x3_scale_w[2] = { 256, 1 };
    vx_tensor inception_c1_1x3_scale_w = vxCreateTensor(context, 2, dims_inception_c1_1x3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_scale_w);
    vx_size dims_inception_c1_1x3_scale_b[2] = { 256, 1 };
    vx_tensor inception_c1_1x3_scale_b = vxCreateTensor(context, 2, dims_inception_c1_1x3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_scale_b);
    vx_size dims_inception_c1_3x1_w[4] = { 1, 3, 384, 256 };
    vx_tensor inception_c1_3x1_w = vxCreateTensor(context, 4, dims_inception_c1_3x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_w);
    vx_size dims_inception_c1_3x1_bn_w[2] = { 256, 1 };
    vx_tensor inception_c1_3x1_bn_w = vxCreateTensor(context, 2, dims_inception_c1_3x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_bn_w);
    vx_size dims_inception_c1_3x1_bn_b[2] = { 256, 1 };
    vx_tensor inception_c1_3x1_bn_b = vxCreateTensor(context, 2, dims_inception_c1_3x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_bn_b);
    vx_size dims_inception_c1_3x1_scale_w[2] = { 256, 1 };
    vx_tensor inception_c1_3x1_scale_w = vxCreateTensor(context, 2, dims_inception_c1_3x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_scale_w);
    vx_size dims_inception_c1_3x1_scale_b[2] = { 256, 1 };
    vx_tensor inception_c1_3x1_scale_b = vxCreateTensor(context, 2, dims_inception_c1_3x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_scale_b);
    vx_size dims_inception_c1_1x1_4_w[4] = { 1, 1, 1536, 384 };
    vx_tensor inception_c1_1x1_4_w = vxCreateTensor(context, 4, dims_inception_c1_1x1_4_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_4_w);
    vx_size dims_inception_c1_1x1_4_bn_w[2] = { 384, 1 };
    vx_tensor inception_c1_1x1_4_bn_w = vxCreateTensor(context, 2, dims_inception_c1_1x1_4_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_4_bn_w);
    vx_size dims_inception_c1_1x1_4_bn_b[2] = { 384, 1 };
    vx_tensor inception_c1_1x1_4_bn_b = vxCreateTensor(context, 2, dims_inception_c1_1x1_4_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_4_bn_b);
    vx_size dims_inception_c1_1x1_4_scale_w[2] = { 384, 1 };
    vx_tensor inception_c1_1x1_4_scale_w = vxCreateTensor(context, 2, dims_inception_c1_1x1_4_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_4_scale_w);
    vx_size dims_inception_c1_1x1_4_scale_b[2] = { 384, 1 };
    vx_tensor inception_c1_1x1_4_scale_b = vxCreateTensor(context, 2, dims_inception_c1_1x1_4_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_4_scale_b);
    vx_size dims_inception_c1_3x1_2_w[4] = { 1, 3, 384, 448 };
    vx_tensor inception_c1_3x1_2_w = vxCreateTensor(context, 4, dims_inception_c1_3x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_2_w);
    vx_size dims_inception_c1_3x1_2_bn_w[2] = { 448, 1 };
    vx_tensor inception_c1_3x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_c1_3x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_2_bn_w);
    vx_size dims_inception_c1_3x1_2_bn_b[2] = { 448, 1 };
    vx_tensor inception_c1_3x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_c1_3x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_2_bn_b);
    vx_size dims_inception_c1_3x1_2_scale_w[2] = { 448, 1 };
    vx_tensor inception_c1_3x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_c1_3x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_2_scale_w);
    vx_size dims_inception_c1_3x1_2_scale_b[2] = { 448, 1 };
    vx_tensor inception_c1_3x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_c1_3x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_2_scale_b);
    vx_size dims_inception_c1_1x3_2_w[4] = { 3, 1, 448, 512 };
    vx_tensor inception_c1_1x3_2_w = vxCreateTensor(context, 4, dims_inception_c1_1x3_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_2_w);
    vx_size dims_inception_c1_1x3_2_bn_w[2] = { 512, 1 };
    vx_tensor inception_c1_1x3_2_bn_w = vxCreateTensor(context, 2, dims_inception_c1_1x3_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_2_bn_w);
    vx_size dims_inception_c1_1x3_2_bn_b[2] = { 512, 1 };
    vx_tensor inception_c1_1x3_2_bn_b = vxCreateTensor(context, 2, dims_inception_c1_1x3_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_2_bn_b);
    vx_size dims_inception_c1_1x3_2_scale_w[2] = { 512, 1 };
    vx_tensor inception_c1_1x3_2_scale_w = vxCreateTensor(context, 2, dims_inception_c1_1x3_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_2_scale_w);
    vx_size dims_inception_c1_1x3_2_scale_b[2] = { 512, 1 };
    vx_tensor inception_c1_1x3_2_scale_b = vxCreateTensor(context, 2, dims_inception_c1_1x3_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_2_scale_b);
    vx_size dims_inception_c1_1x3_3_w[4] = { 3, 1, 512, 256 };
    vx_tensor inception_c1_1x3_3_w = vxCreateTensor(context, 4, dims_inception_c1_1x3_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_3_w);
    vx_size dims_inception_c1_1x3_3_bn_w[2] = { 256, 1 };
    vx_tensor inception_c1_1x3_3_bn_w = vxCreateTensor(context, 2, dims_inception_c1_1x3_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_3_bn_w);
    vx_size dims_inception_c1_1x3_3_bn_b[2] = { 256, 1 };
    vx_tensor inception_c1_1x3_3_bn_b = vxCreateTensor(context, 2, dims_inception_c1_1x3_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_3_bn_b);
    vx_size dims_inception_c1_1x3_3_scale_w[2] = { 256, 1 };
    vx_tensor inception_c1_1x3_3_scale_w = vxCreateTensor(context, 2, dims_inception_c1_1x3_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_3_scale_w);
    vx_size dims_inception_c1_1x3_3_scale_b[2] = { 256, 1 };
    vx_tensor inception_c1_1x3_3_scale_b = vxCreateTensor(context, 2, dims_inception_c1_1x3_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x3_3_scale_b);
    vx_size dims_inception_c1_3x1_3_w[4] = { 1, 3, 512, 256 };
    vx_tensor inception_c1_3x1_3_w = vxCreateTensor(context, 4, dims_inception_c1_3x1_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_3_w);
    vx_size dims_inception_c1_3x1_3_bn_w[2] = { 256, 1 };
    vx_tensor inception_c1_3x1_3_bn_w = vxCreateTensor(context, 2, dims_inception_c1_3x1_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_3_bn_w);
    vx_size dims_inception_c1_3x1_3_bn_b[2] = { 256, 1 };
    vx_tensor inception_c1_3x1_3_bn_b = vxCreateTensor(context, 2, dims_inception_c1_3x1_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_3_bn_b);
    vx_size dims_inception_c1_3x1_3_scale_w[2] = { 256, 1 };
    vx_tensor inception_c1_3x1_3_scale_w = vxCreateTensor(context, 2, dims_inception_c1_3x1_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_3_scale_w);
    vx_size dims_inception_c1_3x1_3_scale_b[2] = { 256, 1 };
    vx_tensor inception_c1_3x1_3_scale_b = vxCreateTensor(context, 2, dims_inception_c1_3x1_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_3x1_3_scale_b);
    vx_size dims_inception_c1_1x1_w[4] = { 1, 1, 1536, 256 };
    vx_tensor inception_c1_1x1_w = vxCreateTensor(context, 4, dims_inception_c1_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_w);
    vx_size dims_inception_c1_1x1_bn_w[2] = { 256, 1 };
    vx_tensor inception_c1_1x1_bn_w = vxCreateTensor(context, 2, dims_inception_c1_1x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_bn_w);
    vx_size dims_inception_c1_1x1_bn_b[2] = { 256, 1 };
    vx_tensor inception_c1_1x1_bn_b = vxCreateTensor(context, 2, dims_inception_c1_1x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_bn_b);
    vx_size dims_inception_c1_1x1_scale_w[2] = { 256, 1 };
    vx_tensor inception_c1_1x1_scale_w = vxCreateTensor(context, 2, dims_inception_c1_1x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_scale_w);
    vx_size dims_inception_c1_1x1_scale_b[2] = { 256, 1 };
    vx_tensor inception_c1_1x1_scale_b = vxCreateTensor(context, 2, dims_inception_c1_1x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c1_1x1_scale_b);
    vx_size dims_inception_c2_1x1_2_w[4] = { 1, 1, 1536, 256 };
    vx_tensor inception_c2_1x1_2_w = vxCreateTensor(context, 4, dims_inception_c2_1x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_2_w);
    vx_size dims_inception_c2_1x1_2_bn_w[2] = { 256, 1 };
    vx_tensor inception_c2_1x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_c2_1x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_2_bn_w);
    vx_size dims_inception_c2_1x1_2_bn_b[2] = { 256, 1 };
    vx_tensor inception_c2_1x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_c2_1x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_2_bn_b);
    vx_size dims_inception_c2_1x1_2_scale_w[2] = { 256, 1 };
    vx_tensor inception_c2_1x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_c2_1x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_2_scale_w);
    vx_size dims_inception_c2_1x1_2_scale_b[2] = { 256, 1 };
    vx_tensor inception_c2_1x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_c2_1x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_2_scale_b);
    vx_size dims_inception_c2_1x1_3_w[4] = { 1, 1, 1536, 384 };
    vx_tensor inception_c2_1x1_3_w = vxCreateTensor(context, 4, dims_inception_c2_1x1_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_3_w);
    vx_size dims_inception_c2_1x1_3_bn_w[2] = { 384, 1 };
    vx_tensor inception_c2_1x1_3_bn_w = vxCreateTensor(context, 2, dims_inception_c2_1x1_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_3_bn_w);
    vx_size dims_inception_c2_1x1_3_bn_b[2] = { 384, 1 };
    vx_tensor inception_c2_1x1_3_bn_b = vxCreateTensor(context, 2, dims_inception_c2_1x1_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_3_bn_b);
    vx_size dims_inception_c2_1x1_3_scale_w[2] = { 384, 1 };
    vx_tensor inception_c2_1x1_3_scale_w = vxCreateTensor(context, 2, dims_inception_c2_1x1_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_3_scale_w);
    vx_size dims_inception_c2_1x1_3_scale_b[2] = { 384, 1 };
    vx_tensor inception_c2_1x1_3_scale_b = vxCreateTensor(context, 2, dims_inception_c2_1x1_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_3_scale_b);
    vx_size dims_inception_c2_1x3_w[4] = { 3, 1, 384, 256 };
    vx_tensor inception_c2_1x3_w = vxCreateTensor(context, 4, dims_inception_c2_1x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_w);
    vx_size dims_inception_c2_1x3_bn_w[2] = { 256, 1 };
    vx_tensor inception_c2_1x3_bn_w = vxCreateTensor(context, 2, dims_inception_c2_1x3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_bn_w);
    vx_size dims_inception_c2_1x3_bn_b[2] = { 256, 1 };
    vx_tensor inception_c2_1x3_bn_b = vxCreateTensor(context, 2, dims_inception_c2_1x3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_bn_b);
    vx_size dims_inception_c2_1x3_scale_w[2] = { 256, 1 };
    vx_tensor inception_c2_1x3_scale_w = vxCreateTensor(context, 2, dims_inception_c2_1x3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_scale_w);
    vx_size dims_inception_c2_1x3_scale_b[2] = { 256, 1 };
    vx_tensor inception_c2_1x3_scale_b = vxCreateTensor(context, 2, dims_inception_c2_1x3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_scale_b);
    vx_size dims_inception_c2_3x1_w[4] = { 1, 3, 384, 256 };
    vx_tensor inception_c2_3x1_w = vxCreateTensor(context, 4, dims_inception_c2_3x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_w);
    vx_size dims_inception_c2_3x1_bn_w[2] = { 256, 1 };
    vx_tensor inception_c2_3x1_bn_w = vxCreateTensor(context, 2, dims_inception_c2_3x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_bn_w);
    vx_size dims_inception_c2_3x1_bn_b[2] = { 256, 1 };
    vx_tensor inception_c2_3x1_bn_b = vxCreateTensor(context, 2, dims_inception_c2_3x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_bn_b);
    vx_size dims_inception_c2_3x1_scale_w[2] = { 256, 1 };
    vx_tensor inception_c2_3x1_scale_w = vxCreateTensor(context, 2, dims_inception_c2_3x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_scale_w);
    vx_size dims_inception_c2_3x1_scale_b[2] = { 256, 1 };
    vx_tensor inception_c2_3x1_scale_b = vxCreateTensor(context, 2, dims_inception_c2_3x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_scale_b);
    vx_size dims_inception_c2_1x1_4_w[4] = { 1, 1, 1536, 384 };
    vx_tensor inception_c2_1x1_4_w = vxCreateTensor(context, 4, dims_inception_c2_1x1_4_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_4_w);
    vx_size dims_inception_c2_1x1_4_bn_w[2] = { 384, 1 };
    vx_tensor inception_c2_1x1_4_bn_w = vxCreateTensor(context, 2, dims_inception_c2_1x1_4_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_4_bn_w);
    vx_size dims_inception_c2_1x1_4_bn_b[2] = { 384, 1 };
    vx_tensor inception_c2_1x1_4_bn_b = vxCreateTensor(context, 2, dims_inception_c2_1x1_4_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_4_bn_b);
    vx_size dims_inception_c2_1x1_4_scale_w[2] = { 384, 1 };
    vx_tensor inception_c2_1x1_4_scale_w = vxCreateTensor(context, 2, dims_inception_c2_1x1_4_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_4_scale_w);
    vx_size dims_inception_c2_1x1_4_scale_b[2] = { 384, 1 };
    vx_tensor inception_c2_1x1_4_scale_b = vxCreateTensor(context, 2, dims_inception_c2_1x1_4_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_4_scale_b);
    vx_size dims_inception_c2_3x1_2_w[4] = { 1, 3, 384, 448 };
    vx_tensor inception_c2_3x1_2_w = vxCreateTensor(context, 4, dims_inception_c2_3x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_2_w);
    vx_size dims_inception_c2_3x1_2_bn_w[2] = { 448, 1 };
    vx_tensor inception_c2_3x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_c2_3x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_2_bn_w);
    vx_size dims_inception_c2_3x1_2_bn_b[2] = { 448, 1 };
    vx_tensor inception_c2_3x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_c2_3x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_2_bn_b);
    vx_size dims_inception_c2_3x1_2_scale_w[2] = { 448, 1 };
    vx_tensor inception_c2_3x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_c2_3x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_2_scale_w);
    vx_size dims_inception_c2_3x1_2_scale_b[2] = { 448, 1 };
    vx_tensor inception_c2_3x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_c2_3x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_2_scale_b);
    vx_size dims_inception_c2_1x3_2_w[4] = { 3, 1, 448, 512 };
    vx_tensor inception_c2_1x3_2_w = vxCreateTensor(context, 4, dims_inception_c2_1x3_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_2_w);
    vx_size dims_inception_c2_1x3_2_bn_w[2] = { 512, 1 };
    vx_tensor inception_c2_1x3_2_bn_w = vxCreateTensor(context, 2, dims_inception_c2_1x3_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_2_bn_w);
    vx_size dims_inception_c2_1x3_2_bn_b[2] = { 512, 1 };
    vx_tensor inception_c2_1x3_2_bn_b = vxCreateTensor(context, 2, dims_inception_c2_1x3_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_2_bn_b);
    vx_size dims_inception_c2_1x3_2_scale_w[2] = { 512, 1 };
    vx_tensor inception_c2_1x3_2_scale_w = vxCreateTensor(context, 2, dims_inception_c2_1x3_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_2_scale_w);
    vx_size dims_inception_c2_1x3_2_scale_b[2] = { 512, 1 };
    vx_tensor inception_c2_1x3_2_scale_b = vxCreateTensor(context, 2, dims_inception_c2_1x3_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_2_scale_b);
    vx_size dims_inception_c2_1x3_3_w[4] = { 3, 1, 512, 256 };
    vx_tensor inception_c2_1x3_3_w = vxCreateTensor(context, 4, dims_inception_c2_1x3_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_3_w);
    vx_size dims_inception_c2_1x3_3_bn_w[2] = { 256, 1 };
    vx_tensor inception_c2_1x3_3_bn_w = vxCreateTensor(context, 2, dims_inception_c2_1x3_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_3_bn_w);
    vx_size dims_inception_c2_1x3_3_bn_b[2] = { 256, 1 };
    vx_tensor inception_c2_1x3_3_bn_b = vxCreateTensor(context, 2, dims_inception_c2_1x3_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_3_bn_b);
    vx_size dims_inception_c2_1x3_3_scale_w[2] = { 256, 1 };
    vx_tensor inception_c2_1x3_3_scale_w = vxCreateTensor(context, 2, dims_inception_c2_1x3_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_3_scale_w);
    vx_size dims_inception_c2_1x3_3_scale_b[2] = { 256, 1 };
    vx_tensor inception_c2_1x3_3_scale_b = vxCreateTensor(context, 2, dims_inception_c2_1x3_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x3_3_scale_b);
    vx_size dims_inception_c2_3x1_3_w[4] = { 1, 3, 512, 256 };
    vx_tensor inception_c2_3x1_3_w = vxCreateTensor(context, 4, dims_inception_c2_3x1_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_3_w);
    vx_size dims_inception_c2_3x1_3_bn_w[2] = { 256, 1 };
    vx_tensor inception_c2_3x1_3_bn_w = vxCreateTensor(context, 2, dims_inception_c2_3x1_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_3_bn_w);
    vx_size dims_inception_c2_3x1_3_bn_b[2] = { 256, 1 };
    vx_tensor inception_c2_3x1_3_bn_b = vxCreateTensor(context, 2, dims_inception_c2_3x1_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_3_bn_b);
    vx_size dims_inception_c2_3x1_3_scale_w[2] = { 256, 1 };
    vx_tensor inception_c2_3x1_3_scale_w = vxCreateTensor(context, 2, dims_inception_c2_3x1_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_3_scale_w);
    vx_size dims_inception_c2_3x1_3_scale_b[2] = { 256, 1 };
    vx_tensor inception_c2_3x1_3_scale_b = vxCreateTensor(context, 2, dims_inception_c2_3x1_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_3x1_3_scale_b);
    vx_size dims_inception_c2_1x1_w[4] = { 1, 1, 1536, 256 };
    vx_tensor inception_c2_1x1_w = vxCreateTensor(context, 4, dims_inception_c2_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_w);
    vx_size dims_inception_c2_1x1_bn_w[2] = { 256, 1 };
    vx_tensor inception_c2_1x1_bn_w = vxCreateTensor(context, 2, dims_inception_c2_1x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_bn_w);
    vx_size dims_inception_c2_1x1_bn_b[2] = { 256, 1 };
    vx_tensor inception_c2_1x1_bn_b = vxCreateTensor(context, 2, dims_inception_c2_1x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_bn_b);
    vx_size dims_inception_c2_1x1_scale_w[2] = { 256, 1 };
    vx_tensor inception_c2_1x1_scale_w = vxCreateTensor(context, 2, dims_inception_c2_1x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_scale_w);
    vx_size dims_inception_c2_1x1_scale_b[2] = { 256, 1 };
    vx_tensor inception_c2_1x1_scale_b = vxCreateTensor(context, 2, dims_inception_c2_1x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c2_1x1_scale_b);
    vx_size dims_inception_c3_1x1_2_w[4] = { 1, 1, 1536, 256 };
    vx_tensor inception_c3_1x1_2_w = vxCreateTensor(context, 4, dims_inception_c3_1x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_2_w);
    vx_size dims_inception_c3_1x1_2_bn_w[2] = { 256, 1 };
    vx_tensor inception_c3_1x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_c3_1x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_2_bn_w);
    vx_size dims_inception_c3_1x1_2_bn_b[2] = { 256, 1 };
    vx_tensor inception_c3_1x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_c3_1x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_2_bn_b);
    vx_size dims_inception_c3_1x1_2_scale_w[2] = { 256, 1 };
    vx_tensor inception_c3_1x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_c3_1x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_2_scale_w);
    vx_size dims_inception_c3_1x1_2_scale_b[2] = { 256, 1 };
    vx_tensor inception_c3_1x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_c3_1x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_2_scale_b);
    vx_size dims_inception_c3_1x1_3_w[4] = { 1, 1, 1536, 384 };
    vx_tensor inception_c3_1x1_3_w = vxCreateTensor(context, 4, dims_inception_c3_1x1_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_3_w);
    vx_size dims_inception_c3_1x1_3_bn_w[2] = { 384, 1 };
    vx_tensor inception_c3_1x1_3_bn_w = vxCreateTensor(context, 2, dims_inception_c3_1x1_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_3_bn_w);
    vx_size dims_inception_c3_1x1_3_bn_b[2] = { 384, 1 };
    vx_tensor inception_c3_1x1_3_bn_b = vxCreateTensor(context, 2, dims_inception_c3_1x1_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_3_bn_b);
    vx_size dims_inception_c3_1x1_3_scale_w[2] = { 384, 1 };
    vx_tensor inception_c3_1x1_3_scale_w = vxCreateTensor(context, 2, dims_inception_c3_1x1_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_3_scale_w);
    vx_size dims_inception_c3_1x1_3_scale_b[2] = { 384, 1 };
    vx_tensor inception_c3_1x1_3_scale_b = vxCreateTensor(context, 2, dims_inception_c3_1x1_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_3_scale_b);
    vx_size dims_inception_c3_1x3_w[4] = { 3, 1, 384, 256 };
    vx_tensor inception_c3_1x3_w = vxCreateTensor(context, 4, dims_inception_c3_1x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_w);
    vx_size dims_inception_c3_1x3_bn_w[2] = { 256, 1 };
    vx_tensor inception_c3_1x3_bn_w = vxCreateTensor(context, 2, dims_inception_c3_1x3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_bn_w);
    vx_size dims_inception_c3_1x3_bn_b[2] = { 256, 1 };
    vx_tensor inception_c3_1x3_bn_b = vxCreateTensor(context, 2, dims_inception_c3_1x3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_bn_b);
    vx_size dims_inception_c3_1x3_scale_w[2] = { 256, 1 };
    vx_tensor inception_c3_1x3_scale_w = vxCreateTensor(context, 2, dims_inception_c3_1x3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_scale_w);
    vx_size dims_inception_c3_1x3_scale_b[2] = { 256, 1 };
    vx_tensor inception_c3_1x3_scale_b = vxCreateTensor(context, 2, dims_inception_c3_1x3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_scale_b);
    vx_size dims_inception_c3_3x1_w[4] = { 1, 3, 384, 256 };
    vx_tensor inception_c3_3x1_w = vxCreateTensor(context, 4, dims_inception_c3_3x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_w);
    vx_size dims_inception_c3_3x1_bn_w[2] = { 256, 1 };
    vx_tensor inception_c3_3x1_bn_w = vxCreateTensor(context, 2, dims_inception_c3_3x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_bn_w);
    vx_size dims_inception_c3_3x1_bn_b[2] = { 256, 1 };
    vx_tensor inception_c3_3x1_bn_b = vxCreateTensor(context, 2, dims_inception_c3_3x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_bn_b);
    vx_size dims_inception_c3_3x1_scale_w[2] = { 256, 1 };
    vx_tensor inception_c3_3x1_scale_w = vxCreateTensor(context, 2, dims_inception_c3_3x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_scale_w);
    vx_size dims_inception_c3_3x1_scale_b[2] = { 256, 1 };
    vx_tensor inception_c3_3x1_scale_b = vxCreateTensor(context, 2, dims_inception_c3_3x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_scale_b);
    vx_size dims_inception_c3_1x1_4_w[4] = { 1, 1, 1536, 384 };
    vx_tensor inception_c3_1x1_4_w = vxCreateTensor(context, 4, dims_inception_c3_1x1_4_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_4_w);
    vx_size dims_inception_c3_1x1_4_bn_w[2] = { 384, 1 };
    vx_tensor inception_c3_1x1_4_bn_w = vxCreateTensor(context, 2, dims_inception_c3_1x1_4_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_4_bn_w);
    vx_size dims_inception_c3_1x1_4_bn_b[2] = { 384, 1 };
    vx_tensor inception_c3_1x1_4_bn_b = vxCreateTensor(context, 2, dims_inception_c3_1x1_4_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_4_bn_b);
    vx_size dims_inception_c3_1x1_4_scale_w[2] = { 384, 1 };
    vx_tensor inception_c3_1x1_4_scale_w = vxCreateTensor(context, 2, dims_inception_c3_1x1_4_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_4_scale_w);
    vx_size dims_inception_c3_1x1_4_scale_b[2] = { 384, 1 };
    vx_tensor inception_c3_1x1_4_scale_b = vxCreateTensor(context, 2, dims_inception_c3_1x1_4_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_4_scale_b);
    vx_size dims_inception_c3_3x1_2_w[4] = { 1, 3, 384, 448 };
    vx_tensor inception_c3_3x1_2_w = vxCreateTensor(context, 4, dims_inception_c3_3x1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_2_w);
    vx_size dims_inception_c3_3x1_2_bn_w[2] = { 448, 1 };
    vx_tensor inception_c3_3x1_2_bn_w = vxCreateTensor(context, 2, dims_inception_c3_3x1_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_2_bn_w);
    vx_size dims_inception_c3_3x1_2_bn_b[2] = { 448, 1 };
    vx_tensor inception_c3_3x1_2_bn_b = vxCreateTensor(context, 2, dims_inception_c3_3x1_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_2_bn_b);
    vx_size dims_inception_c3_3x1_2_scale_w[2] = { 448, 1 };
    vx_tensor inception_c3_3x1_2_scale_w = vxCreateTensor(context, 2, dims_inception_c3_3x1_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_2_scale_w);
    vx_size dims_inception_c3_3x1_2_scale_b[2] = { 448, 1 };
    vx_tensor inception_c3_3x1_2_scale_b = vxCreateTensor(context, 2, dims_inception_c3_3x1_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_2_scale_b);
    vx_size dims_inception_c3_1x3_2_w[4] = { 3, 1, 448, 512 };
    vx_tensor inception_c3_1x3_2_w = vxCreateTensor(context, 4, dims_inception_c3_1x3_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_2_w);
    vx_size dims_inception_c3_1x3_2_bn_w[2] = { 512, 1 };
    vx_tensor inception_c3_1x3_2_bn_w = vxCreateTensor(context, 2, dims_inception_c3_1x3_2_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_2_bn_w);
    vx_size dims_inception_c3_1x3_2_bn_b[2] = { 512, 1 };
    vx_tensor inception_c3_1x3_2_bn_b = vxCreateTensor(context, 2, dims_inception_c3_1x3_2_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_2_bn_b);
    vx_size dims_inception_c3_1x3_2_scale_w[2] = { 512, 1 };
    vx_tensor inception_c3_1x3_2_scale_w = vxCreateTensor(context, 2, dims_inception_c3_1x3_2_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_2_scale_w);
    vx_size dims_inception_c3_1x3_2_scale_b[2] = { 512, 1 };
    vx_tensor inception_c3_1x3_2_scale_b = vxCreateTensor(context, 2, dims_inception_c3_1x3_2_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_2_scale_b);
    vx_size dims_inception_c3_1x3_3_w[4] = { 3, 1, 512, 256 };
    vx_tensor inception_c3_1x3_3_w = vxCreateTensor(context, 4, dims_inception_c3_1x3_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_3_w);
    vx_size dims_inception_c3_1x3_3_bn_w[2] = { 256, 1 };
    vx_tensor inception_c3_1x3_3_bn_w = vxCreateTensor(context, 2, dims_inception_c3_1x3_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_3_bn_w);
    vx_size dims_inception_c3_1x3_3_bn_b[2] = { 256, 1 };
    vx_tensor inception_c3_1x3_3_bn_b = vxCreateTensor(context, 2, dims_inception_c3_1x3_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_3_bn_b);
    vx_size dims_inception_c3_1x3_3_scale_w[2] = { 256, 1 };
    vx_tensor inception_c3_1x3_3_scale_w = vxCreateTensor(context, 2, dims_inception_c3_1x3_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_3_scale_w);
    vx_size dims_inception_c3_1x3_3_scale_b[2] = { 256, 1 };
    vx_tensor inception_c3_1x3_3_scale_b = vxCreateTensor(context, 2, dims_inception_c3_1x3_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x3_3_scale_b);
    vx_size dims_inception_c3_3x1_3_w[4] = { 1, 3, 512, 256 };
    vx_tensor inception_c3_3x1_3_w = vxCreateTensor(context, 4, dims_inception_c3_3x1_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_3_w);
    vx_size dims_inception_c3_3x1_3_bn_w[2] = { 256, 1 };
    vx_tensor inception_c3_3x1_3_bn_w = vxCreateTensor(context, 2, dims_inception_c3_3x1_3_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_3_bn_w);
    vx_size dims_inception_c3_3x1_3_bn_b[2] = { 256, 1 };
    vx_tensor inception_c3_3x1_3_bn_b = vxCreateTensor(context, 2, dims_inception_c3_3x1_3_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_3_bn_b);
    vx_size dims_inception_c3_3x1_3_scale_w[2] = { 256, 1 };
    vx_tensor inception_c3_3x1_3_scale_w = vxCreateTensor(context, 2, dims_inception_c3_3x1_3_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_3_scale_w);
    vx_size dims_inception_c3_3x1_3_scale_b[2] = { 256, 1 };
    vx_tensor inception_c3_3x1_3_scale_b = vxCreateTensor(context, 2, dims_inception_c3_3x1_3_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_3x1_3_scale_b);
    vx_size dims_inception_c3_1x1_w[4] = { 1, 1, 1536, 256 };
    vx_tensor inception_c3_1x1_w = vxCreateTensor(context, 4, dims_inception_c3_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_w);
    vx_size dims_inception_c3_1x1_bn_w[2] = { 256, 1 };
    vx_tensor inception_c3_1x1_bn_w = vxCreateTensor(context, 2, dims_inception_c3_1x1_bn_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_bn_w);
    vx_size dims_inception_c3_1x1_bn_b[2] = { 256, 1 };
    vx_tensor inception_c3_1x1_bn_b = vxCreateTensor(context, 2, dims_inception_c3_1x1_bn_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_bn_b);
    vx_size dims_inception_c3_1x1_scale_w[2] = { 256, 1 };
    vx_tensor inception_c3_1x1_scale_w = vxCreateTensor(context, 2, dims_inception_c3_1x1_scale_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_scale_w);
    vx_size dims_inception_c3_1x1_scale_b[2] = { 256, 1 };
    vx_tensor inception_c3_1x1_scale_b = vxCreateTensor(context, 2, dims_inception_c3_1x1_scale_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_c3_1x1_scale_b);
    vx_size dims_classifier_w[4] = { 1, 1, 1536, 1000 };
    vx_tensor classifier_w = vxCreateTensor(context, 4, dims_classifier_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(classifier_w);
    vx_size dims_classifier_b[2] = { 1000, 1 };
    vx_tensor classifier_b = vxCreateTensor(context, 2, dims_classifier_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(classifier_b);

    // initialize variables
    FILE * fp__variables = fopen(binaryFilename, "rb");
    if(!fp__variables) {
        vxAddLogEntry((vx_reference)context, VX_FAILURE, "ERROR: unable to open: %s\n", binaryFilename);
        return VX_FAILURE;
    }
    { vx_uint32 magic = 0;
      fread(&magic, 1, sizeof(magic), fp__variables);
      if(magic != 0xf00dd1e0) {
        vxAddLogEntry((vx_reference)context, VX_FAILURE, "ERROR: invalid file magic in %s\n", binaryFilename);
        return VX_FAILURE;
      }
    }
    ERROR_CHECK_STATUS(initializeTensor(context, conv1_3x3_s2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv1_3x3_s2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv1_3x3_s2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv1_3x3_s2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv1_3x3_s2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv2_3x3_s1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv2_3x3_s1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv2_3x3_s1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv2_3x3_s1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv2_3x3_s1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv3_3x3_s1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv3_3x3_s1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv3_3x3_s1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv3_3x3_s1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv3_3x3_s1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem1_3x3_s2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem1_3x3_s2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem1_3x3_s2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem1_3x3_s2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem1_3x3_s2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_1x7_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_1x7_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_1x7_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_1x7_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_1x7_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_1x7_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_1x7_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_1x7_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_1x7_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_1x7_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_7x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_7x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_7x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_7x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_7x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem2_3x3_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem3_3x3_s2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem3_3x3_s2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem3_3x3_s2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem3_3x3_s2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_stem3_3x3_s2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_1x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_1x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_1x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_1x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_1x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_2_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_2_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_2_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_2_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_2_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_3x3_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_1x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_1x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_1x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a1_1x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_1x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_1x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_1x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_1x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_1x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_2_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_2_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_2_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_2_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_2_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_3x3_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_1x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_1x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_1x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a2_1x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_1x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_1x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_1x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_1x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_1x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_2_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_2_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_2_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_2_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_2_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_3x3_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_1x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_1x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_1x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a3_1x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_1x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_1x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_1x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_1x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_1x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_2_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_2_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_2_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_2_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_2_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_3x3_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_1x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_1x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_1x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_a4_1x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_2_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_2_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_2_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_2_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_2_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_a_3x3_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_2_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_2_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_2_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_2_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_2_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_7x1_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x7_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b1_1x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_2_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_2_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_2_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_2_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_2_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_7x1_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x7_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b2_1x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_2_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_2_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_2_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_2_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_2_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_7x1_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x7_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b3_1x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_2_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_2_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_2_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_2_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_2_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_7x1_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x7_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b4_1x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_2_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_2_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_2_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_2_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_2_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_7x1_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x7_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b5_1x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_2_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_2_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_2_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_2_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_2_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_7x1_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x7_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b6_1x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_2_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_2_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_2_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_2_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_2_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_7x1_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x7_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_b7_1x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_1x7_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_1x7_reduce_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_1x7_reduce_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_1x7_reduce_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_1x7_reduce_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_1x7_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_1x7_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_1x7_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_1x7_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_1x7_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_7x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_7x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_7x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_7x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_7x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, reduction_b_3x3_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_4_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_4_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_4_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_4_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_4_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x3_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_3x1_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c1_1x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_4_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_4_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_4_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_4_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_4_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x3_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_3x1_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c2_1x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_4_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_4_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_4_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_4_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_4_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_2_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_2_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_2_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_2_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x3_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_3_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_3_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_3_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_3x1_3_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_bn_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_bn_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_scale_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_c3_1x1_scale_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, classifier_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, classifier_b, fp__variables, binaryFilename));
    { vx_uint32 magic = 0;
      fread(&magic, 1, sizeof(magic), fp__variables);
      if(magic != 0xf00dd1e2) {
        vxAddLogEntry((vx_reference)context, VX_FAILURE, "ERROR: invalid eoff magic in %s\n", binaryFilename);
        return VX_FAILURE;
      }
      fclose(fp__variables);
    }

    // create local tensors used in graph
    vx_size dims_conv_conv1_3x3_s2[4] = { 149, 149, 32, 1 };
    vx_tensor conv_conv1_3x3_s2 = vxCreateVirtualTensor(graph, 4, dims_conv_conv1_3x3_s2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv1_3x3_s2);
    vx_size dims_batch_norm_conv1_3x3_s2_scale[4] = { 149, 149, 32, 1 };
    vx_tensor batch_norm_conv1_3x3_s2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_conv1_3x3_s2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_conv1_3x3_s2_scale);
    vx_size dims_relu_conv1_3x3_s2_relu[4] = { 149, 149, 32, 1 };
    vx_tensor relu_conv1_3x3_s2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_conv1_3x3_s2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_conv1_3x3_s2_relu);
    vx_size dims_conv_conv2_3x3_s1[4] = { 147, 147, 32, 1 };
    vx_tensor conv_conv2_3x3_s1 = vxCreateVirtualTensor(graph, 4, dims_conv_conv2_3x3_s1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv2_3x3_s1);
    vx_size dims_batch_norm_conv2_3x3_s1_scale[4] = { 147, 147, 32, 1 };
    vx_tensor batch_norm_conv2_3x3_s1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_conv2_3x3_s1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_conv2_3x3_s1_scale);
    vx_size dims_relu_conv2_3x3_s1_relu[4] = { 147, 147, 32, 1 };
    vx_tensor relu_conv2_3x3_s1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_conv2_3x3_s1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_conv2_3x3_s1_relu);
    vx_size dims_conv_conv3_3x3_s1[4] = { 147, 147, 64, 1 };
    vx_tensor conv_conv3_3x3_s1 = vxCreateVirtualTensor(graph, 4, dims_conv_conv3_3x3_s1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv3_3x3_s1);
    vx_size dims_batch_norm_conv3_3x3_s1_scale[4] = { 147, 147, 64, 1 };
    vx_tensor batch_norm_conv3_3x3_s1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_conv3_3x3_s1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_conv3_3x3_s1_scale);
    vx_size dims_relu_conv3_3x3_s1_relu[4] = { 147, 147, 64, 1 };
    vx_tensor relu_conv3_3x3_s1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_conv3_3x3_s1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_conv3_3x3_s1_relu);
    vx_size dims_conv_inception_stem1_3x3_s2[4] = { 73, 73, 96, 1 };
    vx_tensor conv_inception_stem1_3x3_s2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_stem1_3x3_s2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_stem1_3x3_s2);
    vx_size dims_batch_norm_inception_stem1_3x3_s2_scale[4] = { 73, 73, 96, 1 };
    vx_tensor batch_norm_inception_stem1_3x3_s2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_stem1_3x3_s2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_stem1_3x3_s2_scale);
    vx_size dims_relu_inception_stem1_3x3_s2_relu[4] = { 73, 73, 96, 1 };
    vx_tensor relu_inception_stem1_3x3_s2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_stem1_3x3_s2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_stem1_3x3_s2_relu);
    vx_size dims_max_pool_inception_stem1_pool[4] = { 73, 73, 64, 1 };
    vx_tensor max_pool_inception_stem1_pool = vxCreateVirtualTensor(graph, 4, dims_max_pool_inception_stem1_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_inception_stem1_pool);
    vx_size dims_concat_inception_stem1[4] = { 73, 73, 160, 1 };
    vx_tensor concat_inception_stem1 = vxCreateVirtualTensor(graph, 4, dims_concat_inception_stem1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_stem1);
    vx_size dims_conv_inception_stem2_3x3_reduce[4] = { 73, 73, 64, 1 };
    vx_tensor conv_inception_stem2_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_stem2_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_stem2_3x3_reduce);
    vx_size dims_batch_norm_inception_stem2_3x3_reduce_scale[4] = { 73, 73, 64, 1 };
    vx_tensor batch_norm_inception_stem2_3x3_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_stem2_3x3_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_stem2_3x3_reduce_scale);
    vx_size dims_relu_inception_stem2_3x3_reduce_relu[4] = { 73, 73, 64, 1 };
    vx_tensor relu_inception_stem2_3x3_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_stem2_3x3_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_stem2_3x3_reduce_relu);
    vx_size dims_conv_inception_stem2_3x3[4] = { 71, 71, 96, 1 };
    vx_tensor conv_inception_stem2_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_stem2_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_stem2_3x3);
    vx_size dims_batch_norm_inception_stem2_3x3_scale[4] = { 71, 71, 96, 1 };
    vx_tensor batch_norm_inception_stem2_3x3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_stem2_3x3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_stem2_3x3_scale);
    vx_size dims_relu_inception_stem2_3x3_relu[4] = { 71, 71, 96, 1 };
    vx_tensor relu_inception_stem2_3x3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_stem2_3x3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_stem2_3x3_relu);
    vx_size dims_conv_inception_stem2_1x7_reduce[4] = { 73, 73, 64, 1 };
    vx_tensor conv_inception_stem2_1x7_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_stem2_1x7_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_stem2_1x7_reduce);
    vx_size dims_batch_norm_inception_stem2_1x7_reduce_scale[4] = { 73, 73, 64, 1 };
    vx_tensor batch_norm_inception_stem2_1x7_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_stem2_1x7_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_stem2_1x7_reduce_scale);
    vx_size dims_relu_inception_stem2_1x7_reduce_relu[4] = { 73, 73, 64, 1 };
    vx_tensor relu_inception_stem2_1x7_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_stem2_1x7_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_stem2_1x7_reduce_relu);
    vx_size dims_conv_inception_stem2_1x7[4] = { 73, 73, 64, 1 };
    vx_tensor conv_inception_stem2_1x7 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_stem2_1x7, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_stem2_1x7);
    vx_size dims_batch_norm_inception_stem2_1x7_scale[4] = { 73, 73, 64, 1 };
    vx_tensor batch_norm_inception_stem2_1x7_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_stem2_1x7_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_stem2_1x7_scale);
    vx_size dims_relu_inception_stem2_1x7_relu[4] = { 73, 73, 64, 1 };
    vx_tensor relu_inception_stem2_1x7_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_stem2_1x7_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_stem2_1x7_relu);
    vx_size dims_conv_inception_stem2_7x1[4] = { 73, 73, 64, 1 };
    vx_tensor conv_inception_stem2_7x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_stem2_7x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_stem2_7x1);
    vx_size dims_batch_norm_inception_stem2_7x1_scale[4] = { 73, 73, 64, 1 };
    vx_tensor batch_norm_inception_stem2_7x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_stem2_7x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_stem2_7x1_scale);
    vx_size dims_relu_inception_stem2_7x1_relu[4] = { 73, 73, 64, 1 };
    vx_tensor relu_inception_stem2_7x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_stem2_7x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_stem2_7x1_relu);
    vx_size dims_conv_inception_stem2_3x3_2[4] = { 71, 71, 96, 1 };
    vx_tensor conv_inception_stem2_3x3_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_stem2_3x3_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_stem2_3x3_2);
    vx_size dims_batch_norm_inception_stem2_3x3_2_scale[4] = { 71, 71, 96, 1 };
    vx_tensor batch_norm_inception_stem2_3x3_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_stem2_3x3_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_stem2_3x3_2_scale);
    vx_size dims_relu_inception_stem2_3x3_2_relu[4] = { 71, 71, 96, 1 };
    vx_tensor relu_inception_stem2_3x3_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_stem2_3x3_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_stem2_3x3_2_relu);
    vx_size dims_concat_inception_stem2[4] = { 71, 71, 192, 1 };
    vx_tensor concat_inception_stem2 = vxCreateVirtualTensor(graph, 4, dims_concat_inception_stem2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_stem2);
    vx_size dims_conv_inception_stem3_3x3_s2[4] = { 35, 35, 192, 1 };
    vx_tensor conv_inception_stem3_3x3_s2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_stem3_3x3_s2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_stem3_3x3_s2);
    vx_size dims_batch_norm_inception_stem3_3x3_s2_scale[4] = { 35, 35, 192, 1 };
    vx_tensor batch_norm_inception_stem3_3x3_s2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_stem3_3x3_s2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_stem3_3x3_s2_scale);
    vx_size dims_relu_inception_stem3_3x3_s2_relu[4] = { 35, 35, 192, 1 };
    vx_tensor relu_inception_stem3_3x3_s2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_stem3_3x3_s2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_stem3_3x3_s2_relu);
    vx_size dims_max_pool_inception_stem3_pool[4] = { 35, 35, 192, 1 };
    vx_tensor max_pool_inception_stem3_pool = vxCreateVirtualTensor(graph, 4, dims_max_pool_inception_stem3_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_inception_stem3_pool);
    vx_size dims_concat_inception_stem3[4] = { 35, 35, 384, 1 };
    vx_tensor concat_inception_stem3 = vxCreateVirtualTensor(graph, 4, dims_concat_inception_stem3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_stem3);
    vx_size dims_conv_inception_a1_1x1_2[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a1_1x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a1_1x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a1_1x1_2);
    vx_size dims_batch_norm_inception_a1_1x1_2_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a1_1x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a1_1x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a1_1x1_2_scale);
    vx_size dims_relu_inception_a1_1x1_2_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a1_1x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a1_1x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a1_1x1_2_relu);
    vx_size dims_conv_inception_a1_3x3_reduce[4] = { 35, 35, 64, 1 };
    vx_tensor conv_inception_a1_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a1_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a1_3x3_reduce);
    vx_size dims_batch_norm_inception_a1_3x3_reduce_scale[4] = { 35, 35, 64, 1 };
    vx_tensor batch_norm_inception_a1_3x3_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a1_3x3_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a1_3x3_reduce_scale);
    vx_size dims_relu_inception_a1_3x3_reduce_relu[4] = { 35, 35, 64, 1 };
    vx_tensor relu_inception_a1_3x3_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a1_3x3_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a1_3x3_reduce_relu);
    vx_size dims_conv_inception_a1_3x3[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a1_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a1_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a1_3x3);
    vx_size dims_batch_norm_inception_a1_3x3_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a1_3x3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a1_3x3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a1_3x3_scale);
    vx_size dims_relu_inception_a1_3x3_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a1_3x3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a1_3x3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a1_3x3_relu);
    vx_size dims_conv_inception_a1_3x3_2_reduce[4] = { 35, 35, 64, 1 };
    vx_tensor conv_inception_a1_3x3_2_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a1_3x3_2_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a1_3x3_2_reduce);
    vx_size dims_batch_norm_inception_a1_3x3_2_reduce_scale[4] = { 35, 35, 64, 1 };
    vx_tensor batch_norm_inception_a1_3x3_2_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a1_3x3_2_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a1_3x3_2_reduce_scale);
    vx_size dims_relu_inception_a1_3x3_2_reduce_relu[4] = { 35, 35, 64, 1 };
    vx_tensor relu_inception_a1_3x3_2_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a1_3x3_2_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a1_3x3_2_reduce_relu);
    vx_size dims_conv_inception_a1_3x3_2[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a1_3x3_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a1_3x3_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a1_3x3_2);
    vx_size dims_batch_norm_inception_a1_3x3_2_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a1_3x3_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a1_3x3_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a1_3x3_2_scale);
    vx_size dims_relu_inception_a1_3x3_2_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a1_3x3_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a1_3x3_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a1_3x3_2_relu);
    vx_size dims_conv_inception_a1_3x3_3[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a1_3x3_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a1_3x3_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a1_3x3_3);
    vx_size dims_batch_norm_inception_a1_3x3_3_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a1_3x3_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a1_3x3_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a1_3x3_3_scale);
    vx_size dims_relu_inception_a1_3x3_3_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a1_3x3_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a1_3x3_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a1_3x3_3_relu);
    vx_size dims_avg_pool_inception_a1_pool_ave[4] = { 35, 35, 384, 1 };
    vx_tensor avg_pool_inception_a1_pool_ave = vxCreateVirtualTensor(graph, 4, dims_avg_pool_inception_a1_pool_ave, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_inception_a1_pool_ave);
    vx_size dims_conv_inception_a1_1x1[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a1_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a1_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a1_1x1);
    vx_size dims_batch_norm_inception_a1_1x1_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a1_1x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a1_1x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a1_1x1_scale);
    vx_size dims_relu_inception_a1_1x1_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a1_1x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a1_1x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a1_1x1_relu);
    vx_size dims_concat_inception_a1_concat[4] = { 35, 35, 384, 1 };
    vx_tensor concat_inception_a1_concat = vxCreateVirtualTensor(graph, 4, dims_concat_inception_a1_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_a1_concat);
    vx_size dims_conv_inception_a2_1x1_2[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a2_1x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a2_1x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a2_1x1_2);
    vx_size dims_batch_norm_inception_a2_1x1_2_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a2_1x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a2_1x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a2_1x1_2_scale);
    vx_size dims_relu_inception_a2_1x1_2_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a2_1x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a2_1x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a2_1x1_2_relu);
    vx_size dims_conv_inception_a2_3x3_reduce[4] = { 35, 35, 64, 1 };
    vx_tensor conv_inception_a2_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a2_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a2_3x3_reduce);
    vx_size dims_batch_norm_inception_a2_3x3_reduce_scale[4] = { 35, 35, 64, 1 };
    vx_tensor batch_norm_inception_a2_3x3_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a2_3x3_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a2_3x3_reduce_scale);
    vx_size dims_relu_inception_a2_3x3_reduce_relu[4] = { 35, 35, 64, 1 };
    vx_tensor relu_inception_a2_3x3_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a2_3x3_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a2_3x3_reduce_relu);
    vx_size dims_conv_inception_a2_3x3[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a2_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a2_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a2_3x3);
    vx_size dims_batch_norm_inception_a2_3x3_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a2_3x3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a2_3x3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a2_3x3_scale);
    vx_size dims_relu_inception_a2_3x3_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a2_3x3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a2_3x3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a2_3x3_relu);
    vx_size dims_conv_inception_a2_3x3_2_reduce[4] = { 35, 35, 64, 1 };
    vx_tensor conv_inception_a2_3x3_2_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a2_3x3_2_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a2_3x3_2_reduce);
    vx_size dims_batch_norm_inception_a2_3x3_2_reduce_scale[4] = { 35, 35, 64, 1 };
    vx_tensor batch_norm_inception_a2_3x3_2_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a2_3x3_2_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a2_3x3_2_reduce_scale);
    vx_size dims_relu_inception_a2_3x3_2_reduce_relu[4] = { 35, 35, 64, 1 };
    vx_tensor relu_inception_a2_3x3_2_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a2_3x3_2_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a2_3x3_2_reduce_relu);
    vx_size dims_conv_inception_a2_3x3_2[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a2_3x3_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a2_3x3_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a2_3x3_2);
    vx_size dims_batch_norm_inception_a2_3x3_2_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a2_3x3_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a2_3x3_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a2_3x3_2_scale);
    vx_size dims_relu_inception_a2_3x3_2_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a2_3x3_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a2_3x3_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a2_3x3_2_relu);
    vx_size dims_conv_inception_a2_3x3_3[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a2_3x3_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a2_3x3_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a2_3x3_3);
    vx_size dims_batch_norm_inception_a2_3x3_3_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a2_3x3_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a2_3x3_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a2_3x3_3_scale);
    vx_size dims_relu_inception_a2_3x3_3_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a2_3x3_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a2_3x3_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a2_3x3_3_relu);
    vx_size dims_avg_pool_inception_a2_pool_ave[4] = { 35, 35, 384, 1 };
    vx_tensor avg_pool_inception_a2_pool_ave = vxCreateVirtualTensor(graph, 4, dims_avg_pool_inception_a2_pool_ave, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_inception_a2_pool_ave);
    vx_size dims_conv_inception_a2_1x1[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a2_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a2_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a2_1x1);
    vx_size dims_batch_norm_inception_a2_1x1_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a2_1x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a2_1x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a2_1x1_scale);
    vx_size dims_relu_inception_a2_1x1_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a2_1x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a2_1x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a2_1x1_relu);
    vx_size dims_concat_inception_a2_concat[4] = { 35, 35, 384, 1 };
    vx_tensor concat_inception_a2_concat = vxCreateVirtualTensor(graph, 4, dims_concat_inception_a2_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_a2_concat);
    vx_size dims_conv_inception_a3_1x1_2[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a3_1x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a3_1x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a3_1x1_2);
    vx_size dims_batch_norm_inception_a3_1x1_2_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a3_1x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a3_1x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a3_1x1_2_scale);
    vx_size dims_relu_inception_a3_1x1_2_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a3_1x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a3_1x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a3_1x1_2_relu);
    vx_size dims_conv_inception_a3_3x3_reduce[4] = { 35, 35, 64, 1 };
    vx_tensor conv_inception_a3_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a3_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a3_3x3_reduce);
    vx_size dims_batch_norm_inception_a3_3x3_reduce_scale[4] = { 35, 35, 64, 1 };
    vx_tensor batch_norm_inception_a3_3x3_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a3_3x3_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a3_3x3_reduce_scale);
    vx_size dims_relu_inception_a3_3x3_reduce_relu[4] = { 35, 35, 64, 1 };
    vx_tensor relu_inception_a3_3x3_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a3_3x3_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a3_3x3_reduce_relu);
    vx_size dims_conv_inception_a3_3x3[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a3_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a3_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a3_3x3);
    vx_size dims_batch_norm_inception_a3_3x3_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a3_3x3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a3_3x3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a3_3x3_scale);
    vx_size dims_relu_inception_a3_3x3_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a3_3x3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a3_3x3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a3_3x3_relu);
    vx_size dims_conv_inception_a3_3x3_2_reduce[4] = { 35, 35, 64, 1 };
    vx_tensor conv_inception_a3_3x3_2_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a3_3x3_2_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a3_3x3_2_reduce);
    vx_size dims_batch_norm_inception_a3_3x3_2_reduce_scale[4] = { 35, 35, 64, 1 };
    vx_tensor batch_norm_inception_a3_3x3_2_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a3_3x3_2_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a3_3x3_2_reduce_scale);
    vx_size dims_relu_inception_a3_3x3_2_reduce_relu[4] = { 35, 35, 64, 1 };
    vx_tensor relu_inception_a3_3x3_2_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a3_3x3_2_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a3_3x3_2_reduce_relu);
    vx_size dims_conv_inception_a3_3x3_2[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a3_3x3_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a3_3x3_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a3_3x3_2);
    vx_size dims_batch_norm_inception_a3_3x3_2_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a3_3x3_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a3_3x3_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a3_3x3_2_scale);
    vx_size dims_relu_inception_a3_3x3_2_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a3_3x3_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a3_3x3_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a3_3x3_2_relu);
    vx_size dims_conv_inception_a3_3x3_3[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a3_3x3_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a3_3x3_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a3_3x3_3);
    vx_size dims_batch_norm_inception_a3_3x3_3_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a3_3x3_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a3_3x3_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a3_3x3_3_scale);
    vx_size dims_relu_inception_a3_3x3_3_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a3_3x3_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a3_3x3_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a3_3x3_3_relu);
    vx_size dims_avg_pool_inception_a3_pool_ave[4] = { 35, 35, 384, 1 };
    vx_tensor avg_pool_inception_a3_pool_ave = vxCreateVirtualTensor(graph, 4, dims_avg_pool_inception_a3_pool_ave, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_inception_a3_pool_ave);
    vx_size dims_conv_inception_a3_1x1[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a3_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a3_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a3_1x1);
    vx_size dims_batch_norm_inception_a3_1x1_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a3_1x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a3_1x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a3_1x1_scale);
    vx_size dims_relu_inception_a3_1x1_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a3_1x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a3_1x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a3_1x1_relu);
    vx_size dims_concat_inception_a3_concat[4] = { 35, 35, 384, 1 };
    vx_tensor concat_inception_a3_concat = vxCreateVirtualTensor(graph, 4, dims_concat_inception_a3_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_a3_concat);
    vx_size dims_conv_inception_a4_1x1_2[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a4_1x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a4_1x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a4_1x1_2);
    vx_size dims_batch_norm_inception_a4_1x1_2_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a4_1x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a4_1x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a4_1x1_2_scale);
    vx_size dims_relu_inception_a4_1x1_2_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a4_1x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a4_1x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a4_1x1_2_relu);
    vx_size dims_conv_inception_a4_3x3_reduce[4] = { 35, 35, 64, 1 };
    vx_tensor conv_inception_a4_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a4_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a4_3x3_reduce);
    vx_size dims_batch_norm_inception_a4_3x3_reduce_scale[4] = { 35, 35, 64, 1 };
    vx_tensor batch_norm_inception_a4_3x3_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a4_3x3_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a4_3x3_reduce_scale);
    vx_size dims_relu_inception_a4_3x3_reduce_relu[4] = { 35, 35, 64, 1 };
    vx_tensor relu_inception_a4_3x3_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a4_3x3_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a4_3x3_reduce_relu);
    vx_size dims_conv_inception_a4_3x3[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a4_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a4_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a4_3x3);
    vx_size dims_batch_norm_inception_a4_3x3_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a4_3x3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a4_3x3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a4_3x3_scale);
    vx_size dims_relu_inception_a4_3x3_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a4_3x3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a4_3x3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a4_3x3_relu);
    vx_size dims_conv_inception_a4_3x3_2_reduce[4] = { 35, 35, 64, 1 };
    vx_tensor conv_inception_a4_3x3_2_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a4_3x3_2_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a4_3x3_2_reduce);
    vx_size dims_batch_norm_inception_a4_3x3_2_reduce_scale[4] = { 35, 35, 64, 1 };
    vx_tensor batch_norm_inception_a4_3x3_2_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a4_3x3_2_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a4_3x3_2_reduce_scale);
    vx_size dims_relu_inception_a4_3x3_2_reduce_relu[4] = { 35, 35, 64, 1 };
    vx_tensor relu_inception_a4_3x3_2_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a4_3x3_2_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a4_3x3_2_reduce_relu);
    vx_size dims_conv_inception_a4_3x3_2[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a4_3x3_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a4_3x3_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a4_3x3_2);
    vx_size dims_batch_norm_inception_a4_3x3_2_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a4_3x3_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a4_3x3_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a4_3x3_2_scale);
    vx_size dims_relu_inception_a4_3x3_2_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a4_3x3_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a4_3x3_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a4_3x3_2_relu);
    vx_size dims_conv_inception_a4_3x3_3[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a4_3x3_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a4_3x3_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a4_3x3_3);
    vx_size dims_batch_norm_inception_a4_3x3_3_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a4_3x3_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a4_3x3_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a4_3x3_3_scale);
    vx_size dims_relu_inception_a4_3x3_3_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a4_3x3_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a4_3x3_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a4_3x3_3_relu);
    vx_size dims_avg_pool_inception_a4_pool_ave[4] = { 35, 35, 384, 1 };
    vx_tensor avg_pool_inception_a4_pool_ave = vxCreateVirtualTensor(graph, 4, dims_avg_pool_inception_a4_pool_ave, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_inception_a4_pool_ave);
    vx_size dims_conv_inception_a4_1x1[4] = { 35, 35, 96, 1 };
    vx_tensor conv_inception_a4_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_a4_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_a4_1x1);
    vx_size dims_batch_norm_inception_a4_1x1_scale[4] = { 35, 35, 96, 1 };
    vx_tensor batch_norm_inception_a4_1x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_a4_1x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_a4_1x1_scale);
    vx_size dims_relu_inception_a4_1x1_relu[4] = { 35, 35, 96, 1 };
    vx_tensor relu_inception_a4_1x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_a4_1x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_a4_1x1_relu);
    vx_size dims_concat_inception_a4_concat[4] = { 35, 35, 384, 1 };
    vx_tensor concat_inception_a4_concat = vxCreateVirtualTensor(graph, 4, dims_concat_inception_a4_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_a4_concat);
    vx_size dims_conv_reduction_a_3x3[4] = { 17, 17, 384, 1 };
    vx_tensor conv_reduction_a_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_reduction_a_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_reduction_a_3x3);
    vx_size dims_batch_norm_reduction_a_3x3_scale[4] = { 17, 17, 384, 1 };
    vx_tensor batch_norm_reduction_a_3x3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_reduction_a_3x3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_reduction_a_3x3_scale);
    vx_size dims_relu_reduction_a_3x3_relu[4] = { 17, 17, 384, 1 };
    vx_tensor relu_reduction_a_3x3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_reduction_a_3x3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_reduction_a_3x3_relu);
    vx_size dims_conv_reduction_a_3x3_2_reduce[4] = { 35, 35, 192, 1 };
    vx_tensor conv_reduction_a_3x3_2_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_reduction_a_3x3_2_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_reduction_a_3x3_2_reduce);
    vx_size dims_batch_norm_reduction_a_3x3_2_reduce_scale[4] = { 35, 35, 192, 1 };
    vx_tensor batch_norm_reduction_a_3x3_2_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_reduction_a_3x3_2_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_reduction_a_3x3_2_reduce_scale);
    vx_size dims_relu_reduction_a_3x3_2_reduce_relu[4] = { 35, 35, 192, 1 };
    vx_tensor relu_reduction_a_3x3_2_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_reduction_a_3x3_2_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_reduction_a_3x3_2_reduce_relu);
    vx_size dims_conv_reduction_a_3x3_2[4] = { 35, 35, 224, 1 };
    vx_tensor conv_reduction_a_3x3_2 = vxCreateVirtualTensor(graph, 4, dims_conv_reduction_a_3x3_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_reduction_a_3x3_2);
    vx_size dims_batch_norm_reduction_a_3x3_2_scale[4] = { 35, 35, 224, 1 };
    vx_tensor batch_norm_reduction_a_3x3_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_reduction_a_3x3_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_reduction_a_3x3_2_scale);
    vx_size dims_relu_reduction_a_3x3_2_relu[4] = { 35, 35, 224, 1 };
    vx_tensor relu_reduction_a_3x3_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_reduction_a_3x3_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_reduction_a_3x3_2_relu);
    vx_size dims_conv_reduction_a_3x3_3[4] = { 17, 17, 256, 1 };
    vx_tensor conv_reduction_a_3x3_3 = vxCreateVirtualTensor(graph, 4, dims_conv_reduction_a_3x3_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_reduction_a_3x3_3);
    vx_size dims_batch_norm_reduction_a_3x3_3_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_reduction_a_3x3_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_reduction_a_3x3_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_reduction_a_3x3_3_scale);
    vx_size dims_relu_reduction_a_3x3_3_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_reduction_a_3x3_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_reduction_a_3x3_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_reduction_a_3x3_3_relu);
    vx_size dims_max_pool_reduction_a_pool[4] = { 17, 17, 384, 1 };
    vx_tensor max_pool_reduction_a_pool = vxCreateVirtualTensor(graph, 4, dims_max_pool_reduction_a_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_reduction_a_pool);
    vx_size dims_concat_reduction_a_concat[4] = { 17, 17, 1024, 1 };
    vx_tensor concat_reduction_a_concat = vxCreateVirtualTensor(graph, 4, dims_concat_reduction_a_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_reduction_a_concat);
    vx_size dims_conv_inception_b1_1x1_2[4] = { 17, 17, 384, 1 };
    vx_tensor conv_inception_b1_1x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b1_1x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b1_1x1_2);
    vx_size dims_batch_norm_inception_b1_1x1_2_scale[4] = { 17, 17, 384, 1 };
    vx_tensor batch_norm_inception_b1_1x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b1_1x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b1_1x1_2_scale);
    vx_size dims_relu_inception_b1_1x1_2_relu[4] = { 17, 17, 384, 1 };
    vx_tensor relu_inception_b1_1x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b1_1x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b1_1x1_2_relu);
    vx_size dims_conv_inception_b1_1x7_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b1_1x7_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b1_1x7_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b1_1x7_reduce);
    vx_size dims_batch_norm_inception_b1_1x7_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b1_1x7_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b1_1x7_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b1_1x7_reduce_scale);
    vx_size dims_relu_inception_b1_1x7_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b1_1x7_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b1_1x7_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b1_1x7_reduce_relu);
    vx_size dims_conv_inception_b1_1x7[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b1_1x7 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b1_1x7, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b1_1x7);
    vx_size dims_batch_norm_inception_b1_1x7_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b1_1x7_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b1_1x7_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b1_1x7_scale);
    vx_size dims_relu_inception_b1_1x7_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b1_1x7_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b1_1x7_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b1_1x7_relu);
    vx_size dims_conv_inception_b1_7x1[4] = { 17, 17, 256, 1 };
    vx_tensor conv_inception_b1_7x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b1_7x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b1_7x1);
    vx_size dims_batch_norm_inception_b1_7x1_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_inception_b1_7x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b1_7x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b1_7x1_scale);
    vx_size dims_relu_inception_b1_7x1_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_inception_b1_7x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b1_7x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b1_7x1_relu);
    vx_size dims_conv_inception_b1_7x1_2_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b1_7x1_2_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b1_7x1_2_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b1_7x1_2_reduce);
    vx_size dims_batch_norm_inception_b1_7x1_2_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b1_7x1_2_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b1_7x1_2_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b1_7x1_2_reduce_scale);
    vx_size dims_relu_inception_b1_7x1_2_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b1_7x1_2_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b1_7x1_2_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b1_7x1_2_reduce_relu);
    vx_size dims_conv_inception_b1_7x1_2[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b1_7x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b1_7x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b1_7x1_2);
    vx_size dims_batch_norm_inception_b1_7x1_2_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b1_7x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b1_7x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b1_7x1_2_scale);
    vx_size dims_relu_inception_b1_7x1_2_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b1_7x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b1_7x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b1_7x1_2_relu);
    vx_size dims_conv_inception_b1_1x7_2[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b1_1x7_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b1_1x7_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b1_1x7_2);
    vx_size dims_batch_norm_inception_b1_1x7_2_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b1_1x7_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b1_1x7_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b1_1x7_2_scale);
    vx_size dims_relu_inception_b1_1x7_2_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b1_1x7_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b1_1x7_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b1_1x7_2_relu);
    vx_size dims_conv_inception_b1_7x1_3[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b1_7x1_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b1_7x1_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b1_7x1_3);
    vx_size dims_batch_norm_inception_b1_7x1_3_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b1_7x1_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b1_7x1_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b1_7x1_3_scale);
    vx_size dims_relu_inception_b1_7x1_3_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b1_7x1_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b1_7x1_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b1_7x1_3_relu);
    vx_size dims_conv_inception_b1_1x7_3[4] = { 17, 17, 256, 1 };
    vx_tensor conv_inception_b1_1x7_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b1_1x7_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b1_1x7_3);
    vx_size dims_batch_norm_inception_b1_1x7_3_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_inception_b1_1x7_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b1_1x7_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b1_1x7_3_scale);
    vx_size dims_relu_inception_b1_1x7_3_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_inception_b1_1x7_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b1_1x7_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b1_1x7_3_relu);
    vx_size dims_avg_pool_inception_b1_pool_ave[4] = { 17, 17, 1024, 1 };
    vx_tensor avg_pool_inception_b1_pool_ave = vxCreateVirtualTensor(graph, 4, dims_avg_pool_inception_b1_pool_ave, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_inception_b1_pool_ave);
    vx_size dims_conv_inception_b1_1x1[4] = { 17, 17, 128, 1 };
    vx_tensor conv_inception_b1_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b1_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b1_1x1);
    vx_size dims_batch_norm_inception_b1_1x1_scale[4] = { 17, 17, 128, 1 };
    vx_tensor batch_norm_inception_b1_1x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b1_1x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b1_1x1_scale);
    vx_size dims_relu_inception_b1_1x1_relu[4] = { 17, 17, 128, 1 };
    vx_tensor relu_inception_b1_1x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b1_1x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b1_1x1_relu);
    vx_size dims_concat_inception_b1_concat[4] = { 17, 17, 1024, 1 };
    vx_tensor concat_inception_b1_concat = vxCreateVirtualTensor(graph, 4, dims_concat_inception_b1_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_b1_concat);
    vx_size dims_conv_inception_b2_1x1_2[4] = { 17, 17, 384, 1 };
    vx_tensor conv_inception_b2_1x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b2_1x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b2_1x1_2);
    vx_size dims_batch_norm_inception_b2_1x1_2_scale[4] = { 17, 17, 384, 1 };
    vx_tensor batch_norm_inception_b2_1x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b2_1x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b2_1x1_2_scale);
    vx_size dims_relu_inception_b2_1x1_2_relu[4] = { 17, 17, 384, 1 };
    vx_tensor relu_inception_b2_1x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b2_1x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b2_1x1_2_relu);
    vx_size dims_conv_inception_b2_1x7_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b2_1x7_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b2_1x7_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b2_1x7_reduce);
    vx_size dims_batch_norm_inception_b2_1x7_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b2_1x7_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b2_1x7_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b2_1x7_reduce_scale);
    vx_size dims_relu_inception_b2_1x7_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b2_1x7_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b2_1x7_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b2_1x7_reduce_relu);
    vx_size dims_conv_inception_b2_1x7[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b2_1x7 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b2_1x7, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b2_1x7);
    vx_size dims_batch_norm_inception_b2_1x7_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b2_1x7_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b2_1x7_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b2_1x7_scale);
    vx_size dims_relu_inception_b2_1x7_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b2_1x7_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b2_1x7_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b2_1x7_relu);
    vx_size dims_conv_inception_b2_7x1[4] = { 17, 17, 256, 1 };
    vx_tensor conv_inception_b2_7x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b2_7x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b2_7x1);
    vx_size dims_batch_norm_inception_b2_7x1_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_inception_b2_7x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b2_7x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b2_7x1_scale);
    vx_size dims_relu_inception_b2_7x1_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_inception_b2_7x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b2_7x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b2_7x1_relu);
    vx_size dims_conv_inception_b2_7x1_2_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b2_7x1_2_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b2_7x1_2_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b2_7x1_2_reduce);
    vx_size dims_batch_norm_inception_b2_7x1_2_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b2_7x1_2_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b2_7x1_2_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b2_7x1_2_reduce_scale);
    vx_size dims_relu_inception_b2_7x1_2_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b2_7x1_2_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b2_7x1_2_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b2_7x1_2_reduce_relu);
    vx_size dims_conv_inception_b2_7x1_2[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b2_7x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b2_7x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b2_7x1_2);
    vx_size dims_batch_norm_inception_b2_7x1_2_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b2_7x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b2_7x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b2_7x1_2_scale);
    vx_size dims_relu_inception_b2_7x1_2_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b2_7x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b2_7x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b2_7x1_2_relu);
    vx_size dims_conv_inception_b2_1x7_2[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b2_1x7_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b2_1x7_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b2_1x7_2);
    vx_size dims_batch_norm_inception_b2_1x7_2_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b2_1x7_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b2_1x7_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b2_1x7_2_scale);
    vx_size dims_relu_inception_b2_1x7_2_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b2_1x7_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b2_1x7_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b2_1x7_2_relu);
    vx_size dims_conv_inception_b2_7x1_3[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b2_7x1_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b2_7x1_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b2_7x1_3);
    vx_size dims_batch_norm_inception_b2_7x1_3_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b2_7x1_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b2_7x1_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b2_7x1_3_scale);
    vx_size dims_relu_inception_b2_7x1_3_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b2_7x1_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b2_7x1_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b2_7x1_3_relu);
    vx_size dims_conv_inception_b2_1x7_3[4] = { 17, 17, 256, 1 };
    vx_tensor conv_inception_b2_1x7_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b2_1x7_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b2_1x7_3);
    vx_size dims_batch_norm_inception_b2_1x7_3_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_inception_b2_1x7_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b2_1x7_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b2_1x7_3_scale);
    vx_size dims_relu_inception_b2_1x7_3_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_inception_b2_1x7_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b2_1x7_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b2_1x7_3_relu);
    vx_size dims_avg_pool_inception_b2_pool_ave[4] = { 17, 17, 1024, 1 };
    vx_tensor avg_pool_inception_b2_pool_ave = vxCreateVirtualTensor(graph, 4, dims_avg_pool_inception_b2_pool_ave, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_inception_b2_pool_ave);
    vx_size dims_conv_inception_b2_1x1[4] = { 17, 17, 128, 1 };
    vx_tensor conv_inception_b2_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b2_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b2_1x1);
    vx_size dims_batch_norm_inception_b2_1x1_scale[4] = { 17, 17, 128, 1 };
    vx_tensor batch_norm_inception_b2_1x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b2_1x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b2_1x1_scale);
    vx_size dims_relu_inception_b2_1x1_relu[4] = { 17, 17, 128, 1 };
    vx_tensor relu_inception_b2_1x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b2_1x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b2_1x1_relu);
    vx_size dims_concat_inception_b2_concat[4] = { 17, 17, 1024, 1 };
    vx_tensor concat_inception_b2_concat = vxCreateVirtualTensor(graph, 4, dims_concat_inception_b2_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_b2_concat);
    vx_size dims_conv_inception_b3_1x1_2[4] = { 17, 17, 384, 1 };
    vx_tensor conv_inception_b3_1x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b3_1x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b3_1x1_2);
    vx_size dims_batch_norm_inception_b3_1x1_2_scale[4] = { 17, 17, 384, 1 };
    vx_tensor batch_norm_inception_b3_1x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b3_1x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b3_1x1_2_scale);
    vx_size dims_relu_inception_b3_1x1_2_relu[4] = { 17, 17, 384, 1 };
    vx_tensor relu_inception_b3_1x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b3_1x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b3_1x1_2_relu);
    vx_size dims_conv_inception_b3_1x7_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b3_1x7_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b3_1x7_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b3_1x7_reduce);
    vx_size dims_batch_norm_inception_b3_1x7_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b3_1x7_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b3_1x7_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b3_1x7_reduce_scale);
    vx_size dims_relu_inception_b3_1x7_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b3_1x7_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b3_1x7_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b3_1x7_reduce_relu);
    vx_size dims_conv_inception_b3_1x7[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b3_1x7 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b3_1x7, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b3_1x7);
    vx_size dims_batch_norm_inception_b3_1x7_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b3_1x7_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b3_1x7_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b3_1x7_scale);
    vx_size dims_relu_inception_b3_1x7_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b3_1x7_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b3_1x7_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b3_1x7_relu);
    vx_size dims_conv_inception_b3_7x1[4] = { 17, 17, 256, 1 };
    vx_tensor conv_inception_b3_7x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b3_7x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b3_7x1);
    vx_size dims_batch_norm_inception_b3_7x1_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_inception_b3_7x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b3_7x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b3_7x1_scale);
    vx_size dims_relu_inception_b3_7x1_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_inception_b3_7x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b3_7x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b3_7x1_relu);
    vx_size dims_conv_inception_b3_7x1_2_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b3_7x1_2_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b3_7x1_2_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b3_7x1_2_reduce);
    vx_size dims_batch_norm_inception_b3_7x1_2_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b3_7x1_2_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b3_7x1_2_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b3_7x1_2_reduce_scale);
    vx_size dims_relu_inception_b3_7x1_2_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b3_7x1_2_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b3_7x1_2_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b3_7x1_2_reduce_relu);
    vx_size dims_conv_inception_b3_7x1_2[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b3_7x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b3_7x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b3_7x1_2);
    vx_size dims_batch_norm_inception_b3_7x1_2_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b3_7x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b3_7x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b3_7x1_2_scale);
    vx_size dims_relu_inception_b3_7x1_2_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b3_7x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b3_7x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b3_7x1_2_relu);
    vx_size dims_conv_inception_b3_1x7_2[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b3_1x7_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b3_1x7_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b3_1x7_2);
    vx_size dims_batch_norm_inception_b3_1x7_2_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b3_1x7_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b3_1x7_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b3_1x7_2_scale);
    vx_size dims_relu_inception_b3_1x7_2_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b3_1x7_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b3_1x7_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b3_1x7_2_relu);
    vx_size dims_conv_inception_b3_7x1_3[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b3_7x1_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b3_7x1_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b3_7x1_3);
    vx_size dims_batch_norm_inception_b3_7x1_3_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b3_7x1_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b3_7x1_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b3_7x1_3_scale);
    vx_size dims_relu_inception_b3_7x1_3_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b3_7x1_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b3_7x1_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b3_7x1_3_relu);
    vx_size dims_conv_inception_b3_1x7_3[4] = { 17, 17, 256, 1 };
    vx_tensor conv_inception_b3_1x7_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b3_1x7_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b3_1x7_3);
    vx_size dims_batch_norm_inception_b3_1x7_3_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_inception_b3_1x7_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b3_1x7_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b3_1x7_3_scale);
    vx_size dims_relu_inception_b3_1x7_3_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_inception_b3_1x7_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b3_1x7_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b3_1x7_3_relu);
    vx_size dims_avg_pool_inception_b3_pool_ave[4] = { 17, 17, 1024, 1 };
    vx_tensor avg_pool_inception_b3_pool_ave = vxCreateVirtualTensor(graph, 4, dims_avg_pool_inception_b3_pool_ave, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_inception_b3_pool_ave);
    vx_size dims_conv_inception_b3_1x1[4] = { 17, 17, 128, 1 };
    vx_tensor conv_inception_b3_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b3_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b3_1x1);
    vx_size dims_batch_norm_inception_b3_1x1_scale[4] = { 17, 17, 128, 1 };
    vx_tensor batch_norm_inception_b3_1x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b3_1x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b3_1x1_scale);
    vx_size dims_relu_inception_b3_1x1_relu[4] = { 17, 17, 128, 1 };
    vx_tensor relu_inception_b3_1x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b3_1x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b3_1x1_relu);
    vx_size dims_concat_inception_b3_concat[4] = { 17, 17, 1024, 1 };
    vx_tensor concat_inception_b3_concat = vxCreateVirtualTensor(graph, 4, dims_concat_inception_b3_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_b3_concat);
    vx_size dims_conv_inception_b4_1x1_2[4] = { 17, 17, 384, 1 };
    vx_tensor conv_inception_b4_1x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b4_1x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b4_1x1_2);
    vx_size dims_batch_norm_inception_b4_1x1_2_scale[4] = { 17, 17, 384, 1 };
    vx_tensor batch_norm_inception_b4_1x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b4_1x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b4_1x1_2_scale);
    vx_size dims_relu_inception_b4_1x1_2_relu[4] = { 17, 17, 384, 1 };
    vx_tensor relu_inception_b4_1x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b4_1x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b4_1x1_2_relu);
    vx_size dims_conv_inception_b4_1x7_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b4_1x7_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b4_1x7_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b4_1x7_reduce);
    vx_size dims_batch_norm_inception_b4_1x7_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b4_1x7_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b4_1x7_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b4_1x7_reduce_scale);
    vx_size dims_relu_inception_b4_1x7_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b4_1x7_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b4_1x7_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b4_1x7_reduce_relu);
    vx_size dims_conv_inception_b4_1x7[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b4_1x7 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b4_1x7, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b4_1x7);
    vx_size dims_batch_norm_inception_b4_1x7_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b4_1x7_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b4_1x7_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b4_1x7_scale);
    vx_size dims_relu_inception_b4_1x7_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b4_1x7_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b4_1x7_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b4_1x7_relu);
    vx_size dims_conv_inception_b4_7x1[4] = { 17, 17, 256, 1 };
    vx_tensor conv_inception_b4_7x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b4_7x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b4_7x1);
    vx_size dims_batch_norm_inception_b4_7x1_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_inception_b4_7x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b4_7x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b4_7x1_scale);
    vx_size dims_relu_inception_b4_7x1_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_inception_b4_7x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b4_7x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b4_7x1_relu);
    vx_size dims_conv_inception_b4_7x1_2_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b4_7x1_2_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b4_7x1_2_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b4_7x1_2_reduce);
    vx_size dims_batch_norm_inception_b4_7x1_2_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b4_7x1_2_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b4_7x1_2_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b4_7x1_2_reduce_scale);
    vx_size dims_relu_inception_b4_7x1_2_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b4_7x1_2_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b4_7x1_2_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b4_7x1_2_reduce_relu);
    vx_size dims_conv_inception_b4_7x1_2[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b4_7x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b4_7x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b4_7x1_2);
    vx_size dims_batch_norm_inception_b4_7x1_2_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b4_7x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b4_7x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b4_7x1_2_scale);
    vx_size dims_relu_inception_b4_7x1_2_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b4_7x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b4_7x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b4_7x1_2_relu);
    vx_size dims_conv_inception_b4_1x7_2[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b4_1x7_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b4_1x7_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b4_1x7_2);
    vx_size dims_batch_norm_inception_b4_1x7_2_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b4_1x7_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b4_1x7_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b4_1x7_2_scale);
    vx_size dims_relu_inception_b4_1x7_2_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b4_1x7_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b4_1x7_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b4_1x7_2_relu);
    vx_size dims_conv_inception_b4_7x1_3[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b4_7x1_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b4_7x1_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b4_7x1_3);
    vx_size dims_batch_norm_inception_b4_7x1_3_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b4_7x1_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b4_7x1_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b4_7x1_3_scale);
    vx_size dims_relu_inception_b4_7x1_3_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b4_7x1_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b4_7x1_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b4_7x1_3_relu);
    vx_size dims_conv_inception_b4_1x7_3[4] = { 17, 17, 256, 1 };
    vx_tensor conv_inception_b4_1x7_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b4_1x7_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b4_1x7_3);
    vx_size dims_batch_norm_inception_b4_1x7_3_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_inception_b4_1x7_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b4_1x7_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b4_1x7_3_scale);
    vx_size dims_relu_inception_b4_1x7_3_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_inception_b4_1x7_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b4_1x7_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b4_1x7_3_relu);
    vx_size dims_avg_pool_inception_b4_pool_ave[4] = { 17, 17, 1024, 1 };
    vx_tensor avg_pool_inception_b4_pool_ave = vxCreateVirtualTensor(graph, 4, dims_avg_pool_inception_b4_pool_ave, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_inception_b4_pool_ave);
    vx_size dims_conv_inception_b4_1x1[4] = { 17, 17, 128, 1 };
    vx_tensor conv_inception_b4_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b4_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b4_1x1);
    vx_size dims_batch_norm_inception_b4_1x1_scale[4] = { 17, 17, 128, 1 };
    vx_tensor batch_norm_inception_b4_1x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b4_1x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b4_1x1_scale);
    vx_size dims_relu_inception_b4_1x1_relu[4] = { 17, 17, 128, 1 };
    vx_tensor relu_inception_b4_1x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b4_1x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b4_1x1_relu);
    vx_size dims_concat_inception_b4_concat[4] = { 17, 17, 1024, 1 };
    vx_tensor concat_inception_b4_concat = vxCreateVirtualTensor(graph, 4, dims_concat_inception_b4_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_b4_concat);
    vx_size dims_conv_inception_b5_1x1_2[4] = { 17, 17, 384, 1 };
    vx_tensor conv_inception_b5_1x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b5_1x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b5_1x1_2);
    vx_size dims_batch_norm_inception_b5_1x1_2_scale[4] = { 17, 17, 384, 1 };
    vx_tensor batch_norm_inception_b5_1x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b5_1x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b5_1x1_2_scale);
    vx_size dims_relu_inception_b5_1x1_2_relu[4] = { 17, 17, 384, 1 };
    vx_tensor relu_inception_b5_1x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b5_1x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b5_1x1_2_relu);
    vx_size dims_conv_inception_b5_1x7_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b5_1x7_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b5_1x7_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b5_1x7_reduce);
    vx_size dims_batch_norm_inception_b5_1x7_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b5_1x7_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b5_1x7_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b5_1x7_reduce_scale);
    vx_size dims_relu_inception_b5_1x7_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b5_1x7_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b5_1x7_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b5_1x7_reduce_relu);
    vx_size dims_conv_inception_b5_1x7[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b5_1x7 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b5_1x7, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b5_1x7);
    vx_size dims_batch_norm_inception_b5_1x7_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b5_1x7_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b5_1x7_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b5_1x7_scale);
    vx_size dims_relu_inception_b5_1x7_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b5_1x7_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b5_1x7_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b5_1x7_relu);
    vx_size dims_conv_inception_b5_7x1[4] = { 17, 17, 256, 1 };
    vx_tensor conv_inception_b5_7x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b5_7x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b5_7x1);
    vx_size dims_batch_norm_inception_b5_7x1_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_inception_b5_7x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b5_7x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b5_7x1_scale);
    vx_size dims_relu_inception_b5_7x1_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_inception_b5_7x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b5_7x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b5_7x1_relu);
    vx_size dims_conv_inception_b5_7x1_2_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b5_7x1_2_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b5_7x1_2_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b5_7x1_2_reduce);
    vx_size dims_batch_norm_inception_b5_7x1_2_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b5_7x1_2_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b5_7x1_2_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b5_7x1_2_reduce_scale);
    vx_size dims_relu_inception_b5_7x1_2_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b5_7x1_2_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b5_7x1_2_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b5_7x1_2_reduce_relu);
    vx_size dims_conv_inception_b5_7x1_2[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b5_7x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b5_7x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b5_7x1_2);
    vx_size dims_batch_norm_inception_b5_7x1_2_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b5_7x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b5_7x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b5_7x1_2_scale);
    vx_size dims_relu_inception_b5_7x1_2_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b5_7x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b5_7x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b5_7x1_2_relu);
    vx_size dims_conv_inception_b5_1x7_2[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b5_1x7_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b5_1x7_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b5_1x7_2);
    vx_size dims_batch_norm_inception_b5_1x7_2_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b5_1x7_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b5_1x7_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b5_1x7_2_scale);
    vx_size dims_relu_inception_b5_1x7_2_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b5_1x7_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b5_1x7_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b5_1x7_2_relu);
    vx_size dims_conv_inception_b5_7x1_3[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b5_7x1_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b5_7x1_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b5_7x1_3);
    vx_size dims_batch_norm_inception_b5_7x1_3_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b5_7x1_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b5_7x1_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b5_7x1_3_scale);
    vx_size dims_relu_inception_b5_7x1_3_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b5_7x1_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b5_7x1_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b5_7x1_3_relu);
    vx_size dims_conv_inception_b5_1x7_3[4] = { 17, 17, 256, 1 };
    vx_tensor conv_inception_b5_1x7_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b5_1x7_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b5_1x7_3);
    vx_size dims_batch_norm_inception_b5_1x7_3_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_inception_b5_1x7_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b5_1x7_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b5_1x7_3_scale);
    vx_size dims_relu_inception_b5_1x7_3_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_inception_b5_1x7_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b5_1x7_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b5_1x7_3_relu);
    vx_size dims_avg_pool_inception_b5_pool_ave[4] = { 17, 17, 1024, 1 };
    vx_tensor avg_pool_inception_b5_pool_ave = vxCreateVirtualTensor(graph, 4, dims_avg_pool_inception_b5_pool_ave, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_inception_b5_pool_ave);
    vx_size dims_conv_inception_b5_1x1[4] = { 17, 17, 128, 1 };
    vx_tensor conv_inception_b5_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b5_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b5_1x1);
    vx_size dims_batch_norm_inception_b5_1x1_scale[4] = { 17, 17, 128, 1 };
    vx_tensor batch_norm_inception_b5_1x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b5_1x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b5_1x1_scale);
    vx_size dims_relu_inception_b5_1x1_relu[4] = { 17, 17, 128, 1 };
    vx_tensor relu_inception_b5_1x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b5_1x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b5_1x1_relu);
    vx_size dims_concat_inception_b5_concat[4] = { 17, 17, 1024, 1 };
    vx_tensor concat_inception_b5_concat = vxCreateVirtualTensor(graph, 4, dims_concat_inception_b5_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_b5_concat);
    vx_size dims_conv_inception_b6_1x1_2[4] = { 17, 17, 384, 1 };
    vx_tensor conv_inception_b6_1x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b6_1x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b6_1x1_2);
    vx_size dims_batch_norm_inception_b6_1x1_2_scale[4] = { 17, 17, 384, 1 };
    vx_tensor batch_norm_inception_b6_1x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b6_1x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b6_1x1_2_scale);
    vx_size dims_relu_inception_b6_1x1_2_relu[4] = { 17, 17, 384, 1 };
    vx_tensor relu_inception_b6_1x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b6_1x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b6_1x1_2_relu);
    vx_size dims_conv_inception_b6_1x7_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b6_1x7_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b6_1x7_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b6_1x7_reduce);
    vx_size dims_batch_norm_inception_b6_1x7_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b6_1x7_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b6_1x7_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b6_1x7_reduce_scale);
    vx_size dims_relu_inception_b6_1x7_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b6_1x7_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b6_1x7_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b6_1x7_reduce_relu);
    vx_size dims_conv_inception_b6_1x7[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b6_1x7 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b6_1x7, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b6_1x7);
    vx_size dims_batch_norm_inception_b6_1x7_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b6_1x7_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b6_1x7_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b6_1x7_scale);
    vx_size dims_relu_inception_b6_1x7_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b6_1x7_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b6_1x7_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b6_1x7_relu);
    vx_size dims_conv_inception_b6_7x1[4] = { 17, 17, 256, 1 };
    vx_tensor conv_inception_b6_7x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b6_7x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b6_7x1);
    vx_size dims_batch_norm_inception_b6_7x1_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_inception_b6_7x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b6_7x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b6_7x1_scale);
    vx_size dims_relu_inception_b6_7x1_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_inception_b6_7x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b6_7x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b6_7x1_relu);
    vx_size dims_conv_inception_b6_7x1_2_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b6_7x1_2_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b6_7x1_2_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b6_7x1_2_reduce);
    vx_size dims_batch_norm_inception_b6_7x1_2_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b6_7x1_2_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b6_7x1_2_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b6_7x1_2_reduce_scale);
    vx_size dims_relu_inception_b6_7x1_2_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b6_7x1_2_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b6_7x1_2_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b6_7x1_2_reduce_relu);
    vx_size dims_conv_inception_b6_7x1_2[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b6_7x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b6_7x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b6_7x1_2);
    vx_size dims_batch_norm_inception_b6_7x1_2_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b6_7x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b6_7x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b6_7x1_2_scale);
    vx_size dims_relu_inception_b6_7x1_2_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b6_7x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b6_7x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b6_7x1_2_relu);
    vx_size dims_conv_inception_b6_1x7_2[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b6_1x7_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b6_1x7_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b6_1x7_2);
    vx_size dims_batch_norm_inception_b6_1x7_2_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b6_1x7_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b6_1x7_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b6_1x7_2_scale);
    vx_size dims_relu_inception_b6_1x7_2_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b6_1x7_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b6_1x7_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b6_1x7_2_relu);
    vx_size dims_conv_inception_b6_7x1_3[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b6_7x1_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b6_7x1_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b6_7x1_3);
    vx_size dims_batch_norm_inception_b6_7x1_3_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b6_7x1_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b6_7x1_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b6_7x1_3_scale);
    vx_size dims_relu_inception_b6_7x1_3_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b6_7x1_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b6_7x1_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b6_7x1_3_relu);
    vx_size dims_conv_inception_b6_1x7_3[4] = { 17, 17, 256, 1 };
    vx_tensor conv_inception_b6_1x7_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b6_1x7_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b6_1x7_3);
    vx_size dims_batch_norm_inception_b6_1x7_3_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_inception_b6_1x7_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b6_1x7_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b6_1x7_3_scale);
    vx_size dims_relu_inception_b6_1x7_3_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_inception_b6_1x7_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b6_1x7_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b6_1x7_3_relu);
    vx_size dims_avg_pool_inception_b6_pool_ave[4] = { 17, 17, 1024, 1 };
    vx_tensor avg_pool_inception_b6_pool_ave = vxCreateVirtualTensor(graph, 4, dims_avg_pool_inception_b6_pool_ave, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_inception_b6_pool_ave);
    vx_size dims_conv_inception_b6_1x1[4] = { 17, 17, 128, 1 };
    vx_tensor conv_inception_b6_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b6_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b6_1x1);
    vx_size dims_batch_norm_inception_b6_1x1_scale[4] = { 17, 17, 128, 1 };
    vx_tensor batch_norm_inception_b6_1x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b6_1x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b6_1x1_scale);
    vx_size dims_relu_inception_b6_1x1_relu[4] = { 17, 17, 128, 1 };
    vx_tensor relu_inception_b6_1x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b6_1x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b6_1x1_relu);
    vx_size dims_concat_inception_b6_concat[4] = { 17, 17, 1024, 1 };
    vx_tensor concat_inception_b6_concat = vxCreateVirtualTensor(graph, 4, dims_concat_inception_b6_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_b6_concat);
    vx_size dims_conv_inception_b7_1x1_2[4] = { 17, 17, 384, 1 };
    vx_tensor conv_inception_b7_1x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b7_1x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b7_1x1_2);
    vx_size dims_batch_norm_inception_b7_1x1_2_scale[4] = { 17, 17, 384, 1 };
    vx_tensor batch_norm_inception_b7_1x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b7_1x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b7_1x1_2_scale);
    vx_size dims_relu_inception_b7_1x1_2_relu[4] = { 17, 17, 384, 1 };
    vx_tensor relu_inception_b7_1x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b7_1x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b7_1x1_2_relu);
    vx_size dims_conv_inception_b7_1x7_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b7_1x7_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b7_1x7_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b7_1x7_reduce);
    vx_size dims_batch_norm_inception_b7_1x7_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b7_1x7_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b7_1x7_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b7_1x7_reduce_scale);
    vx_size dims_relu_inception_b7_1x7_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b7_1x7_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b7_1x7_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b7_1x7_reduce_relu);
    vx_size dims_conv_inception_b7_1x7[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b7_1x7 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b7_1x7, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b7_1x7);
    vx_size dims_batch_norm_inception_b7_1x7_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b7_1x7_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b7_1x7_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b7_1x7_scale);
    vx_size dims_relu_inception_b7_1x7_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b7_1x7_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b7_1x7_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b7_1x7_relu);
    vx_size dims_conv_inception_b7_7x1[4] = { 17, 17, 256, 1 };
    vx_tensor conv_inception_b7_7x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b7_7x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b7_7x1);
    vx_size dims_batch_norm_inception_b7_7x1_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_inception_b7_7x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b7_7x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b7_7x1_scale);
    vx_size dims_relu_inception_b7_7x1_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_inception_b7_7x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b7_7x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b7_7x1_relu);
    vx_size dims_conv_inception_b7_7x1_2_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b7_7x1_2_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b7_7x1_2_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b7_7x1_2_reduce);
    vx_size dims_batch_norm_inception_b7_7x1_2_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b7_7x1_2_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b7_7x1_2_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b7_7x1_2_reduce_scale);
    vx_size dims_relu_inception_b7_7x1_2_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b7_7x1_2_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b7_7x1_2_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b7_7x1_2_reduce_relu);
    vx_size dims_conv_inception_b7_7x1_2[4] = { 17, 17, 192, 1 };
    vx_tensor conv_inception_b7_7x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b7_7x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b7_7x1_2);
    vx_size dims_batch_norm_inception_b7_7x1_2_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_inception_b7_7x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b7_7x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b7_7x1_2_scale);
    vx_size dims_relu_inception_b7_7x1_2_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_inception_b7_7x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b7_7x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b7_7x1_2_relu);
    vx_size dims_conv_inception_b7_1x7_2[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b7_1x7_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b7_1x7_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b7_1x7_2);
    vx_size dims_batch_norm_inception_b7_1x7_2_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b7_1x7_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b7_1x7_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b7_1x7_2_scale);
    vx_size dims_relu_inception_b7_1x7_2_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b7_1x7_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b7_1x7_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b7_1x7_2_relu);
    vx_size dims_conv_inception_b7_7x1_3[4] = { 17, 17, 224, 1 };
    vx_tensor conv_inception_b7_7x1_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b7_7x1_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b7_7x1_3);
    vx_size dims_batch_norm_inception_b7_7x1_3_scale[4] = { 17, 17, 224, 1 };
    vx_tensor batch_norm_inception_b7_7x1_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b7_7x1_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b7_7x1_3_scale);
    vx_size dims_relu_inception_b7_7x1_3_relu[4] = { 17, 17, 224, 1 };
    vx_tensor relu_inception_b7_7x1_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b7_7x1_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b7_7x1_3_relu);
    vx_size dims_conv_inception_b7_1x7_3[4] = { 17, 17, 256, 1 };
    vx_tensor conv_inception_b7_1x7_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b7_1x7_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b7_1x7_3);
    vx_size dims_batch_norm_inception_b7_1x7_3_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_inception_b7_1x7_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b7_1x7_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b7_1x7_3_scale);
    vx_size dims_relu_inception_b7_1x7_3_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_inception_b7_1x7_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b7_1x7_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b7_1x7_3_relu);
    vx_size dims_avg_pool_inception_b7_pool_ave[4] = { 17, 17, 1024, 1 };
    vx_tensor avg_pool_inception_b7_pool_ave = vxCreateVirtualTensor(graph, 4, dims_avg_pool_inception_b7_pool_ave, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_inception_b7_pool_ave);
    vx_size dims_conv_inception_b7_1x1[4] = { 17, 17, 128, 1 };
    vx_tensor conv_inception_b7_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_b7_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_b7_1x1);
    vx_size dims_batch_norm_inception_b7_1x1_scale[4] = { 17, 17, 128, 1 };
    vx_tensor batch_norm_inception_b7_1x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_b7_1x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_b7_1x1_scale);
    vx_size dims_relu_inception_b7_1x1_relu[4] = { 17, 17, 128, 1 };
    vx_tensor relu_inception_b7_1x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_b7_1x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_b7_1x1_relu);
    vx_size dims_concat_inception_b7_concat[4] = { 17, 17, 1024, 1 };
    vx_tensor concat_inception_b7_concat = vxCreateVirtualTensor(graph, 4, dims_concat_inception_b7_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_b7_concat);
    vx_size dims_conv_reduction_b_3x3_reduce[4] = { 17, 17, 192, 1 };
    vx_tensor conv_reduction_b_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_reduction_b_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_reduction_b_3x3_reduce);
    vx_size dims_batch_norm_reduction_b_3x3_reduce_scale[4] = { 17, 17, 192, 1 };
    vx_tensor batch_norm_reduction_b_3x3_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_reduction_b_3x3_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_reduction_b_3x3_reduce_scale);
    vx_size dims_relu_reduction_b_3x3_reduce_relu[4] = { 17, 17, 192, 1 };
    vx_tensor relu_reduction_b_3x3_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_reduction_b_3x3_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_reduction_b_3x3_reduce_relu);
    vx_size dims_conv_reduction_b_3x3[4] = { 8, 8, 192, 1 };
    vx_tensor conv_reduction_b_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_reduction_b_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_reduction_b_3x3);
    vx_size dims_batch_norm_reduction_b_3x3_scale[4] = { 8, 8, 192, 1 };
    vx_tensor batch_norm_reduction_b_3x3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_reduction_b_3x3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_reduction_b_3x3_scale);
    vx_size dims_relu_reduction_b_3x3_relu[4] = { 8, 8, 192, 1 };
    vx_tensor relu_reduction_b_3x3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_reduction_b_3x3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_reduction_b_3x3_relu);
    vx_size dims_conv_reduction_b_1x7_reduce[4] = { 17, 17, 256, 1 };
    vx_tensor conv_reduction_b_1x7_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_reduction_b_1x7_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_reduction_b_1x7_reduce);
    vx_size dims_batch_norm_reduction_b_1x7_reduce_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_reduction_b_1x7_reduce_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_reduction_b_1x7_reduce_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_reduction_b_1x7_reduce_scale);
    vx_size dims_relu_reduction_b_1x7_reduce_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_reduction_b_1x7_reduce_relu = vxCreateVirtualTensor(graph, 4, dims_relu_reduction_b_1x7_reduce_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_reduction_b_1x7_reduce_relu);
    vx_size dims_conv_reduction_b_1x7[4] = { 17, 17, 256, 1 };
    vx_tensor conv_reduction_b_1x7 = vxCreateVirtualTensor(graph, 4, dims_conv_reduction_b_1x7, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_reduction_b_1x7);
    vx_size dims_batch_norm_reduction_b_1x7_scale[4] = { 17, 17, 256, 1 };
    vx_tensor batch_norm_reduction_b_1x7_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_reduction_b_1x7_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_reduction_b_1x7_scale);
    vx_size dims_relu_reduction_b_1x7_relu[4] = { 17, 17, 256, 1 };
    vx_tensor relu_reduction_b_1x7_relu = vxCreateVirtualTensor(graph, 4, dims_relu_reduction_b_1x7_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_reduction_b_1x7_relu);
    vx_size dims_conv_reduction_b_7x1[4] = { 17, 17, 320, 1 };
    vx_tensor conv_reduction_b_7x1 = vxCreateVirtualTensor(graph, 4, dims_conv_reduction_b_7x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_reduction_b_7x1);
    vx_size dims_batch_norm_reduction_b_7x1_scale[4] = { 17, 17, 320, 1 };
    vx_tensor batch_norm_reduction_b_7x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_reduction_b_7x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_reduction_b_7x1_scale);
    vx_size dims_relu_reduction_b_7x1_relu[4] = { 17, 17, 320, 1 };
    vx_tensor relu_reduction_b_7x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_reduction_b_7x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_reduction_b_7x1_relu);
    vx_size dims_conv_reduction_b_3x3_2[4] = { 8, 8, 320, 1 };
    vx_tensor conv_reduction_b_3x3_2 = vxCreateVirtualTensor(graph, 4, dims_conv_reduction_b_3x3_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_reduction_b_3x3_2);
    vx_size dims_batch_norm_reduction_b_3x3_2_scale[4] = { 8, 8, 320, 1 };
    vx_tensor batch_norm_reduction_b_3x3_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_reduction_b_3x3_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_reduction_b_3x3_2_scale);
    vx_size dims_relu_reduction_b_3x3_2_relu[4] = { 8, 8, 320, 1 };
    vx_tensor relu_reduction_b_3x3_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_reduction_b_3x3_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_reduction_b_3x3_2_relu);
    vx_size dims_max_pool_reduction_b_pool[4] = { 8, 8, 1024, 1 };
    vx_tensor max_pool_reduction_b_pool = vxCreateVirtualTensor(graph, 4, dims_max_pool_reduction_b_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_reduction_b_pool);
    vx_size dims_concat_reduction_b_concat[4] = { 8, 8, 1536, 1 };
    vx_tensor concat_reduction_b_concat = vxCreateVirtualTensor(graph, 4, dims_concat_reduction_b_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_reduction_b_concat);
    vx_size dims_conv_inception_c1_1x1_2[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c1_1x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c1_1x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c1_1x1_2);
    vx_size dims_batch_norm_inception_c1_1x1_2_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c1_1x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c1_1x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c1_1x1_2_scale);
    vx_size dims_relu_inception_c1_1x1_2_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c1_1x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c1_1x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c1_1x1_2_relu);
    vx_size dims_conv_inception_c1_1x1_3[4] = { 8, 8, 384, 1 };
    vx_tensor conv_inception_c1_1x1_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c1_1x1_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c1_1x1_3);
    vx_size dims_batch_norm_inception_c1_1x1_3_scale[4] = { 8, 8, 384, 1 };
    vx_tensor batch_norm_inception_c1_1x1_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c1_1x1_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c1_1x1_3_scale);
    vx_size dims_relu_inception_c1_1x1_3_relu[4] = { 8, 8, 384, 1 };
    vx_tensor relu_inception_c1_1x1_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c1_1x1_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c1_1x1_3_relu);
    vx_size dims_conv_inception_c1_1x3[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c1_1x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c1_1x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c1_1x3);
    vx_size dims_batch_norm_inception_c1_1x3_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c1_1x3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c1_1x3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c1_1x3_scale);
    vx_size dims_relu_inception_c1_1x3_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c1_1x3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c1_1x3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c1_1x3_relu);
    vx_size dims_conv_inception_c1_3x1[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c1_3x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c1_3x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c1_3x1);
    vx_size dims_batch_norm_inception_c1_3x1_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c1_3x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c1_3x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c1_3x1_scale);
    vx_size dims_relu_inception_c1_3x1_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c1_3x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c1_3x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c1_3x1_relu);
    vx_size dims_conv_inception_c1_1x1_4[4] = { 8, 8, 384, 1 };
    vx_tensor conv_inception_c1_1x1_4 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c1_1x1_4, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c1_1x1_4);
    vx_size dims_batch_norm_inception_c1_1x1_4_scale[4] = { 8, 8, 384, 1 };
    vx_tensor batch_norm_inception_c1_1x1_4_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c1_1x1_4_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c1_1x1_4_scale);
    vx_size dims_relu_inception_c1_1x1_4_relu[4] = { 8, 8, 384, 1 };
    vx_tensor relu_inception_c1_1x1_4_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c1_1x1_4_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c1_1x1_4_relu);
    vx_size dims_conv_inception_c1_3x1_2[4] = { 8, 8, 448, 1 };
    vx_tensor conv_inception_c1_3x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c1_3x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c1_3x1_2);
    vx_size dims_batch_norm_inception_c1_3x1_2_scale[4] = { 8, 8, 448, 1 };
    vx_tensor batch_norm_inception_c1_3x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c1_3x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c1_3x1_2_scale);
    vx_size dims_relu_inception_c1_3x1_2_relu[4] = { 8, 8, 448, 1 };
    vx_tensor relu_inception_c1_3x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c1_3x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c1_3x1_2_relu);
    vx_size dims_conv_inception_c1_1x3_2[4] = { 8, 8, 512, 1 };
    vx_tensor conv_inception_c1_1x3_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c1_1x3_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c1_1x3_2);
    vx_size dims_batch_norm_inception_c1_1x3_2_scale[4] = { 8, 8, 512, 1 };
    vx_tensor batch_norm_inception_c1_1x3_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c1_1x3_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c1_1x3_2_scale);
    vx_size dims_relu_inception_c1_1x3_2_relu[4] = { 8, 8, 512, 1 };
    vx_tensor relu_inception_c1_1x3_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c1_1x3_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c1_1x3_2_relu);
    vx_size dims_conv_inception_c1_1x3_3[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c1_1x3_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c1_1x3_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c1_1x3_3);
    vx_size dims_batch_norm_inception_c1_1x3_3_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c1_1x3_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c1_1x3_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c1_1x3_3_scale);
    vx_size dims_relu_inception_c1_1x3_3_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c1_1x3_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c1_1x3_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c1_1x3_3_relu);
    vx_size dims_conv_inception_c1_3x1_3[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c1_3x1_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c1_3x1_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c1_3x1_3);
    vx_size dims_batch_norm_inception_c1_3x1_3_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c1_3x1_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c1_3x1_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c1_3x1_3_scale);
    vx_size dims_relu_inception_c1_3x1_3_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c1_3x1_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c1_3x1_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c1_3x1_3_relu);
    vx_size dims_avg_pool_inception_c1_pool_ave[4] = { 8, 8, 1536, 1 };
    vx_tensor avg_pool_inception_c1_pool_ave = vxCreateVirtualTensor(graph, 4, dims_avg_pool_inception_c1_pool_ave, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_inception_c1_pool_ave);
    vx_size dims_conv_inception_c1_1x1[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c1_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c1_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c1_1x1);
    vx_size dims_batch_norm_inception_c1_1x1_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c1_1x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c1_1x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c1_1x1_scale);
    vx_size dims_relu_inception_c1_1x1_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c1_1x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c1_1x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c1_1x1_relu);
    vx_size dims_concat_inception_c1_concat[4] = { 8, 8, 1536, 1 };
    vx_tensor concat_inception_c1_concat = vxCreateVirtualTensor(graph, 4, dims_concat_inception_c1_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_c1_concat);
    vx_size dims_conv_inception_c2_1x1_2[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c2_1x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c2_1x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c2_1x1_2);
    vx_size dims_batch_norm_inception_c2_1x1_2_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c2_1x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c2_1x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c2_1x1_2_scale);
    vx_size dims_relu_inception_c2_1x1_2_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c2_1x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c2_1x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c2_1x1_2_relu);
    vx_size dims_conv_inception_c2_1x1_3[4] = { 8, 8, 384, 1 };
    vx_tensor conv_inception_c2_1x1_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c2_1x1_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c2_1x1_3);
    vx_size dims_batch_norm_inception_c2_1x1_3_scale[4] = { 8, 8, 384, 1 };
    vx_tensor batch_norm_inception_c2_1x1_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c2_1x1_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c2_1x1_3_scale);
    vx_size dims_relu_inception_c2_1x1_3_relu[4] = { 8, 8, 384, 1 };
    vx_tensor relu_inception_c2_1x1_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c2_1x1_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c2_1x1_3_relu);
    vx_size dims_conv_inception_c2_1x3[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c2_1x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c2_1x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c2_1x3);
    vx_size dims_batch_norm_inception_c2_1x3_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c2_1x3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c2_1x3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c2_1x3_scale);
    vx_size dims_relu_inception_c2_1x3_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c2_1x3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c2_1x3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c2_1x3_relu);
    vx_size dims_conv_inception_c2_3x1[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c2_3x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c2_3x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c2_3x1);
    vx_size dims_batch_norm_inception_c2_3x1_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c2_3x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c2_3x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c2_3x1_scale);
    vx_size dims_relu_inception_c2_3x1_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c2_3x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c2_3x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c2_3x1_relu);
    vx_size dims_conv_inception_c2_1x1_4[4] = { 8, 8, 384, 1 };
    vx_tensor conv_inception_c2_1x1_4 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c2_1x1_4, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c2_1x1_4);
    vx_size dims_batch_norm_inception_c2_1x1_4_scale[4] = { 8, 8, 384, 1 };
    vx_tensor batch_norm_inception_c2_1x1_4_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c2_1x1_4_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c2_1x1_4_scale);
    vx_size dims_relu_inception_c2_1x1_4_relu[4] = { 8, 8, 384, 1 };
    vx_tensor relu_inception_c2_1x1_4_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c2_1x1_4_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c2_1x1_4_relu);
    vx_size dims_conv_inception_c2_3x1_2[4] = { 8, 8, 448, 1 };
    vx_tensor conv_inception_c2_3x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c2_3x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c2_3x1_2);
    vx_size dims_batch_norm_inception_c2_3x1_2_scale[4] = { 8, 8, 448, 1 };
    vx_tensor batch_norm_inception_c2_3x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c2_3x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c2_3x1_2_scale);
    vx_size dims_relu_inception_c2_3x1_2_relu[4] = { 8, 8, 448, 1 };
    vx_tensor relu_inception_c2_3x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c2_3x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c2_3x1_2_relu);
    vx_size dims_conv_inception_c2_1x3_2[4] = { 8, 8, 512, 1 };
    vx_tensor conv_inception_c2_1x3_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c2_1x3_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c2_1x3_2);
    vx_size dims_batch_norm_inception_c2_1x3_2_scale[4] = { 8, 8, 512, 1 };
    vx_tensor batch_norm_inception_c2_1x3_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c2_1x3_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c2_1x3_2_scale);
    vx_size dims_relu_inception_c2_1x3_2_relu[4] = { 8, 8, 512, 1 };
    vx_tensor relu_inception_c2_1x3_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c2_1x3_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c2_1x3_2_relu);
    vx_size dims_conv_inception_c2_1x3_3[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c2_1x3_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c2_1x3_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c2_1x3_3);
    vx_size dims_batch_norm_inception_c2_1x3_3_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c2_1x3_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c2_1x3_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c2_1x3_3_scale);
    vx_size dims_relu_inception_c2_1x3_3_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c2_1x3_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c2_1x3_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c2_1x3_3_relu);
    vx_size dims_conv_inception_c2_3x1_3[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c2_3x1_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c2_3x1_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c2_3x1_3);
    vx_size dims_batch_norm_inception_c2_3x1_3_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c2_3x1_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c2_3x1_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c2_3x1_3_scale);
    vx_size dims_relu_inception_c2_3x1_3_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c2_3x1_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c2_3x1_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c2_3x1_3_relu);
    vx_size dims_avg_pool_inception_c2_pool_ave[4] = { 8, 8, 1536, 1 };
    vx_tensor avg_pool_inception_c2_pool_ave = vxCreateVirtualTensor(graph, 4, dims_avg_pool_inception_c2_pool_ave, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_inception_c2_pool_ave);
    vx_size dims_conv_inception_c2_1x1[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c2_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c2_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c2_1x1);
    vx_size dims_batch_norm_inception_c2_1x1_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c2_1x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c2_1x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c2_1x1_scale);
    vx_size dims_relu_inception_c2_1x1_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c2_1x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c2_1x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c2_1x1_relu);
    vx_size dims_concat_inception_c2_concat[4] = { 8, 8, 1536, 1 };
    vx_tensor concat_inception_c2_concat = vxCreateVirtualTensor(graph, 4, dims_concat_inception_c2_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_c2_concat);
    vx_size dims_conv_inception_c3_1x1_2[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c3_1x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c3_1x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c3_1x1_2);
    vx_size dims_batch_norm_inception_c3_1x1_2_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c3_1x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c3_1x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c3_1x1_2_scale);
    vx_size dims_relu_inception_c3_1x1_2_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c3_1x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c3_1x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c3_1x1_2_relu);
    vx_size dims_conv_inception_c3_1x1_3[4] = { 8, 8, 384, 1 };
    vx_tensor conv_inception_c3_1x1_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c3_1x1_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c3_1x1_3);
    vx_size dims_batch_norm_inception_c3_1x1_3_scale[4] = { 8, 8, 384, 1 };
    vx_tensor batch_norm_inception_c3_1x1_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c3_1x1_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c3_1x1_3_scale);
    vx_size dims_relu_inception_c3_1x1_3_relu[4] = { 8, 8, 384, 1 };
    vx_tensor relu_inception_c3_1x1_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c3_1x1_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c3_1x1_3_relu);
    vx_size dims_conv_inception_c3_1x3[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c3_1x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c3_1x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c3_1x3);
    vx_size dims_batch_norm_inception_c3_1x3_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c3_1x3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c3_1x3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c3_1x3_scale);
    vx_size dims_relu_inception_c3_1x3_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c3_1x3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c3_1x3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c3_1x3_relu);
    vx_size dims_conv_inception_c3_3x1[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c3_3x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c3_3x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c3_3x1);
    vx_size dims_batch_norm_inception_c3_3x1_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c3_3x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c3_3x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c3_3x1_scale);
    vx_size dims_relu_inception_c3_3x1_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c3_3x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c3_3x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c3_3x1_relu);
    vx_size dims_conv_inception_c3_1x1_4[4] = { 8, 8, 384, 1 };
    vx_tensor conv_inception_c3_1x1_4 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c3_1x1_4, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c3_1x1_4);
    vx_size dims_batch_norm_inception_c3_1x1_4_scale[4] = { 8, 8, 384, 1 };
    vx_tensor batch_norm_inception_c3_1x1_4_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c3_1x1_4_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c3_1x1_4_scale);
    vx_size dims_relu_inception_c3_1x1_4_relu[4] = { 8, 8, 384, 1 };
    vx_tensor relu_inception_c3_1x1_4_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c3_1x1_4_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c3_1x1_4_relu);
    vx_size dims_conv_inception_c3_3x1_2[4] = { 8, 8, 448, 1 };
    vx_tensor conv_inception_c3_3x1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c3_3x1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c3_3x1_2);
    vx_size dims_batch_norm_inception_c3_3x1_2_scale[4] = { 8, 8, 448, 1 };
    vx_tensor batch_norm_inception_c3_3x1_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c3_3x1_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c3_3x1_2_scale);
    vx_size dims_relu_inception_c3_3x1_2_relu[4] = { 8, 8, 448, 1 };
    vx_tensor relu_inception_c3_3x1_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c3_3x1_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c3_3x1_2_relu);
    vx_size dims_conv_inception_c3_1x3_2[4] = { 8, 8, 512, 1 };
    vx_tensor conv_inception_c3_1x3_2 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c3_1x3_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c3_1x3_2);
    vx_size dims_batch_norm_inception_c3_1x3_2_scale[4] = { 8, 8, 512, 1 };
    vx_tensor batch_norm_inception_c3_1x3_2_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c3_1x3_2_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c3_1x3_2_scale);
    vx_size dims_relu_inception_c3_1x3_2_relu[4] = { 8, 8, 512, 1 };
    vx_tensor relu_inception_c3_1x3_2_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c3_1x3_2_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c3_1x3_2_relu);
    vx_size dims_conv_inception_c3_1x3_3[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c3_1x3_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c3_1x3_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c3_1x3_3);
    vx_size dims_batch_norm_inception_c3_1x3_3_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c3_1x3_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c3_1x3_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c3_1x3_3_scale);
    vx_size dims_relu_inception_c3_1x3_3_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c3_1x3_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c3_1x3_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c3_1x3_3_relu);
    vx_size dims_conv_inception_c3_3x1_3[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c3_3x1_3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c3_3x1_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c3_3x1_3);
    vx_size dims_batch_norm_inception_c3_3x1_3_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c3_3x1_3_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c3_3x1_3_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c3_3x1_3_scale);
    vx_size dims_relu_inception_c3_3x1_3_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c3_3x1_3_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c3_3x1_3_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c3_3x1_3_relu);
    vx_size dims_avg_pool_inception_c3_pool_ave[4] = { 8, 8, 1536, 1 };
    vx_tensor avg_pool_inception_c3_pool_ave = vxCreateVirtualTensor(graph, 4, dims_avg_pool_inception_c3_pool_ave, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_inception_c3_pool_ave);
    vx_size dims_conv_inception_c3_1x1[4] = { 8, 8, 256, 1 };
    vx_tensor conv_inception_c3_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_c3_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_c3_1x1);
    vx_size dims_batch_norm_inception_c3_1x1_scale[4] = { 8, 8, 256, 1 };
    vx_tensor batch_norm_inception_c3_1x1_scale = vxCreateVirtualTensor(graph, 4, dims_batch_norm_inception_c3_1x1_scale, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_inception_c3_1x1_scale);
    vx_size dims_relu_inception_c3_1x1_relu[4] = { 8, 8, 256, 1 };
    vx_tensor relu_inception_c3_1x1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_inception_c3_1x1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_c3_1x1_relu);
    vx_size dims_concat_inception_c3_concat[4] = { 8, 8, 1536, 1 };
    vx_tensor concat_inception_c3_concat = vxCreateVirtualTensor(graph, 4, dims_concat_inception_c3_concat, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_c3_concat);
    vx_size dims_avg_pool_pool_8x8_s1[4] = { 1, 1, 1536, 1 };
    vx_tensor avg_pool_pool_8x8_s1 = vxCreateVirtualTensor(graph, 4, dims_avg_pool_pool_8x8_s1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_pool_8x8_s1);
    vx_size dims_gemm_classifier[4] = { 1, 1, 1000, 1 };
    vx_tensor gemm_classifier = vxCreateVirtualTensor(graph, 4, dims_gemm_classifier, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(gemm_classifier);

    // create nodes in graph

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, data, conv1_3x3_s2_w, NULL, &conv_params, sizeof(conv_params), conv_conv1_3x3_s2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_conv1_3x3_s2, conv1_3x3_s2_bn_w, conv1_3x3_s2_bn_b, conv1_3x3_s2_scale_w, conv1_3x3_s2_scale_b, 1.000000e-03f, batch_norm_conv1_3x3_s2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_conv1_3x3_s2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_conv1_3x3_s2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_conv1_3x3_s2_relu, conv2_3x3_s1_w, NULL, &conv_params, sizeof(conv_params), conv_conv2_3x3_s1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_conv2_3x3_s1, conv2_3x3_s1_bn_w, conv2_3x3_s1_bn_b, conv2_3x3_s1_scale_w, conv2_3x3_s1_scale_b, 1.000000e-03f, batch_norm_conv2_3x3_s1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_conv2_3x3_s1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_conv2_3x3_s1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_conv2_3x3_s1_relu, conv3_3x3_s1_w, NULL, &conv_params, sizeof(conv_params), conv_conv3_3x3_s1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_conv3_3x3_s1, conv3_3x3_s1_bn_w, conv3_3x3_s1_bn_b, conv3_3x3_s1_scale_w, conv3_3x3_s1_scale_b, 1.000000e-03f, batch_norm_conv3_3x3_s1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_conv3_3x3_s1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_conv3_3x3_s1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_conv3_3x3_s1_relu, inception_stem1_3x3_s2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_stem1_3x3_s2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_stem1_3x3_s2, inception_stem1_3x3_s2_bn_w, inception_stem1_3x3_s2_bn_b, inception_stem1_3x3_s2_scale_w, inception_stem1_3x3_s2_scale_b, 1.000000e-03f, batch_norm_inception_stem1_3x3_s2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_stem1_3x3_s2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_stem1_3x3_s2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, relu_conv3_3x3_s1_relu, VX_NN_POOLING_MAX, 3, 3, 0, 0, VX_ROUND_POLICY_TO_NEAREST_EVEN, max_pool_inception_stem1_pool);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_stem1, max_pool_inception_stem1_pool, relu_inception_stem1_3x3_s2_relu, NULL, NULL, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_stem1, inception_stem2_3x3_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_stem2_3x3_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_stem2_3x3_reduce, inception_stem2_3x3_reduce_bn_w, inception_stem2_3x3_reduce_bn_b, inception_stem2_3x3_reduce_scale_w, inception_stem2_3x3_reduce_scale_b, 1.000000e-03f, batch_norm_inception_stem2_3x3_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_stem2_3x3_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_stem2_3x3_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_stem2_3x3_reduce_relu, inception_stem2_3x3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_stem2_3x3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_stem2_3x3, inception_stem2_3x3_bn_w, inception_stem2_3x3_bn_b, inception_stem2_3x3_scale_w, inception_stem2_3x3_scale_b, 1.000000e-03f, batch_norm_inception_stem2_3x3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_stem2_3x3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_stem2_3x3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_stem1, inception_stem2_1x7_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_stem2_1x7_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_stem2_1x7_reduce, inception_stem2_1x7_reduce_bn_w, inception_stem2_1x7_reduce_bn_b, inception_stem2_1x7_reduce_scale_w, inception_stem2_1x7_reduce_scale_b, 1.000000e-03f, batch_norm_inception_stem2_1x7_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_stem2_1x7_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_stem2_1x7_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_stem2_1x7_reduce_relu, inception_stem2_1x7_w, NULL, &conv_params, sizeof(conv_params), conv_inception_stem2_1x7);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_stem2_1x7, inception_stem2_1x7_bn_w, inception_stem2_1x7_bn_b, inception_stem2_1x7_scale_w, inception_stem2_1x7_scale_b, 1.000000e-03f, batch_norm_inception_stem2_1x7_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_stem2_1x7_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_stem2_1x7_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_stem2_1x7_relu, inception_stem2_7x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_stem2_7x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_stem2_7x1, inception_stem2_7x1_bn_w, inception_stem2_7x1_bn_b, inception_stem2_7x1_scale_w, inception_stem2_7x1_scale_b, 1.000000e-03f, batch_norm_inception_stem2_7x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_stem2_7x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_stem2_7x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_stem2_7x1_relu, inception_stem2_3x3_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_stem2_3x3_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_stem2_3x3_2, inception_stem2_3x3_2_bn_w, inception_stem2_3x3_2_bn_b, inception_stem2_3x3_2_scale_w, inception_stem2_3x3_2_scale_b, 1.000000e-03f, batch_norm_inception_stem2_3x3_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_stem2_3x3_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_stem2_3x3_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_stem2, relu_inception_stem2_3x3_relu, relu_inception_stem2_3x3_2_relu, NULL, NULL, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_stem2, inception_stem3_3x3_s2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_stem3_3x3_s2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_stem3_3x3_s2, inception_stem3_3x3_s2_bn_w, inception_stem3_3x3_s2_bn_b, inception_stem3_3x3_s2_scale_w, inception_stem3_3x3_s2_scale_b, 1.000000e-03f, batch_norm_inception_stem3_3x3_s2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_stem3_3x3_s2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_stem3_3x3_s2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_stem2, VX_NN_POOLING_MAX, 3, 3, 0, 0, VX_ROUND_POLICY_TO_NEAREST_EVEN, max_pool_inception_stem3_pool);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_stem3, relu_inception_stem3_3x3_s2_relu, max_pool_inception_stem3_pool, NULL, NULL, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_stem3, inception_a1_1x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a1_1x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a1_1x1_2, inception_a1_1x1_2_bn_w, inception_a1_1x1_2_bn_b, inception_a1_1x1_2_scale_w, inception_a1_1x1_2_scale_b, 1.000000e-03f, batch_norm_inception_a1_1x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a1_1x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a1_1x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_stem3, inception_a1_3x3_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a1_3x3_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a1_3x3_reduce, inception_a1_3x3_reduce_bn_w, inception_a1_3x3_reduce_bn_b, inception_a1_3x3_reduce_scale_w, inception_a1_3x3_reduce_scale_b, 1.000000e-03f, batch_norm_inception_a1_3x3_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a1_3x3_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a1_3x3_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_a1_3x3_reduce_relu, inception_a1_3x3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a1_3x3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a1_3x3, inception_a1_3x3_bn_w, inception_a1_3x3_bn_b, inception_a1_3x3_scale_w, inception_a1_3x3_scale_b, 1.000000e-03f, batch_norm_inception_a1_3x3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a1_3x3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a1_3x3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_stem3, inception_a1_3x3_2_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a1_3x3_2_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a1_3x3_2_reduce, inception_a1_3x3_2_reduce_bn_w, inception_a1_3x3_2_reduce_bn_b, inception_a1_3x3_2_reduce_scale_w, inception_a1_3x3_2_reduce_scale_b, 1.000000e-03f, batch_norm_inception_a1_3x3_2_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a1_3x3_2_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a1_3x3_2_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_a1_3x3_2_reduce_relu, inception_a1_3x3_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a1_3x3_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a1_3x3_2, inception_a1_3x3_2_bn_w, inception_a1_3x3_2_bn_b, inception_a1_3x3_2_scale_w, inception_a1_3x3_2_scale_b, 1.000000e-03f, batch_norm_inception_a1_3x3_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a1_3x3_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a1_3x3_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_a1_3x3_2_relu, inception_a1_3x3_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a1_3x3_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a1_3x3_3, inception_a1_3x3_3_bn_w, inception_a1_3x3_3_bn_b, inception_a1_3x3_3_scale_w, inception_a1_3x3_3_scale_b, 1.000000e-03f, batch_norm_inception_a1_3x3_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a1_3x3_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a1_3x3_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_stem3, VX_NN_POOLING_AVG, 3, 3, 1, 1, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_inception_a1_pool_ave);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, avg_pool_inception_a1_pool_ave, inception_a1_1x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a1_1x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a1_1x1, inception_a1_1x1_bn_w, inception_a1_1x1_bn_b, inception_a1_1x1_scale_w, inception_a1_1x1_scale_b, 1.000000e-03f, batch_norm_inception_a1_1x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a1_1x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a1_1x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_a1_concat, relu_inception_a1_1x1_2_relu, relu_inception_a1_3x3_relu, relu_inception_a1_3x3_3_relu, relu_inception_a1_1x1_relu, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_a1_concat, inception_a2_1x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a2_1x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a2_1x1_2, inception_a2_1x1_2_bn_w, inception_a2_1x1_2_bn_b, inception_a2_1x1_2_scale_w, inception_a2_1x1_2_scale_b, 1.000000e-03f, batch_norm_inception_a2_1x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a2_1x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a2_1x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_a1_concat, inception_a2_3x3_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a2_3x3_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a2_3x3_reduce, inception_a2_3x3_reduce_bn_w, inception_a2_3x3_reduce_bn_b, inception_a2_3x3_reduce_scale_w, inception_a2_3x3_reduce_scale_b, 1.000000e-03f, batch_norm_inception_a2_3x3_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a2_3x3_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a2_3x3_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_a2_3x3_reduce_relu, inception_a2_3x3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a2_3x3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a2_3x3, inception_a2_3x3_bn_w, inception_a2_3x3_bn_b, inception_a2_3x3_scale_w, inception_a2_3x3_scale_b, 1.000000e-03f, batch_norm_inception_a2_3x3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a2_3x3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a2_3x3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_a1_concat, inception_a2_3x3_2_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a2_3x3_2_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a2_3x3_2_reduce, inception_a2_3x3_2_reduce_bn_w, inception_a2_3x3_2_reduce_bn_b, inception_a2_3x3_2_reduce_scale_w, inception_a2_3x3_2_reduce_scale_b, 1.000000e-03f, batch_norm_inception_a2_3x3_2_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a2_3x3_2_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a2_3x3_2_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_a2_3x3_2_reduce_relu, inception_a2_3x3_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a2_3x3_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a2_3x3_2, inception_a2_3x3_2_bn_w, inception_a2_3x3_2_bn_b, inception_a2_3x3_2_scale_w, inception_a2_3x3_2_scale_b, 1.000000e-03f, batch_norm_inception_a2_3x3_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a2_3x3_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a2_3x3_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_a2_3x3_2_relu, inception_a2_3x3_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a2_3x3_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a2_3x3_3, inception_a2_3x3_3_bn_w, inception_a2_3x3_3_bn_b, inception_a2_3x3_3_scale_w, inception_a2_3x3_3_scale_b, 1.000000e-03f, batch_norm_inception_a2_3x3_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a2_3x3_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a2_3x3_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_a1_concat, VX_NN_POOLING_AVG, 3, 3, 1, 1, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_inception_a2_pool_ave);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, avg_pool_inception_a2_pool_ave, inception_a2_1x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a2_1x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a2_1x1, inception_a2_1x1_bn_w, inception_a2_1x1_bn_b, inception_a2_1x1_scale_w, inception_a2_1x1_scale_b, 1.000000e-03f, batch_norm_inception_a2_1x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a2_1x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a2_1x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_a2_concat, relu_inception_a2_1x1_2_relu, relu_inception_a2_3x3_relu, relu_inception_a2_3x3_3_relu, relu_inception_a2_1x1_relu, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_a2_concat, inception_a3_1x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a3_1x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a3_1x1_2, inception_a3_1x1_2_bn_w, inception_a3_1x1_2_bn_b, inception_a3_1x1_2_scale_w, inception_a3_1x1_2_scale_b, 1.000000e-03f, batch_norm_inception_a3_1x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a3_1x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a3_1x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_a2_concat, inception_a3_3x3_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a3_3x3_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a3_3x3_reduce, inception_a3_3x3_reduce_bn_w, inception_a3_3x3_reduce_bn_b, inception_a3_3x3_reduce_scale_w, inception_a3_3x3_reduce_scale_b, 1.000000e-03f, batch_norm_inception_a3_3x3_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a3_3x3_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a3_3x3_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_a3_3x3_reduce_relu, inception_a3_3x3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a3_3x3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a3_3x3, inception_a3_3x3_bn_w, inception_a3_3x3_bn_b, inception_a3_3x3_scale_w, inception_a3_3x3_scale_b, 1.000000e-03f, batch_norm_inception_a3_3x3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a3_3x3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a3_3x3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_a2_concat, inception_a3_3x3_2_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a3_3x3_2_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a3_3x3_2_reduce, inception_a3_3x3_2_reduce_bn_w, inception_a3_3x3_2_reduce_bn_b, inception_a3_3x3_2_reduce_scale_w, inception_a3_3x3_2_reduce_scale_b, 1.000000e-03f, batch_norm_inception_a3_3x3_2_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a3_3x3_2_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a3_3x3_2_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_a3_3x3_2_reduce_relu, inception_a3_3x3_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a3_3x3_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a3_3x3_2, inception_a3_3x3_2_bn_w, inception_a3_3x3_2_bn_b, inception_a3_3x3_2_scale_w, inception_a3_3x3_2_scale_b, 1.000000e-03f, batch_norm_inception_a3_3x3_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a3_3x3_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a3_3x3_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_a3_3x3_2_relu, inception_a3_3x3_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a3_3x3_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a3_3x3_3, inception_a3_3x3_3_bn_w, inception_a3_3x3_3_bn_b, inception_a3_3x3_3_scale_w, inception_a3_3x3_3_scale_b, 1.000000e-03f, batch_norm_inception_a3_3x3_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a3_3x3_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a3_3x3_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_a2_concat, VX_NN_POOLING_AVG, 3, 3, 1, 1, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_inception_a3_pool_ave);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, avg_pool_inception_a3_pool_ave, inception_a3_1x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a3_1x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a3_1x1, inception_a3_1x1_bn_w, inception_a3_1x1_bn_b, inception_a3_1x1_scale_w, inception_a3_1x1_scale_b, 1.000000e-03f, batch_norm_inception_a3_1x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a3_1x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a3_1x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_a3_concat, relu_inception_a3_1x1_2_relu, relu_inception_a3_3x3_relu, relu_inception_a3_3x3_3_relu, relu_inception_a3_1x1_relu, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_a3_concat, inception_a4_1x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a4_1x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a4_1x1_2, inception_a4_1x1_2_bn_w, inception_a4_1x1_2_bn_b, inception_a4_1x1_2_scale_w, inception_a4_1x1_2_scale_b, 1.000000e-03f, batch_norm_inception_a4_1x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a4_1x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a4_1x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_a3_concat, inception_a4_3x3_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a4_3x3_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a4_3x3_reduce, inception_a4_3x3_reduce_bn_w, inception_a4_3x3_reduce_bn_b, inception_a4_3x3_reduce_scale_w, inception_a4_3x3_reduce_scale_b, 1.000000e-03f, batch_norm_inception_a4_3x3_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a4_3x3_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a4_3x3_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_a4_3x3_reduce_relu, inception_a4_3x3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a4_3x3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a4_3x3, inception_a4_3x3_bn_w, inception_a4_3x3_bn_b, inception_a4_3x3_scale_w, inception_a4_3x3_scale_b, 1.000000e-03f, batch_norm_inception_a4_3x3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a4_3x3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a4_3x3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_a3_concat, inception_a4_3x3_2_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a4_3x3_2_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a4_3x3_2_reduce, inception_a4_3x3_2_reduce_bn_w, inception_a4_3x3_2_reduce_bn_b, inception_a4_3x3_2_reduce_scale_w, inception_a4_3x3_2_reduce_scale_b, 1.000000e-03f, batch_norm_inception_a4_3x3_2_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a4_3x3_2_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a4_3x3_2_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_a4_3x3_2_reduce_relu, inception_a4_3x3_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a4_3x3_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a4_3x3_2, inception_a4_3x3_2_bn_w, inception_a4_3x3_2_bn_b, inception_a4_3x3_2_scale_w, inception_a4_3x3_2_scale_b, 1.000000e-03f, batch_norm_inception_a4_3x3_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a4_3x3_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a4_3x3_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_a4_3x3_2_relu, inception_a4_3x3_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a4_3x3_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a4_3x3_3, inception_a4_3x3_3_bn_w, inception_a4_3x3_3_bn_b, inception_a4_3x3_3_scale_w, inception_a4_3x3_3_scale_b, 1.000000e-03f, batch_norm_inception_a4_3x3_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a4_3x3_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a4_3x3_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_a3_concat, VX_NN_POOLING_AVG, 3, 3, 1, 1, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_inception_a4_pool_ave);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, avg_pool_inception_a4_pool_ave, inception_a4_1x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_a4_1x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_a4_1x1, inception_a4_1x1_bn_w, inception_a4_1x1_bn_b, inception_a4_1x1_scale_w, inception_a4_1x1_scale_b, 1.000000e-03f, batch_norm_inception_a4_1x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_a4_1x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_a4_1x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_a4_concat, relu_inception_a4_1x1_2_relu, relu_inception_a4_3x3_relu, relu_inception_a4_3x3_3_relu, relu_inception_a4_1x1_relu, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_a4_concat, reduction_a_3x3_w, NULL, &conv_params, sizeof(conv_params), conv_reduction_a_3x3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_reduction_a_3x3, reduction_a_3x3_bn_w, reduction_a_3x3_bn_b, reduction_a_3x3_scale_w, reduction_a_3x3_scale_b, 1.000000e-03f, batch_norm_reduction_a_3x3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_reduction_a_3x3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_reduction_a_3x3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_a4_concat, reduction_a_3x3_2_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_reduction_a_3x3_2_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_reduction_a_3x3_2_reduce, reduction_a_3x3_2_reduce_bn_w, reduction_a_3x3_2_reduce_bn_b, reduction_a_3x3_2_reduce_scale_w, reduction_a_3x3_2_reduce_scale_b, 1.000000e-03f, batch_norm_reduction_a_3x3_2_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_reduction_a_3x3_2_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_reduction_a_3x3_2_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_reduction_a_3x3_2_reduce_relu, reduction_a_3x3_2_w, NULL, &conv_params, sizeof(conv_params), conv_reduction_a_3x3_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_reduction_a_3x3_2, reduction_a_3x3_2_bn_w, reduction_a_3x3_2_bn_b, reduction_a_3x3_2_scale_w, reduction_a_3x3_2_scale_b, 1.000000e-03f, batch_norm_reduction_a_3x3_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_reduction_a_3x3_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_reduction_a_3x3_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_reduction_a_3x3_2_relu, reduction_a_3x3_3_w, NULL, &conv_params, sizeof(conv_params), conv_reduction_a_3x3_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_reduction_a_3x3_3, reduction_a_3x3_3_bn_w, reduction_a_3x3_3_bn_b, reduction_a_3x3_3_scale_w, reduction_a_3x3_3_scale_b, 1.000000e-03f, batch_norm_reduction_a_3x3_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_reduction_a_3x3_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_reduction_a_3x3_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_a4_concat, VX_NN_POOLING_MAX, 3, 3, 0, 0, VX_ROUND_POLICY_TO_NEAREST_EVEN, max_pool_reduction_a_pool);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_reduction_a_concat, relu_reduction_a_3x3_relu, relu_reduction_a_3x3_3_relu, max_pool_reduction_a_pool, NULL, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_reduction_a_concat, inception_b1_1x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b1_1x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b1_1x1_2, inception_b1_1x1_2_bn_w, inception_b1_1x1_2_bn_b, inception_b1_1x1_2_scale_w, inception_b1_1x1_2_scale_b, 1.000000e-03f, batch_norm_inception_b1_1x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b1_1x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b1_1x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_reduction_a_concat, inception_b1_1x7_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b1_1x7_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b1_1x7_reduce, inception_b1_1x7_reduce_bn_w, inception_b1_1x7_reduce_bn_b, inception_b1_1x7_reduce_scale_w, inception_b1_1x7_reduce_scale_b, 1.000000e-03f, batch_norm_inception_b1_1x7_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b1_1x7_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b1_1x7_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b1_1x7_reduce_relu, inception_b1_1x7_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b1_1x7);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b1_1x7, inception_b1_1x7_bn_w, inception_b1_1x7_bn_b, inception_b1_1x7_scale_w, inception_b1_1x7_scale_b, 1.000000e-03f, batch_norm_inception_b1_1x7_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b1_1x7_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b1_1x7_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b1_1x7_relu, inception_b1_7x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b1_7x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b1_7x1, inception_b1_7x1_bn_w, inception_b1_7x1_bn_b, inception_b1_7x1_scale_w, inception_b1_7x1_scale_b, 1.000000e-03f, batch_norm_inception_b1_7x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b1_7x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b1_7x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_reduction_a_concat, inception_b1_7x1_2_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b1_7x1_2_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b1_7x1_2_reduce, inception_b1_7x1_2_reduce_bn_w, inception_b1_7x1_2_reduce_bn_b, inception_b1_7x1_2_reduce_scale_w, inception_b1_7x1_2_reduce_scale_b, 1.000000e-03f, batch_norm_inception_b1_7x1_2_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b1_7x1_2_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b1_7x1_2_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b1_7x1_2_reduce_relu, inception_b1_7x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b1_7x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b1_7x1_2, inception_b1_7x1_2_bn_w, inception_b1_7x1_2_bn_b, inception_b1_7x1_2_scale_w, inception_b1_7x1_2_scale_b, 1.000000e-03f, batch_norm_inception_b1_7x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b1_7x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b1_7x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b1_7x1_2_relu, inception_b1_1x7_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b1_1x7_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b1_1x7_2, inception_b1_1x7_2_bn_w, inception_b1_1x7_2_bn_b, inception_b1_1x7_2_scale_w, inception_b1_1x7_2_scale_b, 1.000000e-03f, batch_norm_inception_b1_1x7_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b1_1x7_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b1_1x7_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b1_1x7_2_relu, inception_b1_7x1_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b1_7x1_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b1_7x1_3, inception_b1_7x1_3_bn_w, inception_b1_7x1_3_bn_b, inception_b1_7x1_3_scale_w, inception_b1_7x1_3_scale_b, 1.000000e-03f, batch_norm_inception_b1_7x1_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b1_7x1_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b1_7x1_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b1_7x1_3_relu, inception_b1_1x7_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b1_1x7_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b1_1x7_3, inception_b1_1x7_3_bn_w, inception_b1_1x7_3_bn_b, inception_b1_1x7_3_scale_w, inception_b1_1x7_3_scale_b, 1.000000e-03f, batch_norm_inception_b1_1x7_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b1_1x7_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b1_1x7_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_reduction_a_concat, VX_NN_POOLING_AVG, 3, 3, 1, 1, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_inception_b1_pool_ave);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, avg_pool_inception_b1_pool_ave, inception_b1_1x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b1_1x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b1_1x1, inception_b1_1x1_bn_w, inception_b1_1x1_bn_b, inception_b1_1x1_scale_w, inception_b1_1x1_scale_b, 1.000000e-03f, batch_norm_inception_b1_1x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b1_1x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b1_1x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_b1_concat, relu_inception_b1_1x1_2_relu, relu_inception_b1_7x1_relu, relu_inception_b1_1x7_3_relu, relu_inception_b1_1x1_relu, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b1_concat, inception_b2_1x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b2_1x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b2_1x1_2, inception_b2_1x1_2_bn_w, inception_b2_1x1_2_bn_b, inception_b2_1x1_2_scale_w, inception_b2_1x1_2_scale_b, 1.000000e-03f, batch_norm_inception_b2_1x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b2_1x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b2_1x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b1_concat, inception_b2_1x7_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b2_1x7_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b2_1x7_reduce, inception_b2_1x7_reduce_bn_w, inception_b2_1x7_reduce_bn_b, inception_b2_1x7_reduce_scale_w, inception_b2_1x7_reduce_scale_b, 1.000000e-03f, batch_norm_inception_b2_1x7_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b2_1x7_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b2_1x7_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b2_1x7_reduce_relu, inception_b2_1x7_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b2_1x7);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b2_1x7, inception_b2_1x7_bn_w, inception_b2_1x7_bn_b, inception_b2_1x7_scale_w, inception_b2_1x7_scale_b, 1.000000e-03f, batch_norm_inception_b2_1x7_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b2_1x7_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b2_1x7_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b2_1x7_relu, inception_b2_7x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b2_7x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b2_7x1, inception_b2_7x1_bn_w, inception_b2_7x1_bn_b, inception_b2_7x1_scale_w, inception_b2_7x1_scale_b, 1.000000e-03f, batch_norm_inception_b2_7x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b2_7x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b2_7x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b1_concat, inception_b2_7x1_2_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b2_7x1_2_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b2_7x1_2_reduce, inception_b2_7x1_2_reduce_bn_w, inception_b2_7x1_2_reduce_bn_b, inception_b2_7x1_2_reduce_scale_w, inception_b2_7x1_2_reduce_scale_b, 1.000000e-03f, batch_norm_inception_b2_7x1_2_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b2_7x1_2_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b2_7x1_2_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b2_7x1_2_reduce_relu, inception_b2_7x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b2_7x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b2_7x1_2, inception_b2_7x1_2_bn_w, inception_b2_7x1_2_bn_b, inception_b2_7x1_2_scale_w, inception_b2_7x1_2_scale_b, 1.000000e-03f, batch_norm_inception_b2_7x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b2_7x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b2_7x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b2_7x1_2_relu, inception_b2_1x7_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b2_1x7_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b2_1x7_2, inception_b2_1x7_2_bn_w, inception_b2_1x7_2_bn_b, inception_b2_1x7_2_scale_w, inception_b2_1x7_2_scale_b, 1.000000e-03f, batch_norm_inception_b2_1x7_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b2_1x7_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b2_1x7_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b2_1x7_2_relu, inception_b2_7x1_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b2_7x1_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b2_7x1_3, inception_b2_7x1_3_bn_w, inception_b2_7x1_3_bn_b, inception_b2_7x1_3_scale_w, inception_b2_7x1_3_scale_b, 1.000000e-03f, batch_norm_inception_b2_7x1_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b2_7x1_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b2_7x1_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b2_7x1_3_relu, inception_b2_1x7_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b2_1x7_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b2_1x7_3, inception_b2_1x7_3_bn_w, inception_b2_1x7_3_bn_b, inception_b2_1x7_3_scale_w, inception_b2_1x7_3_scale_b, 1.000000e-03f, batch_norm_inception_b2_1x7_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b2_1x7_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b2_1x7_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_b1_concat, VX_NN_POOLING_AVG, 3, 3, 1, 1, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_inception_b2_pool_ave);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, avg_pool_inception_b2_pool_ave, inception_b2_1x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b2_1x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b2_1x1, inception_b2_1x1_bn_w, inception_b2_1x1_bn_b, inception_b2_1x1_scale_w, inception_b2_1x1_scale_b, 1.000000e-03f, batch_norm_inception_b2_1x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b2_1x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b2_1x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_b2_concat, relu_inception_b2_1x1_2_relu, relu_inception_b2_7x1_relu, relu_inception_b2_1x7_3_relu, relu_inception_b2_1x1_relu, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b2_concat, inception_b3_1x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b3_1x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b3_1x1_2, inception_b3_1x1_2_bn_w, inception_b3_1x1_2_bn_b, inception_b3_1x1_2_scale_w, inception_b3_1x1_2_scale_b, 1.000000e-03f, batch_norm_inception_b3_1x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b3_1x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b3_1x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b2_concat, inception_b3_1x7_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b3_1x7_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b3_1x7_reduce, inception_b3_1x7_reduce_bn_w, inception_b3_1x7_reduce_bn_b, inception_b3_1x7_reduce_scale_w, inception_b3_1x7_reduce_scale_b, 1.000000e-03f, batch_norm_inception_b3_1x7_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b3_1x7_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b3_1x7_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b3_1x7_reduce_relu, inception_b3_1x7_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b3_1x7);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b3_1x7, inception_b3_1x7_bn_w, inception_b3_1x7_bn_b, inception_b3_1x7_scale_w, inception_b3_1x7_scale_b, 1.000000e-03f, batch_norm_inception_b3_1x7_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b3_1x7_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b3_1x7_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b3_1x7_relu, inception_b3_7x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b3_7x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b3_7x1, inception_b3_7x1_bn_w, inception_b3_7x1_bn_b, inception_b3_7x1_scale_w, inception_b3_7x1_scale_b, 1.000000e-03f, batch_norm_inception_b3_7x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b3_7x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b3_7x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b2_concat, inception_b3_7x1_2_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b3_7x1_2_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b3_7x1_2_reduce, inception_b3_7x1_2_reduce_bn_w, inception_b3_7x1_2_reduce_bn_b, inception_b3_7x1_2_reduce_scale_w, inception_b3_7x1_2_reduce_scale_b, 1.000000e-03f, batch_norm_inception_b3_7x1_2_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b3_7x1_2_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b3_7x1_2_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b3_7x1_2_reduce_relu, inception_b3_7x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b3_7x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b3_7x1_2, inception_b3_7x1_2_bn_w, inception_b3_7x1_2_bn_b, inception_b3_7x1_2_scale_w, inception_b3_7x1_2_scale_b, 1.000000e-03f, batch_norm_inception_b3_7x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b3_7x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b3_7x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b3_7x1_2_relu, inception_b3_1x7_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b3_1x7_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b3_1x7_2, inception_b3_1x7_2_bn_w, inception_b3_1x7_2_bn_b, inception_b3_1x7_2_scale_w, inception_b3_1x7_2_scale_b, 1.000000e-03f, batch_norm_inception_b3_1x7_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b3_1x7_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b3_1x7_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b3_1x7_2_relu, inception_b3_7x1_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b3_7x1_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b3_7x1_3, inception_b3_7x1_3_bn_w, inception_b3_7x1_3_bn_b, inception_b3_7x1_3_scale_w, inception_b3_7x1_3_scale_b, 1.000000e-03f, batch_norm_inception_b3_7x1_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b3_7x1_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b3_7x1_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b3_7x1_3_relu, inception_b3_1x7_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b3_1x7_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b3_1x7_3, inception_b3_1x7_3_bn_w, inception_b3_1x7_3_bn_b, inception_b3_1x7_3_scale_w, inception_b3_1x7_3_scale_b, 1.000000e-03f, batch_norm_inception_b3_1x7_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b3_1x7_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b3_1x7_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_b2_concat, VX_NN_POOLING_AVG, 3, 3, 1, 1, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_inception_b3_pool_ave);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, avg_pool_inception_b3_pool_ave, inception_b3_1x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b3_1x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b3_1x1, inception_b3_1x1_bn_w, inception_b3_1x1_bn_b, inception_b3_1x1_scale_w, inception_b3_1x1_scale_b, 1.000000e-03f, batch_norm_inception_b3_1x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b3_1x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b3_1x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_b3_concat, relu_inception_b3_1x1_2_relu, relu_inception_b3_7x1_relu, relu_inception_b3_1x7_3_relu, relu_inception_b3_1x1_relu, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b3_concat, inception_b4_1x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b4_1x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b4_1x1_2, inception_b4_1x1_2_bn_w, inception_b4_1x1_2_bn_b, inception_b4_1x1_2_scale_w, inception_b4_1x1_2_scale_b, 1.000000e-03f, batch_norm_inception_b4_1x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b4_1x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b4_1x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b3_concat, inception_b4_1x7_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b4_1x7_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b4_1x7_reduce, inception_b4_1x7_reduce_bn_w, inception_b4_1x7_reduce_bn_b, inception_b4_1x7_reduce_scale_w, inception_b4_1x7_reduce_scale_b, 1.000000e-03f, batch_norm_inception_b4_1x7_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b4_1x7_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b4_1x7_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b4_1x7_reduce_relu, inception_b4_1x7_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b4_1x7);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b4_1x7, inception_b4_1x7_bn_w, inception_b4_1x7_bn_b, inception_b4_1x7_scale_w, inception_b4_1x7_scale_b, 1.000000e-03f, batch_norm_inception_b4_1x7_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b4_1x7_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b4_1x7_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b4_1x7_relu, inception_b4_7x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b4_7x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b4_7x1, inception_b4_7x1_bn_w, inception_b4_7x1_bn_b, inception_b4_7x1_scale_w, inception_b4_7x1_scale_b, 1.000000e-03f, batch_norm_inception_b4_7x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b4_7x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b4_7x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b3_concat, inception_b4_7x1_2_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b4_7x1_2_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b4_7x1_2_reduce, inception_b4_7x1_2_reduce_bn_w, inception_b4_7x1_2_reduce_bn_b, inception_b4_7x1_2_reduce_scale_w, inception_b4_7x1_2_reduce_scale_b, 1.000000e-03f, batch_norm_inception_b4_7x1_2_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b4_7x1_2_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b4_7x1_2_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b4_7x1_2_reduce_relu, inception_b4_7x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b4_7x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b4_7x1_2, inception_b4_7x1_2_bn_w, inception_b4_7x1_2_bn_b, inception_b4_7x1_2_scale_w, inception_b4_7x1_2_scale_b, 1.000000e-03f, batch_norm_inception_b4_7x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b4_7x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b4_7x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b4_7x1_2_relu, inception_b4_1x7_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b4_1x7_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b4_1x7_2, inception_b4_1x7_2_bn_w, inception_b4_1x7_2_bn_b, inception_b4_1x7_2_scale_w, inception_b4_1x7_2_scale_b, 1.000000e-03f, batch_norm_inception_b4_1x7_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b4_1x7_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b4_1x7_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b4_1x7_2_relu, inception_b4_7x1_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b4_7x1_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b4_7x1_3, inception_b4_7x1_3_bn_w, inception_b4_7x1_3_bn_b, inception_b4_7x1_3_scale_w, inception_b4_7x1_3_scale_b, 1.000000e-03f, batch_norm_inception_b4_7x1_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b4_7x1_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b4_7x1_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b4_7x1_3_relu, inception_b4_1x7_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b4_1x7_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b4_1x7_3, inception_b4_1x7_3_bn_w, inception_b4_1x7_3_bn_b, inception_b4_1x7_3_scale_w, inception_b4_1x7_3_scale_b, 1.000000e-03f, batch_norm_inception_b4_1x7_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b4_1x7_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b4_1x7_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_b3_concat, VX_NN_POOLING_AVG, 3, 3, 1, 1, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_inception_b4_pool_ave);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, avg_pool_inception_b4_pool_ave, inception_b4_1x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b4_1x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b4_1x1, inception_b4_1x1_bn_w, inception_b4_1x1_bn_b, inception_b4_1x1_scale_w, inception_b4_1x1_scale_b, 1.000000e-03f, batch_norm_inception_b4_1x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b4_1x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b4_1x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_b4_concat, relu_inception_b4_1x1_2_relu, relu_inception_b4_7x1_relu, relu_inception_b4_1x7_3_relu, relu_inception_b4_1x1_relu, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b4_concat, inception_b5_1x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b5_1x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b5_1x1_2, inception_b5_1x1_2_bn_w, inception_b5_1x1_2_bn_b, inception_b5_1x1_2_scale_w, inception_b5_1x1_2_scale_b, 1.000000e-03f, batch_norm_inception_b5_1x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b5_1x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b5_1x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b4_concat, inception_b5_1x7_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b5_1x7_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b5_1x7_reduce, inception_b5_1x7_reduce_bn_w, inception_b5_1x7_reduce_bn_b, inception_b5_1x7_reduce_scale_w, inception_b5_1x7_reduce_scale_b, 1.000000e-03f, batch_norm_inception_b5_1x7_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b5_1x7_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b5_1x7_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b5_1x7_reduce_relu, inception_b5_1x7_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b5_1x7);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b5_1x7, inception_b5_1x7_bn_w, inception_b5_1x7_bn_b, inception_b5_1x7_scale_w, inception_b5_1x7_scale_b, 1.000000e-03f, batch_norm_inception_b5_1x7_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b5_1x7_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b5_1x7_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b5_1x7_relu, inception_b5_7x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b5_7x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b5_7x1, inception_b5_7x1_bn_w, inception_b5_7x1_bn_b, inception_b5_7x1_scale_w, inception_b5_7x1_scale_b, 1.000000e-03f, batch_norm_inception_b5_7x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b5_7x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b5_7x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b4_concat, inception_b5_7x1_2_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b5_7x1_2_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b5_7x1_2_reduce, inception_b5_7x1_2_reduce_bn_w, inception_b5_7x1_2_reduce_bn_b, inception_b5_7x1_2_reduce_scale_w, inception_b5_7x1_2_reduce_scale_b, 1.000000e-03f, batch_norm_inception_b5_7x1_2_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b5_7x1_2_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b5_7x1_2_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b5_7x1_2_reduce_relu, inception_b5_7x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b5_7x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b5_7x1_2, inception_b5_7x1_2_bn_w, inception_b5_7x1_2_bn_b, inception_b5_7x1_2_scale_w, inception_b5_7x1_2_scale_b, 1.000000e-03f, batch_norm_inception_b5_7x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b5_7x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b5_7x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b5_7x1_2_relu, inception_b5_1x7_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b5_1x7_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b5_1x7_2, inception_b5_1x7_2_bn_w, inception_b5_1x7_2_bn_b, inception_b5_1x7_2_scale_w, inception_b5_1x7_2_scale_b, 1.000000e-03f, batch_norm_inception_b5_1x7_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b5_1x7_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b5_1x7_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b5_1x7_2_relu, inception_b5_7x1_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b5_7x1_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b5_7x1_3, inception_b5_7x1_3_bn_w, inception_b5_7x1_3_bn_b, inception_b5_7x1_3_scale_w, inception_b5_7x1_3_scale_b, 1.000000e-03f, batch_norm_inception_b5_7x1_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b5_7x1_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b5_7x1_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b5_7x1_3_relu, inception_b5_1x7_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b5_1x7_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b5_1x7_3, inception_b5_1x7_3_bn_w, inception_b5_1x7_3_bn_b, inception_b5_1x7_3_scale_w, inception_b5_1x7_3_scale_b, 1.000000e-03f, batch_norm_inception_b5_1x7_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b5_1x7_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b5_1x7_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_b4_concat, VX_NN_POOLING_AVG, 3, 3, 1, 1, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_inception_b5_pool_ave);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, avg_pool_inception_b5_pool_ave, inception_b5_1x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b5_1x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b5_1x1, inception_b5_1x1_bn_w, inception_b5_1x1_bn_b, inception_b5_1x1_scale_w, inception_b5_1x1_scale_b, 1.000000e-03f, batch_norm_inception_b5_1x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b5_1x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b5_1x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_b5_concat, relu_inception_b5_1x1_2_relu, relu_inception_b5_7x1_relu, relu_inception_b5_1x7_3_relu, relu_inception_b5_1x1_relu, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b5_concat, inception_b6_1x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b6_1x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b6_1x1_2, inception_b6_1x1_2_bn_w, inception_b6_1x1_2_bn_b, inception_b6_1x1_2_scale_w, inception_b6_1x1_2_scale_b, 1.000000e-03f, batch_norm_inception_b6_1x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b6_1x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b6_1x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b5_concat, inception_b6_1x7_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b6_1x7_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b6_1x7_reduce, inception_b6_1x7_reduce_bn_w, inception_b6_1x7_reduce_bn_b, inception_b6_1x7_reduce_scale_w, inception_b6_1x7_reduce_scale_b, 1.000000e-03f, batch_norm_inception_b6_1x7_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b6_1x7_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b6_1x7_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b6_1x7_reduce_relu, inception_b6_1x7_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b6_1x7);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b6_1x7, inception_b6_1x7_bn_w, inception_b6_1x7_bn_b, inception_b6_1x7_scale_w, inception_b6_1x7_scale_b, 1.000000e-03f, batch_norm_inception_b6_1x7_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b6_1x7_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b6_1x7_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b6_1x7_relu, inception_b6_7x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b6_7x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b6_7x1, inception_b6_7x1_bn_w, inception_b6_7x1_bn_b, inception_b6_7x1_scale_w, inception_b6_7x1_scale_b, 1.000000e-03f, batch_norm_inception_b6_7x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b6_7x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b6_7x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b5_concat, inception_b6_7x1_2_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b6_7x1_2_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b6_7x1_2_reduce, inception_b6_7x1_2_reduce_bn_w, inception_b6_7x1_2_reduce_bn_b, inception_b6_7x1_2_reduce_scale_w, inception_b6_7x1_2_reduce_scale_b, 1.000000e-03f, batch_norm_inception_b6_7x1_2_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b6_7x1_2_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b6_7x1_2_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b6_7x1_2_reduce_relu, inception_b6_7x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b6_7x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b6_7x1_2, inception_b6_7x1_2_bn_w, inception_b6_7x1_2_bn_b, inception_b6_7x1_2_scale_w, inception_b6_7x1_2_scale_b, 1.000000e-03f, batch_norm_inception_b6_7x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b6_7x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b6_7x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b6_7x1_2_relu, inception_b6_1x7_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b6_1x7_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b6_1x7_2, inception_b6_1x7_2_bn_w, inception_b6_1x7_2_bn_b, inception_b6_1x7_2_scale_w, inception_b6_1x7_2_scale_b, 1.000000e-03f, batch_norm_inception_b6_1x7_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b6_1x7_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b6_1x7_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b6_1x7_2_relu, inception_b6_7x1_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b6_7x1_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b6_7x1_3, inception_b6_7x1_3_bn_w, inception_b6_7x1_3_bn_b, inception_b6_7x1_3_scale_w, inception_b6_7x1_3_scale_b, 1.000000e-03f, batch_norm_inception_b6_7x1_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b6_7x1_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b6_7x1_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b6_7x1_3_relu, inception_b6_1x7_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b6_1x7_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b6_1x7_3, inception_b6_1x7_3_bn_w, inception_b6_1x7_3_bn_b, inception_b6_1x7_3_scale_w, inception_b6_1x7_3_scale_b, 1.000000e-03f, batch_norm_inception_b6_1x7_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b6_1x7_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b6_1x7_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_b5_concat, VX_NN_POOLING_AVG, 3, 3, 1, 1, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_inception_b6_pool_ave);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, avg_pool_inception_b6_pool_ave, inception_b6_1x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b6_1x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b6_1x1, inception_b6_1x1_bn_w, inception_b6_1x1_bn_b, inception_b6_1x1_scale_w, inception_b6_1x1_scale_b, 1.000000e-03f, batch_norm_inception_b6_1x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b6_1x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b6_1x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_b6_concat, relu_inception_b6_1x1_2_relu, relu_inception_b6_7x1_relu, relu_inception_b6_1x7_3_relu, relu_inception_b6_1x1_relu, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b6_concat, inception_b7_1x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b7_1x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b7_1x1_2, inception_b7_1x1_2_bn_w, inception_b7_1x1_2_bn_b, inception_b7_1x1_2_scale_w, inception_b7_1x1_2_scale_b, 1.000000e-03f, batch_norm_inception_b7_1x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b7_1x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b7_1x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b6_concat, inception_b7_1x7_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b7_1x7_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b7_1x7_reduce, inception_b7_1x7_reduce_bn_w, inception_b7_1x7_reduce_bn_b, inception_b7_1x7_reduce_scale_w, inception_b7_1x7_reduce_scale_b, 1.000000e-03f, batch_norm_inception_b7_1x7_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b7_1x7_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b7_1x7_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b7_1x7_reduce_relu, inception_b7_1x7_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b7_1x7);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b7_1x7, inception_b7_1x7_bn_w, inception_b7_1x7_bn_b, inception_b7_1x7_scale_w, inception_b7_1x7_scale_b, 1.000000e-03f, batch_norm_inception_b7_1x7_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b7_1x7_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b7_1x7_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b7_1x7_relu, inception_b7_7x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b7_7x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b7_7x1, inception_b7_7x1_bn_w, inception_b7_7x1_bn_b, inception_b7_7x1_scale_w, inception_b7_7x1_scale_b, 1.000000e-03f, batch_norm_inception_b7_7x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b7_7x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b7_7x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b6_concat, inception_b7_7x1_2_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b7_7x1_2_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b7_7x1_2_reduce, inception_b7_7x1_2_reduce_bn_w, inception_b7_7x1_2_reduce_bn_b, inception_b7_7x1_2_reduce_scale_w, inception_b7_7x1_2_reduce_scale_b, 1.000000e-03f, batch_norm_inception_b7_7x1_2_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b7_7x1_2_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b7_7x1_2_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b7_7x1_2_reduce_relu, inception_b7_7x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b7_7x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b7_7x1_2, inception_b7_7x1_2_bn_w, inception_b7_7x1_2_bn_b, inception_b7_7x1_2_scale_w, inception_b7_7x1_2_scale_b, 1.000000e-03f, batch_norm_inception_b7_7x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b7_7x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b7_7x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b7_7x1_2_relu, inception_b7_1x7_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b7_1x7_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b7_1x7_2, inception_b7_1x7_2_bn_w, inception_b7_1x7_2_bn_b, inception_b7_1x7_2_scale_w, inception_b7_1x7_2_scale_b, 1.000000e-03f, batch_norm_inception_b7_1x7_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b7_1x7_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b7_1x7_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b7_1x7_2_relu, inception_b7_7x1_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b7_7x1_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b7_7x1_3, inception_b7_7x1_3_bn_w, inception_b7_7x1_3_bn_b, inception_b7_7x1_3_scale_w, inception_b7_7x1_3_scale_b, 1.000000e-03f, batch_norm_inception_b7_7x1_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b7_7x1_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b7_7x1_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_b7_7x1_3_relu, inception_b7_1x7_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b7_1x7_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b7_1x7_3, inception_b7_1x7_3_bn_w, inception_b7_1x7_3_bn_b, inception_b7_1x7_3_scale_w, inception_b7_1x7_3_scale_b, 1.000000e-03f, batch_norm_inception_b7_1x7_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b7_1x7_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b7_1x7_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_b6_concat, VX_NN_POOLING_AVG, 3, 3, 1, 1, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_inception_b7_pool_ave);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, avg_pool_inception_b7_pool_ave, inception_b7_1x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_b7_1x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_b7_1x1, inception_b7_1x1_bn_w, inception_b7_1x1_bn_b, inception_b7_1x1_scale_w, inception_b7_1x1_scale_b, 1.000000e-03f, batch_norm_inception_b7_1x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_b7_1x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_b7_1x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_b7_concat, relu_inception_b7_1x1_2_relu, relu_inception_b7_7x1_relu, relu_inception_b7_1x7_3_relu, relu_inception_b7_1x1_relu, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b7_concat, reduction_b_3x3_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_reduction_b_3x3_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_reduction_b_3x3_reduce, reduction_b_3x3_reduce_bn_w, reduction_b_3x3_reduce_bn_b, reduction_b_3x3_reduce_scale_w, reduction_b_3x3_reduce_scale_b, 1.000000e-03f, batch_norm_reduction_b_3x3_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_reduction_b_3x3_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_reduction_b_3x3_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_reduction_b_3x3_reduce_relu, reduction_b_3x3_w, NULL, &conv_params, sizeof(conv_params), conv_reduction_b_3x3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_reduction_b_3x3, reduction_b_3x3_bn_w, reduction_b_3x3_bn_b, reduction_b_3x3_scale_w, reduction_b_3x3_scale_b, 1.000000e-03f, batch_norm_reduction_b_3x3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_reduction_b_3x3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_reduction_b_3x3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_b7_concat, reduction_b_1x7_reduce_w, NULL, &conv_params, sizeof(conv_params), conv_reduction_b_1x7_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_reduction_b_1x7_reduce, reduction_b_1x7_reduce_bn_w, reduction_b_1x7_reduce_bn_b, reduction_b_1x7_reduce_scale_w, reduction_b_1x7_reduce_scale_b, 1.000000e-03f, batch_norm_reduction_b_1x7_reduce_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_reduction_b_1x7_reduce_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_reduction_b_1x7_reduce_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_reduction_b_1x7_reduce_relu, reduction_b_1x7_w, NULL, &conv_params, sizeof(conv_params), conv_reduction_b_1x7);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_reduction_b_1x7, reduction_b_1x7_bn_w, reduction_b_1x7_bn_b, reduction_b_1x7_scale_w, reduction_b_1x7_scale_b, 1.000000e-03f, batch_norm_reduction_b_1x7_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_reduction_b_1x7_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_reduction_b_1x7_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_reduction_b_1x7_relu, reduction_b_7x1_w, NULL, &conv_params, sizeof(conv_params), conv_reduction_b_7x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_reduction_b_7x1, reduction_b_7x1_bn_w, reduction_b_7x1_bn_b, reduction_b_7x1_scale_w, reduction_b_7x1_scale_b, 1.000000e-03f, batch_norm_reduction_b_7x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_reduction_b_7x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_reduction_b_7x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_reduction_b_7x1_relu, reduction_b_3x3_2_w, NULL, &conv_params, sizeof(conv_params), conv_reduction_b_3x3_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_reduction_b_3x3_2, reduction_b_3x3_2_bn_w, reduction_b_3x3_2_bn_b, reduction_b_3x3_2_scale_w, reduction_b_3x3_2_scale_b, 1.000000e-03f, batch_norm_reduction_b_3x3_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_reduction_b_3x3_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_reduction_b_3x3_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_b7_concat, VX_NN_POOLING_MAX, 3, 3, 0, 0, VX_ROUND_POLICY_TO_NEAREST_EVEN, max_pool_reduction_b_pool);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_reduction_b_concat, relu_reduction_b_3x3_relu, relu_reduction_b_3x3_2_relu, max_pool_reduction_b_pool, NULL, NULL, NULL, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_reduction_b_concat, inception_c1_1x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c1_1x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c1_1x1_2, inception_c1_1x1_2_bn_w, inception_c1_1x1_2_bn_b, inception_c1_1x1_2_scale_w, inception_c1_1x1_2_scale_b, 1.000000e-03f, batch_norm_inception_c1_1x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c1_1x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c1_1x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_reduction_b_concat, inception_c1_1x1_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c1_1x1_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c1_1x1_3, inception_c1_1x1_3_bn_w, inception_c1_1x1_3_bn_b, inception_c1_1x1_3_scale_w, inception_c1_1x1_3_scale_b, 1.000000e-03f, batch_norm_inception_c1_1x1_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c1_1x1_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c1_1x1_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c1_1x1_3_relu, inception_c1_1x3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c1_1x3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c1_1x3, inception_c1_1x3_bn_w, inception_c1_1x3_bn_b, inception_c1_1x3_scale_w, inception_c1_1x3_scale_b, 1.000000e-03f, batch_norm_inception_c1_1x3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c1_1x3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c1_1x3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c1_1x1_3_relu, inception_c1_3x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c1_3x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c1_3x1, inception_c1_3x1_bn_w, inception_c1_3x1_bn_b, inception_c1_3x1_scale_w, inception_c1_3x1_scale_b, 1.000000e-03f, batch_norm_inception_c1_3x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c1_3x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c1_3x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_reduction_b_concat, inception_c1_1x1_4_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c1_1x1_4);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c1_1x1_4, inception_c1_1x1_4_bn_w, inception_c1_1x1_4_bn_b, inception_c1_1x1_4_scale_w, inception_c1_1x1_4_scale_b, 1.000000e-03f, batch_norm_inception_c1_1x1_4_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c1_1x1_4_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c1_1x1_4_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c1_1x1_4_relu, inception_c1_3x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c1_3x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c1_3x1_2, inception_c1_3x1_2_bn_w, inception_c1_3x1_2_bn_b, inception_c1_3x1_2_scale_w, inception_c1_3x1_2_scale_b, 1.000000e-03f, batch_norm_inception_c1_3x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c1_3x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c1_3x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c1_3x1_2_relu, inception_c1_1x3_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c1_1x3_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c1_1x3_2, inception_c1_1x3_2_bn_w, inception_c1_1x3_2_bn_b, inception_c1_1x3_2_scale_w, inception_c1_1x3_2_scale_b, 1.000000e-03f, batch_norm_inception_c1_1x3_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c1_1x3_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c1_1x3_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c1_1x3_2_relu, inception_c1_1x3_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c1_1x3_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c1_1x3_3, inception_c1_1x3_3_bn_w, inception_c1_1x3_3_bn_b, inception_c1_1x3_3_scale_w, inception_c1_1x3_3_scale_b, 1.000000e-03f, batch_norm_inception_c1_1x3_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c1_1x3_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c1_1x3_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c1_1x3_2_relu, inception_c1_3x1_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c1_3x1_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c1_3x1_3, inception_c1_3x1_3_bn_w, inception_c1_3x1_3_bn_b, inception_c1_3x1_3_scale_w, inception_c1_3x1_3_scale_b, 1.000000e-03f, batch_norm_inception_c1_3x1_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c1_3x1_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c1_3x1_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_reduction_b_concat, VX_NN_POOLING_AVG, 3, 3, 1, 1, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_inception_c1_pool_ave);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, avg_pool_inception_c1_pool_ave, inception_c1_1x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c1_1x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c1_1x1, inception_c1_1x1_bn_w, inception_c1_1x1_bn_b, inception_c1_1x1_scale_w, inception_c1_1x1_scale_b, 1.000000e-03f, batch_norm_inception_c1_1x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c1_1x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c1_1x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_c1_concat, relu_inception_c1_1x1_2_relu, relu_inception_c1_1x3_relu, relu_inception_c1_3x1_relu, relu_inception_c1_1x3_3_relu, relu_inception_c1_3x1_3_relu, relu_inception_c1_1x1_relu, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_c1_concat, inception_c2_1x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c2_1x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c2_1x1_2, inception_c2_1x1_2_bn_w, inception_c2_1x1_2_bn_b, inception_c2_1x1_2_scale_w, inception_c2_1x1_2_scale_b, 1.000000e-03f, batch_norm_inception_c2_1x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c2_1x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c2_1x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_c1_concat, inception_c2_1x1_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c2_1x1_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c2_1x1_3, inception_c2_1x1_3_bn_w, inception_c2_1x1_3_bn_b, inception_c2_1x1_3_scale_w, inception_c2_1x1_3_scale_b, 1.000000e-03f, batch_norm_inception_c2_1x1_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c2_1x1_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c2_1x1_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c2_1x1_3_relu, inception_c2_1x3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c2_1x3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c2_1x3, inception_c2_1x3_bn_w, inception_c2_1x3_bn_b, inception_c2_1x3_scale_w, inception_c2_1x3_scale_b, 1.000000e-03f, batch_norm_inception_c2_1x3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c2_1x3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c2_1x3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c2_1x1_3_relu, inception_c2_3x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c2_3x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c2_3x1, inception_c2_3x1_bn_w, inception_c2_3x1_bn_b, inception_c2_3x1_scale_w, inception_c2_3x1_scale_b, 1.000000e-03f, batch_norm_inception_c2_3x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c2_3x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c2_3x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_c1_concat, inception_c2_1x1_4_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c2_1x1_4);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c2_1x1_4, inception_c2_1x1_4_bn_w, inception_c2_1x1_4_bn_b, inception_c2_1x1_4_scale_w, inception_c2_1x1_4_scale_b, 1.000000e-03f, batch_norm_inception_c2_1x1_4_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c2_1x1_4_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c2_1x1_4_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c2_1x1_4_relu, inception_c2_3x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c2_3x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c2_3x1_2, inception_c2_3x1_2_bn_w, inception_c2_3x1_2_bn_b, inception_c2_3x1_2_scale_w, inception_c2_3x1_2_scale_b, 1.000000e-03f, batch_norm_inception_c2_3x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c2_3x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c2_3x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c2_3x1_2_relu, inception_c2_1x3_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c2_1x3_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c2_1x3_2, inception_c2_1x3_2_bn_w, inception_c2_1x3_2_bn_b, inception_c2_1x3_2_scale_w, inception_c2_1x3_2_scale_b, 1.000000e-03f, batch_norm_inception_c2_1x3_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c2_1x3_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c2_1x3_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c2_1x3_2_relu, inception_c2_1x3_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c2_1x3_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c2_1x3_3, inception_c2_1x3_3_bn_w, inception_c2_1x3_3_bn_b, inception_c2_1x3_3_scale_w, inception_c2_1x3_3_scale_b, 1.000000e-03f, batch_norm_inception_c2_1x3_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c2_1x3_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c2_1x3_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c2_1x3_2_relu, inception_c2_3x1_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c2_3x1_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c2_3x1_3, inception_c2_3x1_3_bn_w, inception_c2_3x1_3_bn_b, inception_c2_3x1_3_scale_w, inception_c2_3x1_3_scale_b, 1.000000e-03f, batch_norm_inception_c2_3x1_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c2_3x1_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c2_3x1_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_c1_concat, VX_NN_POOLING_AVG, 3, 3, 1, 1, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_inception_c2_pool_ave);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, avg_pool_inception_c2_pool_ave, inception_c2_1x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c2_1x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c2_1x1, inception_c2_1x1_bn_w, inception_c2_1x1_bn_b, inception_c2_1x1_scale_w, inception_c2_1x1_scale_b, 1.000000e-03f, batch_norm_inception_c2_1x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c2_1x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c2_1x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_c2_concat, relu_inception_c2_1x1_2_relu, relu_inception_c2_1x3_relu, relu_inception_c2_3x1_relu, relu_inception_c2_1x3_3_relu, relu_inception_c2_3x1_3_relu, relu_inception_c2_1x1_relu, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_c2_concat, inception_c3_1x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c3_1x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c3_1x1_2, inception_c3_1x1_2_bn_w, inception_c3_1x1_2_bn_b, inception_c3_1x1_2_scale_w, inception_c3_1x1_2_scale_b, 1.000000e-03f, batch_norm_inception_c3_1x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c3_1x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c3_1x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_c2_concat, inception_c3_1x1_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c3_1x1_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c3_1x1_3, inception_c3_1x1_3_bn_w, inception_c3_1x1_3_bn_b, inception_c3_1x1_3_scale_w, inception_c3_1x1_3_scale_b, 1.000000e-03f, batch_norm_inception_c3_1x1_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c3_1x1_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c3_1x1_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c3_1x1_3_relu, inception_c3_1x3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c3_1x3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c3_1x3, inception_c3_1x3_bn_w, inception_c3_1x3_bn_b, inception_c3_1x3_scale_w, inception_c3_1x3_scale_b, 1.000000e-03f, batch_norm_inception_c3_1x3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c3_1x3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c3_1x3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c3_1x1_3_relu, inception_c3_3x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c3_3x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c3_3x1, inception_c3_3x1_bn_w, inception_c3_3x1_bn_b, inception_c3_3x1_scale_w, inception_c3_3x1_scale_b, 1.000000e-03f, batch_norm_inception_c3_3x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c3_3x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c3_3x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, concat_inception_c2_concat, inception_c3_1x1_4_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c3_1x1_4);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c3_1x1_4, inception_c3_1x1_4_bn_w, inception_c3_1x1_4_bn_b, inception_c3_1x1_4_scale_w, inception_c3_1x1_4_scale_b, 1.000000e-03f, batch_norm_inception_c3_1x1_4_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c3_1x1_4_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c3_1x1_4_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c3_1x1_4_relu, inception_c3_3x1_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c3_3x1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c3_3x1_2, inception_c3_3x1_2_bn_w, inception_c3_3x1_2_bn_b, inception_c3_3x1_2_scale_w, inception_c3_3x1_2_scale_b, 1.000000e-03f, batch_norm_inception_c3_3x1_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c3_3x1_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c3_3x1_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c3_3x1_2_relu, inception_c3_1x3_2_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c3_1x3_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c3_1x3_2, inception_c3_1x3_2_bn_w, inception_c3_1x3_2_bn_b, inception_c3_1x3_2_scale_w, inception_c3_1x3_2_scale_b, 1.000000e-03f, batch_norm_inception_c3_1x3_2_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c3_1x3_2_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c3_1x3_2_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c3_1x3_2_relu, inception_c3_1x3_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c3_1x3_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c3_1x3_3, inception_c3_1x3_3_bn_w, inception_c3_1x3_3_bn_b, inception_c3_1x3_3_scale_w, inception_c3_1x3_3_scale_b, 1.000000e-03f, batch_norm_inception_c3_1x3_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c3_1x3_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c3_1x3_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_inception_c3_1x3_2_relu, inception_c3_3x1_3_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c3_3x1_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c3_3x1_3, inception_c3_3x1_3_bn_w, inception_c3_3x1_3_bn_b, inception_c3_3x1_3_scale_w, inception_c3_3x1_3_scale_b, 1.000000e-03f, batch_norm_inception_c3_3x1_3_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c3_3x1_3_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c3_3x1_3_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_c2_concat, VX_NN_POOLING_AVG, 3, 3, 1, 1, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_inception_c3_pool_ave);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, avg_pool_inception_c3_pool_ave, inception_c3_1x1_w, NULL, &conv_params, sizeof(conv_params), conv_inception_c3_1x1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_inception_c3_1x1, inception_c3_1x1_bn_w, inception_c3_1x1_bn_b, inception_c3_1x1_scale_w, inception_c3_1x1_scale_b, 1.000000e-03f, batch_norm_inception_c3_1x1_scale);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_inception_c3_1x1_scale, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_inception_c3_1x1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxConcatLayer(graph, concat_inception_c3_concat, relu_inception_c3_1x1_2_relu, relu_inception_c3_1x3_relu, relu_inception_c3_3x1_relu, relu_inception_c3_1x3_3_relu, relu_inception_c3_3x1_3_relu, relu_inception_c3_1x1_relu, NULL, NULL, 1);
      ERROR_CHECK_OBJECT(node);ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, concat_inception_c3_concat, VX_NN_POOLING_AVG, 8, 8, 0, 0, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_pool_8x8_s1);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxFullyConnectedLayer(graph, avg_pool_pool_8x8_s1, classifier_w, classifier_b, VX_CONVERT_POLICY_SATURATE, VX_ROUND_POLICY_TO_NEAREST_EVEN, gemm_classifier);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxSoftmaxLayer(graph, gemm_classifier, softmax_prob);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    // release local tensors
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv1_3x3_s2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_conv1_3x3_s2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_conv1_3x3_s2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv2_3x3_s1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_conv2_3x3_s1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_conv2_3x3_s1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv3_3x3_s1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_conv3_3x3_s1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_conv3_3x3_s1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_stem1_3x3_s2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_stem1_3x3_s2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_stem1_3x3_s2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&max_pool_inception_stem1_pool));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_stem1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_stem2_3x3_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_stem2_3x3_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_stem2_3x3_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_stem2_3x3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_stem2_3x3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_stem2_3x3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_stem2_1x7_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_stem2_1x7_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_stem2_1x7_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_stem2_1x7));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_stem2_1x7_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_stem2_1x7_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_stem2_7x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_stem2_7x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_stem2_7x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_stem2_3x3_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_stem2_3x3_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_stem2_3x3_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_stem2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_stem3_3x3_s2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_stem3_3x3_s2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_stem3_3x3_s2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&max_pool_inception_stem3_pool));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_stem3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a1_1x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a1_1x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a1_1x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a1_3x3_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a1_3x3_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a1_3x3_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a1_3x3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a1_3x3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a1_3x3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a1_3x3_2_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a1_3x3_2_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a1_3x3_2_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a1_3x3_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a1_3x3_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a1_3x3_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a1_3x3_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a1_3x3_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a1_3x3_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_inception_a1_pool_ave));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a1_1x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a1_1x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a1_1x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_a1_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a2_1x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a2_1x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a2_1x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a2_3x3_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a2_3x3_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a2_3x3_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a2_3x3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a2_3x3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a2_3x3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a2_3x3_2_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a2_3x3_2_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a2_3x3_2_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a2_3x3_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a2_3x3_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a2_3x3_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a2_3x3_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a2_3x3_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a2_3x3_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_inception_a2_pool_ave));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a2_1x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a2_1x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a2_1x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_a2_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a3_1x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a3_1x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a3_1x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a3_3x3_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a3_3x3_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a3_3x3_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a3_3x3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a3_3x3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a3_3x3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a3_3x3_2_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a3_3x3_2_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a3_3x3_2_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a3_3x3_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a3_3x3_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a3_3x3_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a3_3x3_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a3_3x3_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a3_3x3_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_inception_a3_pool_ave));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a3_1x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a3_1x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a3_1x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_a3_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a4_1x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a4_1x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a4_1x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a4_3x3_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a4_3x3_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a4_3x3_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a4_3x3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a4_3x3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a4_3x3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a4_3x3_2_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a4_3x3_2_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a4_3x3_2_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a4_3x3_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a4_3x3_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a4_3x3_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a4_3x3_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a4_3x3_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a4_3x3_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_inception_a4_pool_ave));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_a4_1x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_a4_1x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_a4_1x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_a4_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_reduction_a_3x3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_reduction_a_3x3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_reduction_a_3x3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_reduction_a_3x3_2_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_reduction_a_3x3_2_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_reduction_a_3x3_2_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_reduction_a_3x3_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_reduction_a_3x3_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_reduction_a_3x3_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_reduction_a_3x3_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_reduction_a_3x3_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_reduction_a_3x3_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&max_pool_reduction_a_pool));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_reduction_a_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b1_1x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b1_1x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b1_1x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b1_1x7_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b1_1x7_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b1_1x7_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b1_1x7));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b1_1x7_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b1_1x7_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b1_7x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b1_7x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b1_7x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b1_7x1_2_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b1_7x1_2_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b1_7x1_2_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b1_7x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b1_7x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b1_7x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b1_1x7_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b1_1x7_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b1_1x7_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b1_7x1_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b1_7x1_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b1_7x1_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b1_1x7_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b1_1x7_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b1_1x7_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_inception_b1_pool_ave));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b1_1x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b1_1x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b1_1x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_b1_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b2_1x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b2_1x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b2_1x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b2_1x7_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b2_1x7_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b2_1x7_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b2_1x7));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b2_1x7_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b2_1x7_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b2_7x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b2_7x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b2_7x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b2_7x1_2_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b2_7x1_2_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b2_7x1_2_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b2_7x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b2_7x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b2_7x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b2_1x7_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b2_1x7_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b2_1x7_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b2_7x1_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b2_7x1_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b2_7x1_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b2_1x7_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b2_1x7_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b2_1x7_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_inception_b2_pool_ave));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b2_1x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b2_1x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b2_1x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_b2_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b3_1x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b3_1x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b3_1x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b3_1x7_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b3_1x7_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b3_1x7_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b3_1x7));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b3_1x7_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b3_1x7_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b3_7x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b3_7x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b3_7x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b3_7x1_2_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b3_7x1_2_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b3_7x1_2_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b3_7x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b3_7x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b3_7x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b3_1x7_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b3_1x7_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b3_1x7_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b3_7x1_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b3_7x1_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b3_7x1_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b3_1x7_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b3_1x7_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b3_1x7_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_inception_b3_pool_ave));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b3_1x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b3_1x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b3_1x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_b3_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b4_1x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b4_1x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b4_1x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b4_1x7_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b4_1x7_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b4_1x7_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b4_1x7));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b4_1x7_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b4_1x7_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b4_7x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b4_7x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b4_7x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b4_7x1_2_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b4_7x1_2_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b4_7x1_2_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b4_7x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b4_7x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b4_7x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b4_1x7_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b4_1x7_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b4_1x7_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b4_7x1_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b4_7x1_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b4_7x1_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b4_1x7_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b4_1x7_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b4_1x7_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_inception_b4_pool_ave));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b4_1x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b4_1x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b4_1x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_b4_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b5_1x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b5_1x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b5_1x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b5_1x7_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b5_1x7_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b5_1x7_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b5_1x7));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b5_1x7_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b5_1x7_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b5_7x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b5_7x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b5_7x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b5_7x1_2_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b5_7x1_2_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b5_7x1_2_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b5_7x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b5_7x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b5_7x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b5_1x7_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b5_1x7_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b5_1x7_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b5_7x1_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b5_7x1_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b5_7x1_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b5_1x7_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b5_1x7_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b5_1x7_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_inception_b5_pool_ave));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b5_1x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b5_1x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b5_1x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_b5_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b6_1x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b6_1x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b6_1x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b6_1x7_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b6_1x7_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b6_1x7_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b6_1x7));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b6_1x7_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b6_1x7_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b6_7x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b6_7x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b6_7x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b6_7x1_2_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b6_7x1_2_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b6_7x1_2_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b6_7x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b6_7x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b6_7x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b6_1x7_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b6_1x7_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b6_1x7_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b6_7x1_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b6_7x1_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b6_7x1_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b6_1x7_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b6_1x7_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b6_1x7_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_inception_b6_pool_ave));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b6_1x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b6_1x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b6_1x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_b6_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b7_1x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b7_1x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b7_1x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b7_1x7_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b7_1x7_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b7_1x7_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b7_1x7));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b7_1x7_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b7_1x7_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b7_7x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b7_7x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b7_7x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b7_7x1_2_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b7_7x1_2_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b7_7x1_2_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b7_7x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b7_7x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b7_7x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b7_1x7_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b7_1x7_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b7_1x7_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b7_7x1_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b7_7x1_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b7_7x1_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b7_1x7_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b7_1x7_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b7_1x7_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_inception_b7_pool_ave));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_b7_1x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_b7_1x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_b7_1x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_b7_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_reduction_b_3x3_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_reduction_b_3x3_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_reduction_b_3x3_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_reduction_b_3x3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_reduction_b_3x3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_reduction_b_3x3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_reduction_b_1x7_reduce));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_reduction_b_1x7_reduce_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_reduction_b_1x7_reduce_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_reduction_b_1x7));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_reduction_b_1x7_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_reduction_b_1x7_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_reduction_b_7x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_reduction_b_7x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_reduction_b_7x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_reduction_b_3x3_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_reduction_b_3x3_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_reduction_b_3x3_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&max_pool_reduction_b_pool));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_reduction_b_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c1_1x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c1_1x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c1_1x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c1_1x1_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c1_1x1_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c1_1x1_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c1_1x3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c1_1x3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c1_1x3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c1_3x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c1_3x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c1_3x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c1_1x1_4));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c1_1x1_4_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c1_1x1_4_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c1_3x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c1_3x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c1_3x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c1_1x3_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c1_1x3_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c1_1x3_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c1_1x3_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c1_1x3_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c1_1x3_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c1_3x1_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c1_3x1_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c1_3x1_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_inception_c1_pool_ave));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c1_1x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c1_1x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c1_1x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_c1_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c2_1x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c2_1x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c2_1x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c2_1x1_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c2_1x1_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c2_1x1_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c2_1x3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c2_1x3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c2_1x3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c2_3x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c2_3x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c2_3x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c2_1x1_4));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c2_1x1_4_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c2_1x1_4_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c2_3x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c2_3x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c2_3x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c2_1x3_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c2_1x3_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c2_1x3_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c2_1x3_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c2_1x3_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c2_1x3_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c2_3x1_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c2_3x1_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c2_3x1_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_inception_c2_pool_ave));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c2_1x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c2_1x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c2_1x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_c2_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c3_1x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c3_1x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c3_1x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c3_1x1_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c3_1x1_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c3_1x1_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c3_1x3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c3_1x3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c3_1x3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c3_3x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c3_3x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c3_3x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c3_1x1_4));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c3_1x1_4_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c3_1x1_4_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c3_3x1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c3_3x1_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c3_3x1_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c3_1x3_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c3_1x3_2_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c3_1x3_2_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c3_1x3_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c3_1x3_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c3_1x3_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c3_3x1_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c3_3x1_3_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c3_3x1_3_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_inception_c3_pool_ave));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_inception_c3_1x1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_inception_c3_1x1_scale));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_inception_c3_1x1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&concat_inception_c3_concat));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_pool_8x8_s1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&gemm_classifier));

    // release initializer tensors
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv1_3x3_s2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv1_3x3_s2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv1_3x3_s2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv1_3x3_s2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv1_3x3_s2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv2_3x3_s1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv2_3x3_s1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv2_3x3_s1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv2_3x3_s1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv2_3x3_s1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv3_3x3_s1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv3_3x3_s1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv3_3x3_s1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv3_3x3_s1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv3_3x3_s1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem1_3x3_s2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem1_3x3_s2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem1_3x3_s2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem1_3x3_s2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem1_3x3_s2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_1x7_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_1x7_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_1x7_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_1x7_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_1x7_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_1x7_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_1x7_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_1x7_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_1x7_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_1x7_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_7x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_7x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_7x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_7x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_7x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem2_3x3_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem3_3x3_s2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem3_3x3_s2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem3_3x3_s2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem3_3x3_s2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_stem3_3x3_s2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_1x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_1x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_1x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_1x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_1x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_2_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_2_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_2_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_2_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_2_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_3x3_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_1x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_1x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_1x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_1x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a1_1x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_1x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_1x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_1x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_1x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_1x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_2_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_2_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_2_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_2_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_2_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_3x3_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_1x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_1x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_1x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_1x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a2_1x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_1x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_1x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_1x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_1x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_1x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_2_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_2_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_2_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_2_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_2_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_3x3_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_1x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_1x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_1x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_1x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a3_1x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_1x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_1x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_1x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_1x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_1x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_2_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_2_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_2_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_2_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_2_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_3x3_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_1x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_1x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_1x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_1x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_a4_1x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_2_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_2_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_2_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_2_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_2_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_a_3x3_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_2_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_2_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_2_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_2_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_2_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_7x1_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x7_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b1_1x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_2_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_2_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_2_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_2_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_2_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_7x1_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x7_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b2_1x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_2_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_2_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_2_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_2_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_2_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_7x1_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x7_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b3_1x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_2_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_2_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_2_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_2_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_2_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_7x1_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x7_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b4_1x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_2_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_2_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_2_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_2_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_2_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_7x1_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x7_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b5_1x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_2_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_2_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_2_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_2_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_2_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_7x1_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x7_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b6_1x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_2_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_2_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_2_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_2_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_2_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_7x1_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x7_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_b7_1x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_1x7_reduce_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_1x7_reduce_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_1x7_reduce_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_1x7_reduce_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_1x7_reduce_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_1x7_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_1x7_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_1x7_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_1x7_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_1x7_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_7x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_7x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_7x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_7x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_7x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&reduction_b_3x3_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_4_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_4_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_4_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_4_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_4_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x3_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_3x1_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c1_1x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_4_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_4_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_4_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_4_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_4_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x3_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_3x1_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c2_1x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_4_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_4_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_4_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_4_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_4_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_2_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_2_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_2_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_2_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x3_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_3_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_3_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_3_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_3x1_3_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_bn_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_bn_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_scale_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&inception_c3_1x1_scale_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&classifier_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&classifier_b));

    return VX_SUCCESS;
}

VX_API_ENTRY vx_status VX_API_CALL annAddToGraph_resnet(vx_graph graph, vx_tensor data, vx_tensor softmax_prob, const char * binaryFilename)
{
    vx_context context = vxGetContext((vx_reference)graph);
    ERROR_CHECK_OBJECT(context);

    // create variables
    vx_size dims_conv1_w[4] = { 7, 7, 3, 64 };
    vx_tensor conv1_w = vxCreateTensor(context, 4, dims_conv1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv1_w);
    vx_size dims_conv1_b[2] = { 64, 1 };
    vx_tensor conv1_b = vxCreateTensor(context, 2, dims_conv1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv1_b);
    vx_size dims_bn_conv1_w[2] = { 64, 1 };
    vx_tensor bn_conv1_w = vxCreateTensor(context, 2, dims_bn_conv1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn_conv1_w);
    vx_size dims_bn_conv1_b[2] = { 64, 1 };
    vx_tensor bn_conv1_b = vxCreateTensor(context, 2, dims_bn_conv1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn_conv1_b);
    vx_size dims_scale_conv1_w[2] = { 64, 1 };
    vx_tensor scale_conv1_w = vxCreateTensor(context, 2, dims_scale_conv1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale_conv1_w);
    vx_size dims_scale_conv1_b[2] = { 64, 1 };
    vx_tensor scale_conv1_b = vxCreateTensor(context, 2, dims_scale_conv1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale_conv1_b);
    vx_size dims_res2a_branch1_w[4] = { 1, 1, 64, 256 };
    vx_tensor res2a_branch1_w = vxCreateTensor(context, 4, dims_res2a_branch1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res2a_branch1_w);
    vx_size dims_bn2a_branch1_w[2] = { 256, 1 };
    vx_tensor bn2a_branch1_w = vxCreateTensor(context, 2, dims_bn2a_branch1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2a_branch1_w);
    vx_size dims_bn2a_branch1_b[2] = { 256, 1 };
    vx_tensor bn2a_branch1_b = vxCreateTensor(context, 2, dims_bn2a_branch1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2a_branch1_b);
    vx_size dims_scale2a_branch1_w[2] = { 256, 1 };
    vx_tensor scale2a_branch1_w = vxCreateTensor(context, 2, dims_scale2a_branch1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2a_branch1_w);
    vx_size dims_scale2a_branch1_b[2] = { 256, 1 };
    vx_tensor scale2a_branch1_b = vxCreateTensor(context, 2, dims_scale2a_branch1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2a_branch1_b);
    vx_size dims_res2a_branch2a_w[4] = { 1, 1, 64, 64 };
    vx_tensor res2a_branch2a_w = vxCreateTensor(context, 4, dims_res2a_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res2a_branch2a_w);
    vx_size dims_bn2a_branch2a_w[2] = { 64, 1 };
    vx_tensor bn2a_branch2a_w = vxCreateTensor(context, 2, dims_bn2a_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2a_branch2a_w);
    vx_size dims_bn2a_branch2a_b[2] = { 64, 1 };
    vx_tensor bn2a_branch2a_b = vxCreateTensor(context, 2, dims_bn2a_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2a_branch2a_b);
    vx_size dims_scale2a_branch2a_w[2] = { 64, 1 };
    vx_tensor scale2a_branch2a_w = vxCreateTensor(context, 2, dims_scale2a_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2a_branch2a_w);
    vx_size dims_scale2a_branch2a_b[2] = { 64, 1 };
    vx_tensor scale2a_branch2a_b = vxCreateTensor(context, 2, dims_scale2a_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2a_branch2a_b);
    vx_size dims_res2a_branch2b_w[4] = { 3, 3, 64, 64 };
    vx_tensor res2a_branch2b_w = vxCreateTensor(context, 4, dims_res2a_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res2a_branch2b_w);
    vx_size dims_bn2a_branch2b_w[2] = { 64, 1 };
    vx_tensor bn2a_branch2b_w = vxCreateTensor(context, 2, dims_bn2a_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2a_branch2b_w);
    vx_size dims_bn2a_branch2b_b[2] = { 64, 1 };
    vx_tensor bn2a_branch2b_b = vxCreateTensor(context, 2, dims_bn2a_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2a_branch2b_b);
    vx_size dims_scale2a_branch2b_w[2] = { 64, 1 };
    vx_tensor scale2a_branch2b_w = vxCreateTensor(context, 2, dims_scale2a_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2a_branch2b_w);
    vx_size dims_scale2a_branch2b_b[2] = { 64, 1 };
    vx_tensor scale2a_branch2b_b = vxCreateTensor(context, 2, dims_scale2a_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2a_branch2b_b);
    vx_size dims_res2a_branch2c_w[4] = { 1, 1, 64, 256 };
    vx_tensor res2a_branch2c_w = vxCreateTensor(context, 4, dims_res2a_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res2a_branch2c_w);
    vx_size dims_bn2a_branch2c_w[2] = { 256, 1 };
    vx_tensor bn2a_branch2c_w = vxCreateTensor(context, 2, dims_bn2a_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2a_branch2c_w);
    vx_size dims_bn2a_branch2c_b[2] = { 256, 1 };
    vx_tensor bn2a_branch2c_b = vxCreateTensor(context, 2, dims_bn2a_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2a_branch2c_b);
    vx_size dims_scale2a_branch2c_w[2] = { 256, 1 };
    vx_tensor scale2a_branch2c_w = vxCreateTensor(context, 2, dims_scale2a_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2a_branch2c_w);
    vx_size dims_scale2a_branch2c_b[2] = { 256, 1 };
    vx_tensor scale2a_branch2c_b = vxCreateTensor(context, 2, dims_scale2a_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2a_branch2c_b);
    vx_size dims_res2b_branch2a_w[4] = { 1, 1, 256, 64 };
    vx_tensor res2b_branch2a_w = vxCreateTensor(context, 4, dims_res2b_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res2b_branch2a_w);
    vx_size dims_bn2b_branch2a_w[2] = { 64, 1 };
    vx_tensor bn2b_branch2a_w = vxCreateTensor(context, 2, dims_bn2b_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2b_branch2a_w);
    vx_size dims_bn2b_branch2a_b[2] = { 64, 1 };
    vx_tensor bn2b_branch2a_b = vxCreateTensor(context, 2, dims_bn2b_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2b_branch2a_b);
    vx_size dims_scale2b_branch2a_w[2] = { 64, 1 };
    vx_tensor scale2b_branch2a_w = vxCreateTensor(context, 2, dims_scale2b_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2b_branch2a_w);
    vx_size dims_scale2b_branch2a_b[2] = { 64, 1 };
    vx_tensor scale2b_branch2a_b = vxCreateTensor(context, 2, dims_scale2b_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2b_branch2a_b);
    vx_size dims_res2b_branch2b_w[4] = { 3, 3, 64, 64 };
    vx_tensor res2b_branch2b_w = vxCreateTensor(context, 4, dims_res2b_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res2b_branch2b_w);
    vx_size dims_bn2b_branch2b_w[2] = { 64, 1 };
    vx_tensor bn2b_branch2b_w = vxCreateTensor(context, 2, dims_bn2b_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2b_branch2b_w);
    vx_size dims_bn2b_branch2b_b[2] = { 64, 1 };
    vx_tensor bn2b_branch2b_b = vxCreateTensor(context, 2, dims_bn2b_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2b_branch2b_b);
    vx_size dims_scale2b_branch2b_w[2] = { 64, 1 };
    vx_tensor scale2b_branch2b_w = vxCreateTensor(context, 2, dims_scale2b_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2b_branch2b_w);
    vx_size dims_scale2b_branch2b_b[2] = { 64, 1 };
    vx_tensor scale2b_branch2b_b = vxCreateTensor(context, 2, dims_scale2b_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2b_branch2b_b);
    vx_size dims_res2b_branch2c_w[4] = { 1, 1, 64, 256 };
    vx_tensor res2b_branch2c_w = vxCreateTensor(context, 4, dims_res2b_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res2b_branch2c_w);
    vx_size dims_bn2b_branch2c_w[2] = { 256, 1 };
    vx_tensor bn2b_branch2c_w = vxCreateTensor(context, 2, dims_bn2b_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2b_branch2c_w);
    vx_size dims_bn2b_branch2c_b[2] = { 256, 1 };
    vx_tensor bn2b_branch2c_b = vxCreateTensor(context, 2, dims_bn2b_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2b_branch2c_b);
    vx_size dims_scale2b_branch2c_w[2] = { 256, 1 };
    vx_tensor scale2b_branch2c_w = vxCreateTensor(context, 2, dims_scale2b_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2b_branch2c_w);
    vx_size dims_scale2b_branch2c_b[2] = { 256, 1 };
    vx_tensor scale2b_branch2c_b = vxCreateTensor(context, 2, dims_scale2b_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2b_branch2c_b);
    vx_size dims_res2c_branch2a_w[4] = { 1, 1, 256, 64 };
    vx_tensor res2c_branch2a_w = vxCreateTensor(context, 4, dims_res2c_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res2c_branch2a_w);
    vx_size dims_bn2c_branch2a_w[2] = { 64, 1 };
    vx_tensor bn2c_branch2a_w = vxCreateTensor(context, 2, dims_bn2c_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2c_branch2a_w);
    vx_size dims_bn2c_branch2a_b[2] = { 64, 1 };
    vx_tensor bn2c_branch2a_b = vxCreateTensor(context, 2, dims_bn2c_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2c_branch2a_b);
    vx_size dims_scale2c_branch2a_w[2] = { 64, 1 };
    vx_tensor scale2c_branch2a_w = vxCreateTensor(context, 2, dims_scale2c_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2c_branch2a_w);
    vx_size dims_scale2c_branch2a_b[2] = { 64, 1 };
    vx_tensor scale2c_branch2a_b = vxCreateTensor(context, 2, dims_scale2c_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2c_branch2a_b);
    vx_size dims_res2c_branch2b_w[4] = { 3, 3, 64, 64 };
    vx_tensor res2c_branch2b_w = vxCreateTensor(context, 4, dims_res2c_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res2c_branch2b_w);
    vx_size dims_bn2c_branch2b_w[2] = { 64, 1 };
    vx_tensor bn2c_branch2b_w = vxCreateTensor(context, 2, dims_bn2c_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2c_branch2b_w);
    vx_size dims_bn2c_branch2b_b[2] = { 64, 1 };
    vx_tensor bn2c_branch2b_b = vxCreateTensor(context, 2, dims_bn2c_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2c_branch2b_b);
    vx_size dims_scale2c_branch2b_w[2] = { 64, 1 };
    vx_tensor scale2c_branch2b_w = vxCreateTensor(context, 2, dims_scale2c_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2c_branch2b_w);
    vx_size dims_scale2c_branch2b_b[2] = { 64, 1 };
    vx_tensor scale2c_branch2b_b = vxCreateTensor(context, 2, dims_scale2c_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2c_branch2b_b);
    vx_size dims_res2c_branch2c_w[4] = { 1, 1, 64, 256 };
    vx_tensor res2c_branch2c_w = vxCreateTensor(context, 4, dims_res2c_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res2c_branch2c_w);
    vx_size dims_bn2c_branch2c_w[2] = { 256, 1 };
    vx_tensor bn2c_branch2c_w = vxCreateTensor(context, 2, dims_bn2c_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2c_branch2c_w);
    vx_size dims_bn2c_branch2c_b[2] = { 256, 1 };
    vx_tensor bn2c_branch2c_b = vxCreateTensor(context, 2, dims_bn2c_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn2c_branch2c_b);
    vx_size dims_scale2c_branch2c_w[2] = { 256, 1 };
    vx_tensor scale2c_branch2c_w = vxCreateTensor(context, 2, dims_scale2c_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2c_branch2c_w);
    vx_size dims_scale2c_branch2c_b[2] = { 256, 1 };
    vx_tensor scale2c_branch2c_b = vxCreateTensor(context, 2, dims_scale2c_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale2c_branch2c_b);
    vx_size dims_res3a_branch1_w[4] = { 1, 1, 256, 512 };
    vx_tensor res3a_branch1_w = vxCreateTensor(context, 4, dims_res3a_branch1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res3a_branch1_w);
    vx_size dims_bn3a_branch1_w[2] = { 512, 1 };
    vx_tensor bn3a_branch1_w = vxCreateTensor(context, 2, dims_bn3a_branch1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3a_branch1_w);
    vx_size dims_bn3a_branch1_b[2] = { 512, 1 };
    vx_tensor bn3a_branch1_b = vxCreateTensor(context, 2, dims_bn3a_branch1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3a_branch1_b);
    vx_size dims_scale3a_branch1_w[2] = { 512, 1 };
    vx_tensor scale3a_branch1_w = vxCreateTensor(context, 2, dims_scale3a_branch1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3a_branch1_w);
    vx_size dims_scale3a_branch1_b[2] = { 512, 1 };
    vx_tensor scale3a_branch1_b = vxCreateTensor(context, 2, dims_scale3a_branch1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3a_branch1_b);
    vx_size dims_res3a_branch2a_w[4] = { 1, 1, 256, 128 };
    vx_tensor res3a_branch2a_w = vxCreateTensor(context, 4, dims_res3a_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res3a_branch2a_w);
    vx_size dims_bn3a_branch2a_w[2] = { 128, 1 };
    vx_tensor bn3a_branch2a_w = vxCreateTensor(context, 2, dims_bn3a_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3a_branch2a_w);
    vx_size dims_bn3a_branch2a_b[2] = { 128, 1 };
    vx_tensor bn3a_branch2a_b = vxCreateTensor(context, 2, dims_bn3a_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3a_branch2a_b);
    vx_size dims_scale3a_branch2a_w[2] = { 128, 1 };
    vx_tensor scale3a_branch2a_w = vxCreateTensor(context, 2, dims_scale3a_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3a_branch2a_w);
    vx_size dims_scale3a_branch2a_b[2] = { 128, 1 };
    vx_tensor scale3a_branch2a_b = vxCreateTensor(context, 2, dims_scale3a_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3a_branch2a_b);
    vx_size dims_res3a_branch2b_w[4] = { 3, 3, 128, 128 };
    vx_tensor res3a_branch2b_w = vxCreateTensor(context, 4, dims_res3a_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res3a_branch2b_w);
    vx_size dims_bn3a_branch2b_w[2] = { 128, 1 };
    vx_tensor bn3a_branch2b_w = vxCreateTensor(context, 2, dims_bn3a_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3a_branch2b_w);
    vx_size dims_bn3a_branch2b_b[2] = { 128, 1 };
    vx_tensor bn3a_branch2b_b = vxCreateTensor(context, 2, dims_bn3a_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3a_branch2b_b);
    vx_size dims_scale3a_branch2b_w[2] = { 128, 1 };
    vx_tensor scale3a_branch2b_w = vxCreateTensor(context, 2, dims_scale3a_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3a_branch2b_w);
    vx_size dims_scale3a_branch2b_b[2] = { 128, 1 };
    vx_tensor scale3a_branch2b_b = vxCreateTensor(context, 2, dims_scale3a_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3a_branch2b_b);
    vx_size dims_res3a_branch2c_w[4] = { 1, 1, 128, 512 };
    vx_tensor res3a_branch2c_w = vxCreateTensor(context, 4, dims_res3a_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res3a_branch2c_w);
    vx_size dims_bn3a_branch2c_w[2] = { 512, 1 };
    vx_tensor bn3a_branch2c_w = vxCreateTensor(context, 2, dims_bn3a_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3a_branch2c_w);
    vx_size dims_bn3a_branch2c_b[2] = { 512, 1 };
    vx_tensor bn3a_branch2c_b = vxCreateTensor(context, 2, dims_bn3a_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3a_branch2c_b);
    vx_size dims_scale3a_branch2c_w[2] = { 512, 1 };
    vx_tensor scale3a_branch2c_w = vxCreateTensor(context, 2, dims_scale3a_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3a_branch2c_w);
    vx_size dims_scale3a_branch2c_b[2] = { 512, 1 };
    vx_tensor scale3a_branch2c_b = vxCreateTensor(context, 2, dims_scale3a_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3a_branch2c_b);
    vx_size dims_res3b_branch2a_w[4] = { 1, 1, 512, 128 };
    vx_tensor res3b_branch2a_w = vxCreateTensor(context, 4, dims_res3b_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res3b_branch2a_w);
    vx_size dims_bn3b_branch2a_w[2] = { 128, 1 };
    vx_tensor bn3b_branch2a_w = vxCreateTensor(context, 2, dims_bn3b_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3b_branch2a_w);
    vx_size dims_bn3b_branch2a_b[2] = { 128, 1 };
    vx_tensor bn3b_branch2a_b = vxCreateTensor(context, 2, dims_bn3b_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3b_branch2a_b);
    vx_size dims_scale3b_branch2a_w[2] = { 128, 1 };
    vx_tensor scale3b_branch2a_w = vxCreateTensor(context, 2, dims_scale3b_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3b_branch2a_w);
    vx_size dims_scale3b_branch2a_b[2] = { 128, 1 };
    vx_tensor scale3b_branch2a_b = vxCreateTensor(context, 2, dims_scale3b_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3b_branch2a_b);
    vx_size dims_res3b_branch2b_w[4] = { 3, 3, 128, 128 };
    vx_tensor res3b_branch2b_w = vxCreateTensor(context, 4, dims_res3b_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res3b_branch2b_w);
    vx_size dims_bn3b_branch2b_w[2] = { 128, 1 };
    vx_tensor bn3b_branch2b_w = vxCreateTensor(context, 2, dims_bn3b_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3b_branch2b_w);
    vx_size dims_bn3b_branch2b_b[2] = { 128, 1 };
    vx_tensor bn3b_branch2b_b = vxCreateTensor(context, 2, dims_bn3b_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3b_branch2b_b);
    vx_size dims_scale3b_branch2b_w[2] = { 128, 1 };
    vx_tensor scale3b_branch2b_w = vxCreateTensor(context, 2, dims_scale3b_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3b_branch2b_w);
    vx_size dims_scale3b_branch2b_b[2] = { 128, 1 };
    vx_tensor scale3b_branch2b_b = vxCreateTensor(context, 2, dims_scale3b_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3b_branch2b_b);
    vx_size dims_res3b_branch2c_w[4] = { 1, 1, 128, 512 };
    vx_tensor res3b_branch2c_w = vxCreateTensor(context, 4, dims_res3b_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res3b_branch2c_w);
    vx_size dims_bn3b_branch2c_w[2] = { 512, 1 };
    vx_tensor bn3b_branch2c_w = vxCreateTensor(context, 2, dims_bn3b_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3b_branch2c_w);
    vx_size dims_bn3b_branch2c_b[2] = { 512, 1 };
    vx_tensor bn3b_branch2c_b = vxCreateTensor(context, 2, dims_bn3b_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3b_branch2c_b);
    vx_size dims_scale3b_branch2c_w[2] = { 512, 1 };
    vx_tensor scale3b_branch2c_w = vxCreateTensor(context, 2, dims_scale3b_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3b_branch2c_w);
    vx_size dims_scale3b_branch2c_b[2] = { 512, 1 };
    vx_tensor scale3b_branch2c_b = vxCreateTensor(context, 2, dims_scale3b_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3b_branch2c_b);
    vx_size dims_res3c_branch2a_w[4] = { 1, 1, 512, 128 };
    vx_tensor res3c_branch2a_w = vxCreateTensor(context, 4, dims_res3c_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res3c_branch2a_w);
    vx_size dims_bn3c_branch2a_w[2] = { 128, 1 };
    vx_tensor bn3c_branch2a_w = vxCreateTensor(context, 2, dims_bn3c_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3c_branch2a_w);
    vx_size dims_bn3c_branch2a_b[2] = { 128, 1 };
    vx_tensor bn3c_branch2a_b = vxCreateTensor(context, 2, dims_bn3c_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3c_branch2a_b);
    vx_size dims_scale3c_branch2a_w[2] = { 128, 1 };
    vx_tensor scale3c_branch2a_w = vxCreateTensor(context, 2, dims_scale3c_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3c_branch2a_w);
    vx_size dims_scale3c_branch2a_b[2] = { 128, 1 };
    vx_tensor scale3c_branch2a_b = vxCreateTensor(context, 2, dims_scale3c_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3c_branch2a_b);
    vx_size dims_res3c_branch2b_w[4] = { 3, 3, 128, 128 };
    vx_tensor res3c_branch2b_w = vxCreateTensor(context, 4, dims_res3c_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res3c_branch2b_w);
    vx_size dims_bn3c_branch2b_w[2] = { 128, 1 };
    vx_tensor bn3c_branch2b_w = vxCreateTensor(context, 2, dims_bn3c_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3c_branch2b_w);
    vx_size dims_bn3c_branch2b_b[2] = { 128, 1 };
    vx_tensor bn3c_branch2b_b = vxCreateTensor(context, 2, dims_bn3c_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3c_branch2b_b);
    vx_size dims_scale3c_branch2b_w[2] = { 128, 1 };
    vx_tensor scale3c_branch2b_w = vxCreateTensor(context, 2, dims_scale3c_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3c_branch2b_w);
    vx_size dims_scale3c_branch2b_b[2] = { 128, 1 };
    vx_tensor scale3c_branch2b_b = vxCreateTensor(context, 2, dims_scale3c_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3c_branch2b_b);
    vx_size dims_res3c_branch2c_w[4] = { 1, 1, 128, 512 };
    vx_tensor res3c_branch2c_w = vxCreateTensor(context, 4, dims_res3c_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res3c_branch2c_w);
    vx_size dims_bn3c_branch2c_w[2] = { 512, 1 };
    vx_tensor bn3c_branch2c_w = vxCreateTensor(context, 2, dims_bn3c_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3c_branch2c_w);
    vx_size dims_bn3c_branch2c_b[2] = { 512, 1 };
    vx_tensor bn3c_branch2c_b = vxCreateTensor(context, 2, dims_bn3c_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3c_branch2c_b);
    vx_size dims_scale3c_branch2c_w[2] = { 512, 1 };
    vx_tensor scale3c_branch2c_w = vxCreateTensor(context, 2, dims_scale3c_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3c_branch2c_w);
    vx_size dims_scale3c_branch2c_b[2] = { 512, 1 };
    vx_tensor scale3c_branch2c_b = vxCreateTensor(context, 2, dims_scale3c_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3c_branch2c_b);
    vx_size dims_res3d_branch2a_w[4] = { 1, 1, 512, 128 };
    vx_tensor res3d_branch2a_w = vxCreateTensor(context, 4, dims_res3d_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res3d_branch2a_w);
    vx_size dims_bn3d_branch2a_w[2] = { 128, 1 };
    vx_tensor bn3d_branch2a_w = vxCreateTensor(context, 2, dims_bn3d_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3d_branch2a_w);
    vx_size dims_bn3d_branch2a_b[2] = { 128, 1 };
    vx_tensor bn3d_branch2a_b = vxCreateTensor(context, 2, dims_bn3d_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3d_branch2a_b);
    vx_size dims_scale3d_branch2a_w[2] = { 128, 1 };
    vx_tensor scale3d_branch2a_w = vxCreateTensor(context, 2, dims_scale3d_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3d_branch2a_w);
    vx_size dims_scale3d_branch2a_b[2] = { 128, 1 };
    vx_tensor scale3d_branch2a_b = vxCreateTensor(context, 2, dims_scale3d_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3d_branch2a_b);
    vx_size dims_res3d_branch2b_w[4] = { 3, 3, 128, 128 };
    vx_tensor res3d_branch2b_w = vxCreateTensor(context, 4, dims_res3d_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res3d_branch2b_w);
    vx_size dims_bn3d_branch2b_w[2] = { 128, 1 };
    vx_tensor bn3d_branch2b_w = vxCreateTensor(context, 2, dims_bn3d_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3d_branch2b_w);
    vx_size dims_bn3d_branch2b_b[2] = { 128, 1 };
    vx_tensor bn3d_branch2b_b = vxCreateTensor(context, 2, dims_bn3d_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3d_branch2b_b);
    vx_size dims_scale3d_branch2b_w[2] = { 128, 1 };
    vx_tensor scale3d_branch2b_w = vxCreateTensor(context, 2, dims_scale3d_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3d_branch2b_w);
    vx_size dims_scale3d_branch2b_b[2] = { 128, 1 };
    vx_tensor scale3d_branch2b_b = vxCreateTensor(context, 2, dims_scale3d_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3d_branch2b_b);
    vx_size dims_res3d_branch2c_w[4] = { 1, 1, 128, 512 };
    vx_tensor res3d_branch2c_w = vxCreateTensor(context, 4, dims_res3d_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res3d_branch2c_w);
    vx_size dims_bn3d_branch2c_w[2] = { 512, 1 };
    vx_tensor bn3d_branch2c_w = vxCreateTensor(context, 2, dims_bn3d_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3d_branch2c_w);
    vx_size dims_bn3d_branch2c_b[2] = { 512, 1 };
    vx_tensor bn3d_branch2c_b = vxCreateTensor(context, 2, dims_bn3d_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn3d_branch2c_b);
    vx_size dims_scale3d_branch2c_w[2] = { 512, 1 };
    vx_tensor scale3d_branch2c_w = vxCreateTensor(context, 2, dims_scale3d_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3d_branch2c_w);
    vx_size dims_scale3d_branch2c_b[2] = { 512, 1 };
    vx_tensor scale3d_branch2c_b = vxCreateTensor(context, 2, dims_scale3d_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale3d_branch2c_b);
    vx_size dims_res4a_branch1_w[4] = { 1, 1, 512, 1024 };
    vx_tensor res4a_branch1_w = vxCreateTensor(context, 4, dims_res4a_branch1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4a_branch1_w);
    vx_size dims_bn4a_branch1_w[2] = { 1024, 1 };
    vx_tensor bn4a_branch1_w = vxCreateTensor(context, 2, dims_bn4a_branch1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4a_branch1_w);
    vx_size dims_bn4a_branch1_b[2] = { 1024, 1 };
    vx_tensor bn4a_branch1_b = vxCreateTensor(context, 2, dims_bn4a_branch1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4a_branch1_b);
    vx_size dims_scale4a_branch1_w[2] = { 1024, 1 };
    vx_tensor scale4a_branch1_w = vxCreateTensor(context, 2, dims_scale4a_branch1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4a_branch1_w);
    vx_size dims_scale4a_branch1_b[2] = { 1024, 1 };
    vx_tensor scale4a_branch1_b = vxCreateTensor(context, 2, dims_scale4a_branch1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4a_branch1_b);
    vx_size dims_res4a_branch2a_w[4] = { 1, 1, 512, 256 };
    vx_tensor res4a_branch2a_w = vxCreateTensor(context, 4, dims_res4a_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4a_branch2a_w);
    vx_size dims_bn4a_branch2a_w[2] = { 256, 1 };
    vx_tensor bn4a_branch2a_w = vxCreateTensor(context, 2, dims_bn4a_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4a_branch2a_w);
    vx_size dims_bn4a_branch2a_b[2] = { 256, 1 };
    vx_tensor bn4a_branch2a_b = vxCreateTensor(context, 2, dims_bn4a_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4a_branch2a_b);
    vx_size dims_scale4a_branch2a_w[2] = { 256, 1 };
    vx_tensor scale4a_branch2a_w = vxCreateTensor(context, 2, dims_scale4a_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4a_branch2a_w);
    vx_size dims_scale4a_branch2a_b[2] = { 256, 1 };
    vx_tensor scale4a_branch2a_b = vxCreateTensor(context, 2, dims_scale4a_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4a_branch2a_b);
    vx_size dims_res4a_branch2b_w[4] = { 3, 3, 256, 256 };
    vx_tensor res4a_branch2b_w = vxCreateTensor(context, 4, dims_res4a_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4a_branch2b_w);
    vx_size dims_bn4a_branch2b_w[2] = { 256, 1 };
    vx_tensor bn4a_branch2b_w = vxCreateTensor(context, 2, dims_bn4a_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4a_branch2b_w);
    vx_size dims_bn4a_branch2b_b[2] = { 256, 1 };
    vx_tensor bn4a_branch2b_b = vxCreateTensor(context, 2, dims_bn4a_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4a_branch2b_b);
    vx_size dims_scale4a_branch2b_w[2] = { 256, 1 };
    vx_tensor scale4a_branch2b_w = vxCreateTensor(context, 2, dims_scale4a_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4a_branch2b_w);
    vx_size dims_scale4a_branch2b_b[2] = { 256, 1 };
    vx_tensor scale4a_branch2b_b = vxCreateTensor(context, 2, dims_scale4a_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4a_branch2b_b);
    vx_size dims_res4a_branch2c_w[4] = { 1, 1, 256, 1024 };
    vx_tensor res4a_branch2c_w = vxCreateTensor(context, 4, dims_res4a_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4a_branch2c_w);
    vx_size dims_bn4a_branch2c_w[2] = { 1024, 1 };
    vx_tensor bn4a_branch2c_w = vxCreateTensor(context, 2, dims_bn4a_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4a_branch2c_w);
    vx_size dims_bn4a_branch2c_b[2] = { 1024, 1 };
    vx_tensor bn4a_branch2c_b = vxCreateTensor(context, 2, dims_bn4a_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4a_branch2c_b);
    vx_size dims_scale4a_branch2c_w[2] = { 1024, 1 };
    vx_tensor scale4a_branch2c_w = vxCreateTensor(context, 2, dims_scale4a_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4a_branch2c_w);
    vx_size dims_scale4a_branch2c_b[2] = { 1024, 1 };
    vx_tensor scale4a_branch2c_b = vxCreateTensor(context, 2, dims_scale4a_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4a_branch2c_b);
    vx_size dims_res4b_branch2a_w[4] = { 1, 1, 1024, 256 };
    vx_tensor res4b_branch2a_w = vxCreateTensor(context, 4, dims_res4b_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4b_branch2a_w);
    vx_size dims_bn4b_branch2a_w[2] = { 256, 1 };
    vx_tensor bn4b_branch2a_w = vxCreateTensor(context, 2, dims_bn4b_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4b_branch2a_w);
    vx_size dims_bn4b_branch2a_b[2] = { 256, 1 };
    vx_tensor bn4b_branch2a_b = vxCreateTensor(context, 2, dims_bn4b_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4b_branch2a_b);
    vx_size dims_scale4b_branch2a_w[2] = { 256, 1 };
    vx_tensor scale4b_branch2a_w = vxCreateTensor(context, 2, dims_scale4b_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4b_branch2a_w);
    vx_size dims_scale4b_branch2a_b[2] = { 256, 1 };
    vx_tensor scale4b_branch2a_b = vxCreateTensor(context, 2, dims_scale4b_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4b_branch2a_b);
    vx_size dims_res4b_branch2b_w[4] = { 3, 3, 256, 256 };
    vx_tensor res4b_branch2b_w = vxCreateTensor(context, 4, dims_res4b_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4b_branch2b_w);
    vx_size dims_bn4b_branch2b_w[2] = { 256, 1 };
    vx_tensor bn4b_branch2b_w = vxCreateTensor(context, 2, dims_bn4b_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4b_branch2b_w);
    vx_size dims_bn4b_branch2b_b[2] = { 256, 1 };
    vx_tensor bn4b_branch2b_b = vxCreateTensor(context, 2, dims_bn4b_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4b_branch2b_b);
    vx_size dims_scale4b_branch2b_w[2] = { 256, 1 };
    vx_tensor scale4b_branch2b_w = vxCreateTensor(context, 2, dims_scale4b_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4b_branch2b_w);
    vx_size dims_scale4b_branch2b_b[2] = { 256, 1 };
    vx_tensor scale4b_branch2b_b = vxCreateTensor(context, 2, dims_scale4b_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4b_branch2b_b);
    vx_size dims_res4b_branch2c_w[4] = { 1, 1, 256, 1024 };
    vx_tensor res4b_branch2c_w = vxCreateTensor(context, 4, dims_res4b_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4b_branch2c_w);
    vx_size dims_bn4b_branch2c_w[2] = { 1024, 1 };
    vx_tensor bn4b_branch2c_w = vxCreateTensor(context, 2, dims_bn4b_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4b_branch2c_w);
    vx_size dims_bn4b_branch2c_b[2] = { 1024, 1 };
    vx_tensor bn4b_branch2c_b = vxCreateTensor(context, 2, dims_bn4b_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4b_branch2c_b);
    vx_size dims_scale4b_branch2c_w[2] = { 1024, 1 };
    vx_tensor scale4b_branch2c_w = vxCreateTensor(context, 2, dims_scale4b_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4b_branch2c_w);
    vx_size dims_scale4b_branch2c_b[2] = { 1024, 1 };
    vx_tensor scale4b_branch2c_b = vxCreateTensor(context, 2, dims_scale4b_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4b_branch2c_b);
    vx_size dims_res4c_branch2a_w[4] = { 1, 1, 1024, 256 };
    vx_tensor res4c_branch2a_w = vxCreateTensor(context, 4, dims_res4c_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4c_branch2a_w);
    vx_size dims_bn4c_branch2a_w[2] = { 256, 1 };
    vx_tensor bn4c_branch2a_w = vxCreateTensor(context, 2, dims_bn4c_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4c_branch2a_w);
    vx_size dims_bn4c_branch2a_b[2] = { 256, 1 };
    vx_tensor bn4c_branch2a_b = vxCreateTensor(context, 2, dims_bn4c_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4c_branch2a_b);
    vx_size dims_scale4c_branch2a_w[2] = { 256, 1 };
    vx_tensor scale4c_branch2a_w = vxCreateTensor(context, 2, dims_scale4c_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4c_branch2a_w);
    vx_size dims_scale4c_branch2a_b[2] = { 256, 1 };
    vx_tensor scale4c_branch2a_b = vxCreateTensor(context, 2, dims_scale4c_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4c_branch2a_b);
    vx_size dims_res4c_branch2b_w[4] = { 3, 3, 256, 256 };
    vx_tensor res4c_branch2b_w = vxCreateTensor(context, 4, dims_res4c_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4c_branch2b_w);
    vx_size dims_bn4c_branch2b_w[2] = { 256, 1 };
    vx_tensor bn4c_branch2b_w = vxCreateTensor(context, 2, dims_bn4c_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4c_branch2b_w);
    vx_size dims_bn4c_branch2b_b[2] = { 256, 1 };
    vx_tensor bn4c_branch2b_b = vxCreateTensor(context, 2, dims_bn4c_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4c_branch2b_b);
    vx_size dims_scale4c_branch2b_w[2] = { 256, 1 };
    vx_tensor scale4c_branch2b_w = vxCreateTensor(context, 2, dims_scale4c_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4c_branch2b_w);
    vx_size dims_scale4c_branch2b_b[2] = { 256, 1 };
    vx_tensor scale4c_branch2b_b = vxCreateTensor(context, 2, dims_scale4c_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4c_branch2b_b);
    vx_size dims_res4c_branch2c_w[4] = { 1, 1, 256, 1024 };
    vx_tensor res4c_branch2c_w = vxCreateTensor(context, 4, dims_res4c_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4c_branch2c_w);
    vx_size dims_bn4c_branch2c_w[2] = { 1024, 1 };
    vx_tensor bn4c_branch2c_w = vxCreateTensor(context, 2, dims_bn4c_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4c_branch2c_w);
    vx_size dims_bn4c_branch2c_b[2] = { 1024, 1 };
    vx_tensor bn4c_branch2c_b = vxCreateTensor(context, 2, dims_bn4c_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4c_branch2c_b);
    vx_size dims_scale4c_branch2c_w[2] = { 1024, 1 };
    vx_tensor scale4c_branch2c_w = vxCreateTensor(context, 2, dims_scale4c_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4c_branch2c_w);
    vx_size dims_scale4c_branch2c_b[2] = { 1024, 1 };
    vx_tensor scale4c_branch2c_b = vxCreateTensor(context, 2, dims_scale4c_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4c_branch2c_b);
    vx_size dims_res4d_branch2a_w[4] = { 1, 1, 1024, 256 };
    vx_tensor res4d_branch2a_w = vxCreateTensor(context, 4, dims_res4d_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4d_branch2a_w);
    vx_size dims_bn4d_branch2a_w[2] = { 256, 1 };
    vx_tensor bn4d_branch2a_w = vxCreateTensor(context, 2, dims_bn4d_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4d_branch2a_w);
    vx_size dims_bn4d_branch2a_b[2] = { 256, 1 };
    vx_tensor bn4d_branch2a_b = vxCreateTensor(context, 2, dims_bn4d_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4d_branch2a_b);
    vx_size dims_scale4d_branch2a_w[2] = { 256, 1 };
    vx_tensor scale4d_branch2a_w = vxCreateTensor(context, 2, dims_scale4d_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4d_branch2a_w);
    vx_size dims_scale4d_branch2a_b[2] = { 256, 1 };
    vx_tensor scale4d_branch2a_b = vxCreateTensor(context, 2, dims_scale4d_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4d_branch2a_b);
    vx_size dims_res4d_branch2b_w[4] = { 3, 3, 256, 256 };
    vx_tensor res4d_branch2b_w = vxCreateTensor(context, 4, dims_res4d_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4d_branch2b_w);
    vx_size dims_bn4d_branch2b_w[2] = { 256, 1 };
    vx_tensor bn4d_branch2b_w = vxCreateTensor(context, 2, dims_bn4d_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4d_branch2b_w);
    vx_size dims_bn4d_branch2b_b[2] = { 256, 1 };
    vx_tensor bn4d_branch2b_b = vxCreateTensor(context, 2, dims_bn4d_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4d_branch2b_b);
    vx_size dims_scale4d_branch2b_w[2] = { 256, 1 };
    vx_tensor scale4d_branch2b_w = vxCreateTensor(context, 2, dims_scale4d_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4d_branch2b_w);
    vx_size dims_scale4d_branch2b_b[2] = { 256, 1 };
    vx_tensor scale4d_branch2b_b = vxCreateTensor(context, 2, dims_scale4d_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4d_branch2b_b);
    vx_size dims_res4d_branch2c_w[4] = { 1, 1, 256, 1024 };
    vx_tensor res4d_branch2c_w = vxCreateTensor(context, 4, dims_res4d_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4d_branch2c_w);
    vx_size dims_bn4d_branch2c_w[2] = { 1024, 1 };
    vx_tensor bn4d_branch2c_w = vxCreateTensor(context, 2, dims_bn4d_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4d_branch2c_w);
    vx_size dims_bn4d_branch2c_b[2] = { 1024, 1 };
    vx_tensor bn4d_branch2c_b = vxCreateTensor(context, 2, dims_bn4d_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4d_branch2c_b);
    vx_size dims_scale4d_branch2c_w[2] = { 1024, 1 };
    vx_tensor scale4d_branch2c_w = vxCreateTensor(context, 2, dims_scale4d_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4d_branch2c_w);
    vx_size dims_scale4d_branch2c_b[2] = { 1024, 1 };
    vx_tensor scale4d_branch2c_b = vxCreateTensor(context, 2, dims_scale4d_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4d_branch2c_b);
    vx_size dims_res4e_branch2a_w[4] = { 1, 1, 1024, 256 };
    vx_tensor res4e_branch2a_w = vxCreateTensor(context, 4, dims_res4e_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4e_branch2a_w);
    vx_size dims_bn4e_branch2a_w[2] = { 256, 1 };
    vx_tensor bn4e_branch2a_w = vxCreateTensor(context, 2, dims_bn4e_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4e_branch2a_w);
    vx_size dims_bn4e_branch2a_b[2] = { 256, 1 };
    vx_tensor bn4e_branch2a_b = vxCreateTensor(context, 2, dims_bn4e_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4e_branch2a_b);
    vx_size dims_scale4e_branch2a_w[2] = { 256, 1 };
    vx_tensor scale4e_branch2a_w = vxCreateTensor(context, 2, dims_scale4e_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4e_branch2a_w);
    vx_size dims_scale4e_branch2a_b[2] = { 256, 1 };
    vx_tensor scale4e_branch2a_b = vxCreateTensor(context, 2, dims_scale4e_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4e_branch2a_b);
    vx_size dims_res4e_branch2b_w[4] = { 3, 3, 256, 256 };
    vx_tensor res4e_branch2b_w = vxCreateTensor(context, 4, dims_res4e_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4e_branch2b_w);
    vx_size dims_bn4e_branch2b_w[2] = { 256, 1 };
    vx_tensor bn4e_branch2b_w = vxCreateTensor(context, 2, dims_bn4e_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4e_branch2b_w);
    vx_size dims_bn4e_branch2b_b[2] = { 256, 1 };
    vx_tensor bn4e_branch2b_b = vxCreateTensor(context, 2, dims_bn4e_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4e_branch2b_b);
    vx_size dims_scale4e_branch2b_w[2] = { 256, 1 };
    vx_tensor scale4e_branch2b_w = vxCreateTensor(context, 2, dims_scale4e_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4e_branch2b_w);
    vx_size dims_scale4e_branch2b_b[2] = { 256, 1 };
    vx_tensor scale4e_branch2b_b = vxCreateTensor(context, 2, dims_scale4e_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4e_branch2b_b);
    vx_size dims_res4e_branch2c_w[4] = { 1, 1, 256, 1024 };
    vx_tensor res4e_branch2c_w = vxCreateTensor(context, 4, dims_res4e_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4e_branch2c_w);
    vx_size dims_bn4e_branch2c_w[2] = { 1024, 1 };
    vx_tensor bn4e_branch2c_w = vxCreateTensor(context, 2, dims_bn4e_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4e_branch2c_w);
    vx_size dims_bn4e_branch2c_b[2] = { 1024, 1 };
    vx_tensor bn4e_branch2c_b = vxCreateTensor(context, 2, dims_bn4e_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4e_branch2c_b);
    vx_size dims_scale4e_branch2c_w[2] = { 1024, 1 };
    vx_tensor scale4e_branch2c_w = vxCreateTensor(context, 2, dims_scale4e_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4e_branch2c_w);
    vx_size dims_scale4e_branch2c_b[2] = { 1024, 1 };
    vx_tensor scale4e_branch2c_b = vxCreateTensor(context, 2, dims_scale4e_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4e_branch2c_b);
    vx_size dims_res4f_branch2a_w[4] = { 1, 1, 1024, 256 };
    vx_tensor res4f_branch2a_w = vxCreateTensor(context, 4, dims_res4f_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4f_branch2a_w);
    vx_size dims_bn4f_branch2a_w[2] = { 256, 1 };
    vx_tensor bn4f_branch2a_w = vxCreateTensor(context, 2, dims_bn4f_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4f_branch2a_w);
    vx_size dims_bn4f_branch2a_b[2] = { 256, 1 };
    vx_tensor bn4f_branch2a_b = vxCreateTensor(context, 2, dims_bn4f_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4f_branch2a_b);
    vx_size dims_scale4f_branch2a_w[2] = { 256, 1 };
    vx_tensor scale4f_branch2a_w = vxCreateTensor(context, 2, dims_scale4f_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4f_branch2a_w);
    vx_size dims_scale4f_branch2a_b[2] = { 256, 1 };
    vx_tensor scale4f_branch2a_b = vxCreateTensor(context, 2, dims_scale4f_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4f_branch2a_b);
    vx_size dims_res4f_branch2b_w[4] = { 3, 3, 256, 256 };
    vx_tensor res4f_branch2b_w = vxCreateTensor(context, 4, dims_res4f_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4f_branch2b_w);
    vx_size dims_bn4f_branch2b_w[2] = { 256, 1 };
    vx_tensor bn4f_branch2b_w = vxCreateTensor(context, 2, dims_bn4f_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4f_branch2b_w);
    vx_size dims_bn4f_branch2b_b[2] = { 256, 1 };
    vx_tensor bn4f_branch2b_b = vxCreateTensor(context, 2, dims_bn4f_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4f_branch2b_b);
    vx_size dims_scale4f_branch2b_w[2] = { 256, 1 };
    vx_tensor scale4f_branch2b_w = vxCreateTensor(context, 2, dims_scale4f_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4f_branch2b_w);
    vx_size dims_scale4f_branch2b_b[2] = { 256, 1 };
    vx_tensor scale4f_branch2b_b = vxCreateTensor(context, 2, dims_scale4f_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4f_branch2b_b);
    vx_size dims_res4f_branch2c_w[4] = { 1, 1, 256, 1024 };
    vx_tensor res4f_branch2c_w = vxCreateTensor(context, 4, dims_res4f_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res4f_branch2c_w);
    vx_size dims_bn4f_branch2c_w[2] = { 1024, 1 };
    vx_tensor bn4f_branch2c_w = vxCreateTensor(context, 2, dims_bn4f_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4f_branch2c_w);
    vx_size dims_bn4f_branch2c_b[2] = { 1024, 1 };
    vx_tensor bn4f_branch2c_b = vxCreateTensor(context, 2, dims_bn4f_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn4f_branch2c_b);
    vx_size dims_scale4f_branch2c_w[2] = { 1024, 1 };
    vx_tensor scale4f_branch2c_w = vxCreateTensor(context, 2, dims_scale4f_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4f_branch2c_w);
    vx_size dims_scale4f_branch2c_b[2] = { 1024, 1 };
    vx_tensor scale4f_branch2c_b = vxCreateTensor(context, 2, dims_scale4f_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale4f_branch2c_b);
    vx_size dims_res5a_branch1_w[4] = { 1, 1, 1024, 2048 };
    vx_tensor res5a_branch1_w = vxCreateTensor(context, 4, dims_res5a_branch1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res5a_branch1_w);
    vx_size dims_bn5a_branch1_w[2] = { 2048, 1 };
    vx_tensor bn5a_branch1_w = vxCreateTensor(context, 2, dims_bn5a_branch1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5a_branch1_w);
    vx_size dims_bn5a_branch1_b[2] = { 2048, 1 };
    vx_tensor bn5a_branch1_b = vxCreateTensor(context, 2, dims_bn5a_branch1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5a_branch1_b);
    vx_size dims_scale5a_branch1_w[2] = { 2048, 1 };
    vx_tensor scale5a_branch1_w = vxCreateTensor(context, 2, dims_scale5a_branch1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5a_branch1_w);
    vx_size dims_scale5a_branch1_b[2] = { 2048, 1 };
    vx_tensor scale5a_branch1_b = vxCreateTensor(context, 2, dims_scale5a_branch1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5a_branch1_b);
    vx_size dims_res5a_branch2a_w[4] = { 1, 1, 1024, 512 };
    vx_tensor res5a_branch2a_w = vxCreateTensor(context, 4, dims_res5a_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res5a_branch2a_w);
    vx_size dims_bn5a_branch2a_w[2] = { 512, 1 };
    vx_tensor bn5a_branch2a_w = vxCreateTensor(context, 2, dims_bn5a_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5a_branch2a_w);
    vx_size dims_bn5a_branch2a_b[2] = { 512, 1 };
    vx_tensor bn5a_branch2a_b = vxCreateTensor(context, 2, dims_bn5a_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5a_branch2a_b);
    vx_size dims_scale5a_branch2a_w[2] = { 512, 1 };
    vx_tensor scale5a_branch2a_w = vxCreateTensor(context, 2, dims_scale5a_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5a_branch2a_w);
    vx_size dims_scale5a_branch2a_b[2] = { 512, 1 };
    vx_tensor scale5a_branch2a_b = vxCreateTensor(context, 2, dims_scale5a_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5a_branch2a_b);
    vx_size dims_res5a_branch2b_w[4] = { 3, 3, 512, 512 };
    vx_tensor res5a_branch2b_w = vxCreateTensor(context, 4, dims_res5a_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res5a_branch2b_w);
    vx_size dims_bn5a_branch2b_w[2] = { 512, 1 };
    vx_tensor bn5a_branch2b_w = vxCreateTensor(context, 2, dims_bn5a_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5a_branch2b_w);
    vx_size dims_bn5a_branch2b_b[2] = { 512, 1 };
    vx_tensor bn5a_branch2b_b = vxCreateTensor(context, 2, dims_bn5a_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5a_branch2b_b);
    vx_size dims_scale5a_branch2b_w[2] = { 512, 1 };
    vx_tensor scale5a_branch2b_w = vxCreateTensor(context, 2, dims_scale5a_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5a_branch2b_w);
    vx_size dims_scale5a_branch2b_b[2] = { 512, 1 };
    vx_tensor scale5a_branch2b_b = vxCreateTensor(context, 2, dims_scale5a_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5a_branch2b_b);
    vx_size dims_res5a_branch2c_w[4] = { 1, 1, 512, 2048 };
    vx_tensor res5a_branch2c_w = vxCreateTensor(context, 4, dims_res5a_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res5a_branch2c_w);
    vx_size dims_bn5a_branch2c_w[2] = { 2048, 1 };
    vx_tensor bn5a_branch2c_w = vxCreateTensor(context, 2, dims_bn5a_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5a_branch2c_w);
    vx_size dims_bn5a_branch2c_b[2] = { 2048, 1 };
    vx_tensor bn5a_branch2c_b = vxCreateTensor(context, 2, dims_bn5a_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5a_branch2c_b);
    vx_size dims_scale5a_branch2c_w[2] = { 2048, 1 };
    vx_tensor scale5a_branch2c_w = vxCreateTensor(context, 2, dims_scale5a_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5a_branch2c_w);
    vx_size dims_scale5a_branch2c_b[2] = { 2048, 1 };
    vx_tensor scale5a_branch2c_b = vxCreateTensor(context, 2, dims_scale5a_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5a_branch2c_b);
    vx_size dims_res5b_branch2a_w[4] = { 1, 1, 2048, 512 };
    vx_tensor res5b_branch2a_w = vxCreateTensor(context, 4, dims_res5b_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res5b_branch2a_w);
    vx_size dims_bn5b_branch2a_w[2] = { 512, 1 };
    vx_tensor bn5b_branch2a_w = vxCreateTensor(context, 2, dims_bn5b_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5b_branch2a_w);
    vx_size dims_bn5b_branch2a_b[2] = { 512, 1 };
    vx_tensor bn5b_branch2a_b = vxCreateTensor(context, 2, dims_bn5b_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5b_branch2a_b);
    vx_size dims_scale5b_branch2a_w[2] = { 512, 1 };
    vx_tensor scale5b_branch2a_w = vxCreateTensor(context, 2, dims_scale5b_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5b_branch2a_w);
    vx_size dims_scale5b_branch2a_b[2] = { 512, 1 };
    vx_tensor scale5b_branch2a_b = vxCreateTensor(context, 2, dims_scale5b_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5b_branch2a_b);
    vx_size dims_res5b_branch2b_w[4] = { 3, 3, 512, 512 };
    vx_tensor res5b_branch2b_w = vxCreateTensor(context, 4, dims_res5b_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res5b_branch2b_w);
    vx_size dims_bn5b_branch2b_w[2] = { 512, 1 };
    vx_tensor bn5b_branch2b_w = vxCreateTensor(context, 2, dims_bn5b_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5b_branch2b_w);
    vx_size dims_bn5b_branch2b_b[2] = { 512, 1 };
    vx_tensor bn5b_branch2b_b = vxCreateTensor(context, 2, dims_bn5b_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5b_branch2b_b);
    vx_size dims_scale5b_branch2b_w[2] = { 512, 1 };
    vx_tensor scale5b_branch2b_w = vxCreateTensor(context, 2, dims_scale5b_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5b_branch2b_w);
    vx_size dims_scale5b_branch2b_b[2] = { 512, 1 };
    vx_tensor scale5b_branch2b_b = vxCreateTensor(context, 2, dims_scale5b_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5b_branch2b_b);
    vx_size dims_res5b_branch2c_w[4] = { 1, 1, 512, 2048 };
    vx_tensor res5b_branch2c_w = vxCreateTensor(context, 4, dims_res5b_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res5b_branch2c_w);
    vx_size dims_bn5b_branch2c_w[2] = { 2048, 1 };
    vx_tensor bn5b_branch2c_w = vxCreateTensor(context, 2, dims_bn5b_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5b_branch2c_w);
    vx_size dims_bn5b_branch2c_b[2] = { 2048, 1 };
    vx_tensor bn5b_branch2c_b = vxCreateTensor(context, 2, dims_bn5b_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5b_branch2c_b);
    vx_size dims_scale5b_branch2c_w[2] = { 2048, 1 };
    vx_tensor scale5b_branch2c_w = vxCreateTensor(context, 2, dims_scale5b_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5b_branch2c_w);
    vx_size dims_scale5b_branch2c_b[2] = { 2048, 1 };
    vx_tensor scale5b_branch2c_b = vxCreateTensor(context, 2, dims_scale5b_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5b_branch2c_b);
    vx_size dims_res5c_branch2a_w[4] = { 1, 1, 2048, 512 };
    vx_tensor res5c_branch2a_w = vxCreateTensor(context, 4, dims_res5c_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res5c_branch2a_w);
    vx_size dims_bn5c_branch2a_w[2] = { 512, 1 };
    vx_tensor bn5c_branch2a_w = vxCreateTensor(context, 2, dims_bn5c_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5c_branch2a_w);
    vx_size dims_bn5c_branch2a_b[2] = { 512, 1 };
    vx_tensor bn5c_branch2a_b = vxCreateTensor(context, 2, dims_bn5c_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5c_branch2a_b);
    vx_size dims_scale5c_branch2a_w[2] = { 512, 1 };
    vx_tensor scale5c_branch2a_w = vxCreateTensor(context, 2, dims_scale5c_branch2a_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5c_branch2a_w);
    vx_size dims_scale5c_branch2a_b[2] = { 512, 1 };
    vx_tensor scale5c_branch2a_b = vxCreateTensor(context, 2, dims_scale5c_branch2a_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5c_branch2a_b);
    vx_size dims_res5c_branch2b_w[4] = { 3, 3, 512, 512 };
    vx_tensor res5c_branch2b_w = vxCreateTensor(context, 4, dims_res5c_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res5c_branch2b_w);
    vx_size dims_bn5c_branch2b_w[2] = { 512, 1 };
    vx_tensor bn5c_branch2b_w = vxCreateTensor(context, 2, dims_bn5c_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5c_branch2b_w);
    vx_size dims_bn5c_branch2b_b[2] = { 512, 1 };
    vx_tensor bn5c_branch2b_b = vxCreateTensor(context, 2, dims_bn5c_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5c_branch2b_b);
    vx_size dims_scale5c_branch2b_w[2] = { 512, 1 };
    vx_tensor scale5c_branch2b_w = vxCreateTensor(context, 2, dims_scale5c_branch2b_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5c_branch2b_w);
    vx_size dims_scale5c_branch2b_b[2] = { 512, 1 };
    vx_tensor scale5c_branch2b_b = vxCreateTensor(context, 2, dims_scale5c_branch2b_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5c_branch2b_b);
    vx_size dims_res5c_branch2c_w[4] = { 1, 1, 512, 2048 };
    vx_tensor res5c_branch2c_w = vxCreateTensor(context, 4, dims_res5c_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(res5c_branch2c_w);
    vx_size dims_bn5c_branch2c_w[2] = { 2048, 1 };
    vx_tensor bn5c_branch2c_w = vxCreateTensor(context, 2, dims_bn5c_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5c_branch2c_w);
    vx_size dims_bn5c_branch2c_b[2] = { 2048, 1 };
    vx_tensor bn5c_branch2c_b = vxCreateTensor(context, 2, dims_bn5c_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(bn5c_branch2c_b);
    vx_size dims_scale5c_branch2c_w[2] = { 2048, 1 };
    vx_tensor scale5c_branch2c_w = vxCreateTensor(context, 2, dims_scale5c_branch2c_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5c_branch2c_w);
    vx_size dims_scale5c_branch2c_b[2] = { 2048, 1 };
    vx_tensor scale5c_branch2c_b = vxCreateTensor(context, 2, dims_scale5c_branch2c_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(scale5c_branch2c_b);
    vx_size dims_fc1000_w[4] = { 1, 1, 2048, 1000 };
    vx_tensor fc1000_w = vxCreateTensor(context, 4, dims_fc1000_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(fc1000_w);
    vx_size dims_fc1000_b[2] = { 1000, 1 };
    vx_tensor fc1000_b = vxCreateTensor(context, 2, dims_fc1000_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(fc1000_b);

    // initialize variables
    FILE * fp__variables = fopen(binaryFilename, "rb");
    if(!fp__variables) {
        vxAddLogEntry((vx_reference)context, VX_FAILURE, "ERROR: unable to open: %s\n", binaryFilename);
        return VX_FAILURE;
    }
    { vx_uint32 magic = 0;
      fread(&magic, 1, sizeof(magic), fp__variables);
      if(magic != 0xf00dd1e0) {
        vxAddLogEntry((vx_reference)context, VX_FAILURE, "ERROR: invalid file magic in %s\n", binaryFilename);
        return VX_FAILURE;
      }
    }
    ERROR_CHECK_STATUS(initializeTensor(context, conv1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn_conv1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn_conv1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale_conv1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale_conv1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res2a_branch1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2a_branch1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2a_branch1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2a_branch1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2a_branch1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res2a_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2a_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2a_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2a_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2a_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res2a_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2a_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2a_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2a_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2a_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res2a_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2a_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2a_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2a_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2a_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res2b_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2b_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2b_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2b_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2b_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res2b_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2b_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2b_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2b_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2b_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res2b_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2b_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2b_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2b_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2b_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res2c_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2c_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2c_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2c_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2c_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res2c_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2c_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2c_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2c_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2c_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res2c_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2c_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn2c_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2c_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale2c_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res3a_branch1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3a_branch1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3a_branch1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3a_branch1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3a_branch1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res3a_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3a_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3a_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3a_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3a_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res3a_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3a_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3a_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3a_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3a_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res3a_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3a_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3a_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3a_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3a_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res3b_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3b_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3b_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3b_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3b_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res3b_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3b_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3b_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3b_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3b_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res3b_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3b_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3b_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3b_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3b_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res3c_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3c_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3c_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3c_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3c_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res3c_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3c_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3c_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3c_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3c_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res3c_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3c_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3c_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3c_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3c_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res3d_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3d_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3d_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3d_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3d_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res3d_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3d_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3d_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3d_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3d_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res3d_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3d_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn3d_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3d_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale3d_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4a_branch1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4a_branch1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4a_branch1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4a_branch1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4a_branch1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4a_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4a_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4a_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4a_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4a_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4a_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4a_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4a_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4a_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4a_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4a_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4a_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4a_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4a_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4a_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4b_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4b_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4b_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4b_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4b_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4b_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4b_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4b_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4b_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4b_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4b_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4b_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4b_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4b_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4b_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4c_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4c_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4c_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4c_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4c_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4c_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4c_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4c_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4c_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4c_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4c_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4c_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4c_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4c_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4c_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4d_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4d_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4d_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4d_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4d_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4d_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4d_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4d_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4d_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4d_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4d_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4d_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4d_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4d_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4d_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4e_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4e_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4e_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4e_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4e_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4e_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4e_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4e_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4e_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4e_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4e_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4e_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4e_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4e_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4e_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4f_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4f_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4f_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4f_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4f_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4f_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4f_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4f_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4f_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4f_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res4f_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4f_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn4f_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4f_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale4f_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res5a_branch1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5a_branch1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5a_branch1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5a_branch1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5a_branch1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res5a_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5a_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5a_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5a_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5a_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res5a_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5a_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5a_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5a_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5a_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res5a_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5a_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5a_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5a_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5a_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res5b_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5b_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5b_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5b_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5b_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res5b_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5b_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5b_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5b_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5b_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res5b_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5b_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5b_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5b_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5b_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res5c_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5c_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5c_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5c_branch2a_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5c_branch2a_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res5c_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5c_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5c_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5c_branch2b_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5c_branch2b_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, res5c_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5c_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, bn5c_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5c_branch2c_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, scale5c_branch2c_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, fc1000_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, fc1000_b, fp__variables, binaryFilename));
    { vx_uint32 magic = 0;
      fread(&magic, 1, sizeof(magic), fp__variables);
      if(magic != 0xf00dd1e2) {
        vxAddLogEntry((vx_reference)context, VX_FAILURE, "ERROR: invalid eoff magic in %s\n", binaryFilename);
        return VX_FAILURE;
      }
      fclose(fp__variables);
    }

    // create local tensors used in graph
    vx_size dims_conv_conv1[4] = { 112, 112, 64, 1 };
    vx_tensor conv_conv1 = vxCreateVirtualTensor(graph, 4, dims_conv_conv1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv1);
    vx_size dims_batch_norm_scale_conv1[4] = { 112, 112, 64, 1 };
    vx_tensor batch_norm_scale_conv1 = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale_conv1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale_conv1);
    vx_size dims_relu_conv1_relu[4] = { 112, 112, 64, 1 };
    vx_tensor relu_conv1_relu = vxCreateVirtualTensor(graph, 4, dims_relu_conv1_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_conv1_relu);
    vx_size dims_max_pool_pool1[4] = { 56, 56, 64, 1 };
    vx_tensor max_pool_pool1 = vxCreateVirtualTensor(graph, 4, dims_max_pool_pool1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_pool1);
    vx_size dims_conv_res2a_branch1[4] = { 56, 56, 256, 1 };
    vx_tensor conv_res2a_branch1 = vxCreateVirtualTensor(graph, 4, dims_conv_res2a_branch1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res2a_branch1);
    vx_size dims_batch_norm_scale2a_branch1[4] = { 56, 56, 256, 1 };
    vx_tensor batch_norm_scale2a_branch1 = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale2a_branch1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale2a_branch1);
    vx_size dims_conv_res2a_branch2a[4] = { 56, 56, 64, 1 };
    vx_tensor conv_res2a_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res2a_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res2a_branch2a);
    vx_size dims_batch_norm_scale2a_branch2a[4] = { 56, 56, 64, 1 };
    vx_tensor batch_norm_scale2a_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale2a_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale2a_branch2a);
    vx_size dims_relu_res2a_branch2a_relu[4] = { 56, 56, 64, 1 };
    vx_tensor relu_res2a_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res2a_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res2a_branch2a_relu);
    vx_size dims_conv_res2a_branch2b[4] = { 56, 56, 64, 1 };
    vx_tensor conv_res2a_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res2a_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res2a_branch2b);
    vx_size dims_batch_norm_scale2a_branch2b[4] = { 56, 56, 64, 1 };
    vx_tensor batch_norm_scale2a_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale2a_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale2a_branch2b);
    vx_size dims_relu_res2a_branch2b_relu[4] = { 56, 56, 64, 1 };
    vx_tensor relu_res2a_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res2a_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res2a_branch2b_relu);
    vx_size dims_conv_res2a_branch2c[4] = { 56, 56, 256, 1 };
    vx_tensor conv_res2a_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res2a_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res2a_branch2c);
    vx_size dims_batch_norm_scale2a_branch2c[4] = { 56, 56, 256, 1 };
    vx_tensor batch_norm_scale2a_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale2a_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale2a_branch2c);
    vx_size dims_sum_res2a[4] = { 56, 56, 256, 1 };
    vx_tensor sum_res2a = vxCreateVirtualTensor(graph, 4, dims_sum_res2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res2a);
    vx_size dims_relu_res2a_relu[4] = { 56, 56, 256, 1 };
    vx_tensor relu_res2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res2a_relu);
    vx_size dims_conv_res2b_branch2a[4] = { 56, 56, 64, 1 };
    vx_tensor conv_res2b_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res2b_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res2b_branch2a);
    vx_size dims_batch_norm_scale2b_branch2a[4] = { 56, 56, 64, 1 };
    vx_tensor batch_norm_scale2b_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale2b_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale2b_branch2a);
    vx_size dims_relu_res2b_branch2a_relu[4] = { 56, 56, 64, 1 };
    vx_tensor relu_res2b_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res2b_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res2b_branch2a_relu);
    vx_size dims_conv_res2b_branch2b[4] = { 56, 56, 64, 1 };
    vx_tensor conv_res2b_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res2b_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res2b_branch2b);
    vx_size dims_batch_norm_scale2b_branch2b[4] = { 56, 56, 64, 1 };
    vx_tensor batch_norm_scale2b_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale2b_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale2b_branch2b);
    vx_size dims_relu_res2b_branch2b_relu[4] = { 56, 56, 64, 1 };
    vx_tensor relu_res2b_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res2b_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res2b_branch2b_relu);
    vx_size dims_conv_res2b_branch2c[4] = { 56, 56, 256, 1 };
    vx_tensor conv_res2b_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res2b_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res2b_branch2c);
    vx_size dims_batch_norm_scale2b_branch2c[4] = { 56, 56, 256, 1 };
    vx_tensor batch_norm_scale2b_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale2b_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale2b_branch2c);
    vx_size dims_sum_res2b[4] = { 56, 56, 256, 1 };
    vx_tensor sum_res2b = vxCreateVirtualTensor(graph, 4, dims_sum_res2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res2b);
    vx_size dims_relu_res2b_relu[4] = { 56, 56, 256, 1 };
    vx_tensor relu_res2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res2b_relu);
    vx_size dims_conv_res2c_branch2a[4] = { 56, 56, 64, 1 };
    vx_tensor conv_res2c_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res2c_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res2c_branch2a);
    vx_size dims_batch_norm_scale2c_branch2a[4] = { 56, 56, 64, 1 };
    vx_tensor batch_norm_scale2c_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale2c_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale2c_branch2a);
    vx_size dims_relu_res2c_branch2a_relu[4] = { 56, 56, 64, 1 };
    vx_tensor relu_res2c_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res2c_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res2c_branch2a_relu);
    vx_size dims_conv_res2c_branch2b[4] = { 56, 56, 64, 1 };
    vx_tensor conv_res2c_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res2c_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res2c_branch2b);
    vx_size dims_batch_norm_scale2c_branch2b[4] = { 56, 56, 64, 1 };
    vx_tensor batch_norm_scale2c_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale2c_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale2c_branch2b);
    vx_size dims_relu_res2c_branch2b_relu[4] = { 56, 56, 64, 1 };
    vx_tensor relu_res2c_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res2c_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res2c_branch2b_relu);
    vx_size dims_conv_res2c_branch2c[4] = { 56, 56, 256, 1 };
    vx_tensor conv_res2c_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res2c_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res2c_branch2c);
    vx_size dims_batch_norm_scale2c_branch2c[4] = { 56, 56, 256, 1 };
    vx_tensor batch_norm_scale2c_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale2c_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale2c_branch2c);
    vx_size dims_sum_res2c[4] = { 56, 56, 256, 1 };
    vx_tensor sum_res2c = vxCreateVirtualTensor(graph, 4, dims_sum_res2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res2c);
    vx_size dims_relu_res2c_relu[4] = { 56, 56, 256, 1 };
    vx_tensor relu_res2c_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res2c_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res2c_relu);
    vx_size dims_conv_res3a_branch1[4] = { 28, 28, 512, 1 };
    vx_tensor conv_res3a_branch1 = vxCreateVirtualTensor(graph, 4, dims_conv_res3a_branch1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res3a_branch1);
    vx_size dims_batch_norm_scale3a_branch1[4] = { 28, 28, 512, 1 };
    vx_tensor batch_norm_scale3a_branch1 = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale3a_branch1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale3a_branch1);
    vx_size dims_conv_res3a_branch2a[4] = { 28, 28, 128, 1 };
    vx_tensor conv_res3a_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res3a_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res3a_branch2a);
    vx_size dims_batch_norm_scale3a_branch2a[4] = { 28, 28, 128, 1 };
    vx_tensor batch_norm_scale3a_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale3a_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale3a_branch2a);
    vx_size dims_relu_res3a_branch2a_relu[4] = { 28, 28, 128, 1 };
    vx_tensor relu_res3a_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res3a_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res3a_branch2a_relu);
    vx_size dims_conv_res3a_branch2b[4] = { 28, 28, 128, 1 };
    vx_tensor conv_res3a_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res3a_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res3a_branch2b);
    vx_size dims_batch_norm_scale3a_branch2b[4] = { 28, 28, 128, 1 };
    vx_tensor batch_norm_scale3a_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale3a_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale3a_branch2b);
    vx_size dims_relu_res3a_branch2b_relu[4] = { 28, 28, 128, 1 };
    vx_tensor relu_res3a_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res3a_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res3a_branch2b_relu);
    vx_size dims_conv_res3a_branch2c[4] = { 28, 28, 512, 1 };
    vx_tensor conv_res3a_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res3a_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res3a_branch2c);
    vx_size dims_batch_norm_scale3a_branch2c[4] = { 28, 28, 512, 1 };
    vx_tensor batch_norm_scale3a_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale3a_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale3a_branch2c);
    vx_size dims_sum_res3a[4] = { 28, 28, 512, 1 };
    vx_tensor sum_res3a = vxCreateVirtualTensor(graph, 4, dims_sum_res3a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res3a);
    vx_size dims_relu_res3a_relu[4] = { 28, 28, 512, 1 };
    vx_tensor relu_res3a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res3a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res3a_relu);
    vx_size dims_conv_res3b_branch2a[4] = { 28, 28, 128, 1 };
    vx_tensor conv_res3b_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res3b_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res3b_branch2a);
    vx_size dims_batch_norm_scale3b_branch2a[4] = { 28, 28, 128, 1 };
    vx_tensor batch_norm_scale3b_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale3b_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale3b_branch2a);
    vx_size dims_relu_res3b_branch2a_relu[4] = { 28, 28, 128, 1 };
    vx_tensor relu_res3b_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res3b_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res3b_branch2a_relu);
    vx_size dims_conv_res3b_branch2b[4] = { 28, 28, 128, 1 };
    vx_tensor conv_res3b_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res3b_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res3b_branch2b);
    vx_size dims_batch_norm_scale3b_branch2b[4] = { 28, 28, 128, 1 };
    vx_tensor batch_norm_scale3b_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale3b_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale3b_branch2b);
    vx_size dims_relu_res3b_branch2b_relu[4] = { 28, 28, 128, 1 };
    vx_tensor relu_res3b_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res3b_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res3b_branch2b_relu);
    vx_size dims_conv_res3b_branch2c[4] = { 28, 28, 512, 1 };
    vx_tensor conv_res3b_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res3b_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res3b_branch2c);
    vx_size dims_batch_norm_scale3b_branch2c[4] = { 28, 28, 512, 1 };
    vx_tensor batch_norm_scale3b_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale3b_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale3b_branch2c);
    vx_size dims_sum_res3b[4] = { 28, 28, 512, 1 };
    vx_tensor sum_res3b = vxCreateVirtualTensor(graph, 4, dims_sum_res3b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res3b);
    vx_size dims_relu_res3b_relu[4] = { 28, 28, 512, 1 };
    vx_tensor relu_res3b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res3b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res3b_relu);
    vx_size dims_conv_res3c_branch2a[4] = { 28, 28, 128, 1 };
    vx_tensor conv_res3c_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res3c_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res3c_branch2a);
    vx_size dims_batch_norm_scale3c_branch2a[4] = { 28, 28, 128, 1 };
    vx_tensor batch_norm_scale3c_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale3c_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale3c_branch2a);
    vx_size dims_relu_res3c_branch2a_relu[4] = { 28, 28, 128, 1 };
    vx_tensor relu_res3c_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res3c_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res3c_branch2a_relu);
    vx_size dims_conv_res3c_branch2b[4] = { 28, 28, 128, 1 };
    vx_tensor conv_res3c_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res3c_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res3c_branch2b);
    vx_size dims_batch_norm_scale3c_branch2b[4] = { 28, 28, 128, 1 };
    vx_tensor batch_norm_scale3c_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale3c_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale3c_branch2b);
    vx_size dims_relu_res3c_branch2b_relu[4] = { 28, 28, 128, 1 };
    vx_tensor relu_res3c_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res3c_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res3c_branch2b_relu);
    vx_size dims_conv_res3c_branch2c[4] = { 28, 28, 512, 1 };
    vx_tensor conv_res3c_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res3c_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res3c_branch2c);
    vx_size dims_batch_norm_scale3c_branch2c[4] = { 28, 28, 512, 1 };
    vx_tensor batch_norm_scale3c_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale3c_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale3c_branch2c);
    vx_size dims_sum_res3c[4] = { 28, 28, 512, 1 };
    vx_tensor sum_res3c = vxCreateVirtualTensor(graph, 4, dims_sum_res3c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res3c);
    vx_size dims_relu_res3c_relu[4] = { 28, 28, 512, 1 };
    vx_tensor relu_res3c_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res3c_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res3c_relu);
    vx_size dims_conv_res3d_branch2a[4] = { 28, 28, 128, 1 };
    vx_tensor conv_res3d_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res3d_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res3d_branch2a);
    vx_size dims_batch_norm_scale3d_branch2a[4] = { 28, 28, 128, 1 };
    vx_tensor batch_norm_scale3d_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale3d_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale3d_branch2a);
    vx_size dims_relu_res3d_branch2a_relu[4] = { 28, 28, 128, 1 };
    vx_tensor relu_res3d_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res3d_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res3d_branch2a_relu);
    vx_size dims_conv_res3d_branch2b[4] = { 28, 28, 128, 1 };
    vx_tensor conv_res3d_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res3d_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res3d_branch2b);
    vx_size dims_batch_norm_scale3d_branch2b[4] = { 28, 28, 128, 1 };
    vx_tensor batch_norm_scale3d_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale3d_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale3d_branch2b);
    vx_size dims_relu_res3d_branch2b_relu[4] = { 28, 28, 128, 1 };
    vx_tensor relu_res3d_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res3d_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res3d_branch2b_relu);
    vx_size dims_conv_res3d_branch2c[4] = { 28, 28, 512, 1 };
    vx_tensor conv_res3d_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res3d_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res3d_branch2c);
    vx_size dims_batch_norm_scale3d_branch2c[4] = { 28, 28, 512, 1 };
    vx_tensor batch_norm_scale3d_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale3d_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale3d_branch2c);
    vx_size dims_sum_res3d[4] = { 28, 28, 512, 1 };
    vx_tensor sum_res3d = vxCreateVirtualTensor(graph, 4, dims_sum_res3d, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res3d);
    vx_size dims_relu_res3d_relu[4] = { 28, 28, 512, 1 };
    vx_tensor relu_res3d_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res3d_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res3d_relu);
    vx_size dims_conv_res4a_branch1[4] = { 14, 14, 1024, 1 };
    vx_tensor conv_res4a_branch1 = vxCreateVirtualTensor(graph, 4, dims_conv_res4a_branch1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4a_branch1);
    vx_size dims_batch_norm_scale4a_branch1[4] = { 14, 14, 1024, 1 };
    vx_tensor batch_norm_scale4a_branch1 = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4a_branch1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4a_branch1);
    vx_size dims_conv_res4a_branch2a[4] = { 14, 14, 256, 1 };
    vx_tensor conv_res4a_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res4a_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4a_branch2a);
    vx_size dims_batch_norm_scale4a_branch2a[4] = { 14, 14, 256, 1 };
    vx_tensor batch_norm_scale4a_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4a_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4a_branch2a);
    vx_size dims_relu_res4a_branch2a_relu[4] = { 14, 14, 256, 1 };
    vx_tensor relu_res4a_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4a_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4a_branch2a_relu);
    vx_size dims_conv_res4a_branch2b[4] = { 14, 14, 256, 1 };
    vx_tensor conv_res4a_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res4a_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4a_branch2b);
    vx_size dims_batch_norm_scale4a_branch2b[4] = { 14, 14, 256, 1 };
    vx_tensor batch_norm_scale4a_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4a_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4a_branch2b);
    vx_size dims_relu_res4a_branch2b_relu[4] = { 14, 14, 256, 1 };
    vx_tensor relu_res4a_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4a_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4a_branch2b_relu);
    vx_size dims_conv_res4a_branch2c[4] = { 14, 14, 1024, 1 };
    vx_tensor conv_res4a_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res4a_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4a_branch2c);
    vx_size dims_batch_norm_scale4a_branch2c[4] = { 14, 14, 1024, 1 };
    vx_tensor batch_norm_scale4a_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4a_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4a_branch2c);
    vx_size dims_sum_res4a[4] = { 14, 14, 1024, 1 };
    vx_tensor sum_res4a = vxCreateVirtualTensor(graph, 4, dims_sum_res4a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res4a);
    vx_size dims_relu_res4a_relu[4] = { 14, 14, 1024, 1 };
    vx_tensor relu_res4a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4a_relu);
    vx_size dims_conv_res4b_branch2a[4] = { 14, 14, 256, 1 };
    vx_tensor conv_res4b_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res4b_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4b_branch2a);
    vx_size dims_batch_norm_scale4b_branch2a[4] = { 14, 14, 256, 1 };
    vx_tensor batch_norm_scale4b_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4b_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4b_branch2a);
    vx_size dims_relu_res4b_branch2a_relu[4] = { 14, 14, 256, 1 };
    vx_tensor relu_res4b_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4b_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4b_branch2a_relu);
    vx_size dims_conv_res4b_branch2b[4] = { 14, 14, 256, 1 };
    vx_tensor conv_res4b_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res4b_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4b_branch2b);
    vx_size dims_batch_norm_scale4b_branch2b[4] = { 14, 14, 256, 1 };
    vx_tensor batch_norm_scale4b_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4b_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4b_branch2b);
    vx_size dims_relu_res4b_branch2b_relu[4] = { 14, 14, 256, 1 };
    vx_tensor relu_res4b_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4b_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4b_branch2b_relu);
    vx_size dims_conv_res4b_branch2c[4] = { 14, 14, 1024, 1 };
    vx_tensor conv_res4b_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res4b_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4b_branch2c);
    vx_size dims_batch_norm_scale4b_branch2c[4] = { 14, 14, 1024, 1 };
    vx_tensor batch_norm_scale4b_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4b_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4b_branch2c);
    vx_size dims_sum_res4b[4] = { 14, 14, 1024, 1 };
    vx_tensor sum_res4b = vxCreateVirtualTensor(graph, 4, dims_sum_res4b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res4b);
    vx_size dims_relu_res4b_relu[4] = { 14, 14, 1024, 1 };
    vx_tensor relu_res4b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4b_relu);
    vx_size dims_conv_res4c_branch2a[4] = { 14, 14, 256, 1 };
    vx_tensor conv_res4c_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res4c_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4c_branch2a);
    vx_size dims_batch_norm_scale4c_branch2a[4] = { 14, 14, 256, 1 };
    vx_tensor batch_norm_scale4c_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4c_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4c_branch2a);
    vx_size dims_relu_res4c_branch2a_relu[4] = { 14, 14, 256, 1 };
    vx_tensor relu_res4c_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4c_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4c_branch2a_relu);
    vx_size dims_conv_res4c_branch2b[4] = { 14, 14, 256, 1 };
    vx_tensor conv_res4c_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res4c_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4c_branch2b);
    vx_size dims_batch_norm_scale4c_branch2b[4] = { 14, 14, 256, 1 };
    vx_tensor batch_norm_scale4c_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4c_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4c_branch2b);
    vx_size dims_relu_res4c_branch2b_relu[4] = { 14, 14, 256, 1 };
    vx_tensor relu_res4c_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4c_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4c_branch2b_relu);
    vx_size dims_conv_res4c_branch2c[4] = { 14, 14, 1024, 1 };
    vx_tensor conv_res4c_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res4c_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4c_branch2c);
    vx_size dims_batch_norm_scale4c_branch2c[4] = { 14, 14, 1024, 1 };
    vx_tensor batch_norm_scale4c_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4c_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4c_branch2c);
    vx_size dims_sum_res4c[4] = { 14, 14, 1024, 1 };
    vx_tensor sum_res4c = vxCreateVirtualTensor(graph, 4, dims_sum_res4c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res4c);
    vx_size dims_relu_res4c_relu[4] = { 14, 14, 1024, 1 };
    vx_tensor relu_res4c_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4c_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4c_relu);
    vx_size dims_conv_res4d_branch2a[4] = { 14, 14, 256, 1 };
    vx_tensor conv_res4d_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res4d_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4d_branch2a);
    vx_size dims_batch_norm_scale4d_branch2a[4] = { 14, 14, 256, 1 };
    vx_tensor batch_norm_scale4d_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4d_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4d_branch2a);
    vx_size dims_relu_res4d_branch2a_relu[4] = { 14, 14, 256, 1 };
    vx_tensor relu_res4d_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4d_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4d_branch2a_relu);
    vx_size dims_conv_res4d_branch2b[4] = { 14, 14, 256, 1 };
    vx_tensor conv_res4d_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res4d_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4d_branch2b);
    vx_size dims_batch_norm_scale4d_branch2b[4] = { 14, 14, 256, 1 };
    vx_tensor batch_norm_scale4d_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4d_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4d_branch2b);
    vx_size dims_relu_res4d_branch2b_relu[4] = { 14, 14, 256, 1 };
    vx_tensor relu_res4d_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4d_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4d_branch2b_relu);
    vx_size dims_conv_res4d_branch2c[4] = { 14, 14, 1024, 1 };
    vx_tensor conv_res4d_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res4d_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4d_branch2c);
    vx_size dims_batch_norm_scale4d_branch2c[4] = { 14, 14, 1024, 1 };
    vx_tensor batch_norm_scale4d_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4d_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4d_branch2c);
    vx_size dims_sum_res4d[4] = { 14, 14, 1024, 1 };
    vx_tensor sum_res4d = vxCreateVirtualTensor(graph, 4, dims_sum_res4d, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res4d);
    vx_size dims_relu_res4d_relu[4] = { 14, 14, 1024, 1 };
    vx_tensor relu_res4d_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4d_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4d_relu);
    vx_size dims_conv_res4e_branch2a[4] = { 14, 14, 256, 1 };
    vx_tensor conv_res4e_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res4e_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4e_branch2a);
    vx_size dims_batch_norm_scale4e_branch2a[4] = { 14, 14, 256, 1 };
    vx_tensor batch_norm_scale4e_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4e_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4e_branch2a);
    vx_size dims_relu_res4e_branch2a_relu[4] = { 14, 14, 256, 1 };
    vx_tensor relu_res4e_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4e_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4e_branch2a_relu);
    vx_size dims_conv_res4e_branch2b[4] = { 14, 14, 256, 1 };
    vx_tensor conv_res4e_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res4e_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4e_branch2b);
    vx_size dims_batch_norm_scale4e_branch2b[4] = { 14, 14, 256, 1 };
    vx_tensor batch_norm_scale4e_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4e_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4e_branch2b);
    vx_size dims_relu_res4e_branch2b_relu[4] = { 14, 14, 256, 1 };
    vx_tensor relu_res4e_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4e_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4e_branch2b_relu);
    vx_size dims_conv_res4e_branch2c[4] = { 14, 14, 1024, 1 };
    vx_tensor conv_res4e_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res4e_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4e_branch2c);
    vx_size dims_batch_norm_scale4e_branch2c[4] = { 14, 14, 1024, 1 };
    vx_tensor batch_norm_scale4e_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4e_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4e_branch2c);
    vx_size dims_sum_res4e[4] = { 14, 14, 1024, 1 };
    vx_tensor sum_res4e = vxCreateVirtualTensor(graph, 4, dims_sum_res4e, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res4e);
    vx_size dims_relu_res4e_relu[4] = { 14, 14, 1024, 1 };
    vx_tensor relu_res4e_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4e_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4e_relu);
    vx_size dims_conv_res4f_branch2a[4] = { 14, 14, 256, 1 };
    vx_tensor conv_res4f_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res4f_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4f_branch2a);
    vx_size dims_batch_norm_scale4f_branch2a[4] = { 14, 14, 256, 1 };
    vx_tensor batch_norm_scale4f_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4f_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4f_branch2a);
    vx_size dims_relu_res4f_branch2a_relu[4] = { 14, 14, 256, 1 };
    vx_tensor relu_res4f_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4f_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4f_branch2a_relu);
    vx_size dims_conv_res4f_branch2b[4] = { 14, 14, 256, 1 };
    vx_tensor conv_res4f_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res4f_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4f_branch2b);
    vx_size dims_batch_norm_scale4f_branch2b[4] = { 14, 14, 256, 1 };
    vx_tensor batch_norm_scale4f_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4f_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4f_branch2b);
    vx_size dims_relu_res4f_branch2b_relu[4] = { 14, 14, 256, 1 };
    vx_tensor relu_res4f_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4f_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4f_branch2b_relu);
    vx_size dims_conv_res4f_branch2c[4] = { 14, 14, 1024, 1 };
    vx_tensor conv_res4f_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res4f_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res4f_branch2c);
    vx_size dims_batch_norm_scale4f_branch2c[4] = { 14, 14, 1024, 1 };
    vx_tensor batch_norm_scale4f_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale4f_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale4f_branch2c);
    vx_size dims_sum_res4f[4] = { 14, 14, 1024, 1 };
    vx_tensor sum_res4f = vxCreateVirtualTensor(graph, 4, dims_sum_res4f, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res4f);
    vx_size dims_relu_res4f_relu[4] = { 14, 14, 1024, 1 };
    vx_tensor relu_res4f_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res4f_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res4f_relu);
    vx_size dims_conv_res5a_branch1[4] = { 7, 7, 2048, 1 };
    vx_tensor conv_res5a_branch1 = vxCreateVirtualTensor(graph, 4, dims_conv_res5a_branch1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res5a_branch1);
    vx_size dims_batch_norm_scale5a_branch1[4] = { 7, 7, 2048, 1 };
    vx_tensor batch_norm_scale5a_branch1 = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale5a_branch1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale5a_branch1);
    vx_size dims_conv_res5a_branch2a[4] = { 7, 7, 512, 1 };
    vx_tensor conv_res5a_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res5a_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res5a_branch2a);
    vx_size dims_batch_norm_scale5a_branch2a[4] = { 7, 7, 512, 1 };
    vx_tensor batch_norm_scale5a_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale5a_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale5a_branch2a);
    vx_size dims_relu_res5a_branch2a_relu[4] = { 7, 7, 512, 1 };
    vx_tensor relu_res5a_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res5a_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res5a_branch2a_relu);
    vx_size dims_conv_res5a_branch2b[4] = { 7, 7, 512, 1 };
    vx_tensor conv_res5a_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res5a_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res5a_branch2b);
    vx_size dims_batch_norm_scale5a_branch2b[4] = { 7, 7, 512, 1 };
    vx_tensor batch_norm_scale5a_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale5a_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale5a_branch2b);
    vx_size dims_relu_res5a_branch2b_relu[4] = { 7, 7, 512, 1 };
    vx_tensor relu_res5a_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res5a_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res5a_branch2b_relu);
    vx_size dims_conv_res5a_branch2c[4] = { 7, 7, 2048, 1 };
    vx_tensor conv_res5a_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res5a_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res5a_branch2c);
    vx_size dims_batch_norm_scale5a_branch2c[4] = { 7, 7, 2048, 1 };
    vx_tensor batch_norm_scale5a_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale5a_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale5a_branch2c);
    vx_size dims_sum_res5a[4] = { 7, 7, 2048, 1 };
    vx_tensor sum_res5a = vxCreateVirtualTensor(graph, 4, dims_sum_res5a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res5a);
    vx_size dims_relu_res5a_relu[4] = { 7, 7, 2048, 1 };
    vx_tensor relu_res5a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res5a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res5a_relu);
    vx_size dims_conv_res5b_branch2a[4] = { 7, 7, 512, 1 };
    vx_tensor conv_res5b_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res5b_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res5b_branch2a);
    vx_size dims_batch_norm_scale5b_branch2a[4] = { 7, 7, 512, 1 };
    vx_tensor batch_norm_scale5b_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale5b_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale5b_branch2a);
    vx_size dims_relu_res5b_branch2a_relu[4] = { 7, 7, 512, 1 };
    vx_tensor relu_res5b_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res5b_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res5b_branch2a_relu);
    vx_size dims_conv_res5b_branch2b[4] = { 7, 7, 512, 1 };
    vx_tensor conv_res5b_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res5b_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res5b_branch2b);
    vx_size dims_batch_norm_scale5b_branch2b[4] = { 7, 7, 512, 1 };
    vx_tensor batch_norm_scale5b_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale5b_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale5b_branch2b);
    vx_size dims_relu_res5b_branch2b_relu[4] = { 7, 7, 512, 1 };
    vx_tensor relu_res5b_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res5b_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res5b_branch2b_relu);
    vx_size dims_conv_res5b_branch2c[4] = { 7, 7, 2048, 1 };
    vx_tensor conv_res5b_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res5b_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res5b_branch2c);
    vx_size dims_batch_norm_scale5b_branch2c[4] = { 7, 7, 2048, 1 };
    vx_tensor batch_norm_scale5b_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale5b_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale5b_branch2c);
    vx_size dims_sum_res5b[4] = { 7, 7, 2048, 1 };
    vx_tensor sum_res5b = vxCreateVirtualTensor(graph, 4, dims_sum_res5b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res5b);
    vx_size dims_relu_res5b_relu[4] = { 7, 7, 2048, 1 };
    vx_tensor relu_res5b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res5b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res5b_relu);
    vx_size dims_conv_res5c_branch2a[4] = { 7, 7, 512, 1 };
    vx_tensor conv_res5c_branch2a = vxCreateVirtualTensor(graph, 4, dims_conv_res5c_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res5c_branch2a);
    vx_size dims_batch_norm_scale5c_branch2a[4] = { 7, 7, 512, 1 };
    vx_tensor batch_norm_scale5c_branch2a = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale5c_branch2a, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale5c_branch2a);
    vx_size dims_relu_res5c_branch2a_relu[4] = { 7, 7, 512, 1 };
    vx_tensor relu_res5c_branch2a_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res5c_branch2a_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res5c_branch2a_relu);
    vx_size dims_conv_res5c_branch2b[4] = { 7, 7, 512, 1 };
    vx_tensor conv_res5c_branch2b = vxCreateVirtualTensor(graph, 4, dims_conv_res5c_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res5c_branch2b);
    vx_size dims_batch_norm_scale5c_branch2b[4] = { 7, 7, 512, 1 };
    vx_tensor batch_norm_scale5c_branch2b = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale5c_branch2b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale5c_branch2b);
    vx_size dims_relu_res5c_branch2b_relu[4] = { 7, 7, 512, 1 };
    vx_tensor relu_res5c_branch2b_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res5c_branch2b_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res5c_branch2b_relu);
    vx_size dims_conv_res5c_branch2c[4] = { 7, 7, 2048, 1 };
    vx_tensor conv_res5c_branch2c = vxCreateVirtualTensor(graph, 4, dims_conv_res5c_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_res5c_branch2c);
    vx_size dims_batch_norm_scale5c_branch2c[4] = { 7, 7, 2048, 1 };
    vx_tensor batch_norm_scale5c_branch2c = vxCreateVirtualTensor(graph, 4, dims_batch_norm_scale5c_branch2c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(batch_norm_scale5c_branch2c);
    vx_size dims_sum_res5c[4] = { 7, 7, 2048, 1 };
    vx_tensor sum_res5c = vxCreateVirtualTensor(graph, 4, dims_sum_res5c, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(sum_res5c);
    vx_size dims_relu_res5c_relu[4] = { 7, 7, 2048, 1 };
    vx_tensor relu_res5c_relu = vxCreateVirtualTensor(graph, 4, dims_relu_res5c_relu, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_res5c_relu);
    vx_size dims_avg_pool_pool5[4] = { 1, 1, 2048, 1 };
    vx_tensor avg_pool_pool5 = vxCreateVirtualTensor(graph, 4, dims_avg_pool_pool5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_pool5);
    vx_size dims_gemm_fc1000[4] = { 1, 1, 1000, 1 };
    vx_tensor gemm_fc1000 = vxCreateVirtualTensor(graph, 4, dims_gemm_fc1000, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(gemm_fc1000);

    // create nodes in graph

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, data, conv1_w, conv1_b, &conv_params, sizeof(conv_params), conv_conv1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_conv1, bn_conv1_w, bn_conv1_b, scale_conv1_w, scale_conv1_b, 1.000000e-05f, batch_norm_scale_conv1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale_conv1, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_conv1_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, relu_conv1_relu, VX_NN_POOLING_MAX, 3, 3, 0, 0, VX_ROUND_POLICY_TO_NEAREST_EVEN, max_pool_pool1);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, max_pool_pool1, res2a_branch1_w, NULL, &conv_params, sizeof(conv_params), conv_res2a_branch1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res2a_branch1, bn2a_branch1_w, bn2a_branch1_b, scale2a_branch1_w, scale2a_branch1_b, 1.000000e-05f, batch_norm_scale2a_branch1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, max_pool_pool1, res2a_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res2a_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res2a_branch2a, bn2a_branch2a_w, bn2a_branch2a_b, scale2a_branch2a_w, scale2a_branch2a_b, 1.000000e-05f, batch_norm_scale2a_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale2a_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res2a_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res2a_branch2a_relu, res2a_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res2a_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res2a_branch2b, bn2a_branch2b_w, bn2a_branch2b_b, scale2a_branch2b_w, scale2a_branch2b_b, 1.000000e-05f, batch_norm_scale2a_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale2a_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res2a_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res2a_branch2b_relu, res2a_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res2a_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res2a_branch2c, bn2a_branch2c_w, bn2a_branch2c_b, scale2a_branch2c_w, scale2a_branch2c_b, 1.000000e-05f, batch_norm_scale2a_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, batch_norm_scale2a_branch1, batch_norm_scale2a_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res2a_relu, res2b_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res2b_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res2b_branch2a, bn2b_branch2a_w, bn2b_branch2a_b, scale2b_branch2a_w, scale2b_branch2a_b, 1.000000e-05f, batch_norm_scale2b_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale2b_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res2b_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res2b_branch2a_relu, res2b_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res2b_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res2b_branch2b, bn2b_branch2b_w, bn2b_branch2b_b, scale2b_branch2b_w, scale2b_branch2b_b, 1.000000e-05f, batch_norm_scale2b_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale2b_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res2b_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res2b_branch2b_relu, res2b_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res2b_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res2b_branch2c, bn2b_branch2c_w, bn2b_branch2c_b, scale2b_branch2c_w, scale2b_branch2c_b, 1.000000e-05f, batch_norm_scale2b_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, relu_res2a_relu, batch_norm_scale2b_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res2b_relu, res2c_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res2c_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res2c_branch2a, bn2c_branch2a_w, bn2c_branch2a_b, scale2c_branch2a_w, scale2c_branch2a_b, 1.000000e-05f, batch_norm_scale2c_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale2c_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res2c_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res2c_branch2a_relu, res2c_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res2c_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res2c_branch2b, bn2c_branch2b_w, bn2c_branch2b_b, scale2c_branch2b_w, scale2c_branch2b_b, 1.000000e-05f, batch_norm_scale2c_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale2c_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res2c_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res2c_branch2b_relu, res2c_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res2c_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res2c_branch2c, bn2c_branch2c_w, bn2c_branch2c_b, scale2c_branch2c_w, scale2c_branch2c_b, 1.000000e-05f, batch_norm_scale2c_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, relu_res2b_relu, batch_norm_scale2c_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res2c, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res2c_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res2c_relu, res3a_branch1_w, NULL, &conv_params, sizeof(conv_params), conv_res3a_branch1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res3a_branch1, bn3a_branch1_w, bn3a_branch1_b, scale3a_branch1_w, scale3a_branch1_b, 1.000000e-05f, batch_norm_scale3a_branch1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res2c_relu, res3a_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res3a_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res3a_branch2a, bn3a_branch2a_w, bn3a_branch2a_b, scale3a_branch2a_w, scale3a_branch2a_b, 1.000000e-05f, batch_norm_scale3a_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale3a_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res3a_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res3a_branch2a_relu, res3a_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res3a_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res3a_branch2b, bn3a_branch2b_w, bn3a_branch2b_b, scale3a_branch2b_w, scale3a_branch2b_b, 1.000000e-05f, batch_norm_scale3a_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale3a_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res3a_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res3a_branch2b_relu, res3a_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res3a_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res3a_branch2c, bn3a_branch2c_w, bn3a_branch2c_b, scale3a_branch2c_w, scale3a_branch2c_b, 1.000000e-05f, batch_norm_scale3a_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, batch_norm_scale3a_branch1, batch_norm_scale3a_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res3a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res3a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res3a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res3a_relu, res3b_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res3b_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res3b_branch2a, bn3b_branch2a_w, bn3b_branch2a_b, scale3b_branch2a_w, scale3b_branch2a_b, 1.000000e-05f, batch_norm_scale3b_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale3b_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res3b_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res3b_branch2a_relu, res3b_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res3b_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res3b_branch2b, bn3b_branch2b_w, bn3b_branch2b_b, scale3b_branch2b_w, scale3b_branch2b_b, 1.000000e-05f, batch_norm_scale3b_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale3b_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res3b_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res3b_branch2b_relu, res3b_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res3b_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res3b_branch2c, bn3b_branch2c_w, bn3b_branch2c_b, scale3b_branch2c_w, scale3b_branch2c_b, 1.000000e-05f, batch_norm_scale3b_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, relu_res3a_relu, batch_norm_scale3b_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res3b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res3b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res3b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res3b_relu, res3c_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res3c_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res3c_branch2a, bn3c_branch2a_w, bn3c_branch2a_b, scale3c_branch2a_w, scale3c_branch2a_b, 1.000000e-05f, batch_norm_scale3c_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale3c_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res3c_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res3c_branch2a_relu, res3c_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res3c_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res3c_branch2b, bn3c_branch2b_w, bn3c_branch2b_b, scale3c_branch2b_w, scale3c_branch2b_b, 1.000000e-05f, batch_norm_scale3c_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale3c_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res3c_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res3c_branch2b_relu, res3c_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res3c_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res3c_branch2c, bn3c_branch2c_w, bn3c_branch2c_b, scale3c_branch2c_w, scale3c_branch2c_b, 1.000000e-05f, batch_norm_scale3c_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, relu_res3b_relu, batch_norm_scale3c_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res3c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res3c, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res3c_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res3c_relu, res3d_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res3d_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res3d_branch2a, bn3d_branch2a_w, bn3d_branch2a_b, scale3d_branch2a_w, scale3d_branch2a_b, 1.000000e-05f, batch_norm_scale3d_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale3d_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res3d_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res3d_branch2a_relu, res3d_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res3d_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res3d_branch2b, bn3d_branch2b_w, bn3d_branch2b_b, scale3d_branch2b_w, scale3d_branch2b_b, 1.000000e-05f, batch_norm_scale3d_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale3d_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res3d_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res3d_branch2b_relu, res3d_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res3d_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res3d_branch2c, bn3d_branch2c_w, bn3d_branch2c_b, scale3d_branch2c_w, scale3d_branch2c_b, 1.000000e-05f, batch_norm_scale3d_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, relu_res3c_relu, batch_norm_scale3d_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res3d);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res3d, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res3d_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res3d_relu, res4a_branch1_w, NULL, &conv_params, sizeof(conv_params), conv_res4a_branch1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4a_branch1, bn4a_branch1_w, bn4a_branch1_b, scale4a_branch1_w, scale4a_branch1_b, 1.000000e-05f, batch_norm_scale4a_branch1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res3d_relu, res4a_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res4a_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4a_branch2a, bn4a_branch2a_w, bn4a_branch2a_b, scale4a_branch2a_w, scale4a_branch2a_b, 1.000000e-05f, batch_norm_scale4a_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale4a_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4a_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4a_branch2a_relu, res4a_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res4a_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4a_branch2b, bn4a_branch2b_w, bn4a_branch2b_b, scale4a_branch2b_w, scale4a_branch2b_b, 1.000000e-05f, batch_norm_scale4a_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale4a_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4a_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4a_branch2b_relu, res4a_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res4a_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4a_branch2c, bn4a_branch2c_w, bn4a_branch2c_b, scale4a_branch2c_w, scale4a_branch2c_b, 1.000000e-05f, batch_norm_scale4a_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, batch_norm_scale4a_branch1, batch_norm_scale4a_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res4a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res4a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4a_relu, res4b_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res4b_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4b_branch2a, bn4b_branch2a_w, bn4b_branch2a_b, scale4b_branch2a_w, scale4b_branch2a_b, 1.000000e-05f, batch_norm_scale4b_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale4b_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4b_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4b_branch2a_relu, res4b_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res4b_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4b_branch2b, bn4b_branch2b_w, bn4b_branch2b_b, scale4b_branch2b_w, scale4b_branch2b_b, 1.000000e-05f, batch_norm_scale4b_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale4b_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4b_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4b_branch2b_relu, res4b_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res4b_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4b_branch2c, bn4b_branch2c_w, bn4b_branch2c_b, scale4b_branch2c_w, scale4b_branch2c_b, 1.000000e-05f, batch_norm_scale4b_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, relu_res4a_relu, batch_norm_scale4b_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res4b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res4b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4b_relu, res4c_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res4c_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4c_branch2a, bn4c_branch2a_w, bn4c_branch2a_b, scale4c_branch2a_w, scale4c_branch2a_b, 1.000000e-05f, batch_norm_scale4c_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale4c_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4c_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4c_branch2a_relu, res4c_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res4c_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4c_branch2b, bn4c_branch2b_w, bn4c_branch2b_b, scale4c_branch2b_w, scale4c_branch2b_b, 1.000000e-05f, batch_norm_scale4c_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale4c_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4c_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4c_branch2b_relu, res4c_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res4c_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4c_branch2c, bn4c_branch2c_w, bn4c_branch2c_b, scale4c_branch2c_w, scale4c_branch2c_b, 1.000000e-05f, batch_norm_scale4c_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, relu_res4b_relu, batch_norm_scale4c_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res4c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res4c, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4c_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4c_relu, res4d_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res4d_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4d_branch2a, bn4d_branch2a_w, bn4d_branch2a_b, scale4d_branch2a_w, scale4d_branch2a_b, 1.000000e-05f, batch_norm_scale4d_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale4d_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4d_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4d_branch2a_relu, res4d_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res4d_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4d_branch2b, bn4d_branch2b_w, bn4d_branch2b_b, scale4d_branch2b_w, scale4d_branch2b_b, 1.000000e-05f, batch_norm_scale4d_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale4d_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4d_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4d_branch2b_relu, res4d_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res4d_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4d_branch2c, bn4d_branch2c_w, bn4d_branch2c_b, scale4d_branch2c_w, scale4d_branch2c_b, 1.000000e-05f, batch_norm_scale4d_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, relu_res4c_relu, batch_norm_scale4d_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res4d);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res4d, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4d_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4d_relu, res4e_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res4e_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4e_branch2a, bn4e_branch2a_w, bn4e_branch2a_b, scale4e_branch2a_w, scale4e_branch2a_b, 1.000000e-05f, batch_norm_scale4e_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale4e_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4e_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4e_branch2a_relu, res4e_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res4e_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4e_branch2b, bn4e_branch2b_w, bn4e_branch2b_b, scale4e_branch2b_w, scale4e_branch2b_b, 1.000000e-05f, batch_norm_scale4e_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale4e_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4e_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4e_branch2b_relu, res4e_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res4e_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4e_branch2c, bn4e_branch2c_w, bn4e_branch2c_b, scale4e_branch2c_w, scale4e_branch2c_b, 1.000000e-05f, batch_norm_scale4e_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, relu_res4d_relu, batch_norm_scale4e_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res4e);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res4e, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4e_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4e_relu, res4f_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res4f_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4f_branch2a, bn4f_branch2a_w, bn4f_branch2a_b, scale4f_branch2a_w, scale4f_branch2a_b, 1.000000e-05f, batch_norm_scale4f_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale4f_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4f_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4f_branch2a_relu, res4f_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res4f_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4f_branch2b, bn4f_branch2b_w, bn4f_branch2b_b, scale4f_branch2b_w, scale4f_branch2b_b, 1.000000e-05f, batch_norm_scale4f_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale4f_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4f_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4f_branch2b_relu, res4f_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res4f_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res4f_branch2c, bn4f_branch2c_w, bn4f_branch2c_b, scale4f_branch2c_w, scale4f_branch2c_b, 1.000000e-05f, batch_norm_scale4f_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, relu_res4e_relu, batch_norm_scale4f_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res4f);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res4f, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res4f_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4f_relu, res5a_branch1_w, NULL, &conv_params, sizeof(conv_params), conv_res5a_branch1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res5a_branch1, bn5a_branch1_w, bn5a_branch1_b, scale5a_branch1_w, scale5a_branch1_b, 1.000000e-05f, batch_norm_scale5a_branch1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res4f_relu, res5a_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res5a_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res5a_branch2a, bn5a_branch2a_w, bn5a_branch2a_b, scale5a_branch2a_w, scale5a_branch2a_b, 1.000000e-05f, batch_norm_scale5a_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale5a_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res5a_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res5a_branch2a_relu, res5a_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res5a_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res5a_branch2b, bn5a_branch2b_w, bn5a_branch2b_b, scale5a_branch2b_w, scale5a_branch2b_b, 1.000000e-05f, batch_norm_scale5a_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale5a_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res5a_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res5a_branch2b_relu, res5a_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res5a_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res5a_branch2c, bn5a_branch2c_w, bn5a_branch2c_b, scale5a_branch2c_w, scale5a_branch2c_b, 1.000000e-05f, batch_norm_scale5a_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, batch_norm_scale5a_branch1, batch_norm_scale5a_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res5a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res5a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res5a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res5a_relu, res5b_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res5b_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res5b_branch2a, bn5b_branch2a_w, bn5b_branch2a_b, scale5b_branch2a_w, scale5b_branch2a_b, 1.000000e-05f, batch_norm_scale5b_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale5b_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res5b_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res5b_branch2a_relu, res5b_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res5b_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res5b_branch2b, bn5b_branch2b_w, bn5b_branch2b_b, scale5b_branch2b_w, scale5b_branch2b_b, 1.000000e-05f, batch_norm_scale5b_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale5b_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res5b_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res5b_branch2b_relu, res5b_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res5b_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res5b_branch2c, bn5b_branch2c_w, bn5b_branch2c_b, scale5b_branch2c_w, scale5b_branch2c_b, 1.000000e-05f, batch_norm_scale5b_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, relu_res5a_relu, batch_norm_scale5b_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res5b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res5b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res5b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res5b_relu, res5c_branch2a_w, NULL, &conv_params, sizeof(conv_params), conv_res5c_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res5c_branch2a, bn5c_branch2a_w, bn5c_branch2a_b, scale5c_branch2a_w, scale5c_branch2a_b, 1.000000e-05f, batch_norm_scale5c_branch2a);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale5c_branch2a, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res5c_branch2a_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res5c_branch2a_relu, res5c_branch2b_w, NULL, &conv_params, sizeof(conv_params), conv_res5c_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res5c_branch2b, bn5c_branch2b_w, bn5c_branch2b_b, scale5c_branch2b_w, scale5c_branch2b_b, 1.000000e-05f, batch_norm_scale5c_branch2b);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, batch_norm_scale5c_branch2b, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res5c_branch2b_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_res5c_branch2b_relu, res5c_branch2c_w, NULL, &conv_params, sizeof(conv_params), conv_res5c_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxBatchNormalizationLayer(graph, conv_res5c_branch2c, bn5c_branch2c_w, bn5c_branch2c_b, scale5c_branch2c_w, scale5c_branch2c_b, 1.000000e-05f, batch_norm_scale5c_branch2c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxTensorAddNode(graph, relu_res5b_relu, batch_norm_scale5c_branch2c, VX_CONVERT_POLICY_SATURATE, sum_res5c);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, sum_res5c, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_res5c_relu);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, relu_res5c_relu, VX_NN_POOLING_AVG, 7, 7, 0, 0, VX_ROUND_POLICY_TO_NEAREST_EVEN, avg_pool_pool5);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxFullyConnectedLayer(graph, avg_pool_pool5, fc1000_w, fc1000_b, VX_CONVERT_POLICY_SATURATE, VX_ROUND_POLICY_TO_NEAREST_EVEN, gemm_fc1000);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxSoftmaxLayer(graph, gemm_fc1000, softmax_prob);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    // release local tensors
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale_conv1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_conv1_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&max_pool_pool1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res2a_branch1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale2a_branch1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res2a_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale2a_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res2a_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res2a_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale2a_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res2a_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res2a_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale2a_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res2b_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale2b_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res2b_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res2b_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale2b_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res2b_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res2b_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale2b_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res2c_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale2c_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res2c_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res2c_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale2c_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res2c_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res2c_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale2c_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res2c_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res3a_branch1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale3a_branch1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res3a_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale3a_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res3a_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res3a_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale3a_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res3a_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res3a_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale3a_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res3a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res3a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res3b_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale3b_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res3b_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res3b_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale3b_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res3b_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res3b_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale3b_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res3b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res3b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res3c_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale3c_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res3c_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res3c_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale3c_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res3c_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res3c_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale3c_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res3c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res3c_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res3d_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale3d_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res3d_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res3d_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale3d_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res3d_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res3d_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale3d_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res3d));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res3d_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4a_branch1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4a_branch1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4a_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4a_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4a_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4a_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4a_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4a_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4a_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4a_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res4a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4b_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4b_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4b_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4b_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4b_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4b_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4b_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4b_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res4b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4c_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4c_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4c_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4c_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4c_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4c_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4c_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4c_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res4c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4c_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4d_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4d_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4d_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4d_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4d_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4d_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4d_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4d_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res4d));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4d_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4e_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4e_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4e_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4e_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4e_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4e_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4e_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4e_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res4e));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4e_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4f_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4f_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4f_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4f_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4f_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4f_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res4f_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale4f_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res4f));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res4f_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res5a_branch1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale5a_branch1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res5a_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale5a_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res5a_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res5a_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale5a_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res5a_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res5a_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale5a_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res5a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res5a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res5b_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale5b_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res5b_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res5b_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale5b_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res5b_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res5b_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale5b_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res5b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res5b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res5c_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale5c_branch2a));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res5c_branch2a_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res5c_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale5c_branch2b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res5c_branch2b_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_res5c_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&batch_norm_scale5c_branch2c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&sum_res5c));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_res5c_relu));
    ERROR_CHECK_STATUS(vxReleaseTensor(&avg_pool_pool5));
    ERROR_CHECK_STATUS(vxReleaseTensor(&gemm_fc1000));

    // release initializer tensors
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn_conv1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn_conv1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale_conv1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale_conv1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res2a_branch1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2a_branch1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2a_branch1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2a_branch1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2a_branch1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res2a_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2a_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2a_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2a_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2a_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res2a_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2a_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2a_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2a_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2a_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res2a_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2a_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2a_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2a_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2a_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res2b_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2b_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2b_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2b_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2b_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res2b_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2b_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2b_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2b_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2b_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res2b_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2b_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2b_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2b_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2b_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res2c_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2c_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2c_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2c_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2c_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res2c_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2c_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2c_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2c_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2c_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res2c_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2c_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn2c_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2c_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale2c_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res3a_branch1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3a_branch1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3a_branch1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3a_branch1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3a_branch1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res3a_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3a_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3a_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3a_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3a_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res3a_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3a_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3a_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3a_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3a_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res3a_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3a_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3a_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3a_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3a_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res3b_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3b_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3b_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3b_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3b_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res3b_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3b_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3b_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3b_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3b_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res3b_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3b_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3b_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3b_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3b_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res3c_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3c_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3c_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3c_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3c_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res3c_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3c_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3c_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3c_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3c_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res3c_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3c_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3c_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3c_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3c_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res3d_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3d_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3d_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3d_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3d_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res3d_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3d_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3d_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3d_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3d_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res3d_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3d_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn3d_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3d_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale3d_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4a_branch1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4a_branch1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4a_branch1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4a_branch1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4a_branch1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4a_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4a_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4a_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4a_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4a_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4a_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4a_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4a_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4a_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4a_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4a_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4a_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4a_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4a_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4a_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4b_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4b_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4b_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4b_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4b_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4b_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4b_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4b_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4b_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4b_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4b_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4b_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4b_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4b_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4b_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4c_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4c_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4c_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4c_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4c_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4c_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4c_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4c_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4c_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4c_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4c_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4c_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4c_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4c_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4c_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4d_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4d_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4d_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4d_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4d_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4d_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4d_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4d_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4d_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4d_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4d_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4d_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4d_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4d_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4d_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4e_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4e_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4e_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4e_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4e_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4e_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4e_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4e_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4e_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4e_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4e_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4e_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4e_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4e_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4e_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4f_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4f_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4f_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4f_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4f_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4f_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4f_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4f_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4f_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4f_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res4f_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4f_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn4f_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4f_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale4f_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res5a_branch1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5a_branch1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5a_branch1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5a_branch1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5a_branch1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res5a_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5a_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5a_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5a_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5a_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res5a_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5a_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5a_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5a_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5a_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res5a_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5a_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5a_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5a_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5a_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res5b_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5b_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5b_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5b_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5b_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res5b_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5b_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5b_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5b_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5b_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res5b_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5b_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5b_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5b_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5b_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res5c_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5c_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5c_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5c_branch2a_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5c_branch2a_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res5c_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5c_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5c_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5c_branch2b_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5c_branch2b_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&res5c_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5c_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&bn5c_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5c_branch2c_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&scale5c_branch2c_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&fc1000_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&fc1000_b));

    return VX_SUCCESS;
}

VX_API_ENTRY vx_status VX_API_CALL annAddToGraph_vgg(vx_graph graph, vx_tensor data, vx_tensor softmax_prob, const char * binaryFilename)
{
    vx_context context = vxGetContext((vx_reference)graph);
    ERROR_CHECK_OBJECT(context);

    // create variables
    vx_size dims_conv1_1_w[4] = { 3, 3, 3, 64 };
    vx_tensor conv1_1_w = vxCreateTensor(context, 4, dims_conv1_1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv1_1_w);
    vx_size dims_conv1_1_b[2] = { 64, 1 };
    vx_tensor conv1_1_b = vxCreateTensor(context, 2, dims_conv1_1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv1_1_b);
    vx_size dims_conv1_2_w[4] = { 3, 3, 64, 64 };
    vx_tensor conv1_2_w = vxCreateTensor(context, 4, dims_conv1_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv1_2_w);
    vx_size dims_conv1_2_b[2] = { 64, 1 };
    vx_tensor conv1_2_b = vxCreateTensor(context, 2, dims_conv1_2_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv1_2_b);
    vx_size dims_conv2_1_w[4] = { 3, 3, 64, 128 };
    vx_tensor conv2_1_w = vxCreateTensor(context, 4, dims_conv2_1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv2_1_w);
    vx_size dims_conv2_1_b[2] = { 128, 1 };
    vx_tensor conv2_1_b = vxCreateTensor(context, 2, dims_conv2_1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv2_1_b);
    vx_size dims_conv2_2_w[4] = { 3, 3, 128, 128 };
    vx_tensor conv2_2_w = vxCreateTensor(context, 4, dims_conv2_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv2_2_w);
    vx_size dims_conv2_2_b[2] = { 128, 1 };
    vx_tensor conv2_2_b = vxCreateTensor(context, 2, dims_conv2_2_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv2_2_b);
    vx_size dims_conv3_1_w[4] = { 3, 3, 128, 256 };
    vx_tensor conv3_1_w = vxCreateTensor(context, 4, dims_conv3_1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv3_1_w);
    vx_size dims_conv3_1_b[2] = { 256, 1 };
    vx_tensor conv3_1_b = vxCreateTensor(context, 2, dims_conv3_1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv3_1_b);
    vx_size dims_conv3_2_w[4] = { 3, 3, 256, 256 };
    vx_tensor conv3_2_w = vxCreateTensor(context, 4, dims_conv3_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv3_2_w);
    vx_size dims_conv3_2_b[2] = { 256, 1 };
    vx_tensor conv3_2_b = vxCreateTensor(context, 2, dims_conv3_2_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv3_2_b);
    vx_size dims_conv3_3_w[4] = { 3, 3, 256, 256 };
    vx_tensor conv3_3_w = vxCreateTensor(context, 4, dims_conv3_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv3_3_w);
    vx_size dims_conv3_3_b[2] = { 256, 1 };
    vx_tensor conv3_3_b = vxCreateTensor(context, 2, dims_conv3_3_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv3_3_b);
    vx_size dims_conv4_1_w[4] = { 3, 3, 256, 512 };
    vx_tensor conv4_1_w = vxCreateTensor(context, 4, dims_conv4_1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv4_1_w);
    vx_size dims_conv4_1_b[2] = { 512, 1 };
    vx_tensor conv4_1_b = vxCreateTensor(context, 2, dims_conv4_1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv4_1_b);
    vx_size dims_conv4_2_w[4] = { 3, 3, 512, 512 };
    vx_tensor conv4_2_w = vxCreateTensor(context, 4, dims_conv4_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv4_2_w);
    vx_size dims_conv4_2_b[2] = { 512, 1 };
    vx_tensor conv4_2_b = vxCreateTensor(context, 2, dims_conv4_2_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv4_2_b);
    vx_size dims_conv4_3_w[4] = { 3, 3, 512, 512 };
    vx_tensor conv4_3_w = vxCreateTensor(context, 4, dims_conv4_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv4_3_w);
    vx_size dims_conv4_3_b[2] = { 512, 1 };
    vx_tensor conv4_3_b = vxCreateTensor(context, 2, dims_conv4_3_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv4_3_b);
    vx_size dims_conv5_1_w[4] = { 3, 3, 512, 512 };
    vx_tensor conv5_1_w = vxCreateTensor(context, 4, dims_conv5_1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv5_1_w);
    vx_size dims_conv5_1_b[2] = { 512, 1 };
    vx_tensor conv5_1_b = vxCreateTensor(context, 2, dims_conv5_1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv5_1_b);
    vx_size dims_conv5_2_w[4] = { 3, 3, 512, 512 };
    vx_tensor conv5_2_w = vxCreateTensor(context, 4, dims_conv5_2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv5_2_w);
    vx_size dims_conv5_2_b[2] = { 512, 1 };
    vx_tensor conv5_2_b = vxCreateTensor(context, 2, dims_conv5_2_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv5_2_b);
    vx_size dims_conv5_3_w[4] = { 3, 3, 512, 512 };
    vx_tensor conv5_3_w = vxCreateTensor(context, 4, dims_conv5_3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv5_3_w);
    vx_size dims_conv5_3_b[2] = { 512, 1 };
    vx_tensor conv5_3_b = vxCreateTensor(context, 2, dims_conv5_3_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv5_3_b);
    vx_size dims_fc6_w[4] = { 7, 7, 512, 4096 };
    vx_tensor fc6_w = vxCreateTensor(context, 4, dims_fc6_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(fc6_w);
    vx_size dims_fc6_b[2] = { 4096, 1 };
    vx_tensor fc6_b = vxCreateTensor(context, 2, dims_fc6_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(fc6_b);
    vx_size dims_fc7_w[4] = { 1, 1, 4096, 4096 };
    vx_tensor fc7_w = vxCreateTensor(context, 4, dims_fc7_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(fc7_w);
    vx_size dims_fc7_b[2] = { 4096, 1 };
    vx_tensor fc7_b = vxCreateTensor(context, 2, dims_fc7_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(fc7_b);
    vx_size dims_fc8_w[4] = { 1, 1, 4096, 1000 };
    vx_tensor fc8_w = vxCreateTensor(context, 4, dims_fc8_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(fc8_w);
    vx_size dims_fc8_b[2] = { 1000, 1 };
    vx_tensor fc8_b = vxCreateTensor(context, 2, dims_fc8_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(fc8_b);

    // initialize variables
    FILE * fp__variables = fopen(binaryFilename, "rb");
    if(!fp__variables) {
        vxAddLogEntry((vx_reference)context, VX_FAILURE, "ERROR: unable to open: %s\n", binaryFilename);
        return VX_FAILURE;
    }
    { vx_uint32 magic = 0;
      fread(&magic, 1, sizeof(magic), fp__variables);
      if(magic != 0xf00dd1e0) {
        vxAddLogEntry((vx_reference)context, VX_FAILURE, "ERROR: invalid file magic in %s\n", binaryFilename);
        return VX_FAILURE;
      }
    }
    ERROR_CHECK_STATUS(initializeTensor(context, conv1_1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv1_1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv1_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv1_2_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv2_1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv2_1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv2_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv2_2_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv3_1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv3_1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv3_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv3_2_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv3_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv3_3_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv4_1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv4_1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv4_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv4_2_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv4_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv4_3_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv5_1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv5_1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv5_2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv5_2_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv5_3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv5_3_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, fc6_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, fc6_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, fc7_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, fc7_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, fc8_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, fc8_b, fp__variables, binaryFilename));
    { vx_uint32 magic = 0;
      fread(&magic, 1, sizeof(magic), fp__variables);
      if(magic != 0xf00dd1e2) {
        vxAddLogEntry((vx_reference)context, VX_FAILURE, "ERROR: invalid eoff magic in %s\n", binaryFilename);
        return VX_FAILURE;
      }
      fclose(fp__variables);
    }

    // create local tensors used in graph
    vx_size dims_conv_conv1_1[4] = { 224, 224, 64, 1 };
    vx_tensor conv_conv1_1 = vxCreateVirtualTensor(graph, 4, dims_conv_conv1_1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv1_1);
    vx_size dims_relu_relu1_1[4] = { 224, 224, 64, 1 };
    vx_tensor relu_relu1_1 = vxCreateVirtualTensor(graph, 4, dims_relu_relu1_1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu1_1);
    vx_size dims_conv_conv1_2[4] = { 224, 224, 64, 1 };
    vx_tensor conv_conv1_2 = vxCreateVirtualTensor(graph, 4, dims_conv_conv1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv1_2);
    vx_size dims_relu_relu1_2[4] = { 224, 224, 64, 1 };
    vx_tensor relu_relu1_2 = vxCreateVirtualTensor(graph, 4, dims_relu_relu1_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu1_2);
    vx_size dims_max_pool_pool1[4] = { 112, 112, 64, 1 };
    vx_tensor max_pool_pool1 = vxCreateVirtualTensor(graph, 4, dims_max_pool_pool1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_pool1);
    vx_size dims_conv_conv2_1[4] = { 112, 112, 128, 1 };
    vx_tensor conv_conv2_1 = vxCreateVirtualTensor(graph, 4, dims_conv_conv2_1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv2_1);
    vx_size dims_relu_relu2_1[4] = { 112, 112, 128, 1 };
    vx_tensor relu_relu2_1 = vxCreateVirtualTensor(graph, 4, dims_relu_relu2_1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu2_1);
    vx_size dims_conv_conv2_2[4] = { 112, 112, 128, 1 };
    vx_tensor conv_conv2_2 = vxCreateVirtualTensor(graph, 4, dims_conv_conv2_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv2_2);
    vx_size dims_relu_relu2_2[4] = { 112, 112, 128, 1 };
    vx_tensor relu_relu2_2 = vxCreateVirtualTensor(graph, 4, dims_relu_relu2_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu2_2);
    vx_size dims_max_pool_pool2[4] = { 56, 56, 128, 1 };
    vx_tensor max_pool_pool2 = vxCreateVirtualTensor(graph, 4, dims_max_pool_pool2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_pool2);
    vx_size dims_conv_conv3_1[4] = { 56, 56, 256, 1 };
    vx_tensor conv_conv3_1 = vxCreateVirtualTensor(graph, 4, dims_conv_conv3_1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv3_1);
    vx_size dims_relu_relu3_1[4] = { 56, 56, 256, 1 };
    vx_tensor relu_relu3_1 = vxCreateVirtualTensor(graph, 4, dims_relu_relu3_1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu3_1);
    vx_size dims_conv_conv3_2[4] = { 56, 56, 256, 1 };
    vx_tensor conv_conv3_2 = vxCreateVirtualTensor(graph, 4, dims_conv_conv3_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv3_2);
    vx_size dims_relu_relu3_2[4] = { 56, 56, 256, 1 };
    vx_tensor relu_relu3_2 = vxCreateVirtualTensor(graph, 4, dims_relu_relu3_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu3_2);
    vx_size dims_conv_conv3_3[4] = { 56, 56, 256, 1 };
    vx_tensor conv_conv3_3 = vxCreateVirtualTensor(graph, 4, dims_conv_conv3_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv3_3);
    vx_size dims_relu_relu3_3[4] = { 56, 56, 256, 1 };
    vx_tensor relu_relu3_3 = vxCreateVirtualTensor(graph, 4, dims_relu_relu3_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu3_3);
    vx_size dims_max_pool_pool3[4] = { 28, 28, 256, 1 };
    vx_tensor max_pool_pool3 = vxCreateVirtualTensor(graph, 4, dims_max_pool_pool3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_pool3);
    vx_size dims_conv_conv4_1[4] = { 28, 28, 512, 1 };
    vx_tensor conv_conv4_1 = vxCreateVirtualTensor(graph, 4, dims_conv_conv4_1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv4_1);
    vx_size dims_relu_relu4_1[4] = { 28, 28, 512, 1 };
    vx_tensor relu_relu4_1 = vxCreateVirtualTensor(graph, 4, dims_relu_relu4_1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu4_1);
    vx_size dims_conv_conv4_2[4] = { 28, 28, 512, 1 };
    vx_tensor conv_conv4_2 = vxCreateVirtualTensor(graph, 4, dims_conv_conv4_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv4_2);
    vx_size dims_relu_relu4_2[4] = { 28, 28, 512, 1 };
    vx_tensor relu_relu4_2 = vxCreateVirtualTensor(graph, 4, dims_relu_relu4_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu4_2);
    vx_size dims_conv_conv4_3[4] = { 28, 28, 512, 1 };
    vx_tensor conv_conv4_3 = vxCreateVirtualTensor(graph, 4, dims_conv_conv4_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv4_3);
    vx_size dims_relu_relu4_3[4] = { 28, 28, 512, 1 };
    vx_tensor relu_relu4_3 = vxCreateVirtualTensor(graph, 4, dims_relu_relu4_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu4_3);
    vx_size dims_max_pool_pool4[4] = { 14, 14, 512, 1 };
    vx_tensor max_pool_pool4 = vxCreateVirtualTensor(graph, 4, dims_max_pool_pool4, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_pool4);
    vx_size dims_conv_conv5_1[4] = { 14, 14, 512, 1 };
    vx_tensor conv_conv5_1 = vxCreateVirtualTensor(graph, 4, dims_conv_conv5_1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv5_1);
    vx_size dims_relu_relu5_1[4] = { 14, 14, 512, 1 };
    vx_tensor relu_relu5_1 = vxCreateVirtualTensor(graph, 4, dims_relu_relu5_1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu5_1);
    vx_size dims_conv_conv5_2[4] = { 14, 14, 512, 1 };
    vx_tensor conv_conv5_2 = vxCreateVirtualTensor(graph, 4, dims_conv_conv5_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv5_2);
    vx_size dims_relu_relu5_2[4] = { 14, 14, 512, 1 };
    vx_tensor relu_relu5_2 = vxCreateVirtualTensor(graph, 4, dims_relu_relu5_2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu5_2);
    vx_size dims_conv_conv5_3[4] = { 14, 14, 512, 1 };
    vx_tensor conv_conv5_3 = vxCreateVirtualTensor(graph, 4, dims_conv_conv5_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv5_3);
    vx_size dims_relu_relu5_3[4] = { 14, 14, 512, 1 };
    vx_tensor relu_relu5_3 = vxCreateVirtualTensor(graph, 4, dims_relu_relu5_3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu5_3);
    vx_size dims_max_pool_pool5[4] = { 7, 7, 512, 1 };
    vx_tensor max_pool_pool5 = vxCreateVirtualTensor(graph, 4, dims_max_pool_pool5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_pool5);
    vx_size dims_gemm_fc6[4] = { 1, 1, 4096, 1 };
    vx_tensor gemm_fc6 = vxCreateVirtualTensor(graph, 4, dims_gemm_fc6, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(gemm_fc6);
    vx_size dims_relu_relu6[4] = { 1, 1, 4096, 1 };
    vx_tensor relu_relu6 = vxCreateVirtualTensor(graph, 4, dims_relu_relu6, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu6);
    vx_size dims_gemm_fc7[4] = { 1, 1, 4096, 1 };
    vx_tensor gemm_fc7 = vxCreateVirtualTensor(graph, 4, dims_gemm_fc7, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(gemm_fc7);
    vx_size dims_relu_relu7[4] = { 1, 1, 4096, 1 };
    vx_tensor relu_relu7 = vxCreateVirtualTensor(graph, 4, dims_relu_relu7, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_relu7);
    vx_size dims_gemm_fc8[4] = { 1, 1, 1000, 1 };
    vx_tensor gemm_fc8 = vxCreateVirtualTensor(graph, 4, dims_gemm_fc8, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(gemm_fc8);

    // create nodes in graph

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, data, conv1_1_w, conv1_1_b, &conv_params, sizeof(conv_params), conv_conv1_1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv1_1, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu1_1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_relu1_1, conv1_2_w, conv1_2_b, &conv_params, sizeof(conv_params), conv_conv1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv1_2, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu1_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, relu_relu1_2, VX_NN_POOLING_MAX, 2, 2, 0, 0, VX_ROUND_POLICY_TO_NEAREST_EVEN, max_pool_pool1);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, max_pool_pool1, conv2_1_w, conv2_1_b, &conv_params, sizeof(conv_params), conv_conv2_1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv2_1, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu2_1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_relu2_1, conv2_2_w, conv2_2_b, &conv_params, sizeof(conv_params), conv_conv2_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv2_2, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu2_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, relu_relu2_2, VX_NN_POOLING_MAX, 2, 2, 0, 0, VX_ROUND_POLICY_TO_NEAREST_EVEN, max_pool_pool2);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, max_pool_pool2, conv3_1_w, conv3_1_b, &conv_params, sizeof(conv_params), conv_conv3_1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv3_1, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu3_1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_relu3_1, conv3_2_w, conv3_2_b, &conv_params, sizeof(conv_params), conv_conv3_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv3_2, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu3_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_relu3_2, conv3_3_w, conv3_3_b, &conv_params, sizeof(conv_params), conv_conv3_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv3_3, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu3_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, relu_relu3_3, VX_NN_POOLING_MAX, 2, 2, 0, 0, VX_ROUND_POLICY_TO_NEAREST_EVEN, max_pool_pool3);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, max_pool_pool3, conv4_1_w, conv4_1_b, &conv_params, sizeof(conv_params), conv_conv4_1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv4_1, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu4_1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_relu4_1, conv4_2_w, conv4_2_b, &conv_params, sizeof(conv_params), conv_conv4_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv4_2, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu4_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_relu4_2, conv4_3_w, conv4_3_b, &conv_params, sizeof(conv_params), conv_conv4_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv4_3, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu4_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, relu_relu4_3, VX_NN_POOLING_MAX, 2, 2, 0, 0, VX_ROUND_POLICY_TO_NEAREST_EVEN, max_pool_pool4);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, max_pool_pool4, conv5_1_w, conv5_1_b, &conv_params, sizeof(conv_params), conv_conv5_1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv5_1, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu5_1);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_relu5_1, conv5_2_w, conv5_2_b, &conv_params, sizeof(conv_params), conv_conv5_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv5_2, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu5_2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_relu5_2, conv5_3_w, conv5_3_b, &conv_params, sizeof(conv_params), conv_conv5_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv5_3, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu5_3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, relu_relu5_3, VX_NN_POOLING_MAX, 2, 2, 0, 0, VX_ROUND_POLICY_TO_NEAREST_EVEN, max_pool_pool5);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxFullyConnectedLayer(graph, max_pool_pool5, fc6_w, fc6_b, VX_CONVERT_POLICY_SATURATE, VX_ROUND_POLICY_TO_NEAREST_EVEN, gemm_fc6);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, gemm_fc6, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu6);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxFullyConnectedLayer(graph, relu_relu6, fc7_w, fc7_b, VX_CONVERT_POLICY_SATURATE, VX_ROUND_POLICY_TO_NEAREST_EVEN, gemm_fc7);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, gemm_fc7, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_relu7);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxFullyConnectedLayer(graph, relu_relu7, fc8_w, fc8_b, VX_CONVERT_POLICY_SATURATE, VX_ROUND_POLICY_TO_NEAREST_EVEN, gemm_fc8);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxSoftmaxLayer(graph, gemm_fc8, softmax_prob);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    // release local tensors
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv1_1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu1_1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu1_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&max_pool_pool1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv2_1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu2_1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv2_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu2_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&max_pool_pool2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv3_1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu3_1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv3_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu3_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv3_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu3_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&max_pool_pool3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv4_1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu4_1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv4_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu4_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv4_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu4_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&max_pool_pool4));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv5_1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu5_1));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv5_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu5_2));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv_conv5_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu5_3));
    ERROR_CHECK_STATUS(vxReleaseTensor(&max_pool_pool5));
    ERROR_CHECK_STATUS(vxReleaseTensor(&gemm_fc6));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu6));
    ERROR_CHECK_STATUS(vxReleaseTensor(&gemm_fc7));
    ERROR_CHECK_STATUS(vxReleaseTensor(&relu_relu7));
    ERROR_CHECK_STATUS(vxReleaseTensor(&gemm_fc8));

    // release initializer tensors
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv1_1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv1_1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv1_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv1_2_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv2_1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv2_1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv2_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv2_2_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv3_1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv3_1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv3_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv3_2_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv3_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv3_3_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv4_1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv4_1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv4_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv4_2_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv4_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv4_3_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv5_1_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv5_1_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv5_2_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv5_2_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv5_3_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&conv5_3_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&fc6_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&fc6_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&fc7_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&fc7_b));
    ERROR_CHECK_STATUS(vxReleaseTensor(&fc8_w));
    ERROR_CHECK_STATUS(vxReleaseTensor(&fc8_b));

    return VX_SUCCESS;
}

VX_API_ENTRY vx_status VX_API_CALL annAddToGraph_googleNet(vx_graph graph, vx_tensor data, vx_tensor softmax_loss2_loss, vx_tensor softmax_loss3_loss3, vx_tensor softmax_loss1_loss, const char * binaryFilename)
{
    vx_context context = vxGetContext((vx_reference)graph);
    ERROR_CHECK_OBJECT(context);

    // create variables
    vx_size dims_conv1_7x7_s2_w[4] = { 7, 7, 3, 64 };
    vx_tensor conv1_7x7_s2_w = vxCreateTensor(context, 4, dims_conv1_7x7_s2_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv1_7x7_s2_w);
    vx_size dims_conv1_7x7_s2_b[2] = { 64, 1 };
    vx_tensor conv1_7x7_s2_b = vxCreateTensor(context, 2, dims_conv1_7x7_s2_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv1_7x7_s2_b);
    vx_size dims_conv2_3x3_reduce_w[4] = { 1, 1, 64, 64 };
    vx_tensor conv2_3x3_reduce_w = vxCreateTensor(context, 4, dims_conv2_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv2_3x3_reduce_w);
    vx_size dims_conv2_3x3_reduce_b[2] = { 64, 1 };
    vx_tensor conv2_3x3_reduce_b = vxCreateTensor(context, 2, dims_conv2_3x3_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv2_3x3_reduce_b);
    vx_size dims_conv2_3x3_w[4] = { 3, 3, 64, 192 };
    vx_tensor conv2_3x3_w = vxCreateTensor(context, 4, dims_conv2_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv2_3x3_w);
    vx_size dims_conv2_3x3_b[2] = { 192, 1 };
    vx_tensor conv2_3x3_b = vxCreateTensor(context, 2, dims_conv2_3x3_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv2_3x3_b);
    vx_size dims_inception_3a_1x1_w[4] = { 1, 1, 192, 64 };
    vx_tensor inception_3a_1x1_w = vxCreateTensor(context, 4, dims_inception_3a_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3a_1x1_w);
    vx_size dims_inception_3a_1x1_b[2] = { 64, 1 };
    vx_tensor inception_3a_1x1_b = vxCreateTensor(context, 2, dims_inception_3a_1x1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3a_1x1_b);
    vx_size dims_inception_3a_3x3_reduce_w[4] = { 1, 1, 192, 96 };
    vx_tensor inception_3a_3x3_reduce_w = vxCreateTensor(context, 4, dims_inception_3a_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3a_3x3_reduce_w);
    vx_size dims_inception_3a_3x3_reduce_b[2] = { 96, 1 };
    vx_tensor inception_3a_3x3_reduce_b = vxCreateTensor(context, 2, dims_inception_3a_3x3_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3a_3x3_reduce_b);
    vx_size dims_inception_3a_3x3_w[4] = { 3, 3, 96, 128 };
    vx_tensor inception_3a_3x3_w = vxCreateTensor(context, 4, dims_inception_3a_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3a_3x3_w);
    vx_size dims_inception_3a_3x3_b[2] = { 128, 1 };
    vx_tensor inception_3a_3x3_b = vxCreateTensor(context, 2, dims_inception_3a_3x3_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3a_3x3_b);
    vx_size dims_inception_3a_5x5_reduce_w[4] = { 1, 1, 192, 16 };
    vx_tensor inception_3a_5x5_reduce_w = vxCreateTensor(context, 4, dims_inception_3a_5x5_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3a_5x5_reduce_w);
    vx_size dims_inception_3a_5x5_reduce_b[2] = { 16, 1 };
    vx_tensor inception_3a_5x5_reduce_b = vxCreateTensor(context, 2, dims_inception_3a_5x5_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3a_5x5_reduce_b);
    vx_size dims_inception_3a_5x5_w[4] = { 5, 5, 16, 32 };
    vx_tensor inception_3a_5x5_w = vxCreateTensor(context, 4, dims_inception_3a_5x5_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3a_5x5_w);
    vx_size dims_inception_3a_5x5_b[2] = { 32, 1 };
    vx_tensor inception_3a_5x5_b = vxCreateTensor(context, 2, dims_inception_3a_5x5_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3a_5x5_b);
    vx_size dims_inception_3a_pool_proj_w[4] = { 1, 1, 192, 32 };
    vx_tensor inception_3a_pool_proj_w = vxCreateTensor(context, 4, dims_inception_3a_pool_proj_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3a_pool_proj_w);
    vx_size dims_inception_3a_pool_proj_b[2] = { 32, 1 };
    vx_tensor inception_3a_pool_proj_b = vxCreateTensor(context, 2, dims_inception_3a_pool_proj_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3a_pool_proj_b);
    vx_size dims_inception_3b_1x1_w[4] = { 1, 1, 256, 128 };
    vx_tensor inception_3b_1x1_w = vxCreateTensor(context, 4, dims_inception_3b_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3b_1x1_w);
    vx_size dims_inception_3b_1x1_b[2] = { 128, 1 };
    vx_tensor inception_3b_1x1_b = vxCreateTensor(context, 2, dims_inception_3b_1x1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3b_1x1_b);
    vx_size dims_inception_3b_3x3_reduce_w[4] = { 1, 1, 256, 128 };
    vx_tensor inception_3b_3x3_reduce_w = vxCreateTensor(context, 4, dims_inception_3b_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3b_3x3_reduce_w);
    vx_size dims_inception_3b_3x3_reduce_b[2] = { 128, 1 };
    vx_tensor inception_3b_3x3_reduce_b = vxCreateTensor(context, 2, dims_inception_3b_3x3_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3b_3x3_reduce_b);
    vx_size dims_inception_3b_3x3_w[4] = { 3, 3, 128, 192 };
    vx_tensor inception_3b_3x3_w = vxCreateTensor(context, 4, dims_inception_3b_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3b_3x3_w);
    vx_size dims_inception_3b_3x3_b[2] = { 192, 1 };
    vx_tensor inception_3b_3x3_b = vxCreateTensor(context, 2, dims_inception_3b_3x3_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3b_3x3_b);
    vx_size dims_inception_3b_5x5_reduce_w[4] = { 1, 1, 256, 32 };
    vx_tensor inception_3b_5x5_reduce_w = vxCreateTensor(context, 4, dims_inception_3b_5x5_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3b_5x5_reduce_w);
    vx_size dims_inception_3b_5x5_reduce_b[2] = { 32, 1 };
    vx_tensor inception_3b_5x5_reduce_b = vxCreateTensor(context, 2, dims_inception_3b_5x5_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3b_5x5_reduce_b);
    vx_size dims_inception_3b_5x5_w[4] = { 5, 5, 32, 96 };
    vx_tensor inception_3b_5x5_w = vxCreateTensor(context, 4, dims_inception_3b_5x5_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3b_5x5_w);
    vx_size dims_inception_3b_5x5_b[2] = { 96, 1 };
    vx_tensor inception_3b_5x5_b = vxCreateTensor(context, 2, dims_inception_3b_5x5_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3b_5x5_b);
    vx_size dims_inception_3b_pool_proj_w[4] = { 1, 1, 256, 64 };
    vx_tensor inception_3b_pool_proj_w = vxCreateTensor(context, 4, dims_inception_3b_pool_proj_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3b_pool_proj_w);
    vx_size dims_inception_3b_pool_proj_b[2] = { 64, 1 };
    vx_tensor inception_3b_pool_proj_b = vxCreateTensor(context, 2, dims_inception_3b_pool_proj_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_3b_pool_proj_b);
    vx_size dims_inception_4a_1x1_w[4] = { 1, 1, 480, 192 };
    vx_tensor inception_4a_1x1_w = vxCreateTensor(context, 4, dims_inception_4a_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4a_1x1_w);
    vx_size dims_inception_4a_1x1_b[2] = { 192, 1 };
    vx_tensor inception_4a_1x1_b = vxCreateTensor(context, 2, dims_inception_4a_1x1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4a_1x1_b);
    vx_size dims_inception_4a_3x3_reduce_w[4] = { 1, 1, 480, 96 };
    vx_tensor inception_4a_3x3_reduce_w = vxCreateTensor(context, 4, dims_inception_4a_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4a_3x3_reduce_w);
    vx_size dims_inception_4a_3x3_reduce_b[2] = { 96, 1 };
    vx_tensor inception_4a_3x3_reduce_b = vxCreateTensor(context, 2, dims_inception_4a_3x3_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4a_3x3_reduce_b);
    vx_size dims_inception_4a_3x3_w[4] = { 3, 3, 96, 208 };
    vx_tensor inception_4a_3x3_w = vxCreateTensor(context, 4, dims_inception_4a_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4a_3x3_w);
    vx_size dims_inception_4a_3x3_b[2] = { 208, 1 };
    vx_tensor inception_4a_3x3_b = vxCreateTensor(context, 2, dims_inception_4a_3x3_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4a_3x3_b);
    vx_size dims_inception_4a_5x5_reduce_w[4] = { 1, 1, 480, 16 };
    vx_tensor inception_4a_5x5_reduce_w = vxCreateTensor(context, 4, dims_inception_4a_5x5_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4a_5x5_reduce_w);
    vx_size dims_inception_4a_5x5_reduce_b[2] = { 16, 1 };
    vx_tensor inception_4a_5x5_reduce_b = vxCreateTensor(context, 2, dims_inception_4a_5x5_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4a_5x5_reduce_b);
    vx_size dims_inception_4a_5x5_w[4] = { 5, 5, 16, 48 };
    vx_tensor inception_4a_5x5_w = vxCreateTensor(context, 4, dims_inception_4a_5x5_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4a_5x5_w);
    vx_size dims_inception_4a_5x5_b[2] = { 48, 1 };
    vx_tensor inception_4a_5x5_b = vxCreateTensor(context, 2, dims_inception_4a_5x5_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4a_5x5_b);
    vx_size dims_inception_4a_pool_proj_w[4] = { 1, 1, 480, 64 };
    vx_tensor inception_4a_pool_proj_w = vxCreateTensor(context, 4, dims_inception_4a_pool_proj_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4a_pool_proj_w);
    vx_size dims_inception_4a_pool_proj_b[2] = { 64, 1 };
    vx_tensor inception_4a_pool_proj_b = vxCreateTensor(context, 2, dims_inception_4a_pool_proj_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4a_pool_proj_b);
    vx_size dims_loss1_conv_w[4] = { 1, 1, 512, 128 };
    vx_tensor loss1_conv_w = vxCreateTensor(context, 4, dims_loss1_conv_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(loss1_conv_w);
    vx_size dims_loss1_conv_b[2] = { 128, 1 };
    vx_tensor loss1_conv_b = vxCreateTensor(context, 2, dims_loss1_conv_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(loss1_conv_b);
    vx_size dims_loss1_fc_w[4] = { 4, 4, 128, 1024 };
    vx_tensor loss1_fc_w = vxCreateTensor(context, 4, dims_loss1_fc_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(loss1_fc_w);
    vx_size dims_loss1_fc_b[2] = { 1024, 1 };
    vx_tensor loss1_fc_b = vxCreateTensor(context, 2, dims_loss1_fc_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(loss1_fc_b);
    vx_size dims_loss1_classifier_w[4] = { 1, 1, 1024, 1000 };
    vx_tensor loss1_classifier_w = vxCreateTensor(context, 4, dims_loss1_classifier_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(loss1_classifier_w);
    vx_size dims_loss1_classifier_b[2] = { 1000, 1 };
    vx_tensor loss1_classifier_b = vxCreateTensor(context, 2, dims_loss1_classifier_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(loss1_classifier_b);
    vx_size dims_inception_4b_1x1_w[4] = { 1, 1, 512, 160 };
    vx_tensor inception_4b_1x1_w = vxCreateTensor(context, 4, dims_inception_4b_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4b_1x1_w);
    vx_size dims_inception_4b_1x1_b[2] = { 160, 1 };
    vx_tensor inception_4b_1x1_b = vxCreateTensor(context, 2, dims_inception_4b_1x1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4b_1x1_b);
    vx_size dims_inception_4b_3x3_reduce_w[4] = { 1, 1, 512, 112 };
    vx_tensor inception_4b_3x3_reduce_w = vxCreateTensor(context, 4, dims_inception_4b_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4b_3x3_reduce_w);
    vx_size dims_inception_4b_3x3_reduce_b[2] = { 112, 1 };
    vx_tensor inception_4b_3x3_reduce_b = vxCreateTensor(context, 2, dims_inception_4b_3x3_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4b_3x3_reduce_b);
    vx_size dims_inception_4b_3x3_w[4] = { 3, 3, 112, 224 };
    vx_tensor inception_4b_3x3_w = vxCreateTensor(context, 4, dims_inception_4b_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4b_3x3_w);
    vx_size dims_inception_4b_3x3_b[2] = { 224, 1 };
    vx_tensor inception_4b_3x3_b = vxCreateTensor(context, 2, dims_inception_4b_3x3_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4b_3x3_b);
    vx_size dims_inception_4b_5x5_reduce_w[4] = { 1, 1, 512, 24 };
    vx_tensor inception_4b_5x5_reduce_w = vxCreateTensor(context, 4, dims_inception_4b_5x5_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4b_5x5_reduce_w);
    vx_size dims_inception_4b_5x5_reduce_b[2] = { 24, 1 };
    vx_tensor inception_4b_5x5_reduce_b = vxCreateTensor(context, 2, dims_inception_4b_5x5_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4b_5x5_reduce_b);
    vx_size dims_inception_4b_5x5_w[4] = { 5, 5, 24, 64 };
    vx_tensor inception_4b_5x5_w = vxCreateTensor(context, 4, dims_inception_4b_5x5_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4b_5x5_w);
    vx_size dims_inception_4b_5x5_b[2] = { 64, 1 };
    vx_tensor inception_4b_5x5_b = vxCreateTensor(context, 2, dims_inception_4b_5x5_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4b_5x5_b);
    vx_size dims_inception_4b_pool_proj_w[4] = { 1, 1, 512, 64 };
    vx_tensor inception_4b_pool_proj_w = vxCreateTensor(context, 4, dims_inception_4b_pool_proj_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4b_pool_proj_w);
    vx_size dims_inception_4b_pool_proj_b[2] = { 64, 1 };
    vx_tensor inception_4b_pool_proj_b = vxCreateTensor(context, 2, dims_inception_4b_pool_proj_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4b_pool_proj_b);
    vx_size dims_inception_4c_1x1_w[4] = { 1, 1, 512, 128 };
    vx_tensor inception_4c_1x1_w = vxCreateTensor(context, 4, dims_inception_4c_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4c_1x1_w);
    vx_size dims_inception_4c_1x1_b[2] = { 128, 1 };
    vx_tensor inception_4c_1x1_b = vxCreateTensor(context, 2, dims_inception_4c_1x1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4c_1x1_b);
    vx_size dims_inception_4c_3x3_reduce_w[4] = { 1, 1, 512, 128 };
    vx_tensor inception_4c_3x3_reduce_w = vxCreateTensor(context, 4, dims_inception_4c_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4c_3x3_reduce_w);
    vx_size dims_inception_4c_3x3_reduce_b[2] = { 128, 1 };
    vx_tensor inception_4c_3x3_reduce_b = vxCreateTensor(context, 2, dims_inception_4c_3x3_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4c_3x3_reduce_b);
    vx_size dims_inception_4c_3x3_w[4] = { 3, 3, 128, 256 };
    vx_tensor inception_4c_3x3_w = vxCreateTensor(context, 4, dims_inception_4c_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4c_3x3_w);
    vx_size dims_inception_4c_3x3_b[2] = { 256, 1 };
    vx_tensor inception_4c_3x3_b = vxCreateTensor(context, 2, dims_inception_4c_3x3_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4c_3x3_b);
    vx_size dims_inception_4c_5x5_reduce_w[4] = { 1, 1, 512, 24 };
    vx_tensor inception_4c_5x5_reduce_w = vxCreateTensor(context, 4, dims_inception_4c_5x5_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4c_5x5_reduce_w);
    vx_size dims_inception_4c_5x5_reduce_b[2] = { 24, 1 };
    vx_tensor inception_4c_5x5_reduce_b = vxCreateTensor(context, 2, dims_inception_4c_5x5_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4c_5x5_reduce_b);
    vx_size dims_inception_4c_5x5_w[4] = { 5, 5, 24, 64 };
    vx_tensor inception_4c_5x5_w = vxCreateTensor(context, 4, dims_inception_4c_5x5_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4c_5x5_w);
    vx_size dims_inception_4c_5x5_b[2] = { 64, 1 };
    vx_tensor inception_4c_5x5_b = vxCreateTensor(context, 2, dims_inception_4c_5x5_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4c_5x5_b);
    vx_size dims_inception_4c_pool_proj_w[4] = { 1, 1, 512, 64 };
    vx_tensor inception_4c_pool_proj_w = vxCreateTensor(context, 4, dims_inception_4c_pool_proj_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4c_pool_proj_w);
    vx_size dims_inception_4c_pool_proj_b[2] = { 64, 1 };
    vx_tensor inception_4c_pool_proj_b = vxCreateTensor(context, 2, dims_inception_4c_pool_proj_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4c_pool_proj_b);
    vx_size dims_inception_4d_1x1_w[4] = { 1, 1, 512, 112 };
    vx_tensor inception_4d_1x1_w = vxCreateTensor(context, 4, dims_inception_4d_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4d_1x1_w);
    vx_size dims_inception_4d_1x1_b[2] = { 112, 1 };
    vx_tensor inception_4d_1x1_b = vxCreateTensor(context, 2, dims_inception_4d_1x1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4d_1x1_b);
    vx_size dims_inception_4d_3x3_reduce_w[4] = { 1, 1, 512, 144 };
    vx_tensor inception_4d_3x3_reduce_w = vxCreateTensor(context, 4, dims_inception_4d_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4d_3x3_reduce_w);
    vx_size dims_inception_4d_3x3_reduce_b[2] = { 144, 1 };
    vx_tensor inception_4d_3x3_reduce_b = vxCreateTensor(context, 2, dims_inception_4d_3x3_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4d_3x3_reduce_b);
    vx_size dims_inception_4d_3x3_w[4] = { 3, 3, 144, 288 };
    vx_tensor inception_4d_3x3_w = vxCreateTensor(context, 4, dims_inception_4d_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4d_3x3_w);
    vx_size dims_inception_4d_3x3_b[2] = { 288, 1 };
    vx_tensor inception_4d_3x3_b = vxCreateTensor(context, 2, dims_inception_4d_3x3_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4d_3x3_b);
    vx_size dims_inception_4d_5x5_reduce_w[4] = { 1, 1, 512, 32 };
    vx_tensor inception_4d_5x5_reduce_w = vxCreateTensor(context, 4, dims_inception_4d_5x5_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4d_5x5_reduce_w);
    vx_size dims_inception_4d_5x5_reduce_b[2] = { 32, 1 };
    vx_tensor inception_4d_5x5_reduce_b = vxCreateTensor(context, 2, dims_inception_4d_5x5_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4d_5x5_reduce_b);
    vx_size dims_inception_4d_5x5_w[4] = { 5, 5, 32, 64 };
    vx_tensor inception_4d_5x5_w = vxCreateTensor(context, 4, dims_inception_4d_5x5_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4d_5x5_w);
    vx_size dims_inception_4d_5x5_b[2] = { 64, 1 };
    vx_tensor inception_4d_5x5_b = vxCreateTensor(context, 2, dims_inception_4d_5x5_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4d_5x5_b);
    vx_size dims_inception_4d_pool_proj_w[4] = { 1, 1, 512, 64 };
    vx_tensor inception_4d_pool_proj_w = vxCreateTensor(context, 4, dims_inception_4d_pool_proj_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4d_pool_proj_w);
    vx_size dims_inception_4d_pool_proj_b[2] = { 64, 1 };
    vx_tensor inception_4d_pool_proj_b = vxCreateTensor(context, 2, dims_inception_4d_pool_proj_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4d_pool_proj_b);
    vx_size dims_loss2_conv_w[4] = { 1, 1, 528, 128 };
    vx_tensor loss2_conv_w = vxCreateTensor(context, 4, dims_loss2_conv_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(loss2_conv_w);
    vx_size dims_loss2_conv_b[2] = { 128, 1 };
    vx_tensor loss2_conv_b = vxCreateTensor(context, 2, dims_loss2_conv_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(loss2_conv_b);
    vx_size dims_loss2_fc_w[4] = { 4, 4, 128, 1024 };
    vx_tensor loss2_fc_w = vxCreateTensor(context, 4, dims_loss2_fc_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(loss2_fc_w);
    vx_size dims_loss2_fc_b[2] = { 1024, 1 };
    vx_tensor loss2_fc_b = vxCreateTensor(context, 2, dims_loss2_fc_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(loss2_fc_b);
    vx_size dims_loss2_classifier_w[4] = { 1, 1, 1024, 1000 };
    vx_tensor loss2_classifier_w = vxCreateTensor(context, 4, dims_loss2_classifier_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(loss2_classifier_w);
    vx_size dims_loss2_classifier_b[2] = { 1000, 1 };
    vx_tensor loss2_classifier_b = vxCreateTensor(context, 2, dims_loss2_classifier_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(loss2_classifier_b);
    vx_size dims_inception_4e_1x1_w[4] = { 1, 1, 528, 256 };
    vx_tensor inception_4e_1x1_w = vxCreateTensor(context, 4, dims_inception_4e_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4e_1x1_w);
    vx_size dims_inception_4e_1x1_b[2] = { 256, 1 };
    vx_tensor inception_4e_1x1_b = vxCreateTensor(context, 2, dims_inception_4e_1x1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4e_1x1_b);
    vx_size dims_inception_4e_3x3_reduce_w[4] = { 1, 1, 528, 160 };
    vx_tensor inception_4e_3x3_reduce_w = vxCreateTensor(context, 4, dims_inception_4e_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4e_3x3_reduce_w);
    vx_size dims_inception_4e_3x3_reduce_b[2] = { 160, 1 };
    vx_tensor inception_4e_3x3_reduce_b = vxCreateTensor(context, 2, dims_inception_4e_3x3_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4e_3x3_reduce_b);
    vx_size dims_inception_4e_3x3_w[4] = { 3, 3, 160, 320 };
    vx_tensor inception_4e_3x3_w = vxCreateTensor(context, 4, dims_inception_4e_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4e_3x3_w);
    vx_size dims_inception_4e_3x3_b[2] = { 320, 1 };
    vx_tensor inception_4e_3x3_b = vxCreateTensor(context, 2, dims_inception_4e_3x3_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4e_3x3_b);
    vx_size dims_inception_4e_5x5_reduce_w[4] = { 1, 1, 528, 32 };
    vx_tensor inception_4e_5x5_reduce_w = vxCreateTensor(context, 4, dims_inception_4e_5x5_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4e_5x5_reduce_w);
    vx_size dims_inception_4e_5x5_reduce_b[2] = { 32, 1 };
    vx_tensor inception_4e_5x5_reduce_b = vxCreateTensor(context, 2, dims_inception_4e_5x5_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4e_5x5_reduce_b);
    vx_size dims_inception_4e_5x5_w[4] = { 5, 5, 32, 128 };
    vx_tensor inception_4e_5x5_w = vxCreateTensor(context, 4, dims_inception_4e_5x5_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4e_5x5_w);
    vx_size dims_inception_4e_5x5_b[2] = { 128, 1 };
    vx_tensor inception_4e_5x5_b = vxCreateTensor(context, 2, dims_inception_4e_5x5_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4e_5x5_b);
    vx_size dims_inception_4e_pool_proj_w[4] = { 1, 1, 528, 128 };
    vx_tensor inception_4e_pool_proj_w = vxCreateTensor(context, 4, dims_inception_4e_pool_proj_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4e_pool_proj_w);
    vx_size dims_inception_4e_pool_proj_b[2] = { 128, 1 };
    vx_tensor inception_4e_pool_proj_b = vxCreateTensor(context, 2, dims_inception_4e_pool_proj_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_4e_pool_proj_b);
    vx_size dims_inception_5a_1x1_w[4] = { 1, 1, 832, 256 };
    vx_tensor inception_5a_1x1_w = vxCreateTensor(context, 4, dims_inception_5a_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5a_1x1_w);
    vx_size dims_inception_5a_1x1_b[2] = { 256, 1 };
    vx_tensor inception_5a_1x1_b = vxCreateTensor(context, 2, dims_inception_5a_1x1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5a_1x1_b);
    vx_size dims_inception_5a_3x3_reduce_w[4] = { 1, 1, 832, 160 };
    vx_tensor inception_5a_3x3_reduce_w = vxCreateTensor(context, 4, dims_inception_5a_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5a_3x3_reduce_w);
    vx_size dims_inception_5a_3x3_reduce_b[2] = { 160, 1 };
    vx_tensor inception_5a_3x3_reduce_b = vxCreateTensor(context, 2, dims_inception_5a_3x3_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5a_3x3_reduce_b);
    vx_size dims_inception_5a_3x3_w[4] = { 3, 3, 160, 320 };
    vx_tensor inception_5a_3x3_w = vxCreateTensor(context, 4, dims_inception_5a_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5a_3x3_w);
    vx_size dims_inception_5a_3x3_b[2] = { 320, 1 };
    vx_tensor inception_5a_3x3_b = vxCreateTensor(context, 2, dims_inception_5a_3x3_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5a_3x3_b);
    vx_size dims_inception_5a_5x5_reduce_w[4] = { 1, 1, 832, 32 };
    vx_tensor inception_5a_5x5_reduce_w = vxCreateTensor(context, 4, dims_inception_5a_5x5_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5a_5x5_reduce_w);
    vx_size dims_inception_5a_5x5_reduce_b[2] = { 32, 1 };
    vx_tensor inception_5a_5x5_reduce_b = vxCreateTensor(context, 2, dims_inception_5a_5x5_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5a_5x5_reduce_b);
    vx_size dims_inception_5a_5x5_w[4] = { 5, 5, 32, 128 };
    vx_tensor inception_5a_5x5_w = vxCreateTensor(context, 4, dims_inception_5a_5x5_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5a_5x5_w);
    vx_size dims_inception_5a_5x5_b[2] = { 128, 1 };
    vx_tensor inception_5a_5x5_b = vxCreateTensor(context, 2, dims_inception_5a_5x5_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5a_5x5_b);
    vx_size dims_inception_5a_pool_proj_w[4] = { 1, 1, 832, 128 };
    vx_tensor inception_5a_pool_proj_w = vxCreateTensor(context, 4, dims_inception_5a_pool_proj_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5a_pool_proj_w);
    vx_size dims_inception_5a_pool_proj_b[2] = { 128, 1 };
    vx_tensor inception_5a_pool_proj_b = vxCreateTensor(context, 2, dims_inception_5a_pool_proj_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5a_pool_proj_b);
    vx_size dims_inception_5b_1x1_w[4] = { 1, 1, 832, 384 };
    vx_tensor inception_5b_1x1_w = vxCreateTensor(context, 4, dims_inception_5b_1x1_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5b_1x1_w);
    vx_size dims_inception_5b_1x1_b[2] = { 384, 1 };
    vx_tensor inception_5b_1x1_b = vxCreateTensor(context, 2, dims_inception_5b_1x1_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5b_1x1_b);
    vx_size dims_inception_5b_3x3_reduce_w[4] = { 1, 1, 832, 192 };
    vx_tensor inception_5b_3x3_reduce_w = vxCreateTensor(context, 4, dims_inception_5b_3x3_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5b_3x3_reduce_w);
    vx_size dims_inception_5b_3x3_reduce_b[2] = { 192, 1 };
    vx_tensor inception_5b_3x3_reduce_b = vxCreateTensor(context, 2, dims_inception_5b_3x3_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5b_3x3_reduce_b);
    vx_size dims_inception_5b_3x3_w[4] = { 3, 3, 192, 384 };
    vx_tensor inception_5b_3x3_w = vxCreateTensor(context, 4, dims_inception_5b_3x3_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5b_3x3_w);
    vx_size dims_inception_5b_3x3_b[2] = { 384, 1 };
    vx_tensor inception_5b_3x3_b = vxCreateTensor(context, 2, dims_inception_5b_3x3_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5b_3x3_b);
    vx_size dims_inception_5b_5x5_reduce_w[4] = { 1, 1, 832, 48 };
    vx_tensor inception_5b_5x5_reduce_w = vxCreateTensor(context, 4, dims_inception_5b_5x5_reduce_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5b_5x5_reduce_w);
    vx_size dims_inception_5b_5x5_reduce_b[2] = { 48, 1 };
    vx_tensor inception_5b_5x5_reduce_b = vxCreateTensor(context, 2, dims_inception_5b_5x5_reduce_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5b_5x5_reduce_b);
    vx_size dims_inception_5b_5x5_w[4] = { 5, 5, 48, 128 };
    vx_tensor inception_5b_5x5_w = vxCreateTensor(context, 4, dims_inception_5b_5x5_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5b_5x5_w);
    vx_size dims_inception_5b_5x5_b[2] = { 128, 1 };
    vx_tensor inception_5b_5x5_b = vxCreateTensor(context, 2, dims_inception_5b_5x5_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5b_5x5_b);
    vx_size dims_inception_5b_pool_proj_w[4] = { 1, 1, 832, 128 };
    vx_tensor inception_5b_pool_proj_w = vxCreateTensor(context, 4, dims_inception_5b_pool_proj_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5b_pool_proj_w);
    vx_size dims_inception_5b_pool_proj_b[2] = { 128, 1 };
    vx_tensor inception_5b_pool_proj_b = vxCreateTensor(context, 2, dims_inception_5b_pool_proj_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(inception_5b_pool_proj_b);
    vx_size dims_loss3_classifier_w[4] = { 1, 1, 1024, 1000 };
    vx_tensor loss3_classifier_w = vxCreateTensor(context, 4, dims_loss3_classifier_w, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(loss3_classifier_w);
    vx_size dims_loss3_classifier_b[2] = { 1000, 1 };
    vx_tensor loss3_classifier_b = vxCreateTensor(context, 2, dims_loss3_classifier_b, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(loss3_classifier_b);

    // initialize variables
    FILE * fp__variables = fopen(binaryFilename, "rb");
    if(!fp__variables) {
        vxAddLogEntry((vx_reference)context, VX_FAILURE, "ERROR: unable to open: %s\n", binaryFilename);
        return VX_FAILURE;
    }
    { vx_uint32 magic = 0;
      fread(&magic, 1, sizeof(magic), fp__variables);
      if(magic != 0xf00dd1e0) {
        vxAddLogEntry((vx_reference)context, VX_FAILURE, "ERROR: invalid file magic in %s\n", binaryFilename);
        return VX_FAILURE;
      }
    }
    ERROR_CHECK_STATUS(initializeTensor(context, conv1_7x7_s2_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv1_7x7_s2_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv2_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv2_3x3_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv2_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, conv2_3x3_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3a_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3a_1x1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3a_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3a_3x3_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3a_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3a_3x3_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3a_5x5_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3a_5x5_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3a_5x5_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3a_5x5_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3a_pool_proj_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3a_pool_proj_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3b_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3b_1x1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3b_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3b_3x3_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3b_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3b_3x3_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3b_5x5_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3b_5x5_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3b_5x5_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3b_5x5_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3b_pool_proj_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_3b_pool_proj_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4a_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4a_1x1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4a_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4a_3x3_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4a_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4a_3x3_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4a_5x5_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4a_5x5_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4a_5x5_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4a_5x5_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4a_pool_proj_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4a_pool_proj_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, loss1_conv_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, loss1_conv_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, loss1_fc_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, loss1_fc_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, loss1_classifier_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, loss1_classifier_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4b_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4b_1x1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4b_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4b_3x3_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4b_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4b_3x3_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4b_5x5_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4b_5x5_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4b_5x5_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4b_5x5_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4b_pool_proj_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4b_pool_proj_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4c_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4c_1x1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4c_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4c_3x3_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4c_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4c_3x3_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4c_5x5_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4c_5x5_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4c_5x5_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4c_5x5_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4c_pool_proj_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4c_pool_proj_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4d_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4d_1x1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4d_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4d_3x3_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4d_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4d_3x3_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4d_5x5_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4d_5x5_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4d_5x5_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4d_5x5_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4d_pool_proj_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4d_pool_proj_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, loss2_conv_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, loss2_conv_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, loss2_fc_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, loss2_fc_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, loss2_classifier_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, loss2_classifier_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4e_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4e_1x1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4e_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4e_3x3_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4e_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4e_3x3_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4e_5x5_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4e_5x5_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4e_5x5_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4e_5x5_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4e_pool_proj_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_4e_pool_proj_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5a_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5a_1x1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5a_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5a_3x3_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5a_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5a_3x3_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5a_5x5_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5a_5x5_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5a_5x5_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5a_5x5_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5a_pool_proj_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5a_pool_proj_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5b_1x1_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5b_1x1_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5b_3x3_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5b_3x3_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5b_3x3_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5b_3x3_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5b_5x5_reduce_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5b_5x5_reduce_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5b_5x5_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5b_5x5_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5b_pool_proj_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, inception_5b_pool_proj_b, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, loss3_classifier_w, fp__variables, binaryFilename));
    ERROR_CHECK_STATUS(initializeTensor(context, loss3_classifier_b, fp__variables, binaryFilename));
    { vx_uint32 magic = 0;
      fread(&magic, 1, sizeof(magic), fp__variables);
      if(magic != 0xf00dd1e2) {
        vxAddLogEntry((vx_reference)context, VX_FAILURE, "ERROR: invalid eoff magic in %s\n", binaryFilename);
        return VX_FAILURE;
      }
      fclose(fp__variables);
    }

    // create local tensors used in graph
    vx_size dims_conv_conv1_7x7_s2[4] = { 112, 112, 64, 1 };
    vx_tensor conv_conv1_7x7_s2 = vxCreateVirtualTensor(graph, 4, dims_conv_conv1_7x7_s2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv1_7x7_s2);
    vx_size dims_relu_conv1_relu_7x7[4] = { 112, 112, 64, 1 };
    vx_tensor relu_conv1_relu_7x7 = vxCreateVirtualTensor(graph, 4, dims_relu_conv1_relu_7x7, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_conv1_relu_7x7);
    vx_size dims_max_pool_pool1_3x3_s2[4] = { 56, 56, 64, 1 };
    vx_tensor max_pool_pool1_3x3_s2 = vxCreateVirtualTensor(graph, 4, dims_max_pool_pool1_3x3_s2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_pool1_3x3_s2);
    vx_size dims_lrn_pool1_norm1[4] = { 56, 56, 64, 1 };
    vx_tensor lrn_pool1_norm1 = vxCreateVirtualTensor(graph, 4, dims_lrn_pool1_norm1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(lrn_pool1_norm1);
    vx_size dims_conv_conv2_3x3_reduce[4] = { 56, 56, 64, 1 };
    vx_tensor conv_conv2_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_conv2_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv2_3x3_reduce);
    vx_size dims_relu_conv2_relu_3x3_reduce[4] = { 56, 56, 64, 1 };
    vx_tensor relu_conv2_relu_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_conv2_relu_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_conv2_relu_3x3_reduce);
    vx_size dims_conv_conv2_3x3[4] = { 56, 56, 192, 1 };
    vx_tensor conv_conv2_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_conv2_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_conv2_3x3);
    vx_size dims_relu_conv2_relu_3x3[4] = { 56, 56, 192, 1 };
    vx_tensor relu_conv2_relu_3x3 = vxCreateVirtualTensor(graph, 4, dims_relu_conv2_relu_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_conv2_relu_3x3);
    vx_size dims_lrn_conv2_norm2[4] = { 56, 56, 192, 1 };
    vx_tensor lrn_conv2_norm2 = vxCreateVirtualTensor(graph, 4, dims_lrn_conv2_norm2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(lrn_conv2_norm2);
    vx_size dims_max_pool_pool2_3x3_s2[4] = { 28, 28, 192, 1 };
    vx_tensor max_pool_pool2_3x3_s2 = vxCreateVirtualTensor(graph, 4, dims_max_pool_pool2_3x3_s2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_pool2_3x3_s2);
    vx_size dims_conv_inception_3a_1x1[4] = { 28, 28, 64, 1 };
    vx_tensor conv_inception_3a_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_3a_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_3a_1x1);
    vx_size dims_relu_inception_3a_relu_1x1[4] = { 28, 28, 64, 1 };
    vx_tensor relu_inception_3a_relu_1x1 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_3a_relu_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_3a_relu_1x1);
    vx_size dims_conv_inception_3a_3x3_reduce[4] = { 28, 28, 96, 1 };
    vx_tensor conv_inception_3a_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_3a_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_3a_3x3_reduce);
    vx_size dims_relu_inception_3a_relu_3x3_reduce[4] = { 28, 28, 96, 1 };
    vx_tensor relu_inception_3a_relu_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_3a_relu_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_3a_relu_3x3_reduce);
    vx_size dims_conv_inception_3a_3x3[4] = { 28, 28, 128, 1 };
    vx_tensor conv_inception_3a_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_3a_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_3a_3x3);
    vx_size dims_relu_inception_3a_relu_3x3[4] = { 28, 28, 128, 1 };
    vx_tensor relu_inception_3a_relu_3x3 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_3a_relu_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_3a_relu_3x3);
    vx_size dims_conv_inception_3a_5x5_reduce[4] = { 28, 28, 16, 1 };
    vx_tensor conv_inception_3a_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_3a_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_3a_5x5_reduce);
    vx_size dims_relu_inception_3a_relu_5x5_reduce[4] = { 28, 28, 16, 1 };
    vx_tensor relu_inception_3a_relu_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_3a_relu_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_3a_relu_5x5_reduce);
    vx_size dims_conv_inception_3a_5x5[4] = { 28, 28, 32, 1 };
    vx_tensor conv_inception_3a_5x5 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_3a_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_3a_5x5);
    vx_size dims_relu_inception_3a_relu_5x5[4] = { 28, 28, 32, 1 };
    vx_tensor relu_inception_3a_relu_5x5 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_3a_relu_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_3a_relu_5x5);
    vx_size dims_max_pool_inception_3a_pool[4] = { 28, 28, 192, 1 };
    vx_tensor max_pool_inception_3a_pool = vxCreateVirtualTensor(graph, 4, dims_max_pool_inception_3a_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_inception_3a_pool);
    vx_size dims_conv_inception_3a_pool_proj[4] = { 28, 28, 32, 1 };
    vx_tensor conv_inception_3a_pool_proj = vxCreateVirtualTensor(graph, 4, dims_conv_inception_3a_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_3a_pool_proj);
    vx_size dims_relu_inception_3a_relu_pool_proj[4] = { 28, 28, 32, 1 };
    vx_tensor relu_inception_3a_relu_pool_proj = vxCreateVirtualTensor(graph, 4, dims_relu_inception_3a_relu_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_3a_relu_pool_proj);
    vx_size dims_concat_inception_3a_output[4] = { 28, 28, 256, 1 };
    vx_tensor concat_inception_3a_output = vxCreateVirtualTensor(graph, 4, dims_concat_inception_3a_output, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_3a_output);
    vx_size dims_conv_inception_3b_1x1[4] = { 28, 28, 128, 1 };
    vx_tensor conv_inception_3b_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_3b_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_3b_1x1);
    vx_size dims_relu_inception_3b_relu_1x1[4] = { 28, 28, 128, 1 };
    vx_tensor relu_inception_3b_relu_1x1 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_3b_relu_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_3b_relu_1x1);
    vx_size dims_conv_inception_3b_3x3_reduce[4] = { 28, 28, 128, 1 };
    vx_tensor conv_inception_3b_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_3b_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_3b_3x3_reduce);
    vx_size dims_relu_inception_3b_relu_3x3_reduce[4] = { 28, 28, 128, 1 };
    vx_tensor relu_inception_3b_relu_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_3b_relu_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_3b_relu_3x3_reduce);
    vx_size dims_conv_inception_3b_3x3[4] = { 28, 28, 192, 1 };
    vx_tensor conv_inception_3b_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_3b_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_3b_3x3);
    vx_size dims_relu_inception_3b_relu_3x3[4] = { 28, 28, 192, 1 };
    vx_tensor relu_inception_3b_relu_3x3 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_3b_relu_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_3b_relu_3x3);
    vx_size dims_conv_inception_3b_5x5_reduce[4] = { 28, 28, 32, 1 };
    vx_tensor conv_inception_3b_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_3b_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_3b_5x5_reduce);
    vx_size dims_relu_inception_3b_relu_5x5_reduce[4] = { 28, 28, 32, 1 };
    vx_tensor relu_inception_3b_relu_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_3b_relu_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_3b_relu_5x5_reduce);
    vx_size dims_conv_inception_3b_5x5[4] = { 28, 28, 96, 1 };
    vx_tensor conv_inception_3b_5x5 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_3b_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_3b_5x5);
    vx_size dims_relu_inception_3b_relu_5x5[4] = { 28, 28, 96, 1 };
    vx_tensor relu_inception_3b_relu_5x5 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_3b_relu_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_3b_relu_5x5);
    vx_size dims_max_pool_inception_3b_pool[4] = { 28, 28, 256, 1 };
    vx_tensor max_pool_inception_3b_pool = vxCreateVirtualTensor(graph, 4, dims_max_pool_inception_3b_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_inception_3b_pool);
    vx_size dims_conv_inception_3b_pool_proj[4] = { 28, 28, 64, 1 };
    vx_tensor conv_inception_3b_pool_proj = vxCreateVirtualTensor(graph, 4, dims_conv_inception_3b_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_3b_pool_proj);
    vx_size dims_relu_inception_3b_relu_pool_proj[4] = { 28, 28, 64, 1 };
    vx_tensor relu_inception_3b_relu_pool_proj = vxCreateVirtualTensor(graph, 4, dims_relu_inception_3b_relu_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_3b_relu_pool_proj);
    vx_size dims_concat_inception_3b_output[4] = { 28, 28, 480, 1 };
    vx_tensor concat_inception_3b_output = vxCreateVirtualTensor(graph, 4, dims_concat_inception_3b_output, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_3b_output);
    vx_size dims_max_pool_pool3_3x3_s2[4] = { 14, 14, 480, 1 };
    vx_tensor max_pool_pool3_3x3_s2 = vxCreateVirtualTensor(graph, 4, dims_max_pool_pool3_3x3_s2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_pool3_3x3_s2);
    vx_size dims_conv_inception_4a_1x1[4] = { 14, 14, 192, 1 };
    vx_tensor conv_inception_4a_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4a_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4a_1x1);
    vx_size dims_relu_inception_4a_relu_1x1[4] = { 14, 14, 192, 1 };
    vx_tensor relu_inception_4a_relu_1x1 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4a_relu_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4a_relu_1x1);
    vx_size dims_conv_inception_4a_3x3_reduce[4] = { 14, 14, 96, 1 };
    vx_tensor conv_inception_4a_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4a_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4a_3x3_reduce);
    vx_size dims_relu_inception_4a_relu_3x3_reduce[4] = { 14, 14, 96, 1 };
    vx_tensor relu_inception_4a_relu_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4a_relu_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4a_relu_3x3_reduce);
    vx_size dims_conv_inception_4a_3x3[4] = { 14, 14, 208, 1 };
    vx_tensor conv_inception_4a_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4a_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4a_3x3);
    vx_size dims_relu_inception_4a_relu_3x3[4] = { 14, 14, 208, 1 };
    vx_tensor relu_inception_4a_relu_3x3 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4a_relu_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4a_relu_3x3);
    vx_size dims_conv_inception_4a_5x5_reduce[4] = { 14, 14, 16, 1 };
    vx_tensor conv_inception_4a_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4a_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4a_5x5_reduce);
    vx_size dims_relu_inception_4a_relu_5x5_reduce[4] = { 14, 14, 16, 1 };
    vx_tensor relu_inception_4a_relu_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4a_relu_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4a_relu_5x5_reduce);
    vx_size dims_conv_inception_4a_5x5[4] = { 14, 14, 48, 1 };
    vx_tensor conv_inception_4a_5x5 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4a_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4a_5x5);
    vx_size dims_relu_inception_4a_relu_5x5[4] = { 14, 14, 48, 1 };
    vx_tensor relu_inception_4a_relu_5x5 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4a_relu_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4a_relu_5x5);
    vx_size dims_max_pool_inception_4a_pool[4] = { 14, 14, 480, 1 };
    vx_tensor max_pool_inception_4a_pool = vxCreateVirtualTensor(graph, 4, dims_max_pool_inception_4a_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_inception_4a_pool);
    vx_size dims_conv_inception_4a_pool_proj[4] = { 14, 14, 64, 1 };
    vx_tensor conv_inception_4a_pool_proj = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4a_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4a_pool_proj);
    vx_size dims_relu_inception_4a_relu_pool_proj[4] = { 14, 14, 64, 1 };
    vx_tensor relu_inception_4a_relu_pool_proj = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4a_relu_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4a_relu_pool_proj);
    vx_size dims_concat_inception_4a_output[4] = { 14, 14, 512, 1 };
    vx_tensor concat_inception_4a_output = vxCreateVirtualTensor(graph, 4, dims_concat_inception_4a_output, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_4a_output);
    vx_size dims_avg_pool_loss1_ave_pool[4] = { 4, 4, 512, 1 };
    vx_tensor avg_pool_loss1_ave_pool = vxCreateVirtualTensor(graph, 4, dims_avg_pool_loss1_ave_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_loss1_ave_pool);
    vx_size dims_conv_loss1_conv[4] = { 4, 4, 128, 1 };
    vx_tensor conv_loss1_conv = vxCreateVirtualTensor(graph, 4, dims_conv_loss1_conv, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_loss1_conv);
    vx_size dims_relu_loss1_relu_conv[4] = { 4, 4, 128, 1 };
    vx_tensor relu_loss1_relu_conv = vxCreateVirtualTensor(graph, 4, dims_relu_loss1_relu_conv, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_loss1_relu_conv);
    vx_size dims_gemm_loss1_fc[4] = { 1, 1, 1024, 1 };
    vx_tensor gemm_loss1_fc = vxCreateVirtualTensor(graph, 4, dims_gemm_loss1_fc, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(gemm_loss1_fc);
    vx_size dims_relu_loss1_relu_fc[4] = { 1, 1, 1024, 1 };
    vx_tensor relu_loss1_relu_fc = vxCreateVirtualTensor(graph, 4, dims_relu_loss1_relu_fc, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_loss1_relu_fc);
    vx_size dims_gemm_loss1_classifier[4] = { 1, 1, 1000, 1 };
    vx_tensor gemm_loss1_classifier = vxCreateVirtualTensor(graph, 4, dims_gemm_loss1_classifier, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(gemm_loss1_classifier);
    vx_size dims_conv_inception_4b_1x1[4] = { 14, 14, 160, 1 };
    vx_tensor conv_inception_4b_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4b_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4b_1x1);
    vx_size dims_relu_inception_4b_relu_1x1[4] = { 14, 14, 160, 1 };
    vx_tensor relu_inception_4b_relu_1x1 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4b_relu_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4b_relu_1x1);
    vx_size dims_conv_inception_4b_3x3_reduce[4] = { 14, 14, 112, 1 };
    vx_tensor conv_inception_4b_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4b_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4b_3x3_reduce);
    vx_size dims_relu_inception_4b_relu_3x3_reduce[4] = { 14, 14, 112, 1 };
    vx_tensor relu_inception_4b_relu_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4b_relu_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4b_relu_3x3_reduce);
    vx_size dims_conv_inception_4b_3x3[4] = { 14, 14, 224, 1 };
    vx_tensor conv_inception_4b_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4b_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4b_3x3);
    vx_size dims_relu_inception_4b_relu_3x3[4] = { 14, 14, 224, 1 };
    vx_tensor relu_inception_4b_relu_3x3 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4b_relu_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4b_relu_3x3);
    vx_size dims_conv_inception_4b_5x5_reduce[4] = { 14, 14, 24, 1 };
    vx_tensor conv_inception_4b_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4b_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4b_5x5_reduce);
    vx_size dims_relu_inception_4b_relu_5x5_reduce[4] = { 14, 14, 24, 1 };
    vx_tensor relu_inception_4b_relu_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4b_relu_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4b_relu_5x5_reduce);
    vx_size dims_conv_inception_4b_5x5[4] = { 14, 14, 64, 1 };
    vx_tensor conv_inception_4b_5x5 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4b_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4b_5x5);
    vx_size dims_relu_inception_4b_relu_5x5[4] = { 14, 14, 64, 1 };
    vx_tensor relu_inception_4b_relu_5x5 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4b_relu_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4b_relu_5x5);
    vx_size dims_max_pool_inception_4b_pool[4] = { 14, 14, 512, 1 };
    vx_tensor max_pool_inception_4b_pool = vxCreateVirtualTensor(graph, 4, dims_max_pool_inception_4b_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_inception_4b_pool);
    vx_size dims_conv_inception_4b_pool_proj[4] = { 14, 14, 64, 1 };
    vx_tensor conv_inception_4b_pool_proj = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4b_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4b_pool_proj);
    vx_size dims_relu_inception_4b_relu_pool_proj[4] = { 14, 14, 64, 1 };
    vx_tensor relu_inception_4b_relu_pool_proj = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4b_relu_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4b_relu_pool_proj);
    vx_size dims_concat_inception_4b_output[4] = { 14, 14, 512, 1 };
    vx_tensor concat_inception_4b_output = vxCreateVirtualTensor(graph, 4, dims_concat_inception_4b_output, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_4b_output);
    vx_size dims_conv_inception_4c_1x1[4] = { 14, 14, 128, 1 };
    vx_tensor conv_inception_4c_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4c_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4c_1x1);
    vx_size dims_relu_inception_4c_relu_1x1[4] = { 14, 14, 128, 1 };
    vx_tensor relu_inception_4c_relu_1x1 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4c_relu_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4c_relu_1x1);
    vx_size dims_conv_inception_4c_3x3_reduce[4] = { 14, 14, 128, 1 };
    vx_tensor conv_inception_4c_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4c_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4c_3x3_reduce);
    vx_size dims_relu_inception_4c_relu_3x3_reduce[4] = { 14, 14, 128, 1 };
    vx_tensor relu_inception_4c_relu_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4c_relu_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4c_relu_3x3_reduce);
    vx_size dims_conv_inception_4c_3x3[4] = { 14, 14, 256, 1 };
    vx_tensor conv_inception_4c_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4c_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4c_3x3);
    vx_size dims_relu_inception_4c_relu_3x3[4] = { 14, 14, 256, 1 };
    vx_tensor relu_inception_4c_relu_3x3 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4c_relu_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4c_relu_3x3);
    vx_size dims_conv_inception_4c_5x5_reduce[4] = { 14, 14, 24, 1 };
    vx_tensor conv_inception_4c_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4c_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4c_5x5_reduce);
    vx_size dims_relu_inception_4c_relu_5x5_reduce[4] = { 14, 14, 24, 1 };
    vx_tensor relu_inception_4c_relu_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4c_relu_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4c_relu_5x5_reduce);
    vx_size dims_conv_inception_4c_5x5[4] = { 14, 14, 64, 1 };
    vx_tensor conv_inception_4c_5x5 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4c_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4c_5x5);
    vx_size dims_relu_inception_4c_relu_5x5[4] = { 14, 14, 64, 1 };
    vx_tensor relu_inception_4c_relu_5x5 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4c_relu_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4c_relu_5x5);
    vx_size dims_max_pool_inception_4c_pool[4] = { 14, 14, 512, 1 };
    vx_tensor max_pool_inception_4c_pool = vxCreateVirtualTensor(graph, 4, dims_max_pool_inception_4c_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_inception_4c_pool);
    vx_size dims_conv_inception_4c_pool_proj[4] = { 14, 14, 64, 1 };
    vx_tensor conv_inception_4c_pool_proj = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4c_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4c_pool_proj);
    vx_size dims_relu_inception_4c_relu_pool_proj[4] = { 14, 14, 64, 1 };
    vx_tensor relu_inception_4c_relu_pool_proj = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4c_relu_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4c_relu_pool_proj);
    vx_size dims_concat_inception_4c_output[4] = { 14, 14, 512, 1 };
    vx_tensor concat_inception_4c_output = vxCreateVirtualTensor(graph, 4, dims_concat_inception_4c_output, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_4c_output);
    vx_size dims_conv_inception_4d_1x1[4] = { 14, 14, 112, 1 };
    vx_tensor conv_inception_4d_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4d_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4d_1x1);
    vx_size dims_relu_inception_4d_relu_1x1[4] = { 14, 14, 112, 1 };
    vx_tensor relu_inception_4d_relu_1x1 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4d_relu_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4d_relu_1x1);
    vx_size dims_conv_inception_4d_3x3_reduce[4] = { 14, 14, 144, 1 };
    vx_tensor conv_inception_4d_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4d_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4d_3x3_reduce);
    vx_size dims_relu_inception_4d_relu_3x3_reduce[4] = { 14, 14, 144, 1 };
    vx_tensor relu_inception_4d_relu_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4d_relu_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4d_relu_3x3_reduce);
    vx_size dims_conv_inception_4d_3x3[4] = { 14, 14, 288, 1 };
    vx_tensor conv_inception_4d_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4d_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4d_3x3);
    vx_size dims_relu_inception_4d_relu_3x3[4] = { 14, 14, 288, 1 };
    vx_tensor relu_inception_4d_relu_3x3 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4d_relu_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4d_relu_3x3);
    vx_size dims_conv_inception_4d_5x5_reduce[4] = { 14, 14, 32, 1 };
    vx_tensor conv_inception_4d_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4d_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4d_5x5_reduce);
    vx_size dims_relu_inception_4d_relu_5x5_reduce[4] = { 14, 14, 32, 1 };
    vx_tensor relu_inception_4d_relu_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4d_relu_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4d_relu_5x5_reduce);
    vx_size dims_conv_inception_4d_5x5[4] = { 14, 14, 64, 1 };
    vx_tensor conv_inception_4d_5x5 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4d_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4d_5x5);
    vx_size dims_relu_inception_4d_relu_5x5[4] = { 14, 14, 64, 1 };
    vx_tensor relu_inception_4d_relu_5x5 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4d_relu_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4d_relu_5x5);
    vx_size dims_max_pool_inception_4d_pool[4] = { 14, 14, 512, 1 };
    vx_tensor max_pool_inception_4d_pool = vxCreateVirtualTensor(graph, 4, dims_max_pool_inception_4d_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_inception_4d_pool);
    vx_size dims_conv_inception_4d_pool_proj[4] = { 14, 14, 64, 1 };
    vx_tensor conv_inception_4d_pool_proj = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4d_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4d_pool_proj);
    vx_size dims_relu_inception_4d_relu_pool_proj[4] = { 14, 14, 64, 1 };
    vx_tensor relu_inception_4d_relu_pool_proj = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4d_relu_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4d_relu_pool_proj);
    vx_size dims_concat_inception_4d_output[4] = { 14, 14, 528, 1 };
    vx_tensor concat_inception_4d_output = vxCreateVirtualTensor(graph, 4, dims_concat_inception_4d_output, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_4d_output);
    vx_size dims_avg_pool_loss2_ave_pool[4] = { 4, 4, 528, 1 };
    vx_tensor avg_pool_loss2_ave_pool = vxCreateVirtualTensor(graph, 4, dims_avg_pool_loss2_ave_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_loss2_ave_pool);
    vx_size dims_conv_loss2_conv[4] = { 4, 4, 128, 1 };
    vx_tensor conv_loss2_conv = vxCreateVirtualTensor(graph, 4, dims_conv_loss2_conv, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_loss2_conv);
    vx_size dims_relu_loss2_relu_conv[4] = { 4, 4, 128, 1 };
    vx_tensor relu_loss2_relu_conv = vxCreateVirtualTensor(graph, 4, dims_relu_loss2_relu_conv, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_loss2_relu_conv);
    vx_size dims_gemm_loss2_fc[4] = { 1, 1, 1024, 1 };
    vx_tensor gemm_loss2_fc = vxCreateVirtualTensor(graph, 4, dims_gemm_loss2_fc, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(gemm_loss2_fc);
    vx_size dims_relu_loss2_relu_fc[4] = { 1, 1, 1024, 1 };
    vx_tensor relu_loss2_relu_fc = vxCreateVirtualTensor(graph, 4, dims_relu_loss2_relu_fc, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_loss2_relu_fc);
    vx_size dims_gemm_loss2_classifier[4] = { 1, 1, 1000, 1 };
    vx_tensor gemm_loss2_classifier = vxCreateVirtualTensor(graph, 4, dims_gemm_loss2_classifier, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(gemm_loss2_classifier);
    vx_size dims_conv_inception_4e_1x1[4] = { 14, 14, 256, 1 };
    vx_tensor conv_inception_4e_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4e_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4e_1x1);
    vx_size dims_relu_inception_4e_relu_1x1[4] = { 14, 14, 256, 1 };
    vx_tensor relu_inception_4e_relu_1x1 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4e_relu_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4e_relu_1x1);
    vx_size dims_conv_inception_4e_3x3_reduce[4] = { 14, 14, 160, 1 };
    vx_tensor conv_inception_4e_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4e_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4e_3x3_reduce);
    vx_size dims_relu_inception_4e_relu_3x3_reduce[4] = { 14, 14, 160, 1 };
    vx_tensor relu_inception_4e_relu_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4e_relu_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4e_relu_3x3_reduce);
    vx_size dims_conv_inception_4e_3x3[4] = { 14, 14, 320, 1 };
    vx_tensor conv_inception_4e_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4e_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4e_3x3);
    vx_size dims_relu_inception_4e_relu_3x3[4] = { 14, 14, 320, 1 };
    vx_tensor relu_inception_4e_relu_3x3 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4e_relu_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4e_relu_3x3);
    vx_size dims_conv_inception_4e_5x5_reduce[4] = { 14, 14, 32, 1 };
    vx_tensor conv_inception_4e_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4e_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4e_5x5_reduce);
    vx_size dims_relu_inception_4e_relu_5x5_reduce[4] = { 14, 14, 32, 1 };
    vx_tensor relu_inception_4e_relu_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4e_relu_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4e_relu_5x5_reduce);
    vx_size dims_conv_inception_4e_5x5[4] = { 14, 14, 128, 1 };
    vx_tensor conv_inception_4e_5x5 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4e_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4e_5x5);
    vx_size dims_relu_inception_4e_relu_5x5[4] = { 14, 14, 128, 1 };
    vx_tensor relu_inception_4e_relu_5x5 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4e_relu_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4e_relu_5x5);
    vx_size dims_max_pool_inception_4e_pool[4] = { 14, 14, 528, 1 };
    vx_tensor max_pool_inception_4e_pool = vxCreateVirtualTensor(graph, 4, dims_max_pool_inception_4e_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_inception_4e_pool);
    vx_size dims_conv_inception_4e_pool_proj[4] = { 14, 14, 128, 1 };
    vx_tensor conv_inception_4e_pool_proj = vxCreateVirtualTensor(graph, 4, dims_conv_inception_4e_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_4e_pool_proj);
    vx_size dims_relu_inception_4e_relu_pool_proj[4] = { 14, 14, 128, 1 };
    vx_tensor relu_inception_4e_relu_pool_proj = vxCreateVirtualTensor(graph, 4, dims_relu_inception_4e_relu_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_4e_relu_pool_proj);
    vx_size dims_concat_inception_4e_output[4] = { 14, 14, 832, 1 };
    vx_tensor concat_inception_4e_output = vxCreateVirtualTensor(graph, 4, dims_concat_inception_4e_output, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_4e_output);
    vx_size dims_max_pool_pool4_3x3_s2[4] = { 7, 7, 832, 1 };
    vx_tensor max_pool_pool4_3x3_s2 = vxCreateVirtualTensor(graph, 4, dims_max_pool_pool4_3x3_s2, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_pool4_3x3_s2);
    vx_size dims_conv_inception_5a_1x1[4] = { 7, 7, 256, 1 };
    vx_tensor conv_inception_5a_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_5a_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_5a_1x1);
    vx_size dims_relu_inception_5a_relu_1x1[4] = { 7, 7, 256, 1 };
    vx_tensor relu_inception_5a_relu_1x1 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_5a_relu_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_5a_relu_1x1);
    vx_size dims_conv_inception_5a_3x3_reduce[4] = { 7, 7, 160, 1 };
    vx_tensor conv_inception_5a_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_5a_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_5a_3x3_reduce);
    vx_size dims_relu_inception_5a_relu_3x3_reduce[4] = { 7, 7, 160, 1 };
    vx_tensor relu_inception_5a_relu_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_5a_relu_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_5a_relu_3x3_reduce);
    vx_size dims_conv_inception_5a_3x3[4] = { 7, 7, 320, 1 };
    vx_tensor conv_inception_5a_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_5a_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_5a_3x3);
    vx_size dims_relu_inception_5a_relu_3x3[4] = { 7, 7, 320, 1 };
    vx_tensor relu_inception_5a_relu_3x3 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_5a_relu_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_5a_relu_3x3);
    vx_size dims_conv_inception_5a_5x5_reduce[4] = { 7, 7, 32, 1 };
    vx_tensor conv_inception_5a_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_5a_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_5a_5x5_reduce);
    vx_size dims_relu_inception_5a_relu_5x5_reduce[4] = { 7, 7, 32, 1 };
    vx_tensor relu_inception_5a_relu_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_5a_relu_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_5a_relu_5x5_reduce);
    vx_size dims_conv_inception_5a_5x5[4] = { 7, 7, 128, 1 };
    vx_tensor conv_inception_5a_5x5 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_5a_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_5a_5x5);
    vx_size dims_relu_inception_5a_relu_5x5[4] = { 7, 7, 128, 1 };
    vx_tensor relu_inception_5a_relu_5x5 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_5a_relu_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_5a_relu_5x5);
    vx_size dims_max_pool_inception_5a_pool[4] = { 7, 7, 832, 1 };
    vx_tensor max_pool_inception_5a_pool = vxCreateVirtualTensor(graph, 4, dims_max_pool_inception_5a_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_inception_5a_pool);
    vx_size dims_conv_inception_5a_pool_proj[4] = { 7, 7, 128, 1 };
    vx_tensor conv_inception_5a_pool_proj = vxCreateVirtualTensor(graph, 4, dims_conv_inception_5a_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_5a_pool_proj);
    vx_size dims_relu_inception_5a_relu_pool_proj[4] = { 7, 7, 128, 1 };
    vx_tensor relu_inception_5a_relu_pool_proj = vxCreateVirtualTensor(graph, 4, dims_relu_inception_5a_relu_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_5a_relu_pool_proj);
    vx_size dims_concat_inception_5a_output[4] = { 7, 7, 832, 1 };
    vx_tensor concat_inception_5a_output = vxCreateVirtualTensor(graph, 4, dims_concat_inception_5a_output, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_5a_output);
    vx_size dims_conv_inception_5b_1x1[4] = { 7, 7, 384, 1 };
    vx_tensor conv_inception_5b_1x1 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_5b_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_5b_1x1);
    vx_size dims_relu_inception_5b_relu_1x1[4] = { 7, 7, 384, 1 };
    vx_tensor relu_inception_5b_relu_1x1 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_5b_relu_1x1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_5b_relu_1x1);
    vx_size dims_conv_inception_5b_3x3_reduce[4] = { 7, 7, 192, 1 };
    vx_tensor conv_inception_5b_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_5b_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_5b_3x3_reduce);
    vx_size dims_relu_inception_5b_relu_3x3_reduce[4] = { 7, 7, 192, 1 };
    vx_tensor relu_inception_5b_relu_3x3_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_5b_relu_3x3_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_5b_relu_3x3_reduce);
    vx_size dims_conv_inception_5b_3x3[4] = { 7, 7, 384, 1 };
    vx_tensor conv_inception_5b_3x3 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_5b_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_5b_3x3);
    vx_size dims_relu_inception_5b_relu_3x3[4] = { 7, 7, 384, 1 };
    vx_tensor relu_inception_5b_relu_3x3 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_5b_relu_3x3, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_5b_relu_3x3);
    vx_size dims_conv_inception_5b_5x5_reduce[4] = { 7, 7, 48, 1 };
    vx_tensor conv_inception_5b_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_conv_inception_5b_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_5b_5x5_reduce);
    vx_size dims_relu_inception_5b_relu_5x5_reduce[4] = { 7, 7, 48, 1 };
    vx_tensor relu_inception_5b_relu_5x5_reduce = vxCreateVirtualTensor(graph, 4, dims_relu_inception_5b_relu_5x5_reduce, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_5b_relu_5x5_reduce);
    vx_size dims_conv_inception_5b_5x5[4] = { 7, 7, 128, 1 };
    vx_tensor conv_inception_5b_5x5 = vxCreateVirtualTensor(graph, 4, dims_conv_inception_5b_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_5b_5x5);
    vx_size dims_relu_inception_5b_relu_5x5[4] = { 7, 7, 128, 1 };
    vx_tensor relu_inception_5b_relu_5x5 = vxCreateVirtualTensor(graph, 4, dims_relu_inception_5b_relu_5x5, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_5b_relu_5x5);
    vx_size dims_max_pool_inception_5b_pool[4] = { 7, 7, 832, 1 };
    vx_tensor max_pool_inception_5b_pool = vxCreateVirtualTensor(graph, 4, dims_max_pool_inception_5b_pool, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(max_pool_inception_5b_pool);
    vx_size dims_conv_inception_5b_pool_proj[4] = { 7, 7, 128, 1 };
    vx_tensor conv_inception_5b_pool_proj = vxCreateVirtualTensor(graph, 4, dims_conv_inception_5b_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(conv_inception_5b_pool_proj);
    vx_size dims_relu_inception_5b_relu_pool_proj[4] = { 7, 7, 128, 1 };
    vx_tensor relu_inception_5b_relu_pool_proj = vxCreateVirtualTensor(graph, 4, dims_relu_inception_5b_relu_pool_proj, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(relu_inception_5b_relu_pool_proj);
    vx_size dims_concat_inception_5b_output[4] = { 7, 7, 1024, 1 };
    vx_tensor concat_inception_5b_output = vxCreateVirtualTensor(graph, 4, dims_concat_inception_5b_output, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(concat_inception_5b_output);
    vx_size dims_avg_pool_pool5_7x7_s1[4] = { 1, 1, 1024, 1 };
    vx_tensor avg_pool_pool5_7x7_s1 = vxCreateVirtualTensor(graph, 4, dims_avg_pool_pool5_7x7_s1, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(avg_pool_pool5_7x7_s1);
    vx_size dims_gemm_loss3_classifier[4] = { 1, 1, 1000, 1 };
    vx_tensor gemm_loss3_classifier = vxCreateVirtualTensor(graph, 4, dims_gemm_loss3_classifier, VX_TYPE_FLOAT32, 0);
    ERROR_CHECK_OBJECT(gemm_loss3_classifier);

    // create nodes in graph

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 3;
      conv_params.padding_y = 3;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, data, conv1_7x7_s2_w, conv1_7x7_s2_b, &conv_params, sizeof(conv_params), conv_conv1_7x7_s2);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv1_7x7_s2, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_conv1_relu_7x7);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, relu_conv1_relu_7x7, VX_NN_POOLING_MAX, 3, 3, 0, 0, VX_ROUND_POLICY_TO_NEAREST_EVEN, max_pool_pool1_3x3_s2);
      ERROR_CHECK_OBJECT(node);
      vx_enum border_mode = 0;
      vx_scalar s_border_mode = vxCreateScalarWithSize(context, VX_TYPE_ENUM, &border_mode, sizeof(border_mode));
      ERROR_CHECK_OBJECT(s_border_mode);
      ERROR_CHECK_STATUS(vxSetParameterByIndex(node, 8, (vx_reference) s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseScalar(&s_border_mode));
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxNormalizationLayer(graph, max_pool_pool1_3x3_s2, VX_NN_NORMALIZATION_ACROSS_MAPS , 5, 1.000000e-04f, 7.500000e-01f, lrn_pool1_norm1);
   ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 0;
      conv_params.padding_y = 0;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, lrn_pool1_norm1, conv2_3x3_reduce_w, conv2_3x3_reduce_b, &conv_params, sizeof(conv_params), conv_conv2_3x3_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv2_3x3_reduce, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_conv2_relu_3x3_reduce);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_nn_convolution_params_t conv_params = { 0 };
      conv_params.padding_x = 1;
      conv_params.padding_y = 1;
      conv_params.overflow_policy = VX_CONVERT_POLICY_SATURATE;
      conv_params.rounding_policy = VX_ROUND_POLICY_TO_NEAREST_EVEN;
      conv_params.down_scale_size_rounding = VX_NN_DS_SIZE_ROUNDING_FLOOR;
      conv_params.dilation_x = 0;
      conv_params.dilation_y = 0;
      vx_node node = vxConvolutionLayer(graph, relu_conv2_relu_3x3_reduce, conv2_3x3_w, conv2_3x3_b, &conv_params, sizeof(conv_params), conv_conv2_3x3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxActivationLayer(graph, conv_conv2_3x3, VX_NN_ACTIVATION_RELU, 0.0f, 0.0f, relu_conv2_relu_3x3);
      ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxNormalizationLayer(graph, relu_conv2_relu_3x3, VX_NN_NORMALIZATION_ACROSS_MAPS , 5, 1.000000e-04f, 7.500000e-01f, lrn_conv2_norm2);
   ERROR_CHECK_OBJECT(node);
      ERROR_CHECK_STATUS(vxReleaseNode(&node));
    }

    { vx_node node = vxPoolingLayer(graph, lrn_conv2_norm2, VX_NN_POOLING_MAX, 3, 3, 0, 0, VX_ROUND_POLICY_TO_NEAREST_EVEN, max_pool_pool