/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.shared.xml.QNameSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.soap.wssecurity.AttributedDateTime;
import org.opensaml.soap.wssecurity.impl.AbstractWSSecurityObjectUnmarshaller;
import org.w3c.dom.Attr;

public class AttributedDateTimeUnmarshaller
extends AbstractWSSecurityObjectUnmarshaller {
    @Override
    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        AttributedDateTime dateTime = (AttributedDateTime)xmlObject;
        QName attrName = QNameSupport.constructQName(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getPrefix());
        if (AttributedDateTime.WSU_ID_ATTR_NAME.equals(attrName)) {
            dateTime.setWSUId(attribute.getValue());
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        } else {
            XMLObjectSupport.unmarshallToAttributeMap(dateTime.getUnknownAttributes(), attribute);
        }
    }

    @Override
    protected void processElementContent(@Nonnull XMLObject xmlObject, @Nonnull String elementContent) {
        AttributedDateTime dateTime = (AttributedDateTime)xmlObject;
        if (!Strings.isNullOrEmpty((String)elementContent)) {
            dateTime.setValue(elementContent);
        }
    }
}

