# This file has been autogenerated by the pywayland scanner

# Copyright 2023 David Redondo
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..xdg_shell import XdgToplevel


class XdgToplevelDragV1(Interface):
    """Object representing a toplevel move during a drag
    """

    name = "xdg_toplevel_drag_v1"
    version = 1

    class error(enum.IntEnum):
        toplevel_attached = 0
        ongoing_drag = 1


class XdgToplevelDragV1Proxy(Proxy[XdgToplevelDragV1]):
    interface = XdgToplevelDragV1

    @XdgToplevelDragV1.request()
    def destroy(self) -> None:
        """Destroy an :class:`XdgToplevelDragV1` object

        Destroy this :class:`XdgToplevelDragV1` object. This request must only
        be called after the underlying
        :class:`~pywayland.protocol.wayland.WlDataSource` drag has ended, as
        indicated by the dnd_drop_performed or cancelled events. In any other
        case an ongoing_drag error is raised.
        """
        self._marshal(0)
        self._destroy()

    @XdgToplevelDragV1.request(
        Argument(ArgumentType.Object, interface=XdgToplevel),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def attach(self, toplevel: XdgToplevel, x_offset: int, y_offset: int) -> None:
        """Move a toplevel with the drag operation

        Request that the window will be moved with the cursor during the drag
        operation. The offset is a hint to the compositor how the toplevel
        should be positioned relative to the cursor hotspot in surface local
        coordinates and relative to the geometry of the toplevel being
        attached. See :func:`XdgSurface.set_window_geometry()
        <pywayland.protocol.xdg_shell.XdgSurface.set_window_geometry>`. For
        example it might only be used when an unmapped window is attached. The
        attached window does not participate in the selection of the drag
        target.

        If the toplevel is unmapped while it is attached, it is automatically
        detached from the drag. In this case this request has to be called
        again if the window should be attached after it is remapped.

        This request can be called multiple times but issuing it while a
        toplevel with an active role is attached raises a toplevel_attached
        error.

        :param toplevel:
        :type toplevel:
            :class:`~pywayland.protocol.xdg_shell.XdgToplevel`
        :param x_offset:
            dragged surface x offset
        :type x_offset:
            `ArgumentType.Int`
        :param y_offset:
            dragged surface y offset
        :type y_offset:
            `ArgumentType.Int`
        """
        self._marshal(1, toplevel, x_offset, y_offset)


class XdgToplevelDragV1Resource(Resource):
    interface = XdgToplevelDragV1


class XdgToplevelDragV1Global(Global):
    interface = XdgToplevelDragV1


XdgToplevelDragV1._gen_c()
XdgToplevelDragV1.proxy_class = XdgToplevelDragV1Proxy
XdgToplevelDragV1.resource_class = XdgToplevelDragV1Resource
XdgToplevelDragV1.global_class = XdgToplevelDragV1Global
