function __fish_complete_tcpdump_interfaces --description "Complete network interfaces available on the system and on which tcpdump can capture packets"
    tcpdump --list-interfaces 2>/dev/null | string replace -r '\d+\.(\S+( \(.*\))?).*' '$1' | string replace -r ' \((.*)\)' '\t$1'
end

complete -c tcpdump -f
complete -c tcpdump -s A -d 'Print each packet in ASCII'
complete -c tcpdump -s b -d 'Print the AS number in BGP packets in ASDOT notation'
complete -c tcpdump -s B -l buffer-size -x -d 'Set the operating system capture buffer size (in KiB)'
complete -c tcpdump -s c -x -d 'Exit after receiving count packets'
complete -c tcpdump -l count -d 'Print only packet count when reading capture files'
complete -c tcpdump -s C -x -d 'Maximum size per savefile (in MB)'
complete -c tcpdump -s d -d 'Dump the compiled packet-matching code in a human readable form'
complete -c tcpdump -o dd -d 'Dump packet-matching code as a C program fragment'
complete -c tcpdump -o ddd -d 'Dump packet-matching code as decimal numbers'
complete -c tcpdump -s D -l list-interfaces -d 'Print the list of the network interfaces'
complete -c tcpdump -s e -d 'Print the link-level header on each dump line'
complete -c tcpdump -s E -x -d 'Set options for decrypting IPsec ESP packets'
complete -c tcpdump -s f -d 'Print foreign IPv4 addresses numerically'
complete -c tcpdump -s F -rF -d 'Use file as input for the filter expression'
complete -c tcpdump -s G -x -d 'Rotate the dump file every rotate_seconds seconds'
complete -c tcpdump -s h -l help -d 'Print version strings and a usage message'
complete -c tcpdump -l version -d 'Print the tcpdump and libpcap version strings'
complete -c tcpdump -s H -d 'Attempt to detect 802.11s draft mesh headers'
complete -c tcpdump -s i -l interface -x -a "(__fish_complete_tcpdump_interfaces)"
complete -c tcpdump -s I -l monitor-mode -d 'Put the interface in monitor mode'
complete -c tcpdump -l immediate-mode -d 'Capture in immediate mode'
complete -c tcpdump -s j -l time-stamp-type -x -a 'host host_lowprec host_hiprec adapter adapter_unsynced' -d 'Set the time stamp type for the capture'
complete -c tcpdump -s J -l list-time-stamp-types -d 'List the supported time stamp types for the interface'
complete -c tcpdump -l time-stamp-precision -x -a 'micro nano' -d 'Set the time stamp precision for the capture'
complete -c tcpdump -l micro -d 'Set time stamp precision to microseconds'
complete -c tcpdump -l nano -d 'Set time stamp precision to nanoseconds'
complete -c tcpdump -s K -l dont-verify-checksums -d 'Don\'t attempt to verify IP, TCP, or UDP checksums'
complete -c tcpdump -s l -d 'Make stdout line buffered'
complete -c tcpdump -s L -l list-data-link-types -d 'List the known data link types for the interface'
complete -c tcpdump -s m -rF -d 'Load SMI MIB module definitions from file'
complete -c tcpdump -s M -x -d 'Use a shared secret for validating digests with the TCP-MD5 option'
complete -c tcpdump -s n -d 'Don\'t convert host addresses to names'
complete -c tcpdump -o nn -d 'Don\'t convert protocol and port numbers etc. to names either'
complete -c tcpdump -s N -d 'Don\'t print domain name qualification of host names'
complete -c tcpdump -s \# -l number -d 'Print an optional packet number'
complete -c tcpdump -s O -l no-optimize -d 'Do not run the packet-matching code optimizer'
complete -c tcpdump -s p -l no-promiscuous-mode -d 'Don\'t put the interface into promiscuous mode'
complete -c tcpdump -l print -d 'Print parsed packet output'
complete -c tcpdump -s Q -l direction -x -a 'in out inout' -d 'Choose direction for which packets should be captured'
complete -c tcpdump -s q -d 'Print less protocol information'
complete -c tcpdump -s r -rF -d 'Read packets from file'
complete -c tcpdump -s S -l absolute-tcp-sequence-numbers -d 'Print absolute TCP sequence numbers'
complete -c tcpdump -s s -l snapshot-length -x -d 'Snarf snaplen bytes of data from each packet'
complete -c tcpdump -s T -x -d 'Force packets to be interpreted the specified type'
complete -c tcpdump -s t -d 'Don\'t print a timestamp on each dump line'
complete -c tcpdump -o tt -d 'Print timestamp as seconds and fractions of a second since epoch'
complete -c tcpdump -o ttt -d 'Print a delta between current and previous line'
complete -c tcpdump -o tttt -d 'Print timestamp as hours, minutes, seconds, and fractions of a second since midnight'
complete -c tcpdump -o ttttt -d 'Print a delta between current and first line'
complete -c tcpdump -s u -d 'Print undecoded NFS handles'
complete -c tcpdump -s U -l packet-buffered -d 'Make the packet output packet-buffered'
complete -c tcpdump -s v -d 'Produce (slightly more) verbose output'
complete -c tcpdump -o vv -d 'Even more verbose output'
complete -c tcpdump -o vvv -d 'Even more verbose output'
complete -c tcpdump -s V -rF -d 'Read a list of filenames from file'
complete -c tcpdump -s w -rF -d 'Write the raw packets to file'
complete -c tcpdump -s W -d 'Limit the number of files created'
complete -c tcpdump -s x -d 'Print the data of each packet in hex (minus link level header)'
complete -c tcpdump -o xx -d 'Print the data of each packet in hex (including link level header)'
complete -c tcpdump -s X -d 'Print the data of each packet in hex and ASCII (minus link level header)'
complete -c tcpdump -o XX -d 'Print the data of each packet in hex and ASCII (including link level header)'
complete -c tcpdump -s y -l linktype -x -d 'Set the data link type to use while capturing packets'
complete -c tcpdump -s z -x -d 'Make tcpdump run "postrotate-command file"'
complete -c tcpdump -s Z -l relinquish-privileges -x -a "(__fish_print_users)" -d 'Change user ID before opening any savefiles for output'
