/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes.matching;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesEntry;
import org.gradle.api.internal.attributes.matching.AttributeSelectionSchema;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.jspecify.annotations.Nullable;

class MultipleCandidateMatcher {
    private final AttributeSelectionSchema schema;
    private final ImmutableAttributes requested;
    private final ImmutableAttributes[] candidates;
    private final AttributeMatchingExplanationBuilder explanationBuilder;
    private final List<Attribute<?>> requestedAttributes;
    private final BitSet compatible;
    private final @Nullable Object[] requestedAttributeValues;
    private final @Nullable Object[] candidateValues;
    private int candidateWithLongestMatch;
    private int lengthOfLongestMatch;
    private BitSet remaining;

    MultipleCandidateMatcher(AttributeSelectionSchema schema, ImmutableAttributes[] candidates, ImmutableAttributes requested, AttributeMatchingExplanationBuilder explanationBuilder) {
        this.schema = schema;
        this.candidates = candidates;
        this.requested = requested;
        this.explanationBuilder = explanationBuilder;
        this.requestedAttributes = requested.keySet().asList();
        this.requestedAttributeValues = MultipleCandidateMatcher.getRequestedValues(this.requestedAttributes, requested);
        this.candidateValues = new Object[candidates.length * this.requestedAttributes.size()];
        this.compatible = new BitSet(candidates.length);
        this.compatible.set(0, candidates.length);
    }

    public int[] getMatches() {
        this.findCompatibleCandidates();
        if (this.compatible.cardinality() <= 1) {
            return this.getCandidates(this.compatible);
        }
        if (this.longestMatchIsSuperSetOfAllOthers()) {
            ImmutableAttributes o = this.candidates[this.candidateWithLongestMatch];
            this.explanationBuilder.candidateIsSuperSetOfAllOthers(o);
            return new int[]{this.candidateWithLongestMatch};
        }
        return this.disambiguateCompatibleCandidates();
    }

    private static @Nullable Object[] getRequestedValues(List<Attribute<?>> requestedAttributes, ImmutableAttributes requested) {
        @Nullable Object[] requestedAttributeValues = new Object[requestedAttributes.size()];
        for (int a = 0; a < requestedAttributes.size(); ++a) {
            Attribute<?> attribute = requestedAttributes.get(a);
            ImmutableAttributesEntry requestedEntry = requested.findEntry(attribute);
            requestedAttributeValues[a] = requestedEntry != null ? requestedEntry.getIsolatedValue() : null;
        }
        return requestedAttributeValues;
    }

    private void findCompatibleCandidates() {
        if (this.requested.isEmpty()) {
            return;
        }
        for (int c = 0; c < this.candidates.length; ++c) {
            this.matchCandidate(c);
        }
    }

    private void matchCandidate(int c) {
        int matchLength = 0;
        for (int a = 0; a < this.requestedAttributes.size(); ++a) {
            MatchResult result = this.recordAndMatchCandidateValue(c, a);
            if (result == MatchResult.NO_MATCH) {
                this.compatible.clear(c);
                return;
            }
            if (result != MatchResult.MATCH) continue;
            ++matchLength;
        }
        if (matchLength > this.lengthOfLongestMatch) {
            this.lengthOfLongestMatch = matchLength;
            this.candidateWithLongestMatch = c;
        }
    }

    private MatchResult recordAndMatchCandidateValue(int c, int a) {
        Object requestedValue = this.requestedAttributeValues[a];
        Attribute<?> attribute = this.requestedAttributes.get(a);
        ImmutableAttributesEntry candidateEntry = this.candidates[c].findEntry(attribute.getName());
        if (candidateEntry == null) {
            this.setCandidateValue(c, a, null);
            this.explanationBuilder.candidateAttributeMissing(this.candidates[c], attribute, requestedValue);
            return MatchResult.MISSING;
        }
        Object coercedValue = candidateEntry.coerce(attribute);
        this.setCandidateValue(c, a, coercedValue);
        if (this.unsafeMatchValue(attribute, requestedValue, coercedValue)) {
            return MatchResult.MATCH;
        }
        this.explanationBuilder.candidateAttributeDoesNotMatch(this.candidates[c], attribute, requestedValue, candidateEntry);
        return MatchResult.NO_MATCH;
    }

    private boolean unsafeMatchValue(Attribute<?> attribute, Object requested, Object candidate) {
        return this.schema.matchValue((Attribute)Cast.uncheckedCast(attribute), Cast.uncheckedCast((Object)requested), Cast.uncheckedCast((Object)candidate));
    }

    private boolean longestMatchIsSuperSetOfAllOthers() {
        int c = this.compatible.nextSetBit(0);
        while (c >= 0) {
            if (c != this.candidateWithLongestMatch) {
                int lengthOfOtherMatch = 0;
                for (int a = 0; a < this.requestedAttributes.size(); ++a) {
                    if (this.getCandidateValue(c, a) == null) continue;
                    ++lengthOfOtherMatch;
                    if (this.getCandidateValue(this.candidateWithLongestMatch, a) != null) continue;
                    return false;
                }
                if (lengthOfOtherMatch == this.lengthOfLongestMatch) {
                    return false;
                }
            }
            c = this.compatible.nextSetBit(c + 1);
        }
        return true;
    }

    private int[] disambiguateCompatibleCandidates() {
        this.remaining = new BitSet(this.candidates.length);
        this.remaining.or(this.compatible);
        this.disambiguateWithRequestedAttributeValues();
        if (this.remaining.cardinality() == 0) {
            return this.getCandidates(this.compatible);
        }
        if (this.remaining.cardinality() == 1) {
            return this.getCandidates(this.remaining);
        }
        Attribute<?>[] extraAttributes = this.schema.collectExtraAttributes(this.candidates, this.requested);
        if (this.remaining.cardinality() > 1) {
            this.disambiguateWithExtraAttributes(extraAttributes);
        }
        if (this.remaining.cardinality() > 1) {
            this.disambiguateWithRequestedAttributeKeys(extraAttributes);
        }
        return this.remaining.cardinality() == 0 ? this.getCandidates(this.compatible) : this.getCandidates(this.remaining);
    }

    private void disambiguateWithRequestedAttributeKeys(Attribute<?>[] extraAttributes) {
        if (this.requestedAttributes.isEmpty()) {
            return;
        }
        for (Attribute<?> extraAttribute : extraAttributes) {
            int candidateCount = this.candidates.length;
            BitSet any = new BitSet(candidateCount);
            for (int c = 0; c < candidateCount; ++c) {
                ImmutableAttributes candidateAttributeSet = this.candidates[c];
                if (candidateAttributeSet.findEntry(extraAttribute.getName()) == null) continue;
                any.set(c);
            }
            if (any.cardinality() <= 0 || any.cardinality() == candidateCount) continue;
            this.remaining.andNot(any);
            if (this.remaining.cardinality() == 0) break;
        }
    }

    private void disambiguateWithRequestedAttributeValues() {
        AttributeSelectionSchema.PrecedenceResult precedenceResult = this.schema.orderByPrecedence((Collection<Attribute<?>>)this.requested.keySet());
        for (int a : precedenceResult.getSortedOrder()) {
            this.disambiguateRequestedAttribute(a);
            if (this.remaining.cardinality() == 0) {
                return;
            }
            if (this.remaining.cardinality() != 1) continue;
            return;
        }
        for (int a : precedenceResult.getUnsortedOrder()) {
            this.disambiguateRequestedAttribute(a);
            if (this.remaining.cardinality() != 0) continue;
            return;
        }
    }

    private void disambiguateRequestedAttribute(int a) {
        Set<Object> candidateValues = MultipleCandidateMatcher.getCandidateValues(this.compatible, c -> this.getCandidateValue(c, a));
        if (candidateValues.size() <= 1) {
            return;
        }
        Set<Object> matches = this.unsafeDisambiguate(this.requestedAttributes.get(a), this.requestedAttributeValues[a], candidateValues);
        if (matches != null && matches.size() < candidateValues.size()) {
            int c2 = this.remaining.nextSetBit(0);
            while (c2 >= 0) {
                if (!matches.contains(this.getCandidateValue(c2, a))) {
                    this.remaining.clear(c2);
                }
                c2 = this.remaining.nextSetBit(c2 + 1);
            }
        }
    }

    @Nullable Set<Object> unsafeDisambiguate(Attribute<?> attribute, @Nullable Object requested, Set<Object> candidates) {
        return this.schema.disambiguate((Attribute)Cast.uncheckedCast(attribute), Cast.uncheckedCast((Object)requested), (Set)Cast.uncheckedCast(candidates));
    }

    private <E> void disambiguateExtraAttribute(Attribute<E> attribute, BitSet candidates) {
        Set<Object> candidateValues = MultipleCandidateMatcher.getCandidateValues(candidates, c -> this.getCandidateValue(c, attribute));
        if (candidateValues.isEmpty()) {
            return;
        }
        Set<Object> matches = this.schema.disambiguate(attribute, null, candidateValues);
        if (matches != null) {
            int c2 = this.remaining.nextSetBit(0);
            while (c2 >= 0) {
                if (!matches.contains(this.getCandidateValue(c2, attribute))) {
                    this.remaining.clear(c2);
                }
                c2 = this.remaining.nextSetBit(c2 + 1);
            }
        }
    }

    private static <E> Set<E> getCandidateValues(BitSet compatible, IntFunction<@Nullable E> candidateValueFetcher) {
        Set candidateValues = null;
        Object compatibleValue = null;
        boolean first = true;
        int c = compatible.nextSetBit(0);
        while (c >= 0) {
            E candidateValue = candidateValueFetcher.apply(c);
            if (candidateValue != null) {
                if (first) {
                    compatibleValue = candidateValue;
                    first = false;
                } else if (compatibleValue != candidateValue || candidateValues != null) {
                    if (candidateValues == null) {
                        candidateValues = Sets.newHashSetWithExpectedSize((int)compatible.cardinality());
                        candidateValues.add(compatibleValue);
                    }
                    candidateValues.add(candidateValue);
                }
            }
            c = compatible.nextSetBit(c + 1);
        }
        if (candidateValues == null) {
            if (compatibleValue == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(compatibleValue);
        }
        return candidateValues;
    }

    private void disambiguateWithExtraAttributes(Attribute<?>[] extraAttributes) {
        AttributeSelectionSchema.PrecedenceResult precedenceResult = this.schema.orderByPrecedence(Arrays.asList(extraAttributes));
        for (int a : precedenceResult.getSortedOrder()) {
            this.disambiguateExtraAttribute(extraAttributes[a], this.remaining);
            if (this.remaining.cardinality() == 0) {
                return;
            }
            if (this.remaining.cardinality() != 1) continue;
            return;
        }
        BitSet candidates = new BitSet();
        candidates.or(this.remaining);
        for (int a : precedenceResult.getUnsortedOrder()) {
            this.disambiguateExtraAttribute(extraAttributes[a], candidates);
            if (this.remaining.cardinality() != 0) continue;
            return;
        }
    }

    private int[] getCandidates(BitSet liveSet) {
        if (liveSet.cardinality() == 0) {
            return new int[0];
        }
        if (liveSet.cardinality() == 1) {
            return new int[]{liveSet.nextSetBit(0)};
        }
        int i = 0;
        int[] result = new int[liveSet.cardinality()];
        int c = liveSet.nextSetBit(0);
        while (c >= 0) {
            result[i++] = c;
            c = liveSet.nextSetBit(c + 1);
        }
        return result;
    }

    private <E> @Nullable E getCandidateValue(int c, Attribute<E> attribute) {
        ImmutableAttributesEntry attributeEntry = this.candidates[c].findEntry(attribute.getName());
        return (E)(attributeEntry != null ? attributeEntry.coerce(attribute) : null);
    }

    private @Nullable Object getCandidateValue(int c, int a) {
        return this.candidateValues[this.getValueIndex(c, a)];
    }

    private void setCandidateValue(int c, int a, @Nullable Object value) {
        this.candidateValues[this.getValueIndex((int)c, (int)a)] = value;
    }

    private int getValueIndex(int c, int a) {
        return c * this.requestedAttributes.size() + a;
    }

    private static enum MatchResult {
        MATCH,
        MISSING,
        NO_MATCH;

    }
}

