/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Increase the image size by padding according to the zero-flux Neumann
boundary condition.


A filter which extends the image size and fill the missing pixels
according to a Neumann boundary condition where first, upwind
derivatives on the boundary are zero. This is a useful condition in
solving some classes of differential equations.

For example, invoking this filter on an image with a corner like: returns the following padded image:


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 WrapPadImageFilter , MirrorPadImageFilter , ConstantPadImageFilter , ZeroFluxNeumannBoundaryCondition

 itk::simple::ZeroFluxNeumannPad for the procedural interface

 itk::ZeroFluxNeumannPadImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkZeroFluxNeumannPadImageFilter.h
*/
public class ZeroFluxNeumannPadImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ZeroFluxNeumannPadImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ZeroFluxNeumannPadImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ZeroFluxNeumannPadImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ZeroFluxNeumannPadImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ZeroFluxNeumannPadImageFilter::~ZeroFluxNeumannPadImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ZeroFluxNeumannPadImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ZeroFluxNeumannPadImageFilter::ZeroFluxNeumannPadImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ZeroFluxNeumannPadImageFilter() {
    this(SimpleITKJNI.new_ZeroFluxNeumannPadImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ZeroFluxNeumannPadImageFilter::SetPadLowerBound(std::vector&lt; unsigned int &gt; PadLowerBound)
*/
public  void setPadLowerBound(VectorUInt32 PadLowerBound) {
    SimpleITKJNI.ZeroFluxNeumannPadImageFilter_setPadLowerBound(swigCPtr, this, VectorUInt32.getCPtr(PadLowerBound), PadLowerBound);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::ZeroFluxNeumannPadImageFilter::GetPadLowerBound() const
*/
public  VectorUInt32 getPadLowerBound() {
    return new VectorUInt32(SimpleITKJNI.ZeroFluxNeumannPadImageFilter_getPadLowerBound(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ZeroFluxNeumannPadImageFilter::SetPadUpperBound(std::vector&lt; unsigned int &gt; PadUpperBound)
*/
public  void setPadUpperBound(VectorUInt32 PadUpperBound) {
    SimpleITKJNI.ZeroFluxNeumannPadImageFilter_setPadUpperBound(swigCPtr, this, VectorUInt32.getCPtr(PadUpperBound), PadUpperBound);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::ZeroFluxNeumannPadImageFilter::GetPadUpperBound() const
*/
public  VectorUInt32 getPadUpperBound() {
    return new VectorUInt32(SimpleITKJNI.ZeroFluxNeumannPadImageFilter_getPadUpperBound(swigCPtr, this), true);
  }

  /**
std::string itk::simple::ZeroFluxNeumannPadImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ZeroFluxNeumannPadImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ZeroFluxNeumannPadImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ZeroFluxNeumannPadImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ZeroFluxNeumannPadImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ZeroFluxNeumannPadImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
