/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.deployment.processor;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.SimpleType;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.JacksonCodeGenerator;
import io.quarkus.resteasy.reactive.jackson.deployment.processor.JacksonSerializationUtils;
import io.quarkus.resteasy.reactive.jackson.runtime.mappers.JacksonMapperUtil;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.VoidType;

public class JacksonSerializerFactory
extends JacksonCodeGenerator {
    private static final String CLASS_NAME_SUFFIX = "$quarkusjacksonserializer";
    private static final String SUPER_CLASS_NAME = StdSerializer.class.getName();
    private static final String JSON_GEN_CLASS_NAME = JsonGenerator.class.getName();
    private static final String SER_STRINGS_CLASS_NAME = "SerializedStrings$quarkusjacksonserializer";
    private final Map<String, Set<String>> generatedFields = new HashMap<String, Set<String>>();

    public JacksonSerializerFactory(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, IndexView jandexIndex) {
        super(generatedClassBuildItemBuildProducer, jandexIndex);
    }

    @Override
    public Collection<String> create(Collection<ClassInfo> classInfos) {
        Collection<String> createdClasses = super.create(classInfos);
        this.createFieldNamesClass();
        return createdClasses;
    }

    private void createFieldNamesClass() {
        if (this.generatedFields.isEmpty()) {
            return;
        }
        MethodDescriptor serStringCtor = MethodDescriptor.ofConstructor(SerializedString.class, (Class[])new Class[]{String.class});
        for (Map.Entry<String, Set<String>> fieldsInPkg : this.generatedFields.entrySet()) {
            try (ClassCreator classCreator = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(this.generatedClassBuildItemBuildProducer, true), fieldsInPkg.getKey() + ".SerializedStrings$quarkusjacksonserializer", null, "java.lang.Object", new String[0]);){
                MethodCreator clinit = (MethodCreator)classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]).setModifiers(8);
                for (String field : fieldsInPkg.getValue()) {
                    FieldCreator fieldCreator = (FieldCreator)classCreator.getFieldCreator(field, SerializedString.class.getName()).setModifiers(24);
                    clinit.writeStaticField(fieldCreator.getFieldDescriptor(), clinit.newInstance(serStringCtor, new ResultHandle[]{clinit.load(field)}));
                }
                clinit.returnVoid();
            }
        }
    }

    @Override
    protected String getSuperClassName() {
        return SUPER_CLASS_NAME;
    }

    @Override
    protected String getClassSuffix() {
        return CLASS_NAME_SUFFIX;
    }

    @Override
    protected boolean createSerializationMethod(ClassInfo classInfo, ClassCreator classCreator, String beanClassName) {
        MethodCreator serialize = ((MethodCreator)classCreator.getMethodCreator("serialize", "void", new String[]{"java.lang.Object", JSON_GEN_CLASS_NAME, "com.fasterxml.jackson.databind.SerializerProvider"}).setModifiers(1)).addException(IOException.class);
        boolean valid = this.serializeObject(classInfo, classCreator, beanClassName, serialize);
        serialize.returnVoid();
        return valid;
    }

    private boolean serializeObject(ClassInfo classInfo, ClassCreator classCreator, String beanClassName, MethodCreator serialize) {
        Optional<JacksonCodeGenerator.FieldSpecs> jsonValueFieldSpecs = this.jsonValueFieldSpecs(classInfo);
        if (jsonValueFieldSpecs == null) {
            return false;
        }
        SerializationContext ctx = new SerializationContext(serialize, beanClassName);
        if (jsonValueFieldSpecs.isPresent()) {
            this.serializeJsonValue(ctx, serialize, jsonValueFieldSpecs.get());
            return true;
        }
        MethodDescriptor writeStartObject = MethodDescriptor.ofMethod((String)JSON_GEN_CLASS_NAME, (String)"writeStartObject", (String)"void", (String[])new String[0]);
        serialize.invokeVirtualMethod(writeStartObject, ctx.jsonGenerator, new ResultHandle[0]);
        HashSet<String> serializedFields = new HashSet<String>();
        boolean valid = this.serializeObjectData(classInfo, classCreator, serialize, ctx, serializedFields);
        MethodDescriptor writeEndObject = MethodDescriptor.ofMethod((String)JSON_GEN_CLASS_NAME, (String)"writeEndObject", (String)"void", (String[])new String[0]);
        serialize.invokeVirtualMethod(writeEndObject, ctx.jsonGenerator, new ResultHandle[0]);
        if (serializedFields.isEmpty()) {
            this.throwExceptionForEmptyBean(beanClassName, serialize, ctx.jsonGenerator);
        }
        ((MethodCreator)classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]).setModifiers(8)).returnVoid();
        return valid;
    }

    private Optional<JacksonCodeGenerator.FieldSpecs> jsonValueFieldSpecs(ClassInfo classInfo) {
        boolean jsonValueAnnotationFound = classInfo.hasAnnotation(JsonValue.class);
        if (!jsonValueAnnotationFound) {
            return Optional.empty();
        }
        Optional<JacksonCodeGenerator.FieldSpecs> jsonValueMethodFieldSpecs = classInfo.methods().stream().filter(mi -> mi.annotation(JsonValue.class) != null).filter(this::isJsonValueMethod).findFirst().map(JacksonCodeGenerator.FieldSpecs::new);
        Optional<JacksonCodeGenerator.FieldSpecs> jsonValueFieldFieldSpecs = classInfo.fields().stream().filter(f -> f.annotation(JsonValue.class) != null).filter(this::isJsonValueField).findFirst().map(JacksonCodeGenerator.FieldSpecs::new);
        if (jsonValueFieldFieldSpecs.isPresent()) {
            return jsonValueMethodFieldSpecs.isPresent() ? null : jsonValueFieldFieldSpecs;
        }
        if (jsonValueMethodFieldSpecs.isEmpty() && jsonValueAnnotationFound) {
            return null;
        }
        return jsonValueMethodFieldSpecs;
    }

    private void serializeJsonValue(SerializationContext ctx, MethodCreator bytecode, JacksonCodeGenerator.FieldSpecs jsonValueFieldSpecs) {
        String typeName = jsonValueFieldSpecs.fieldType.name().toString();
        ResultHandle arg = jsonValueFieldSpecs.toValueReaderHandle((BytecodeCreator)bytecode, ctx.valueHandle);
        this.writeFieldValue(jsonValueFieldSpecs, (BytecodeCreator)bytecode, ctx, typeName, arg, null);
    }

    private boolean serializeObjectData(ClassInfo classInfo, ClassCreator classCreator, MethodCreator serialize, SerializationContext ctx, Set<String> serializedFields) {
        return this.serializeFields(classInfo, classCreator, serialize, ctx, serializedFields) && this.serializeMethods(classInfo, classCreator, serialize, ctx, serializedFields);
    }

    private boolean serializeFields(ClassInfo classInfo, ClassCreator classCreator, MethodCreator serialize, SerializationContext ctx, Set<String> serializedFields) {
        MethodInfo constructor = this.findConstructor(classInfo).orElse(null);
        for (FieldInfo fieldInfo : this.classFields(classInfo)) {
            JacksonCodeGenerator.FieldSpecs fieldSpecs = this.fieldSpecsFromField(classInfo, constructor, fieldInfo);
            if (fieldSpecs == null || !serializedFields.add(fieldSpecs.jsonName) || fieldSpecs.isIgnoredField()) continue;
            if (fieldSpecs.hasUnknownAnnotation()) {
                return false;
            }
            this.writeField(classInfo, fieldSpecs, this.writeFieldBranch(classCreator, serialize, fieldSpecs), ctx);
        }
        return true;
    }

    private boolean serializeMethods(ClassInfo classInfo, ClassCreator classCreator, MethodCreator serialize, SerializationContext ctx, Set<String> serializedFields) {
        for (MethodInfo methodInfo : this.classMethods(classInfo)) {
            JacksonCodeGenerator.FieldSpecs fieldSpecs = this.fieldSpecsFromMethod(methodInfo);
            if (fieldSpecs == null || !serializedFields.add(fieldSpecs.jsonName) || fieldSpecs.isIgnoredField()) continue;
            if (fieldSpecs.hasUnknownAnnotation()) {
                return false;
            }
            this.writeField(classInfo, fieldSpecs, (BytecodeCreator)serialize, ctx);
        }
        return true;
    }

    private JacksonCodeGenerator.FieldSpecs fieldSpecsFromMethod(MethodInfo methodInfo) {
        return !Modifier.isStatic(methodInfo.flags()) && this.isGetterMethod(methodInfo) ? new JacksonCodeGenerator.FieldSpecs(methodInfo) : null;
    }

    private boolean isJsonValueMethod(MethodInfo methodInfo) {
        return Modifier.isPublic(methodInfo.flags()) && !Modifier.isStatic(methodInfo.flags()) && methodInfo.parametersCount() == 0 && !methodInfo.returnType().equals((Object)VoidType.VOID);
    }

    private boolean isJsonValueField(FieldInfo fieldInfo) {
        return Modifier.isPublic(fieldInfo.flags()) && !Modifier.isStatic(fieldInfo.flags());
    }

    private boolean isGetterMethod(MethodInfo methodInfo) {
        String methodName = methodInfo.name();
        return Modifier.isPublic(methodInfo.flags()) && !Modifier.isStatic(methodInfo.flags()) && methodInfo.parametersCount() == 0 && (methodName.startsWith("get") || methodName.startsWith("is"));
    }

    private void writeField(ClassInfo classInfo, JacksonCodeGenerator.FieldSpecs fieldSpecs, BytecodeCreator bytecode, SerializationContext ctx) {
        String pkgName = classInfo.name().packagePrefixName().toString();
        this.generatedFields.computeIfAbsent(pkgName, pkg -> new HashSet()).add(fieldSpecs.jsonName);
        ResultHandle arg = fieldSpecs.toValueReaderHandle(bytecode, ctx.valueHandle);
        bytecode = JacksonSerializerFactory.checkInclude(bytecode, ctx, arg);
        String typeName = fieldSpecs.fieldType.name().toString();
        this.writeFieldValue(fieldSpecs, bytecode, ctx, typeName, arg, pkgName);
    }

    private void writeFieldValue(JacksonCodeGenerator.FieldSpecs fieldSpecs, BytecodeCreator bytecode, SerializationContext ctx, String typeName, ResultHandle arg, String pkgName) {
        String primitiveMethodName = this.writeMethodForPrimitiveFields(typeName);
        if (primitiveMethodName != null) {
            BytecodeCreator primitiveBytecode;
            BytecodeCreator bytecodeCreator = primitiveBytecode = JacksonSerializationUtils.isBoxedPrimitive(typeName) ? bytecode.ifNotNull(arg).trueBranch() : bytecode;
            if (pkgName != null) {
                JacksonSerializerFactory.writeFieldName(fieldSpecs, primitiveBytecode, ctx.jsonGenerator, pkgName);
            }
            MethodDescriptor primitiveWriter = MethodDescriptor.ofMethod((String)JSON_GEN_CLASS_NAME, (String)primitiveMethodName, (String)"void", (String[])new String[]{fieldSpecs.writtenType()});
            primitiveBytecode.invokeVirtualMethod(primitiveWriter, ctx.jsonGenerator, new ResultHandle[]{arg});
        } else {
            if (pkgName != null) {
                this.registerTypeToBeGenerated(fieldSpecs.fieldType, typeName);
                JacksonSerializerFactory.writeFieldName(fieldSpecs, bytecode, ctx.jsonGenerator, pkgName);
            }
            MethodDescriptor writeMethod = MethodDescriptor.ofMethod((Object)JSON_GEN_CLASS_NAME, (String)"writePOJO", Void.TYPE, (Object[])new Object[]{Object.class});
            bytecode.invokeVirtualMethod(writeMethod, ctx.jsonGenerator, new ResultHandle[]{arg});
        }
    }

    private static BytecodeCreator checkInclude(BytecodeCreator bytecode, SerializationContext ctx, ResultHandle arg) {
        MethodDescriptor shouldSerialize = MethodDescriptor.ofMethod(JacksonMapperUtil.SerializationInclude.class, (String)"shouldSerialize", Boolean.TYPE, (Class[])new Class[]{Object.class});
        ResultHandle included = bytecode.invokeVirtualMethod(shouldSerialize, ctx.includeHandle, new ResultHandle[]{arg});
        return bytecode.ifTrue(included).trueBranch();
    }

    private static void writeFieldName(JacksonCodeGenerator.FieldSpecs fieldSpecs, BytecodeCreator bytecode, ResultHandle jsonGenerator, String pkgName) {
        MethodDescriptor writeFieldName = MethodDescriptor.ofMethod((Object)JSON_GEN_CLASS_NAME, (String)"writeFieldName", Void.TYPE, (Object[])new Object[]{SerializableString.class});
        ResultHandle serStringHandle = bytecode.readStaticField(FieldDescriptor.of((String)(pkgName + ".SerializedStrings$quarkusjacksonserializer"), (String)fieldSpecs.jsonName, (String)SerializedString.class.getName()));
        bytecode.invokeVirtualMethod(writeFieldName, jsonGenerator, new ResultHandle[]{serStringHandle});
    }

    private String writeMethodForPrimitiveFields(String typeName) {
        return switch (typeName) {
            case "java.lang.String", "char", "java.lang.Character" -> "writeString";
            case "short", "java.lang.Short", "int", "java.lang.Integer", "long", "java.lang.Long", "float", "java.lang.Float", "double", "java.lang.Double" -> "writeNumber";
            case "boolean", "java.lang.Boolean" -> "writeBoolean";
            default -> null;
        };
    }

    private BytecodeCreator writeFieldBranch(ClassCreator classCreator, MethodCreator serialize, JacksonCodeGenerator.FieldSpecs fieldSpecs) {
        String[] rolesAllowed = fieldSpecs.rolesAllowed();
        if (rolesAllowed != null) {
            MethodCreator clinit = (MethodCreator)classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]).setModifiers(8);
            ResultHandle rolesArray = clinit.newArray(String.class, rolesAllowed.length);
            for (int i = 0; i < rolesAllowed.length; ++i) {
                clinit.writeArrayValue(rolesArray, clinit.load(i), clinit.load(rolesAllowed[i]));
            }
            FieldCreator fieldCreator = (FieldCreator)classCreator.getFieldCreator(fieldSpecs.fieldName + "_ROLES_ALLOWED", String[].class.getName()).setModifiers(24);
            clinit.writeStaticField(fieldCreator.getFieldDescriptor(), rolesArray);
            ResultHandle rolesArrayReader = serialize.readStaticField(FieldDescriptor.of((String)classCreator.getClassName(), (String)(fieldSpecs.fieldName + "_ROLES_ALLOWED"), (String)String[].class.getName()));
            MethodDescriptor includeSecureField = MethodDescriptor.ofMethod(JacksonMapperUtil.class, (String)"includeSecureField", Boolean.TYPE, (Class[])new Class[]{String[].class});
            ResultHandle included = serialize.invokeStaticMethod(includeSecureField, new ResultHandle[]{rolesArrayReader});
            return serialize.ifTrue(included).trueBranch();
        }
        return serialize;
    }

    private void throwExceptionForEmptyBean(String beanClassName, MethodCreator serialize, ResultHandle jsonGenerator) {
        String serializationFeatureClassName = SerializationFeature.class.getName();
        ResultHandle serializerProvider = serialize.getMethodParam(2);
        MethodDescriptor isEnabled = MethodDescriptor.ofMethod((String)SerializerProvider.class.getName(), (String)"isEnabled", (String)"boolean", (String[])new String[]{serializationFeatureClassName});
        FieldDescriptor failField = FieldDescriptor.of((String)serializationFeatureClassName, (String)"FAIL_ON_EMPTY_BEANS", (String)serializationFeatureClassName);
        ResultHandle failOnEmptyBeans = serialize.readStaticField(failField);
        ResultHandle isFailEnabled = serialize.invokeVirtualMethod(isEnabled, serializerProvider, new ResultHandle[]{failOnEmptyBeans});
        BytecodeCreator isFailEnabledBranch = serialize.ifTrue(isFailEnabled).trueBranch();
        ResultHandle javaType = isFailEnabledBranch.invokeStaticMethod(MethodDescriptor.ofMethod(SimpleType.class, (String)"constructUnsafe", SimpleType.class, (Class[])new Class[]{Class.class}), new ResultHandle[]{isFailEnabledBranch.loadClass(beanClassName)});
        MethodDescriptor exceptionConstructor = MethodDescriptor.ofMethod(InvalidDefinitionException.class, (String)"from", InvalidDefinitionException.class, (Class[])new Class[]{JsonGenerator.class, String.class, JavaType.class});
        String errorMsg = String.format("No serializer found for class %s and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationFeature.FAIL_ON_EMPTY_BEANS)", beanClassName);
        ResultHandle invalidException = isFailEnabledBranch.invokeStaticMethod(exceptionConstructor, new ResultHandle[]{jsonGenerator, isFailEnabledBranch.load(errorMsg), javaType});
        isFailEnabledBranch.throwException(invalidException);
    }

    private record SerializationContext(ResultHandle valueHandle, ResultHandle jsonGenerator, ResultHandle serializerProvider, ResultHandle includeHandle) {
        SerializationContext(MethodCreator serialize, String beanClassName) {
            this(SerializationContext.valueHandle(serialize, beanClassName), serialize.getMethodParam(1), serialize.getMethodParam(2), SerializationContext.includeHandle(serialize));
        }

        private static ResultHandle valueHandle(MethodCreator serialize, String beanClassName) {
            return serialize.checkCast(serialize.getMethodParam(0), beanClassName);
        }

        private static ResultHandle includeHandle(MethodCreator serialize) {
            MethodDescriptor decodeInclude = MethodDescriptor.ofMethod(JacksonMapperUtil.SerializationInclude.class, (String)"decode", JacksonMapperUtil.SerializationInclude.class, (Class[])new Class[]{Object.class, SerializerProvider.class});
            return serialize.invokeStaticMethod(decodeInclude, new ResultHandle[]{serialize.getMethodParam(0), serialize.getMethodParam(2)});
        }
    }
}

