/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.authenticators.browser.AbstractUsernameFormAuthenticator;
import org.keycloak.authentication.authenticators.browser.WebAuthnConditionalUIAuthenticator;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.sessions.AuthenticationSessionModel;

public class UsernamePasswordForm
extends AbstractUsernameFormAuthenticator
implements Authenticator {
    protected final WebAuthnConditionalUIAuthenticator webauthnAuth;

    public UsernamePasswordForm() {
        this.webauthnAuth = null;
    }

    public UsernamePasswordForm(KeycloakSession session) {
        this.webauthnAuth = new WebAuthnConditionalUIAuthenticator(session, context -> this.createLoginForm(context.form()));
    }

    @Override
    public void action(AuthenticationFlowContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        if (formData.containsKey((Object)"cancel")) {
            context.cancelLogin();
            return;
        }
        if (this.webauthnAuth != null && this.webauthnAuth.isPasskeysEnabled() && (formData.containsKey((Object)"authenticatorData") || formData.containsKey((Object)"error"))) {
            this.webauthnAuth.action(context);
            return;
        }
        if (!this.validateForm(context, (MultivaluedMap<String, String>)formData)) {
            return;
        }
        context.success("password");
    }

    protected boolean validateForm(AuthenticationFlowContext context, MultivaluedMap<String, String> formData) {
        return this.validateUserAndPassword(context, formData);
    }

    protected boolean alreadyAuthenticatedUsingPasswordlessCredential(AuthenticationFlowContext context) {
        return this.alreadyAuthenticatedUsingPasswordlessCredential(context.getAuthenticationSession());
    }

    protected boolean alreadyAuthenticatedUsingPasswordlessCredential(AuthenticationSessionModel authSession) {
        return this.webauthnAuth != null && this.webauthnAuth.isPasskeysEnabled() && AuthenticatorUtil.getAuthnCredentials(authSession).contains(this.webauthnAuth.getCredentialType());
    }

    public void authenticate(AuthenticationFlowContext context) {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        String loginHint = context.getAuthenticationSession().getClientNote("login_hint");
        String rememberMeUsername = AuthenticationManager.getRememberMeUsername(context.getSession());
        if (context.getUser() != null) {
            if (this.alreadyAuthenticatedUsingPasswordlessCredential(context)) {
                context.success();
                return;
            }
            LoginFormsProvider form = context.form();
            form.setAttribute("usernameHidden", (Object)true);
            form.setAttribute("registrationDisabled", (Object)true);
            context.getAuthenticationSession().setAuthNote("USER_SET_BEFORE_USERNAME_PASSWORD_AUTH", "true");
        } else {
            context.getAuthenticationSession().removeAuthNote("USER_SET_BEFORE_USERNAME_PASSWORD_AUTH");
            if (loginHint != null || rememberMeUsername != null) {
                if (loginHint != null) {
                    formData.add((Object)"username", (Object)loginHint);
                } else {
                    formData.add((Object)"username", (Object)rememberMeUsername);
                    formData.add((Object)"rememberMe", (Object)"on");
                }
            }
        }
        if (this.isConditionalPasskeysEnabled(context.getUser())) {
            this.webauthnAuth.fillContextForm(context);
        }
        Response challengeResponse = this.challenge(context, (MultivaluedMap<String, String>)formData);
        context.challenge(challengeResponse);
    }

    public boolean requiresUser() {
        return false;
    }

    protected Response challenge(AuthenticationFlowContext context, MultivaluedMap<String, String> formData) {
        LoginFormsProvider forms = context.form();
        if (!formData.isEmpty()) {
            forms.setFormData(formData);
        }
        return forms.createLoginUsernamePassword();
    }

    @Override
    protected Response challenge(AuthenticationFlowContext context, String error, String field) {
        if (this.isConditionalPasskeysEnabled(context.getUser())) {
            this.webauthnAuth.fillContextForm(context);
        }
        return super.challenge(context, error, field);
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    @Override
    public void close() {
    }

    protected boolean isConditionalPasskeysEnabled(UserModel currentUser) {
        return this.webauthnAuth != null && this.webauthnAuth.isPasskeysEnabled() && (currentUser == null || currentUser.credentialManager().isConfiguredFor(this.webauthnAuth.getCredentialType()));
    }
}

