/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CoipPool;
import software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsResponse;

public class DescribeCoipPoolsPublisher
implements SdkPublisher<DescribeCoipPoolsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeCoipPoolsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCoipPoolsPublisher(Ec2AsyncClient client, DescribeCoipPoolsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCoipPoolsPublisher(Ec2AsyncClient client, DescribeCoipPoolsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCoipPoolsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCoipPoolsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CoipPool> coipPools() {
        Function<DescribeCoipPoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.coipPools() != null) {
                return response.coipPools().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCoipPoolsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCoipPoolsResponseFetcher
    implements AsyncPageFetcher<DescribeCoipPoolsResponse> {
        private DescribeCoipPoolsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCoipPoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCoipPoolsResponse> nextPage(DescribeCoipPoolsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCoipPoolsPublisher.this.client.describeCoipPools(DescribeCoipPoolsPublisher.this.firstRequest);
            }
            return DescribeCoipPoolsPublisher.this.client.describeCoipPools((DescribeCoipPoolsRequest)((Object)DescribeCoipPoolsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

