/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Transport
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Transport> {
    @Nullable
    private final Long rxCount;
    @Nullable
    private final String rxSize;
    @Nullable
    private final Long rxSizeInBytes;
    @Nullable
    private final Long serverOpen;
    @Nullable
    private final Long totalOutboundConnections;
    @Nullable
    private final Long txCount;
    @Nullable
    private final String txSize;
    @Nullable
    private final Long txSizeInBytes;
    public static final JsonpDeserializer<Transport> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Transport::setupTransportDeserializer);

    private Transport(Builder builder) {
        this.rxCount = builder.rxCount;
        this.rxSize = builder.rxSize;
        this.rxSizeInBytes = builder.rxSizeInBytes;
        this.serverOpen = builder.serverOpen;
        this.totalOutboundConnections = builder.totalOutboundConnections;
        this.txCount = builder.txCount;
        this.txSize = builder.txSize;
        this.txSizeInBytes = builder.txSizeInBytes;
    }

    public static Transport of(Function<Builder, ObjectBuilder<Transport>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long rxCount() {
        return this.rxCount;
    }

    @Nullable
    public final String rxSize() {
        return this.rxSize;
    }

    @Nullable
    public final Long rxSizeInBytes() {
        return this.rxSizeInBytes;
    }

    @Nullable
    public final Long serverOpen() {
        return this.serverOpen;
    }

    @Nullable
    public final Long totalOutboundConnections() {
        return this.totalOutboundConnections;
    }

    @Nullable
    public final Long txCount() {
        return this.txCount;
    }

    @Nullable
    public final String txSize() {
        return this.txSize;
    }

    @Nullable
    public final Long txSizeInBytes() {
        return this.txSizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.rxCount != null) {
            generator.writeKey("rx_count");
            generator.write(this.rxCount.longValue());
        }
        if (this.rxSize != null) {
            generator.writeKey("rx_size");
            generator.write(this.rxSize);
        }
        if (this.rxSizeInBytes != null) {
            generator.writeKey("rx_size_in_bytes");
            generator.write(this.rxSizeInBytes.longValue());
        }
        if (this.serverOpen != null) {
            generator.writeKey("server_open");
            generator.write(this.serverOpen.longValue());
        }
        if (this.totalOutboundConnections != null) {
            generator.writeKey("total_outbound_connections");
            generator.write(this.totalOutboundConnections.longValue());
        }
        if (this.txCount != null) {
            generator.writeKey("tx_count");
            generator.write(this.txCount.longValue());
        }
        if (this.txSize != null) {
            generator.writeKey("tx_size");
            generator.write(this.txSize);
        }
        if (this.txSizeInBytes != null) {
            generator.writeKey("tx_size_in_bytes");
            generator.write(this.txSizeInBytes.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTransportDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::rxCount, JsonpDeserializer.longDeserializer(), "rx_count");
        op.add(Builder::rxSize, JsonpDeserializer.stringDeserializer(), "rx_size");
        op.add(Builder::rxSizeInBytes, JsonpDeserializer.longDeserializer(), "rx_size_in_bytes");
        op.add(Builder::serverOpen, JsonpDeserializer.longDeserializer(), "server_open");
        op.add(Builder::totalOutboundConnections, JsonpDeserializer.longDeserializer(), "total_outbound_connections");
        op.add(Builder::txCount, JsonpDeserializer.longDeserializer(), "tx_count");
        op.add(Builder::txSize, JsonpDeserializer.stringDeserializer(), "tx_size");
        op.add(Builder::txSizeInBytes, JsonpDeserializer.longDeserializer(), "tx_size_in_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.rxCount);
        result = 31 * result + Objects.hashCode(this.rxSize);
        result = 31 * result + Objects.hashCode(this.rxSizeInBytes);
        result = 31 * result + Objects.hashCode(this.serverOpen);
        result = 31 * result + Objects.hashCode(this.totalOutboundConnections);
        result = 31 * result + Objects.hashCode(this.txCount);
        result = 31 * result + Objects.hashCode(this.txSize);
        result = 31 * result + Objects.hashCode(this.txSizeInBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transport other = (Transport)o;
        return Objects.equals(this.rxCount, other.rxCount) && Objects.equals(this.rxSize, other.rxSize) && Objects.equals(this.rxSizeInBytes, other.rxSizeInBytes) && Objects.equals(this.serverOpen, other.serverOpen) && Objects.equals(this.totalOutboundConnections, other.totalOutboundConnections) && Objects.equals(this.txCount, other.txCount) && Objects.equals(this.txSize, other.txSize) && Objects.equals(this.txSizeInBytes, other.txSizeInBytes);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Transport> {
        @Nullable
        private Long rxCount;
        @Nullable
        private String rxSize;
        @Nullable
        private Long rxSizeInBytes;
        @Nullable
        private Long serverOpen;
        @Nullable
        private Long totalOutboundConnections;
        @Nullable
        private Long txCount;
        @Nullable
        private String txSize;
        @Nullable
        private Long txSizeInBytes;

        public Builder() {
        }

        private Builder(Transport o) {
            this.rxCount = o.rxCount;
            this.rxSize = o.rxSize;
            this.rxSizeInBytes = o.rxSizeInBytes;
            this.serverOpen = o.serverOpen;
            this.totalOutboundConnections = o.totalOutboundConnections;
            this.txCount = o.txCount;
            this.txSize = o.txSize;
            this.txSizeInBytes = o.txSizeInBytes;
        }

        private Builder(Builder o) {
            this.rxCount = o.rxCount;
            this.rxSize = o.rxSize;
            this.rxSizeInBytes = o.rxSizeInBytes;
            this.serverOpen = o.serverOpen;
            this.totalOutboundConnections = o.totalOutboundConnections;
            this.txCount = o.txCount;
            this.txSize = o.txSize;
            this.txSizeInBytes = o.txSizeInBytes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder rxCount(@Nullable Long value) {
            this.rxCount = value;
            return this;
        }

        @Nonnull
        public final Builder rxSize(@Nullable String value) {
            this.rxSize = value;
            return this;
        }

        @Nonnull
        public final Builder rxSizeInBytes(@Nullable Long value) {
            this.rxSizeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder serverOpen(@Nullable Long value) {
            this.serverOpen = value;
            return this;
        }

        @Nonnull
        public final Builder totalOutboundConnections(@Nullable Long value) {
            this.totalOutboundConnections = value;
            return this;
        }

        @Nonnull
        public final Builder txCount(@Nullable Long value) {
            this.txCount = value;
            return this;
        }

        @Nonnull
        public final Builder txSize(@Nullable String value) {
            this.txSize = value;
            return this;
        }

        @Nonnull
        public final Builder txSizeInBytes(@Nullable Long value) {
            this.txSizeInBytes = value;
            return this;
        }

        @Override
        @Nonnull
        public Transport build() {
            this._checkSingleUse();
            return new Transport(this);
        }
    }
}

