/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * USB HID keycodes
 * http://www.freebsddiary.org/APC/usb_hid_usages.php
 */

#ifndef __USB_HID_KEYS_H
#define __USB_HID_KEYS_H

#define USB_HID_KEY_F13 0x68
#define USB_HID_KEY_F14 0x69
#define USB_HID_KEY_F15 0x6A
#define USB_HID_KEY_F16 0x6B
#define USB_HID_KEY_F17 0x6C
#define USB_HID_KEY_F18 0x6D
#define USB_HID_KEY_F19 0x6E
#define USB_HID_KEY_F20 0x6F
#define USB_HID_KEY_F21 0x70
#define USB_HID_KEY_F22 0x71
#define USB_HID_KEY_F23 0x72
#define USB_HID_KEY_F24 0x73

#define USB_HID_KEY_MEDIA_PLAYPAUSE 0xE8
#define USB_HID_KEY_MEDIA_PREVIOUSSONG  0xEA
#define USB_HID_KEY_MEDIA_NEXTSONG  0xEB
#define USB_HID_KEY_MEDIA_VOLUMEUP 0xED
#define USB_HID_KEY_MEDIA_VOLUMEDOWN 0xEE
#define USB_HID_KEY_MEDIA_MUTE 0xEF
#define USB_HID_KEY_MEDIA_SLEEP 0xF8

// https://usb.org/sites/default/files/hut1_22.pdf
#define USB_HID_USAGE_MEDIA_PLAYPAUSE 0xCD
#define USB_HID_USAGE_MEDIA_PREVIOUSSONG 0xB6
#define USB_HID_USAGE_MEDIA_NEXTSONG 0xB5
#define USB_HID_USAGE_MEDIA_VOLUMEUP 0xE9
#define USB_HID_USAGE_MEDIA_VOLUMEDOWN 0xEA
#define USB_HID_USAGE_MEDIA_MUTE 0xE2

#endif // __USB_HID_KEYS_H
