/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawCommonAccessor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class LongRawAccessor
extends RawCommonAccessor {
    static final int MAXLENGTH = Integer.MAX_VALUE;
    OracleInputStream stream;
    int columnPosition;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    LongRawAccessor(OracleStatement stmt, int column_pos, int max_len, short form, int external_type) throws SQLException {
        super(stmt, Integer.MAX_VALUE, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$9, null, stmt, column_pos, max_len, form, external_type);
            }
            this.columnPosition = 0;
            this.init(stmt, 24, 24, form, false);
            this.columnPosition = column_pos;
            this.initForDataAccess(external_type, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$9, null);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$9, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    LongRawAccessor(OracleStatement stmt, int column_pos, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(stmt, Integer.MAX_VALUE, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$10, null, stmt, column_pos, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            this.columnPosition = 0;
            this.init(stmt, 24, 24, form, false);
            this.columnPosition = column_pos;
            this.initForDescribe(24, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            int max_field_size = stmt.maxFieldSize;
            if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
                max_len = max_field_size;
            }
            this.initForDataAccess(0, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void external_type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$0, this, n2, n3, string);
            }
            if (external_type != false) {
                this.externalType = external_type;
            }
            this.isStream = true;
            this.isColumnNumberAware = true;
            this.byteLength = 0;
            this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
            if (bl) {
                OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "LongRawAccessor.initForDataAccess, columnPosition=" + this.columnPosition + ", stream= " + this.stream);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    OracleInputStream initForNewRow() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "initForNewRow accessor " + this + ", old stream " + this.stream);
            }
            this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
            if (bl) {
                OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "initForNewRow accessor " + this + ", new stream " + this.stream);
            }
            OracleInputStream oracleInputStream = this.stream;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$1, this, oracleInputStream);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$1, this, null);
            }
            return oracleInputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void updateColumnNumber(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void colNumber;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$2, this, n2);
            }
            this.columnPosition = ++colNumber;
            if (this.stream != null) {
                this.stream.columnIndex = colNumber;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] getBytesInternal(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$3, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$3, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$3, this, null);
                }
                return null;
            }
            if (this.statement.isFetchStreams) {
                byte[] byArray = super.getBytesInternal((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$3, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$3, this, null);
                }
                return byArray;
            }
            if (this.stream == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$3, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$3, this, null);
                }
                return null;
            }
            if (!this.isStream) {
                byte[] byArray = super.getBytesInternal((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$3, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$3, this, null);
                }
                return byArray;
            }
            if (this.stream.closed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            ByteArrayOutputStream outs = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            try {
                int length;
                while ((length = this.stream.read(buffer)) != -1) {
                    outs.write(buffer, 0, length);
                }
            }
            catch (IOException e2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$3, this, sQLException);
                }
                throw sQLException;
            }
            byte[] byArray = outs.toByteArray();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$3, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$3, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected InputStream convertBytesToStream(int n2, int n3) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            InputStream inputStream;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$4, this, n2, n3);
            }
            ByteArrayInputStream is = new ByteArrayInputStream(this.getBytesInternal((int)currentRow));
            try {
                void conversion;
                InputStream result;
                inputStream = result = this.statement.connection.conversion.ConvertStream(is, (int)conversion);
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Throwable throwable2 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$4, this, throwable2);
                }
                throw throwable2;
            }
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            InputStream inputStream2 = inputStream;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$4, this, inputStream2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$4, this, null);
            }
            return inputStream2;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$4, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    InputStream getAsciiStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$5, this, n2);
            }
            PhysicalConnection conn = this.statement.connection;
            if (this.isNull((int)currentRow)) {
                InputStream inputStream = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$5, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$5, this, null);
                }
                return null;
            }
            if (this.statement.isFetchStreams) {
                InputStream inputStream = this.convertBytesToStream((int)currentRow, 2);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$5, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$5, this, null);
                }
                return inputStream;
            }
            if (this.stream.closed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$5, this, sQLException);
                }
                throw sQLException;
            }
            InputStream inputStream = conn.conversion.ConvertStream(this.stream, 2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$5, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$5, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    InputStream getUnicodeStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$6, this, n2);
            }
            PhysicalConnection conn = this.statement.connection;
            if (this.isNull((int)currentRow)) {
                InputStream inputStream = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$6, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$6, this, null);
                }
                return null;
            }
            if (this.statement.isFetchStreams) {
                InputStream inputStream = this.convertBytesToStream((int)currentRow, 3);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$6, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$6, this, null);
                }
                return inputStream;
            }
            if (this.stream.closed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$6, this, sQLException);
                }
                throw sQLException;
            }
            InputStream inputStream = conn.conversion.ConvertStream(this.stream, 3);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$6, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$6, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    Reader getCharacterStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$7, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                Reader reader = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$7, this, reader);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$7, this, null);
                }
                return null;
            }
            if (this.statement.isFetchStreams) {
                Reader reader;
                ByteArrayInputStream is = new ByteArrayInputStream(this.getBytesInternal((int)currentRow));
                try {
                    Reader result;
                    PhysicalConnection conn = this.statement.connection;
                    reader = result = this.statement.connection.conversion.ConvertCharacterStream(is, 8, this.formOfUse);
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$7, this, throwable2);
                    }
                    throw throwable2;
                }
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Reader reader2 = reader;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$7, this, reader2);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$7, this, null);
                }
                return reader2;
            }
            if (this.stream.closed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$7, this, sQLException);
                }
                throw sQLException;
            }
            PhysicalConnection conn = this.statement.connection;
            Reader reader = conn.conversion.ConvertCharacterStream(this.stream, 8, this.formOfUse);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$7, this, reader);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$7, this, null);
            }
            return reader;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$7, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    InputStream getBinaryStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$8, this, n2);
            }
            PhysicalConnection conn = this.statement.connection;
            if (this.isNull((int)currentRow)) {
                InputStream inputStream = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$8, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$8, this, null);
                }
                return null;
            }
            if (this.statement.isFetchStreams) {
                InputStream inputStream = this.convertBytesToStream((int)currentRow, 6);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$8, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$8, this, null);
                }
                return inputStream;
            }
            if (this.stream.closed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$8, this, sQLException);
                }
                throw sQLException;
            }
            InputStream inputStream = conn.conversion.ConvertStream(this.stream, 6);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$8, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$8, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, LongRawAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @DisableTrace
    public String toString() {
        return "LongRawAccessor@" + Integer.toHexString(this.hashCode()) + "{columnPosition = " + this.columnPosition + "}";
    }

    static {
        try {
            $$$methodRef$$$10 = LongRawAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = LongRawAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = LongRawAccessor.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = LongRawAccessor.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = LongRawAccessor.class.getDeclaredMethod("getUnicodeStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = LongRawAccessor.class.getDeclaredMethod("getAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LongRawAccessor.class.getDeclaredMethod("convertBytesToStream", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LongRawAccessor.class.getDeclaredMethod("getBytesInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LongRawAccessor.class.getDeclaredMethod("updateColumnNumber", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LongRawAccessor.class.getDeclaredMethod("initForNewRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LongRawAccessor.class.getDeclaredMethod("initForDataAccess", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

