/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;

@ExportLibrary(value=InteropLibrary.class, delegateTo="number")
public final class JSNumberObject
extends JSNonProxyObject {
    final Number number;

    protected JSNumberObject(Shape shape, JSDynamicObject proto, Number number) {
        super(shape, proto);
        this.number = number;
    }

    public Number getNumber() {
        return this.number;
    }

    @Override
    public TruffleString getClassName() {
        return this.getBuiltinToStringTag();
    }

    @Override
    public TruffleString getBuiltinToStringTag() {
        return JSNumber.CLASS_NAME;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return super.toDisplayStringImpl(allowSideEffects, format, depth);
        }
        Number primitiveValue = JSNumber.valueOf(this);
        return JSRuntime.objectToDisplayString(this, allowSideEffects, format, depth, this.getBuiltinToStringTag(), new TruffleString[]{Strings.PRIMITIVE_VALUE}, new Object[]{primitiveValue});
    }

    public static JSNumberObject create(Shape shape, JSDynamicObject proto, Number value) {
        return new JSNumberObject(shape, proto, value);
    }
}

