/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableSynonym;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaReference;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class SynonymRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(SynonymRetriever.class.getName());

    SynonymRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveSynonymInformation(InclusionRule synonymInclusionRule) throws SQLException {
        InclusionRuleFilter<MutableSynonym> synonymFilter = new InclusionRuleFilter<MutableSynonym>(synonymInclusionRule, false);
        if (synonymFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving synonyms, since this was not requested");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving synonyms");
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.EXT_SYNONYMS)) {
            LOGGER.log(Level.FINE, "Synonym definition SQL statement was not provided");
            return;
        }
        Query synonymsDefinitionSql = informationSchemaViews.getQuery(InformationSchemaKey.EXT_SYNONYMS);
        NamedObjectList<SchemaReference> schemas = this.getAllSchemas();
        String name = "synonyms";
        RetrievalCounts retrievalCounts = new RetrievalCounts("synonyms");
        try (Connection connection = this.getRetrieverConnection().getConnection("synonyms");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(synonymsDefinitionSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("SYNONYM_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("SYNONYM_SCHEMA"));
                String synonymName = results.getString("SYNONYM_NAME");
                String referencedObjectCatalogName = results.getString("REFERENCED_OBJECT_CATALOG");
                String referencedObjectSchemaName = results.getString("REFERENCED_OBJECT_SCHEMA");
                String referencedObjectName = results.getString("REFERENCED_OBJECT_NAME");
                if (Utility.isBlank((CharSequence)referencedObjectName)) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("No reference for synonym <%s.%s.%s>", new Object[]{catalogName, schemaName, synonymName}));
                    continue;
                }
                SchemaReference schema = new SchemaReference(catalogName, schemaName);
                SchemaReference referencedSchema = new SchemaReference(referencedObjectCatalogName, referencedObjectSchemaName);
                if (!schemas.contains(schema) && !schemas.contains(referencedSchema)) continue;
                Optional<MutableTable> referencedTable = this.lookupTable(referencedObjectCatalogName, referencedObjectSchemaName, referencedObjectName);
                Optional<MutableRoutine> referencedRoutine = this.lookupRoutine(referencedObjectCatalogName, referencedObjectSchemaName, referencedObjectName, referencedObjectName);
                DatabaseObject referencedObject = referencedTable.isPresent() ? (DatabaseObject)referencedTable.get() : (referencedRoutine.isPresent() ? (DatabaseObject)referencedRoutine.get() : new UnknownDatabaseObject(referencedSchema, referencedObjectName));
                MutableSynonym synonym = new MutableSynonym(schema, synonymName);
                synonym.withQuoting(this.getRetrieverConnection().getIdentifiers());
                if (!synonymFilter.test(synonym)) continue;
                synonym.setReferencedObject(referencedObject);
                synonym.addAttributes(results.getAttributes());
                this.catalog.addSynonym(synonym);
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve synonyms", e);
        }
        retrievalCounts.log();
    }

    private static final class UnknownDatabaseObject
    extends AbstractDatabaseObject {
        private static final long serialVersionUID = -2212843304418302122L;

        UnknownDatabaseObject(Schema schema, String name) {
            super(schema, name);
        }
    }
}

