/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jna.embedded;

import com.sun.jna.Platform;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.firebirdsql.jna.embedded.spi.FirebirdEmbeddedLibrary;
import org.firebirdsql.jna.embedded.spi.FirebirdEmbeddedProvider;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FirebirdEmbeddedLookup {
    private static final Logger log = LoggerFactory.getLogger(FirebirdEmbeddedLookup.class);

    public static Optional<FirebirdEmbeddedLibrary> findFirebirdEmbedded() {
        try {
            ServiceLoader<FirebirdEmbeddedProvider> firebirdEmbeddedProviders = ServiceLoader.load(FirebirdEmbeddedProvider.class);
            Iterator<FirebirdEmbeddedProvider> iterator = firebirdEmbeddedProviders.iterator();
            while (iterator.hasNext()) {
                try {
                    FirebirdEmbeddedProvider provider = iterator.next();
                    if (!Platform.RESOURCE_PREFIX.equals(provider.getPlatform())) continue;
                    return Optional.of(provider.getFirebirdEmbeddedLibrary());
                }
                catch (Exception | ServiceConfigurationError e) {
                    log.errorDebug("Can't load FirebirdEmbeddedProvider (skipping)", e);
                }
            }
        }
        catch (RuntimeException | ServiceConfigurationError e) {
            log.error("Unable to install Firebird Embedded using ServiceLoader", e);
        }
        return Optional.empty();
    }
}

