/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.exception;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.jcc.DB2Diagnosable;
import com.ibm.db2.jcc.DB2Sqlca;
import com.ibm.db2.jcc.DBBindDiagnostics;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.regex.PatternSyntaxException;

public class HeteroBatchSQLException
extends SQLException
implements DB2Diagnosable {
    private static final long serialVersionUID = -5217442784449778863L;
    private static final String batchElementHeader_ = "Error for batch element #";
    private final SQLException exceptionContainer_;
    private final boolean initialized_;
    private final boolean implementsDB2Diagnosable_;
    private int batchElementOffset_;
    private int stmtOffset_;
    private int originalOffsetInChain_;
    private HeteroBatchSQLException nextHeteroBatchSQLException_ = null;
    private boolean validContainer_ = false;

    public HeteroBatchSQLException() {
        this.exceptionContainer_ = this;
        this.validContainer_ = false;
        this.implementsDB2Diagnosable_ = false;
        this.batchElementOffset_ = -1;
        this.stmtOffset_ = -1;
        this.initialized_ = true;
    }

    public HeteroBatchSQLException(SQLException sQLException, int n2) {
        if (sQLException != null) {
            this.originalOffsetInChain_ = n2;
            this.exceptionContainer_ = sQLException;
            Class<?> clazz = sQLException.getClass();
            if (clazz.getCanonicalName().startsWith("com.ibm.db2.jcc.")) {
                this.parseBatchElementStmtOffset();
                this.implementsDB2Diagnosable_ = sQLException instanceof DB2Diagnosable;
            } else {
                this.implementsDB2Diagnosable_ = false;
                this.batchElementOffset_ = -1;
                this.stmtOffset_ = -1;
            }
            this.validContainer_ = true;
            this.initialized_ = true;
        } else {
            this.exceptionContainer_ = this;
            this.validContainer_ = false;
            this.implementsDB2Diagnosable_ = false;
            this.batchElementOffset_ = -1;
            this.stmtOffset_ = -1;
            this.initialized_ = true;
        }
    }

    @Override
    public SQLException getNextException() {
        return this.nextHeteroBatchSQLException_;
    }

    public HeteroBatchSQLException getNextHeteroBatchSQLException() {
        return this.nextHeteroBatchSQLException_;
    }

    public int getOriginalOffsetInChain() {
        return this.originalOffsetInChain_;
    }

    public SQLException getUnderlyingSQLException() {
        return this.exceptionContainer_;
    }

    public boolean isRowSpecificSQLException() {
        return this.batchElementOffset_ != -1 || this.stmtOffset_ != -1;
    }

    public boolean implementsDB2Diagnosable() {
        return this.implementsDB2Diagnosable_;
    }

    @Override
    public synchronized void setNextException(SQLException sQLException) {
        if (!(sQLException instanceof HeteroBatchSQLException)) {
            throw new DataRuntimeException("Input parameter of HeteroBatchSQLException.setNextException must be an instance of HeteroBatchSQLException", sQLException, 11730, "3.3306.7");
        }
        this.setNextHeteroBatchSQLException((HeteroBatchSQLException)sQLException);
    }

    public synchronized void setNextHeteroBatchSQLException(HeteroBatchSQLException heteroBatchSQLException) {
        if (this.nextHeteroBatchSQLException_ == null) {
            this.nextHeteroBatchSQLException_ = heteroBatchSQLException;
        } else {
            HeteroBatchSQLException heteroBatchSQLException2 = this.nextHeteroBatchSQLException_;
            while (heteroBatchSQLException2.nextHeteroBatchSQLException_ != null) {
                heteroBatchSQLException2 = heteroBatchSQLException2.nextHeteroBatchSQLException_;
            }
            heteroBatchSQLException2.nextHeteroBatchSQLException_ = heteroBatchSQLException;
        }
    }

    @Override
    public DBBindDiagnostics getBindDiagnostics() {
        if (this.implementsDB2Diagnosable_) {
            return ((DB2Diagnosable)((Object)this.exceptionContainer_)).getBindDiagnostics();
        }
        return null;
    }

    @Override
    public DB2Sqlca getSqlca() {
        if (this.implementsDB2Diagnosable_) {
            return ((DB2Diagnosable)((Object)this.exceptionContainer_)).getSqlca();
        }
        return null;
    }

    @Override
    public Throwable getThrowable() {
        if (this.implementsDB2Diagnosable_) {
            return ((DB2Diagnosable)((Object)this.exceptionContainer_)).getThrowable();
        }
        return null;
    }

    @Override
    public void printTrace(PrintWriter printWriter, String string) {
        if (this.implementsDB2Diagnosable_) {
            ((DB2Diagnosable)((Object)this.exceptionContainer_)).printTrace(printWriter, string);
        }
    }

    public int getBatchElementOffset() {
        return this.batchElementOffset_;
    }

    public int getStmtOffset() {
        return this.stmtOffset_;
    }

    private String notInitializedMsg() {
        return Messages.getText("ERR_HETEROBATCH_WRAP", "pureQuery Runtime");
    }

    private void parseBatchElementStmtOffset() {
        String string = this.exceptionContainer_.getMessage();
        if (string.startsWith(batchElementHeader_) && Character.isDigit(string.charAt(batchElementHeader_.length()))) {
            string = string.substring(batchElementHeader_.length());
            String[] stringArray = null;
            try {
                stringArray = string.split("[#:\\s]", 8);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                System.out.println(patternSyntaxException.toString());
                patternSyntaxException.printStackTrace();
            }
            if (stringArray != null && stringArray.length > 1) {
                try {
                    this.batchElementOffset_ = Integer.parseInt(stringArray[0]) - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    this.batchElementOffset_ = -1;
                    this.stmtOffset_ = -1;
                    stringArray = null;
                }
                if (stringArray != null && stringArray.length > 6 && Character.isDigit(stringArray[6].charAt(0))) {
                    try {
                        this.stmtOffset_ = Integer.parseInt(stringArray[6]) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                        this.stmtOffset_ = 0;
                    }
                } else {
                    this.stmtOffset_ = 0;
                }
            } else {
                this.batchElementOffset_ = -1;
                this.stmtOffset_ = -1;
            }
        } else {
            this.batchElementOffset_ = -1;
            this.stmtOffset_ = -1;
        }
    }

    @Override
    public int getErrorCode() {
        if (!this.initialized_) {
            return super.getErrorCode();
        }
        if (this.validContainer_) {
            return this.exceptionContainer_.getErrorCode();
        }
        throw new DataRuntimeException(this.notInitializedMsg(), null, 11731, "3.3306.7");
    }

    @Override
    public String getSQLState() {
        if (!this.initialized_) {
            return super.getSQLState();
        }
        if (this.validContainer_) {
            return this.exceptionContainer_.getSQLState();
        }
        throw new DataRuntimeException(this.notInitializedMsg(), null, 11732, "3.3306.7");
    }

    @Override
    public Throwable fillInStackTrace() {
        if (!this.initialized_) {
            return super.fillInStackTrace();
        }
        if (this.validContainer_) {
            return this.exceptionContainer_.fillInStackTrace();
        }
        throw new DataRuntimeException(this.notInitializedMsg(), null, 11733, "3.3306.7");
    }

    @Override
    public Throwable getCause() {
        if (!this.initialized_) {
            return super.getCause();
        }
        if (this.validContainer_) {
            return this.exceptionContainer_.getCause();
        }
        throw new DataRuntimeException(this.notInitializedMsg(), null, 11734, "3.3306.7");
    }

    @Override
    public String getLocalizedMessage() {
        if (!this.initialized_) {
            return super.getLocalizedMessage();
        }
        if (this.validContainer_) {
            return this.exceptionContainer_.getLocalizedMessage();
        }
        throw new DataRuntimeException(this.notInitializedMsg(), null, 11735, "3.3306.7");
    }

    @Override
    public String getMessage() {
        if (!this.initialized_) {
            return super.getMessage();
        }
        if (this.validContainer_) {
            return this.exceptionContainer_.getMessage();
        }
        throw new DataRuntimeException(this.notInitializedMsg(), null, 11736, "3.3306.7");
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        if (!this.initialized_) {
            return super.getStackTrace();
        }
        if (this.validContainer_) {
            return this.exceptionContainer_.getStackTrace();
        }
        throw new DataRuntimeException(this.notInitializedMsg(), null, 11737, "3.3306.7");
    }

    @Override
    public synchronized Throwable initCause(Throwable throwable) {
        if (!this.initialized_) {
            return super.initCause(throwable);
        }
        if (this.validContainer_) {
            return this.exceptionContainer_.initCause(throwable);
        }
        throw new DataRuntimeException(this.notInitializedMsg(), null, 11738, "3.3306.7");
    }

    @Override
    public void printStackTrace() {
        if (!this.initialized_) {
            super.printStackTrace();
            return;
        }
        if (!this.validContainer_) {
            throw new DataRuntimeException(this.notInitializedMsg(), null, 11739, "3.3306.7");
        }
        this.exceptionContainer_.printStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        if (!this.initialized_) {
            super.printStackTrace(printStream);
            return;
        }
        if (!this.validContainer_) {
            throw new DataRuntimeException(this.notInitializedMsg(), null, 11740, "3.3306.7");
        }
        this.exceptionContainer_.printStackTrace(printStream);
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (!this.initialized_) {
            super.printStackTrace(printWriter);
            return;
        }
        if (!this.validContainer_) {
            throw new DataRuntimeException(this.notInitializedMsg(), null, 11741, "3.3306.7");
        }
        this.exceptionContainer_.printStackTrace(printWriter);
    }

    @Override
    public void setStackTrace(StackTraceElement[] stackTraceElementArray) {
        if (!this.initialized_) {
            super.setStackTrace(stackTraceElementArray);
            return;
        }
        if (!this.validContainer_) {
            throw new DataRuntimeException(this.notInitializedMsg(), null, 11742, "3.3306.7");
        }
        this.exceptionContainer_.setStackTrace(stackTraceElementArray);
    }

    @Override
    public String toString() {
        if (!this.initialized_) {
            return super.toString();
        }
        if (!this.validContainer_) {
            throw new DataRuntimeException(this.notInitializedMsg(), null, 11743, "3.3306.7");
        }
        StringBuilder stringBuilder = new StringBuilder("HeteroBatchSQLException, ");
        if (this.isRowSpecificSQLException()) {
            if (this.stmtOffset_ >= 0) {
                stringBuilder.append("stmtOffset: ");
                stringBuilder.append(this.stmtOffset_);
                stringBuilder.append(", ");
            }
            stringBuilder.append("batchElementOffset: ");
            stringBuilder.append(this.batchElementOffset_);
            stringBuilder.append(", ");
        } else {
            stringBuilder.append("Non-row specific exception, ");
        }
        if (this.implementsDB2Diagnosable_) {
            stringBuilder.append("DB2Diagnosable {DB2Sqlca: ");
            DB2Sqlca dB2Sqlca = this.getSqlca();
            if (dB2Sqlca != null) {
                stringBuilder.append('{');
                stringBuilder.append("SQLCode: ");
                stringBuilder.append(dB2Sqlca.getSqlCode());
                stringBuilder.append(", SQLErrMc: \"");
                stringBuilder.append(dB2Sqlca.getSqlErrmc());
                stringBuilder.append("\", SQLErrP: \"");
                stringBuilder.append(dB2Sqlca.getSqlErrp());
                stringBuilder.append("\", SQLState: \"");
                stringBuilder.append(dB2Sqlca.getSqlState());
                stringBuilder.append("\", SQLWarn: \"");
                stringBuilder.append(dB2Sqlca.getSqlWarn());
                stringBuilder.append("\", SQLErrD: ");
                stringBuilder.append(Arrays.toString(dB2Sqlca.getSqlErrd()));
                stringBuilder.append(", SQLErrmcTokens: ");
                stringBuilder.append(Arrays.toString(dB2Sqlca.getSqlErrmcTokens()));
                stringBuilder.append("}, ");
            } else {
                stringBuilder.append("{null}, ");
            }
            stringBuilder.append(", BindDiagnostics: ");
            stringBuilder.append(this.getBindDiagnostics());
            stringBuilder.append("}, ");
        }
        stringBuilder.append("original Offset in SQLException chain: ");
        stringBuilder.append(this.originalOffsetInChain_);
        stringBuilder.append(", ");
        stringBuilder.append("Actual Exception: ");
        stringBuilder.append(this.exceptionContainer_.toString());
        return stringBuilder.toString();
    }
}

