/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.util.List;
import java.util.Objects;
import org.firebirdsql.gds.DefaultMessageTemplate;
import org.firebirdsql.gds.MessageTemplate;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class OverriddenSqlStateMessageTemplate
extends MessageTemplate {
    private final DefaultMessageTemplate parent;
    private final String sqlState;

    OverriddenSqlStateMessageTemplate(DefaultMessageTemplate parent, String sqlState) {
        this.parent = Objects.requireNonNull(parent, "parent");
        this.sqlState = MessageTemplate.validateSqlState(sqlState);
    }

    @Override
    public int errorCode() {
        return this.parent.errorCode();
    }

    @Override
    public String sqlState() {
        return this.sqlState;
    }

    @Override
    public MessageTemplate withDefaultSqlState(String defaultSqlState) {
        return this;
    }

    @Override
    public MessageTemplate withSqlState(String sqlState) {
        if (sqlState.equals(this.sqlState())) {
            return this;
        }
        if (sqlState.equals(this.parent.sqlState())) {
            return this.parent;
        }
        return new OverriddenSqlStateMessageTemplate(this.parent, sqlState);
    }

    public void appendMessage(StringBuilder messageBuffer, List<?> parameters) {
        this.parent.appendMessage(messageBuffer, parameters);
    }
}

