/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBCachedBlob;
import org.firebirdsql.jdbc.FBDriverNotCapableException;

public final class FBCachedClob
implements Clob,
NClob {
    private final FBCachedBlob wrappedBlob;
    private final FBBlob.Config blobConfig;

    public FBCachedClob(FBCachedBlob blob, FBBlob.Config blobConfig) {
        this.wrappedBlob = blob;
        this.blobConfig = blobConfig;
    }

    @Override
    public void free() throws SQLException {
        this.wrappedBlob.free();
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.wrappedBlob.getBinaryStream();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.blobConfig.createReader(this.wrappedBlob.getBinaryStream());
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        return this.blobConfig.createReader(this.wrappedBlob.getBinaryStream(pos, length));
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        throw new FBDriverNotCapableException("Method getSubstring(long, int) is not supported");
    }

    @Override
    public long length() throws SQLException {
        throw new FBDriverNotCapableException("Cannot determine length for CLOB");
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        throw new FBDriverNotCapableException("Method position(String, long) is not supported");
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        throw new FBDriverNotCapableException("Method position(Clob, long) is not supported");
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw FBCachedClob.clobReadOnly();
    }

    private static SQLException clobReadOnly() {
        return new SQLNonTransientException("Clob in auto-commit mode is read-only", "0F000");
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        throw FBCachedClob.clobReadOnly();
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        throw FBCachedClob.clobReadOnly();
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw FBCachedClob.clobReadOnly();
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.wrappedBlob.truncate(len);
    }
}

