/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import java.sql.Connection;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBDocumentType;
import oracle.xdb.dom.XDBNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class XDBDomImplementation
implements DOMImplementation {
    private long xdbgp = 0L;
    private Connection m_conn;

    private native long createDocumentNative(String var1, String var2);

    private native long createDocTypeNative(String var1, String var2, String var3);

    @Override
    public boolean hasFeature(String feature, String version) {
        return true;
    }

    @Override
    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws DOMException {
        XDBNode.validateName(qualifiedName);
        long retVal = this.createDocTypeNative(qualifiedName, publicId, systemId);
        XDBDocumentType dtd = new XDBDocumentType(this.m_conn, null, retVal);
        return dtd;
    }

    @Override
    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        XDBNode.validateName(qualifiedName);
        long retVal = this.createDocumentNative(namespaceURI, qualifiedName);
        return new XDBDocument(this.m_conn, retVal);
    }

    public XDBDomImplementation() {
        this.m_conn = null;
        this.xdbgp = XDBDocument.getGP(this.m_conn);
    }

    public XDBDomImplementation(Connection conn) {
        this.m_conn = conn;
        this.xdbgp = XDBDocument.getGP(conn);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }
}

