/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import org.firebirdsql.management.FBManager;

public class FBCommandLine {
    public static void main(String[] args) throws Exception {
        if (args.length != 6) {
            FBCommandLine.usage();
            return;
        }
        if (!args[2].equals("-user") && !args[2].equals("-u")) {
            FBCommandLine.usage();
            return;
        }
        if (!args[4].equals("-password") && !args[4].equals("-p")) {
            FBCommandLine.usage();
            return;
        }
        String filename = args[1];
        String user = args[3];
        String password = args[5];
        FBManager fbm = new FBManager();
        System.out.println("filename: " + filename + ", user: " + user + ", password: " + password);
        fbm.start();
        if (args[0].equals("-create") || args[0].equals("-c")) {
            fbm.createDatabase(filename, user, password);
            return;
        }
        if (args[0].equals("-drop") || args[0].equals("-d")) {
            fbm.dropDatabase(filename, user, password);
            return;
        }
        FBCommandLine.usage();
    }

    private static void usage() {
        System.out.println("Firebird driver command line db create/drop tool");
        System.out.println("This works only on localhost. Use filename rather than jdbc url.");
        System.out.println("create:");
        System.out.println("     -create <filename> -user <user> -password <password>");
        System.out.println("drop:");
        System.out.println("     -drop <filename>");
        System.out.println("flags -create may be abbreviated as -c, etc.");
    }
}

