/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.extern.decimal;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.firebirdsql.extern.decimal.Decimal;
import org.firebirdsql.extern.decimal.DecimalCodec;
import org.firebirdsql.extern.decimal.DecimalFactory;
import org.firebirdsql.extern.decimal.DecimalFormat;
import org.firebirdsql.extern.decimal.DecimalType;
import org.firebirdsql.extern.decimal.OverflowHandling;

public final class Decimal64
extends Decimal<Decimal64> {
    public static final Decimal64 POSITIVE_INFINITY = new Decimal64(1, DecimalType.INFINITY);
    public static final Decimal64 NEGATIVE_INFINITY = new Decimal64(-1, DecimalType.INFINITY);
    public static final Decimal64 POSITIVE_NAN = new Decimal64(1, DecimalType.NAN);
    public static final Decimal64 NEGATIVE_NAN = new Decimal64(-1, DecimalType.NAN);
    public static final Decimal64 POSITIVE_SIGNALING_NAN = new Decimal64(1, DecimalType.SIGNALING_NAN);
    public static final Decimal64 NEGATIVE_SIGNALING_NAN = new Decimal64(-1, DecimalType.SIGNALING_NAN);
    private static final Decimal64Factory DECIMAL_64_FACTORY = new Decimal64Factory();
    private static final DecimalCodec<Decimal64> DECIMAL_64_CODEC = new DecimalCodec<Decimal64>(DECIMAL_64_FACTORY);

    private Decimal64(int signum, DecimalType decimalType) {
        super(signum, decimalType);
    }

    private Decimal64(int signum, BigDecimal bigDecimal) {
        super(signum, bigDecimal);
    }

    @Override
    DecimalCodec<Decimal64> getDecimalCodec() {
        return DECIMAL_64_CODEC;
    }

    @Override
    DecimalFactory<Decimal64> getDecimalFactory() {
        return DECIMAL_64_FACTORY;
    }

    public static Decimal64 parseBytes(byte[] decBytes) {
        return DECIMAL_64_CODEC.parseBytes(decBytes);
    }

    public static Decimal64 valueOf(BigDecimal value) {
        return Decimal64.valueOf(value, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal64 valueOf(BigDecimal value, OverflowHandling overflowHandling) {
        return (Decimal64)DECIMAL_64_FACTORY.valueOf(value, overflowHandling);
    }

    public static Decimal64 valueOf(BigInteger value) {
        return Decimal64.valueOf(value, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal64 valueOf(BigInteger value, OverflowHandling overflowHandling) {
        return (Decimal64)DECIMAL_64_FACTORY.valueOf(value, overflowHandling);
    }

    public static Decimal64 valueOfExact(BigInteger value) {
        return (Decimal64)DECIMAL_64_FACTORY.valueOfExact(value);
    }

    public static Decimal64 valueOf(double value) {
        return Decimal64.valueOf(value, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal64 valueOf(double value, OverflowHandling overflowHandling) {
        return (Decimal64)DECIMAL_64_FACTORY.valueOf(value, overflowHandling);
    }

    public static Decimal64 valueOf(Decimal<?> decimal) {
        return Decimal64.valueOf(decimal, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal64 valueOf(Decimal<?> decimal, OverflowHandling overflowHandling) {
        if (decimal instanceof Decimal64) {
            return (Decimal64)decimal;
        }
        return (Decimal64)DECIMAL_64_FACTORY.valueOf(decimal, overflowHandling);
    }

    public static Decimal64 valueOf(String value) {
        return Decimal64.valueOf(value, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal64 valueOf(String value, OverflowHandling overflowHandling) {
        return (Decimal64)DECIMAL_64_FACTORY.valueOf(value, overflowHandling);
    }

    private static class Decimal64Factory
    extends Decimal.AbstractDecimalFactory<Decimal64> {
        private Decimal64Factory() {
            super(Decimal64.class, DecimalFormat.Decimal64, POSITIVE_INFINITY, NEGATIVE_INFINITY, POSITIVE_NAN, NEGATIVE_NAN, POSITIVE_SIGNALING_NAN, NEGATIVE_SIGNALING_NAN);
        }

        @Override
        public Decimal64 createDecimal(int signum, BigDecimal value) {
            return new Decimal64(signum, this.validateRange(value));
        }
    }
}

