/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.builtins.JSGlobalObject;
import com.oracle.truffle.js.runtime.builtins.JSProxyObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;

abstract class HasRestrictedGlobalPropertyNode
extends JavaScriptBaseNode {
    protected HasRestrictedGlobalPropertyNode() {
    }

    public abstract boolean execute(JSDynamicObject var1, Object var2);

    @Specialization(guards={"cachedShape == thisObj.getShape()"}, assumptions={"cachedShape.getValidAssumption()"}, limit="3")
    static boolean doGlobalObjectCached(JSGlobalObject thisObj, Object propertyKey, @Cached(value="thisObj.getShape()") Shape cachedShape, @Cached(value="cachedShape.getProperty(propertyKey)") Property cachedProperty) {
        CompilerAsserts.partialEvaluationConstant((Object)propertyKey);
        return cachedProperty != null && !JSProperty.isConfigurable(cachedProperty.getFlags());
    }

    @Specialization(replaces={"doGlobalObjectCached"})
    static boolean doGlobalObjectUncached(JSGlobalObject thisObj, Object propertyKey) {
        CompilerAsserts.partialEvaluationConstant((Object)propertyKey);
        Property property = thisObj.getShape().getProperty(propertyKey);
        return property != null && !JSProperty.isConfigurable(property.getFlags());
    }

    @Specialization
    static boolean doProxy(JSProxyObject thisObj, Object propertyKey) {
        CompilerAsserts.partialEvaluationConstant((Object)propertyKey);
        PropertyDescriptor desc = JSObject.getOwnProperty(thisObj, propertyKey);
        return desc != null && !desc.getConfigurable();
    }
}

