/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum OSErrorEnum {
    EPERM(1, PythonUtils.tsLiteral("Operation not permitted")),
    ENOENT(2, PythonUtils.tsLiteral("No such file or directory")),
    ESRCH(3, PythonUtils.tsLiteral("No such process")),
    EINTR(4, PythonUtils.tsLiteral("Interrupted system call")),
    EIO(5, PythonUtils.tsLiteral("I/O error")),
    ENXIO(6, PythonUtils.tsLiteral("No such device or address")),
    E2BIG(7, PythonUtils.tsLiteral("Argument list too long")),
    ENOEXEC(8, PythonUtils.tsLiteral("Exec format error")),
    EBADF(9, PythonUtils.tsLiteral("Bad file number")),
    ECHILD(10, PythonUtils.tsLiteral("No child processes")),
    EWOULDBLOCK(OSErrorEnum.platformSpecific(11, 35), PythonUtils.tsLiteral("Operation would block")),
    EAGAIN(OSErrorEnum.platformSpecific(11, 35), PythonUtils.tsLiteral("Try again")),
    ENOMEM(12, PythonUtils.tsLiteral("Out of memory")),
    EACCES(13, PythonUtils.tsLiteral("Permission denied")),
    EFAULT(14, PythonUtils.tsLiteral("Bad address")),
    ENOTBLK(15, PythonUtils.tsLiteral("Block device required")),
    EBUSY(16, PythonUtils.tsLiteral("Device or resource busy")),
    EEXIST(17, PythonUtils.tsLiteral("File exists")),
    EXDEV(18, PythonUtils.tsLiteral("Cross-device link")),
    ENODEV(19, PythonUtils.tsLiteral("No such device")),
    ENOTDIR(20, PythonUtils.tsLiteral("Not a directory")),
    EISDIR(21, PythonUtils.tsLiteral("Is a directory")),
    EINVAL(22, PythonUtils.tsLiteral("Invalid argument")),
    ENFILE(23, PythonUtils.tsLiteral("File table overflow")),
    EMFILE(24, PythonUtils.tsLiteral("Too many open files")),
    ENOTTY(25, PythonUtils.tsLiteral("Not a typewriter")),
    ETXTBSY(26, PythonUtils.tsLiteral("Text file busy")),
    EFBIG(27, PythonUtils.tsLiteral("File too large")),
    ENOSPC(28, PythonUtils.tsLiteral("No space left on device")),
    ESPIPE(29, PythonUtils.tsLiteral("Illegal seek")),
    EROFS(30, PythonUtils.tsLiteral("Read-only file system")),
    EMLINK(31, PythonUtils.tsLiteral("Too many links")),
    EPIPE(32, PythonUtils.tsLiteral("Broken pipe")),
    EDOM(33, PythonUtils.tsLiteral("Math argument out of domain of func")),
    ERANGE(34, PythonUtils.tsLiteral("Math result not representable")),
    EDEADLOCK(OSErrorEnum.platformSpecific(35, 11)),
    EDEADLK(OSErrorEnum.platformSpecific(35, 11), PythonUtils.tsLiteral("Resource deadlock would occur")),
    ENAMETOOLONG(OSErrorEnum.platformSpecific(36, 63), PythonUtils.tsLiteral("File name too long")),
    ENOLCK(OSErrorEnum.platformSpecific(37, 77), PythonUtils.tsLiteral("No record locks available")),
    ENOSYS(OSErrorEnum.platformSpecific(38, 78), PythonUtils.tsLiteral("Invalid system call number")),
    ENOTEMPTY(OSErrorEnum.platformSpecific(39, 66), PythonUtils.tsLiteral("Directory not empty")),
    ELOOP(OSErrorEnum.platformSpecific(40, 62), PythonUtils.tsLiteral("Too many symbolic links encountered"), PythonUtils.tsLiteral("Too many levels of symbolic links")),
    ENOMSG(OSErrorEnum.platformSpecific(42, 91), PythonUtils.tsLiteral("No message of desired type")),
    EIDRM(OSErrorEnum.platformSpecific(43, 90), PythonUtils.tsLiteral("Identifier removed")),
    ECHRNG(44, PythonUtils.tsLiteral("Channel number out of range")),
    EL2NSYNC(45, PythonUtils.tsLiteral("Level 2 not synchronized")),
    EL3HLT(46, PythonUtils.tsLiteral("Level 3 halted")),
    EL3RST(47, PythonUtils.tsLiteral("Level 3 reset")),
    ELNRNG(48, PythonUtils.tsLiteral("Link number out of range")),
    EUNATCH(49, PythonUtils.tsLiteral("Protocol driver not attached")),
    ENOCSI(50, PythonUtils.tsLiteral("No CSI structure available")),
    EL2HLT(51, PythonUtils.tsLiteral("Level 2 halted")),
    EBADE(52, PythonUtils.tsLiteral("Invalid exchange")),
    EBADR(OSErrorEnum.platformSpecific(53, -1), PythonUtils.tsLiteral("Invalid request descriptor")),
    EXFULL(OSErrorEnum.platformSpecific(54, -1), PythonUtils.tsLiteral("Exchange full")),
    ENOANO(55, PythonUtils.tsLiteral("No anode")),
    EBADRQC(56, PythonUtils.tsLiteral("Invalid request code")),
    EBADSLT(57, PythonUtils.tsLiteral("Invalid slot")),
    EBFONT(59, PythonUtils.tsLiteral("Bad font file format")),
    ENOSTR(OSErrorEnum.platformSpecific(60, 99), PythonUtils.tsLiteral("Device not a stream")),
    ENODATA(OSErrorEnum.platformSpecific(61, 96), PythonUtils.tsLiteral("No data available")),
    ETIME(OSErrorEnum.platformSpecific(62, 101), PythonUtils.tsLiteral("Timer expired")),
    ENOSR(OSErrorEnum.platformSpecific(63, 98), PythonUtils.tsLiteral("Out of streams resources")),
    ENONET(64, PythonUtils.tsLiteral("Machine is not on the network")),
    ENOPKG(65, PythonUtils.tsLiteral("Package not installed")),
    EREMOTE(OSErrorEnum.platformSpecific(66, 71), PythonUtils.tsLiteral("Object is remote")),
    ENOLINK(OSErrorEnum.platformSpecific(67, 97), PythonUtils.tsLiteral("Link has been severed")),
    EADV(68, PythonUtils.tsLiteral("Advertise error")),
    ESRMNT(69, PythonUtils.tsLiteral("Srmount error")),
    ECOMM(70, PythonUtils.tsLiteral("Communication error on send")),
    EPROTO(OSErrorEnum.platformSpecific(71, 100), PythonUtils.tsLiteral("Protocol error")),
    EMULTIHOP(OSErrorEnum.platformSpecific(72, 95), PythonUtils.tsLiteral("Multihop attempted")),
    EDOTDOT(73, PythonUtils.tsLiteral("RFS specific error")),
    EBADMSG(OSErrorEnum.platformSpecific(74, 94), PythonUtils.tsLiteral("Not a data message")),
    EOVERFLOW(OSErrorEnum.platformSpecific(75, 84), PythonUtils.tsLiteral("Value too large for defined data type")),
    ENOTUNIQ(76, PythonUtils.tsLiteral("Name not unique on network")),
    EBADFD(77, PythonUtils.tsLiteral("File descriptor in bad state")),
    EREMCHG(78, PythonUtils.tsLiteral("Remote address changed")),
    ELIBACC(79, PythonUtils.tsLiteral("Can not access a needed shared library")),
    ELIBBAD(80, PythonUtils.tsLiteral("Accessing a corrupted shared library")),
    ELIBSCN(81, PythonUtils.tsLiteral(".lib section in a.out corrupted")),
    ELIBMAX(82, PythonUtils.tsLiteral("Attempting to link in too many shared libraries")),
    ELIBEXEC(83, PythonUtils.tsLiteral("Cannot exec a shared library directly")),
    EILSEQ(OSErrorEnum.platformSpecific(84, 92), PythonUtils.tsLiteral("Illegal byte sequence")),
    ERESTART(85, PythonUtils.tsLiteral("Interrupted system call should be restarted")),
    ESTRPIPE(86, PythonUtils.tsLiteral("Streams pipe error")),
    EUSERS(OSErrorEnum.platformSpecific(87, 68), PythonUtils.tsLiteral("Too many users")),
    ENOTSOCK(OSErrorEnum.platformSpecific(88, 38), PythonUtils.tsLiteral("Socket operation on non-socket")),
    EDESTADDRREQ(OSErrorEnum.platformSpecific(89, 39), PythonUtils.tsLiteral("Destination address required")),
    EMSGSIZE(OSErrorEnum.platformSpecific(90, 40), PythonUtils.tsLiteral("Message too long")),
    EPROTOTYPE(OSErrorEnum.platformSpecific(91, 41), PythonUtils.tsLiteral("Protocol wrong type for socket")),
    ENOPROTOOPT(OSErrorEnum.platformSpecific(92, 42), PythonUtils.tsLiteral("Protocol not available")),
    EPROTONOSUPPORT(OSErrorEnum.platformSpecific(93, 43), PythonUtils.tsLiteral("Protocol not supported")),
    ESOCKTNOSUPPORT(OSErrorEnum.platformSpecific(94, 44), PythonUtils.tsLiteral("Socket type not supported")),
    EOPNOTSUPP(OSErrorEnum.platformSpecific(95, 102), PythonUtils.tsLiteral("Operation not supported on transport endpoint")),
    EPFNOSUPPORT(OSErrorEnum.platformSpecific(96, 46), PythonUtils.tsLiteral("Protocol family not supported")),
    EAFNOSUPPORT(OSErrorEnum.platformSpecific(97, 47), PythonUtils.tsLiteral("Address family not supported by protocol")),
    EADDRINUSE(OSErrorEnum.platformSpecific(98, 48), PythonUtils.tsLiteral("Address already in use")),
    EADDRNOTAVAIL(OSErrorEnum.platformSpecific(99, 49), PythonUtils.tsLiteral("Cannot assign requested address")),
    ENETDOWN(OSErrorEnum.platformSpecific(100, 50), PythonUtils.tsLiteral("Network is down")),
    ENETUNREACH(OSErrorEnum.platformSpecific(101, 51), PythonUtils.tsLiteral("Network is unreachable")),
    ENETRESET(OSErrorEnum.platformSpecific(102, 52), PythonUtils.tsLiteral("Network dropped connection because of reset")),
    ECONNABORTED(OSErrorEnum.platformSpecific(103, 53), PythonUtils.tsLiteral("Software caused connection abort")),
    ECONNRESET(OSErrorEnum.platformSpecific(104, 54), PythonUtils.tsLiteral("Connection reset by peer")),
    ENOBUFS(OSErrorEnum.platformSpecific(105, 55), PythonUtils.tsLiteral("No buffer space available")),
    EISCONN(OSErrorEnum.platformSpecific(106, 56), PythonUtils.tsLiteral("Transport endpoint is already connected")),
    ENOTCONN(OSErrorEnum.platformSpecific(107, 57), PythonUtils.tsLiteral("Transport endpoint is not connected")),
    ESHUTDOWN(OSErrorEnum.platformSpecific(108, 58), PythonUtils.tsLiteral("Cannot send after transport endpoint shutdown")),
    ETOOMANYREFS(OSErrorEnum.platformSpecific(109, 59), PythonUtils.tsLiteral("Too many references: cannot splice")),
    ETIMEDOUT(OSErrorEnum.platformSpecific(110, 60), PythonUtils.tsLiteral("Connection timed out")),
    ECONNREFUSED(OSErrorEnum.platformSpecific(111, 61), PythonUtils.tsLiteral("Connection refused")),
    EHOSTDOWN(OSErrorEnum.platformSpecific(112, 64), PythonUtils.tsLiteral("Host is down")),
    EHOSTUNREACH(OSErrorEnum.platformSpecific(113, 65), PythonUtils.tsLiteral("No route to host")),
    EALREADY(OSErrorEnum.platformSpecific(114, 37), PythonUtils.tsLiteral("Operation already in progress")),
    EINPROGRESS(OSErrorEnum.platformSpecific(115, 36), PythonUtils.tsLiteral("Operation now in progress")),
    ESTALE(OSErrorEnum.platformSpecific(116, 70), PythonUtils.tsLiteral("Stale file handle")),
    EUCLEAN(117, PythonUtils.tsLiteral("Structure needs cleaning")),
    ENOTNAM(118, PythonUtils.tsLiteral("Not a XENIX named type file")),
    ENAVAIL(119, PythonUtils.tsLiteral("No XENIX semaphores available")),
    EISNAM(120, PythonUtils.tsLiteral("Is a named type file")),
    EREMOTEIO(121, PythonUtils.tsLiteral("Remote I/O error")),
    EDQUOT(OSErrorEnum.platformSpecific(122, 69), PythonUtils.tsLiteral("Quota exceeded")),
    ENOMEDIUM(123, PythonUtils.tsLiteral("No medium found")),
    EMEDIUMTYPE(124, PythonUtils.tsLiteral("Wrong medium type")),
    ECANCELED(OSErrorEnum.platformSpecific(125, 89), PythonUtils.tsLiteral("Operation Canceled")),
    ENOKEY(126, PythonUtils.tsLiteral("Required key not available")),
    EKEYEXPIRED(127, PythonUtils.tsLiteral("Key has expired")),
    EKEYREVOKED(128, PythonUtils.tsLiteral("Key has been revoked")),
    EKEYREJECTED(129, PythonUtils.tsLiteral("Key was rejected by service")),
    EOWNERDEAD(OSErrorEnum.platformSpecific(130, 105), PythonUtils.tsLiteral("Owner died")),
    ENOTRECOVERABLE(OSErrorEnum.platformSpecific(131, 104), PythonUtils.tsLiteral("State not recoverable")),
    ERFKILL(132, PythonUtils.tsLiteral("Operation not possible due to RF-kill")),
    EHWPOISON(133, PythonUtils.tsLiteral("Memory page has hardware error"));

    private final TruffleString message;
    private final TruffleString[] alternativeMessages;
    private final int number;
    private static final Pattern ERRNO_PATTERN;

    private OSErrorEnum(int number, TruffleString message, TruffleString ... alternativeMessages) {
        this.number = number;
        this.message = message != null ? message : null;
        this.alternativeMessages = new TruffleString[alternativeMessages.length];
        for (int i = 0; i < alternativeMessages.length; ++i) {
            this.alternativeMessages[i] = alternativeMessages[i];
        }
    }

    private OSErrorEnum(int number, TruffleString message) {
        this(number, message, PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
    }

    private OSErrorEnum(int number) {
        this(number, null);
    }

    public TruffleString getMessage() {
        return this.message;
    }

    public int getNumber() {
        return this.number;
    }

    @CompilerDirectives.TruffleBoundary
    private static OSErrorEnum fromMessage(TruffleString message, TruffleString.EqualNode eqNode) {
        if (message == null) {
            return null;
        }
        for (OSErrorEnum oserror : OSErrorEnum.values()) {
            if (oserror.getMessage() == null) continue;
            if (eqNode.execute((AbstractTruffleString)message, (AbstractTruffleString)oserror.getMessage(), PythonUtils.TS_ENCODING)) {
                return oserror;
            }
            for (TruffleString altMessage : oserror.alternativeMessages) {
                if (altMessage == null || !eqNode.execute((AbstractTruffleString)message, (AbstractTruffleString)altMessage, PythonUtils.TS_ENCODING)) continue;
                return oserror;
            }
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static OSErrorEnum fromNumber(int number) {
        OSErrorEnum[] values = OSErrorEnum.values();
        for (int i = 0; i < values.length; ++i) {
            if (values[i].getNumber() != number) continue;
            return values[i];
        }
        return null;
    }

    public static ErrorAndMessagePair fromException(Exception e, TruffleString.EqualNode eqNode) {
        if (e instanceof IOException) {
            if (e instanceof NoSuchFileException || e instanceof FileNotFoundException) {
                return new ErrorAndMessagePair(ENOENT, ENOENT.getMessage());
            }
            if (e instanceof AccessDeniedException) {
                return new ErrorAndMessagePair(EACCES, EACCES.getMessage());
            }
            if (e instanceof FileAlreadyExistsException) {
                return new ErrorAndMessagePair(EEXIST, EEXIST.getMessage());
            }
            if (e instanceof NotDirectoryException) {
                return new ErrorAndMessagePair(ENOTDIR, ENOTDIR.getMessage());
            }
            if (e instanceof DirectoryNotEmptyException) {
                return new ErrorAndMessagePair(ENOTEMPTY, ENOTEMPTY.getMessage());
            }
            if (e instanceof FileSystemLoopException) {
                return new ErrorAndMessagePair(ELOOP, ELOOP.getMessage());
            }
            if (e instanceof NotLinkException) {
                return new ErrorAndMessagePair(EINVAL, EINVAL.getMessage());
            }
            if (e instanceof ClosedChannelException) {
                return new ErrorAndMessagePair(EPIPE, EPIPE.getMessage());
            }
            if (e instanceof FileSystemException) {
                TruffleString reason = OSErrorEnum.getReason((FileSystemException)e);
                OSErrorEnum oserror = OSErrorEnum.fromMessage(reason, eqNode);
                if (oserror == null) {
                    return new ErrorAndMessagePair(EIO, reason);
                }
                return new ErrorAndMessagePair(oserror, oserror.getMessage());
            }
            OSErrorEnum oserror = OSErrorEnum.tryFindErrnoFromMessage(e, eqNode);
            if (oserror == null) {
                return new ErrorAndMessagePair(EIO, OSErrorEnum.getMessage(e));
            }
            return new ErrorAndMessagePair(oserror, oserror.getMessage());
        }
        if (e instanceof SecurityException) {
            return new ErrorAndMessagePair(EPERM, EPERM.getMessage());
        }
        if (e instanceof IllegalArgumentException) {
            return new ErrorAndMessagePair(EINVAL, EINVAL.getMessage());
        }
        if (e instanceof UnsupportedOperationException) {
            return new ErrorAndMessagePair(EOPNOTSUPP, EOPNOTSUPP.getMessage());
        }
        if (e instanceof NonReadableChannelException || e instanceof NonWritableChannelException) {
            return new ErrorAndMessagePair(EBADF, EBADF.getMessage());
        }
        if (e instanceof OperationWouldBlockException) {
            return new ErrorAndMessagePair(EWOULDBLOCK, EWOULDBLOCK.getMessage());
        }
        if (e instanceof NotYetConnectedException) {
            return new ErrorAndMessagePair(ENOTCONN, ENOTCONN.getMessage());
        }
        if (e instanceof AlreadyConnectedException) {
            return new ErrorAndMessagePair(EISCONN, EISCONN.getMessage());
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw OSErrorEnum.toRuntimeException(e);
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString getMessage(Exception e) {
        return PythonUtils.toTruffleStringUncached(e.getMessage());
    }

    @CompilerDirectives.TruffleBoundary
    private static RuntimeException toRuntimeException(Exception e) {
        return new RuntimeException(e.getMessage(), e);
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString getReason(FileSystemException e) {
        return PythonUtils.toTruffleStringUncached(e.getReason());
    }

    @CompilerDirectives.TruffleBoundary
    private static OSErrorEnum tryFindErrnoFromMessage(Exception e, TruffleString.EqualNode eqNode) {
        String message = e.getMessage();
        Matcher m = ERRNO_PATTERN.matcher(message);
        if (m.find()) {
            return OSErrorEnum.fromNumber(Integer.parseInt(m.group(1)));
        }
        return OSErrorEnum.fromMessage(PythonUtils.toTruffleStringUncached(message), eqNode);
    }

    private static int platformSpecific(int linuxValue, int darwinValue) {
        return PythonOS.getPythonOS() == PythonOS.PLATFORM_DARWIN ? darwinValue : linuxValue;
    }

    static {
        ERRNO_PATTERN = Pattern.compile("error=(\\d+)");
    }

    @CompilerDirectives.ValueType
    public static final class ErrorAndMessagePair {
        public final OSErrorEnum oserror;
        public final TruffleString message;

        public ErrorAndMessagePair(OSErrorEnum oserror, TruffleString message) {
            this.oserror = oserror;
            this.message = message;
        }
    }

    public static class OperationWouldBlockException
    extends IllegalStateException {
        private static final long serialVersionUID = -6947337041526311362L;
    }
}

