/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxResultSetMetaData;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDatabaseMetaData;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.lang.IfxTypes;
import com.informix.lang.Interval;
import com.informix.util.IfxErrMsg;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxResultSetMetaData
implements IfmxResultSetMetaData {
    Vector<IfxColumnInfo> cinfoVector = new Vector();
    protected boolean hasVariableLengthColumns;
    protected boolean hasVariableLengthCharColumns = false;
    short textByteColumnCount;
    private short tupleSize;
    private int numberofcol;
    protected boolean delimIdent = false;
    protected final IfxConnection conn;
    protected int serialidx;
    protected int rowidx;
    String routineDbName;
    int namedFlags;
    int numArgsRoutine;
    int fpHandle;
    private boolean uppercaseMetaData = false;
    private final Map<Integer, Integer> columnTypeMap = new HashMap<Integer, Integer>();
    private static final String EMPTY_STRING = "";

    public IfxResultSetMetaData(int numcol, IfxConnection thisconn) {
        this.setColumnCount(numcol);
        this.textByteColumnCount = 0;
        this.conn = thisconn;
        this.numArgsRoutine = -1;
        this.routineDbName = null;
        this.fpHandle = -1;
    }

    IfxResultSetMetaData(IfxResultSetMetaData rsmd) throws SQLException {
        this.numberofcol = rsmd.numberofcol;
        if (this.numberofcol > 0) {
            this.cinfoVector.setSize(this.numberofcol);
        } else {
            this.cinfoVector.setSize(20);
        }
        for (int i = 0; i < this.numberofcol; ++i) {
            this.cinfoVector.setElementAt((IfxColumnInfo)rsmd.getColumnInfo(i + 1).clone(), i);
        }
        this.hasVariableLengthColumns = rsmd.hasVariableLengthColumns;
        this.textByteColumnCount = rsmd.textByteColumnCount;
        this.delimIdent = rsmd.delimIdent;
        this.conn = rsmd.conn;
        this.numArgsRoutine = rsmd.numArgsRoutine;
        this.routineDbName = rsmd.routineDbName;
        this.fpHandle = rsmd.fpHandle;
    }

    IfxResultSetMetaData(IfxConnection thisconn, Vector<IfxColumnInfo> thisCinfoVector) throws SQLException {
        this.conn = thisconn;
        this.delimIdent = thisconn.isDelimIdentSet();
        this.cinfoVector = thisCinfoVector;
        this.numberofcol = thisCinfoVector.size();
        for (int i = 1; i <= this.numberofcol; ++i) {
            if (!this.isVariableLengthType(i)) continue;
            this.hasVariableLengthColumns = true;
            break;
        }
        this.setTextByteColumnCount();
    }

    public Vector<IfxColumnInfo> getColumnInfoVector() {
        return this.cinfoVector;
    }

    @Override
    public int getColumnCount() {
        return this.numberofcol;
    }

    IfxColumnInfo getColumnInfo(int column) throws SQLException {
        if (column < 1 || column > this.numberofcol) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        return this.cinfoVector.elementAt(column - 1);
    }

    private IfxColumnInfo getColumnInfo(int column, boolean add) throws SQLException {
        if (add && column > this.numberofcol) {
            if (column > this.cinfoVector.size()) {
                this.cinfoVector.setSize(column + 20);
            }
            for (int i = 0; i < column - this.numberofcol; ++i) {
                this.cinfoVector.setElementAt(new IfxColumnInfo(), this.numberofcol + i);
            }
            this.numberofcol = column;
        }
        return this.getColumnInfo(column);
    }

    public int getColumnLength(int column) throws SQLException {
        return this.getColumnInfo(column).getAdjustedColumnLength();
    }

    @Override
    public int getColumnStartPosition(int column) throws SQLException {
        return this.getColumnInfo((int)column).ColStartPos;
    }

    @Override
    public int getColumnExtendedId(int column) throws SQLException {
        return this.getColumnInfo((int)column).ExtendedId;
    }

    @Override
    public String getExtendedName(int column) throws SQLException {
        return this.processValueCase(this.getColumnInfo((int)column).ExtendedName);
    }

    @Override
    public String getExtendedOwnerName(int column) throws SQLException {
        return this.processValueCase(this.getColumnInfo((int)column).ExtendedOwner);
    }

    @Override
    public short getReference(int column) throws SQLException {
        return this.getColumnInfo((int)column).Reference;
    }

    @Override
    public int getAlignment(int column) throws SQLException {
        return this.getColumnInfo((int)column).Alignment;
    }

    @Override
    public int getSourceType(int column) throws SQLException {
        return this.getColumnInfo((int)column).SourceType;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.SQLtype == 6 || cinfo.SQLtype == 18;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.delimIdent;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.getColumnInfo(column).isSearchable();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.getColumnInfo((int)column).SQLtype == 8;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getColumnInfo((int)column).Nullable;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumnInfo(column).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        if (cinfo.ColumnDisplaySize == -1) {
            cinfo.ColumnDisplaySize = IfxDatabaseMetaData.getJDBCColumnSize((short)cinfo.SQLtype, (short)cinfo.ExtendedId, cinfo.ColLength);
        }
        return cinfo.ColumnDisplaySize;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.processValueCase(this.getColumnInfo((int)column).ColName);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.processValueCase(this.getColumnInfo((int)column).ColName);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.getColumnInfo(column);
        return EMPTY_STRING;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumnInfo(column).getDecimalDigits();
    }

    @Override
    public int getEncodedLength(int column) throws SQLException {
        return this.getColumnInfo((int)column).ColLength;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumnInfo((int)column).RightDecimal;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.processValueCase(this.getColumnInfo((int)column).TableName);
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.getColumnInfo(column);
        return EMPTY_STRING;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        if (cinfo.ExtendedName.equals("boolean")) {
            return 16;
        }
        if (cinfo.ExtendedName.equals("lvarchar")) {
            return -1;
        }
        if (cinfo.ExtendedName.equalsIgnoreCase("smartvarchar") || cinfo.ExtendedName.equalsIgnoreCase("longlvarchar")) {
            return -1;
        }
        if (cinfo.IsDistinct) {
            return 2001;
        }
        if (cinfo.ExtendedName.equals("clob")) {
            return 2005;
        }
        if (cinfo.ExtendedName.equals("blob")) {
            return 2004;
        }
        if (cinfo.SQLtype == 10) {
            byte tu_start = IfxDateTime.getStartCode((short)cinfo.ColLength);
            if (tu_start >= 6) {
                return 92;
            }
            return 93;
        }
        if (cinfo.SQLtype == 4 && !this.conn.getMapReal()) {
            return 6;
        }
        return IfxTypes.FromIfxToJDBCType(cinfo.SQLtype);
    }

    @Override
    public int getIfxColumnType(int column) throws SQLException {
        if (this.columnTypeMap.containsKey(column)) {
            return this.columnTypeMap.get(column);
        }
        int type = this.getColumnInfo((int)column).SQLtype;
        this.columnTypeMap.put(column, type);
        return type;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        if (cinfo.SQLtype == 52 || cinfo.SQLtype == 53) {
            return cinfo.DataSourceName;
        }
        if (cinfo.SQLtype > 18 && (cinfo.SQLtype != 52 || cinfo.SQLtype != 53) || cinfo.IsDistinct) {
            return cinfo.ExtendedName;
        }
        return cinfo.DataSourceName;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        this.getColumnInfo(column);
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        this.getColumnInfo(column);
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.getColumnInfo(column);
        return true;
    }

    @Override
    public boolean isDistinct(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.IsDistinct;
    }

    @Override
    public boolean isNamedRow(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.IsNamedRow;
    }

    @Override
    public IfmxResultSetMetaData getChild(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        if (cinfo.child == null) {
            return null;
        }
        IfxResultSetMetaData rsmd = new IfxResultSetMetaData(this.conn, cinfo.child);
        return rsmd;
    }

    @Override
    public short getLevelNo(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.Levelno;
    }

    @Override
    public short getSeqNo(int column) throws SQLException {
        return this.getColumnInfo((int)column).Seqno;
    }

    @Override
    public short getParentNo(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.Parentno;
    }

    @Override
    public short getFieldNo(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.Fieldno;
    }

    byte getArgumentFlags(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.ArgumentFlags;
    }

    String getArgumentName(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return cinfo.ArgumentName;
    }

    public void setEncodedLength(int colnum, int len) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.ColLength = len;
        if (cinfo.SQLtype == 10 || cinfo.SQLtype == 14) {
            cinfo.DataSourceName = cinfo.DataSourceName + " " + IfxDateTime.getQualifierName((short)len, cinfo.SQLtype);
        }
    }

    public void setNullable(int colnum, int Xnull) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.Nullable = Xnull;
    }

    public void setAutoIncrement(int colnum, short ai) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.autoIncrement = ai;
    }

    void setMaxWidth(int colnum, int Xwidth) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.MaxWidth = Xwidth;
    }

    IfxResultSetMetaData setColtitle(int colnum, String Xtitle) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.Coltitle = Xtitle == null ? EMPTY_STRING : Xtitle;
        return this;
    }

    public IfxResultSetMetaData setColumnName(int colnum, String Xname) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.ColName = Xname == null ? EMPTY_STRING : Xname;
        return this;
    }

    public IfxResultSetMetaData setDecimalDigits(int colnum, int digits) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.setDecimalDigits(digits);
        return this;
    }

    public IfxResultSetMetaData setRightDecimal(int colnum, int Xright) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.RightDecimal = Xright;
        return this;
    }

    public IfxResultSetMetaData setTableName(int colnum, String Xtname) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.TableName = Xtname == null ? EMPTY_STRING : Xtname;
        return this;
    }

    IfxResultSetMetaData setArgumentFlags(int colnum, byte Xflags) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.ArgumentFlags = Xflags;
        return this;
    }

    IfxResultSetMetaData setArgumentName(int colnum, String Xname) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.ArgumentName = Xname == null ? EMPTY_STRING : Xname;
        return this;
    }

    public boolean isVariableLengthType(int colnum) throws SQLException {
        return this.getColumnInfo(colnum, true).isVariableLengthType((IfxSqliConnect)this.conn);
    }

    boolean usingIMPEXP() throws SQLException {
        boolean retVal = false;
        for (int i = 1; i <= this.getColumnCount(); ++i) {
            IfxColumnInfo cinfo = this.getColumnInfo(i);
            if (cinfo.SQLtype != 46) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public IfxResultSetMetaData setIfxColumnType(int colnum, int Xtype) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        if (IfxResultSetMetaData.setTypeBooleanFields(cinfo, Xtype)) {
            this.hasVariableLengthColumns = true;
        }
        if (!this.hasVariableLengthColumns && this.isVariableLengthType(colnum)) {
            this.hasVariableLengthColumns = true;
        }
        this.setDataSourceName(colnum, IfxTypes.IfxTypeToName(cinfo.SQLtype));
        return this;
    }

    public static boolean setTypeBooleanFields(IfxColumnInfo cinfo, int Xtype) {
        boolean hasVariableLengthColumns = false;
        cinfo.Nullable = (Xtype & 0x100) > 0 ? 0 : 1;
        if ((Xtype & 0x800) > 0) {
            cinfo.IsDistinct = true;
            hasVariableLengthColumns = true;
        }
        if ((Xtype & 0x1000) > 0) {
            cinfo.IsNamedRow = true;
        }
        cinfo.SQLtype = Xtype & 0xFF;
        return hasVariableLengthColumns;
    }

    public IfxResultSetMetaData setDataSourceName(int colnum, String Xstype) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.DataSourceName = Xstype == null ? EMPTY_STRING : Xstype;
        return this;
    }

    IfxResultSetMetaData setSourceType(int colnum, int sourceType) throws SQLException {
        this.getColumnInfo((int)colnum, (boolean)true).SourceType = sourceType;
        return this;
    }

    IfxResultSetMetaData setColumnStartPosition(int colnum, int pos) throws SQLException {
        this.getColumnInfo((int)colnum, (boolean)true).ColStartPos = pos;
        return this;
    }

    IfxResultSetMetaData setColumnExtendedId(int colnum, int id) throws SQLException {
        this.getColumnInfo((int)colnum, (boolean)true).ExtendedId = id;
        return this;
    }

    IfxResultSetMetaData setExtendedName(int colnum, String Xname) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.ExtendedName = Xname == null ? EMPTY_STRING : Xname;
        return this;
    }

    void setExtendedOwnerName(int colnum, String s) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.ExtendedOwner = s == null ? EMPTY_STRING : s;
    }

    void setReference(int colnum, short ref) throws SQLException {
        this.getColumnInfo((int)colnum, (boolean)true).Reference = ref;
    }

    void setAlignment(int colnum, short alignment) throws SQLException {
        this.getColumnInfo((int)colnum, (boolean)true).Alignment = alignment;
    }

    public void setColumnCount(int numcol) {
        this.numberofcol = numcol;
        if (numcol > 0) {
            this.cinfoVector.setSize(numcol);
        } else {
            this.cinfoVector.setSize(20);
        }
        for (int i = 0; i < numcol; ++i) {
            this.cinfoVector.setElementAt(new IfxColumnInfo(), i);
        }
    }

    void setBlobColAsUDT(int index) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(index);
        if (cinfo.SQLtype != 102 && cinfo.SQLtype != 101) {
            return;
        }
        cinfo.ExtendedId = 0;
        cinfo.SQLtype = 41;
    }

    public void setColumnInfo(int colnum, String name, int type, int length) throws SQLException {
        this.setColumnName(colnum, name);
        this.setIfxColumnType(colnum, type);
        this.setEncodedLength(colnum, length);
    }

    void setColInfo(int colnum, int maxWidth, String colName, String tableName, int sqlType, String dataSourceName, int sourceType, int colLength, int extendedId, String extendedOwner, String extendedName, int nullable, int delimident) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        try {
            cinfo.ColLength = colLength;
            cinfo.MaxWidth = maxWidth;
            cinfo.Coltitle = colName == null ? EMPTY_STRING : colName;
            cinfo.ColName = cinfo.Coltitle;
            cinfo.TableName = tableName == null ? EMPTY_STRING : tableName;
            if (sqlType == 41 && extendedId == 10) {
                this.setIfxColumnType(colnum, 102);
            } else if (sqlType == 41 && extendedId == 11) {
                this.setIfxColumnType(colnum, 101);
            } else {
                this.setIfxColumnType(colnum, sqlType);
            }
            cinfo.DataSourceName = dataSourceName == null ? EMPTY_STRING : dataSourceName;
            cinfo.SourceType = sourceType;
            cinfo.ExtendedId = extendedId;
            cinfo.ExtendedName = extendedName == null ? EMPTY_STRING : extendedName;
            cinfo.ExtendedOwner = extendedOwner == null ? EMPTY_STRING : extendedOwner;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79750, this.conn);
        }
        cinfo.Nullable = nullable;
        this.delimIdent = delimident == 1;
    }

    void setColInfo(int colnum, int maxWidth, byte[] colName, byte[] tableName, int sqlType, byte[] dataSourceName, int sourceType, int colLength, int extendedId, byte[] extendedOwner, byte[] extendedName, int nullable, int delimident, String encoding) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        try {
            cinfo.ColLength = colLength;
            cinfo.MaxWidth = maxWidth;
            cinfo.Coltitle = colName == null ? EMPTY_STRING : (encoding == null ? new String(colName) : new String(colName, encoding));
            cinfo.ColName = cinfo.Coltitle;
            cinfo.TableName = tableName == null ? EMPTY_STRING : (encoding == null ? new String(tableName) : new String(tableName, encoding));
            if (sqlType == 41 && extendedId == 10) {
                this.setIfxColumnType(colnum, 102);
            } else if (sqlType == 41 && extendedId == 11) {
                this.setIfxColumnType(colnum, 101);
            } else {
                this.setIfxColumnType(colnum, sqlType);
            }
            cinfo.DataSourceName = dataSourceName == null ? EMPTY_STRING : (encoding == null ? new String(dataSourceName) : new String(dataSourceName, encoding));
            cinfo.SourceType = sourceType;
            cinfo.ExtendedId = extendedId;
            cinfo.ExtendedName = extendedName == null ? EMPTY_STRING : (encoding == null ? new String(extendedName) : new String(extendedName, encoding));
            cinfo.ExtendedOwner = extendedOwner == null ? EMPTY_STRING : (encoding == null ? new String(extendedOwner) : new String(extendedOwner, encoding));
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79750, this.conn);
        }
        cinfo.Nullable = nullable;
        this.delimIdent = delimident == 1;
    }

    void setDistinct(int colnum, boolean isDistinct) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.IsDistinct = isDistinct;
    }

    public void setDelimIdent(boolean value) {
        this.delimIdent = value;
    }

    public boolean getDelimIdent() {
        return this.delimIdent;
    }

    public IfxConnection getConnection() {
        return this.conn;
    }

    void copyColumnInfo(int colnum, IfxColumnInfo from) throws SQLException {
        this.getColumnInfo(colnum, true);
        this.cinfoVector.setElementAt(from, colnum - 1);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        Map<String, Class<?>> typemap = this.conn.getTypeMap();
        String className = null;
        Class<?> cls = null;
        if (cinfo.IsDistinct && typemap != null && !typemap.isEmpty() && (cls = typemap.get(cinfo.ExtendedName)) != null) {
            className = cls.getName();
        } else if (typemap != null && !typemap.isEmpty() && (cls = typemap.get(IfxTypes.IfxTypeToName(cinfo.SQLtype))) != null) {
            className = cls.getName();
        } else {
            switch (cinfo.SQLtype) {
                case 10: {
                    short len = (short)this.getEncodedLength(column);
                    if (IfxDateTime.getStartCode(len) >= 6) {
                        className = "java.sql.Time";
                        break;
                    }
                    className = "java.sql.Timestamp";
                    break;
                }
                case 14: {
                    short len = (short)this.getEncodedLength(column);
                    if (Interval.getStartCode(len) < 4) {
                        className = "com.informix.jdbc.IntervalYM";
                        break;
                    }
                    className = "com.informix.jdbc.IntervalDF";
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 52: 
                case 53: {
                    className = IfxTypes.FromIfxTypeToJava(cinfo.SQLtype);
                    break;
                }
                case 40: 
                case 41: {
                    if (cinfo.ExtendedName.equals("boolean")) {
                        className = "java.lang.Boolean";
                    } else if (cinfo.ExtendedName.equals("lvarchar")) {
                        className = "java.lang.String";
                    } else if (cinfo.ExtendedName.equals("clob")) {
                        className = "com.informix.jdbc.IfxCblob";
                    } else if (cinfo.ExtendedName.equals("blob")) {
                        className = "com.informix.jdbc.IfxBblob";
                    }
                    if (className != null) break;
                    if (cinfo.SourceType == 5) {
                        className = "java.lang.Boolean";
                        break;
                    }
                    if (cinfo.SourceType == 1) {
                        className = "java.lang.String";
                        break;
                    }
                    if (cinfo.SourceType == 11) {
                        className = "com.informix.jdbc.IfxCblob";
                        break;
                    }
                    if (cinfo.SourceType == 10) {
                        className = "com.informix.jdbc.IfxBblob";
                        break;
                    }
                    if (typemap != null && !typemap.isEmpty() && (cls = typemap.get(cinfo.ExtendedName)) != null) {
                        className = cls.getName();
                        break;
                    }
                    className = "java.sql.SQLData";
                    break;
                }
                default: {
                    className = "unknown classname";
                }
            }
        }
        return className;
    }

    public void setTextByteColumnCount() throws SQLException {
        this.textByteColumnCount = 0;
        for (int i = 1; i <= this.getColumnCount(); ++i) {
            IfxColumnInfo cinfo = this.getColumnInfo(i, true);
            if (cinfo.SQLtype != 11 && cinfo.SQLtype != 12 && (cinfo.SQLtype != 41 || cinfo.ExtendedId != 10 && cinfo.ExtendedId != 11)) continue;
            this.textByteColumnCount = (short)(this.textByteColumnCount + 1);
        }
    }

    boolean needSvrConv(int i) throws SQLException {
        int colType = this.getIfxColumnType(i);
        int extendedId = this.getColumnExtendedId(i);
        return colType == 41 && extendedId != 10 && extendedId != 11 || colType == 40 && extendedId != 1 || colType == 19 || colType == 21 || colType == 20 || colType == 22;
    }

    public static String parseTableName(String command) {
        int stmtType = -1;
        if (command == null) {
            return EMPTY_STRING;
        }
        try {
            command = IfxResultSetMetaData.getCommandAfterStripComments(command);
            String str = command.trim().toUpperCase();
            int scanptr = -1;
            if (str.startsWith("SELECT")) {
                scanptr = IfxResultSetMetaData.getIndexOfFrom(str);
                stmtType = 2;
            } else if (str.startsWith("UPDATE")) {
                scanptr = 0;
                stmtType = 4;
            } else if (str.startsWith("INSERT")) {
                stmtType = 6;
                scanptr = str.indexOf("INTO");
            } else {
                stmtType = -1;
            }
            if (scanptr == -1) {
                return EMPTY_STRING;
            }
            String tmpstr = command.substring(scanptr);
            StringTokenizer st = new StringTokenizer(tmpstr);
            switch (stmtType) {
                case 2: {
                    String next = st.nextToken();
                    if (!st.hasMoreTokens()) {
                        return EMPTY_STRING;
                    }
                    next = st.nextToken();
                    if (next.startsWith("(")) {
                        return EMPTY_STRING;
                    }
                    if (next.endsWith(",")) {
                        return EMPTY_STRING;
                    }
                    if (next.indexOf(44) != -1) {
                        return EMPTY_STRING;
                    }
                    if (next.endsWith(";")) {
                        return next.replace(';', ' ').trim();
                    }
                    if (!st.hasMoreTokens()) {
                        return next;
                    }
                    String nextNext = st.nextToken();
                    if (nextNext.equalsIgnoreCase("AS")) {
                        if (st.hasMoreTokens()) {
                            nextNext = st.nextToken();
                        } else {
                            return EMPTY_STRING;
                        }
                    }
                    if (nextNext.equals(";")) {
                        return next;
                    }
                    if (nextNext.endsWith(";")) {
                        return next;
                    }
                    if (nextNext.indexOf(44) != -1) {
                        return EMPTY_STRING;
                    }
                    if (nextNext.equalsIgnoreCase("LEFT") || nextNext.equalsIgnoreCase("RIGHT") || nextNext.equalsIgnoreCase("FULL") || nextNext.equalsIgnoreCase("INNER") || nextNext.equalsIgnoreCase("CROSS") || nextNext.equalsIgnoreCase("JOIN") || nextNext.equalsIgnoreCase("OUTER") || nextNext.equalsIgnoreCase("UNION")) {
                        return EMPTY_STRING;
                    }
                    if (!st.hasMoreTokens()) {
                        return next;
                    }
                    String nextNextNext = st.nextToken();
                    if (nextNextNext.equals(";")) {
                        return next;
                    }
                    if (nextNextNext.equals(",")) {
                        return EMPTY_STRING;
                    }
                    if (nextNextNext.startsWith(",")) {
                        return EMPTY_STRING;
                    }
                    if (nextNextNext.equalsIgnoreCase("LEFT") || nextNextNext.equalsIgnoreCase("RIGHT") || nextNextNext.equalsIgnoreCase("FULL") || nextNextNext.equalsIgnoreCase("INNER") || nextNextNext.equalsIgnoreCase("CROSS") || nextNextNext.equalsIgnoreCase("JOIN") || nextNextNext.equalsIgnoreCase("OUTER") || nextNextNext.equalsIgnoreCase("UNION")) {
                        return EMPTY_STRING;
                    }
                    return next;
                }
                case 6: {
                    String next = st.nextToken();
                    if (!st.hasMoreTokens()) {
                        return EMPTY_STRING;
                    }
                    next = st.nextToken();
                    int lParanIndex = next.indexOf(40);
                    if (lParanIndex != -1) {
                        return next.substring(0, lParanIndex);
                    }
                    return next;
                }
                case 4: {
                    String next = st.nextToken();
                    if (!st.hasMoreTokens()) {
                        return EMPTY_STRING;
                    }
                    next = st.nextToken();
                    return next;
                }
            }
            return EMPTY_STRING;
        }
        catch (Exception e) {
            return EMPTY_STRING;
        }
    }

    private static String getCommandAfterStripComments(String command) {
        StringBuilder result = new StringBuilder();
        Stack<Character> stack = new Stack<Character>();
        boolean inString = false;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean inLineComment = false;
        boolean inBlockComment = false;
        int blocktype = 0;
        for (int i = 0; i < command.length(); ++i) {
            char nextChar;
            char currentChar = command.charAt(i);
            char c = nextChar = i + 1 < command.length() ? command.charAt(i + 1) : (char)'\u0000';
            if (inLineComment) {
                if (currentChar != '\n') continue;
                inLineComment = false;
                result.append(currentChar);
                continue;
            }
            if (inBlockComment) {
                if (blocktype == 123 && currentChar == '}') {
                    stack.pop();
                    ++i;
                    if (stack.isEmpty()) {
                        inBlockComment = false;
                    }
                }
                if (currentChar == '*' && nextChar == '/') {
                    stack.pop();
                    ++i;
                    if (!stack.isEmpty()) continue;
                    inBlockComment = false;
                    continue;
                }
                if (currentChar != '/' || nextChar != '*') continue;
                stack.push(Character.valueOf(currentChar));
                ++i;
                continue;
            }
            if (inString) {
                result.append(currentChar);
                if (inSingleQuote && currentChar == '\'' && command.charAt(i - 1) != '\\') {
                    inString = false;
                    inSingleQuote = false;
                    continue;
                }
                if (!inDoubleQuote || currentChar != '\"' || command.charAt(i - 1) == '\\') continue;
                inString = false;
                inDoubleQuote = false;
                continue;
            }
            if (currentChar == '\'' && !inDoubleQuote) {
                inString = true;
                inSingleQuote = true;
                result.append(currentChar);
                continue;
            }
            if (currentChar == '\"' && !inSingleQuote) {
                inString = true;
                inDoubleQuote = true;
                result.append(currentChar);
                continue;
            }
            if (currentChar == '-' && nextChar == '-') {
                inLineComment = true;
                ++i;
                continue;
            }
            if (currentChar == '/' && nextChar == '*') {
                blocktype = currentChar;
                inBlockComment = true;
                stack.push(Character.valueOf(currentChar));
                ++i;
                continue;
            }
            if (currentChar == '{') {
                inBlockComment = true;
                blocktype = currentChar;
                stack.push(Character.valueOf(currentChar));
                ++i;
                continue;
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    private static int getIndexOfFrom(String query) {
        int scanptr = -1;
        try {
            int ptr = 0;
            int lParanCount = 0;
            while ((scanptr = query.indexOf("FROM", ptr)) != -1) {
                for (int i = ptr; i < scanptr; ++i) {
                    char pchar = query.charAt(i);
                    if (pchar == '(') {
                        ++lParanCount;
                    }
                    if (pchar != ')') continue;
                    if (lParanCount <= 0) {
                        return -1;
                    }
                    --lParanCount;
                }
                if (lParanCount != 0) {
                    ptr = scanptr + 4;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            return -1;
        }
        return scanptr;
    }

    public void parseSetTableName(String command) throws SQLException {
        String tableName = IfxResultSetMetaData.parseTableName(command);
        if (tableName != null) {
            for (int i = 1; i <= this.numberofcol; ++i) {
                this.setTableName(i, tableName);
            }
        }
    }

    protected int findrowid() throws SQLException {
        this.rowidx = -1;
        for (int i = 1; i <= this.numberofcol; ++i) {
            if (!this.getColumnName(i).equals("rowid")) continue;
            this.rowidx = i;
            return this.rowidx;
        }
        return -1;
    }

    protected String findserial() throws SQLException {
        this.serialidx = -1;
        for (int i = 1; i <= this.numberofcol; ++i) {
            int type = this.getIfxColumnType(i);
            if (type != 6 && type != 18) continue;
            this.serialidx = i;
            return this.getColumnName(this.serialidx);
        }
        return null;
    }

    protected void setTupleSize(short size) {
        this.tupleSize = size;
    }

    protected short getTupleSize() {
        return this.tupleSize;
    }

    protected int getMode(int colnum) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        return cinfo.colMode;
    }

    protected void setMode(int colnum, int modeVal) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(colnum, true);
        cinfo.colMode = modeVal == 0 ? 1 : (modeVal == 1 ? 4 : (modeVal == 2 ? 2 : modeVal));
    }

    boolean hasDefaultValue(int column) throws SQLException {
        IfxColumnInfo cinfo = this.getColumnInfo(column);
        return (cinfo.ArgumentFlags & 1) != 0;
    }

    boolean wasRoutineUnique() {
        return (this.namedFlags & 2) != 0;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw IfxErrMsg.getSQLException(-80053, this.conn, this.getClass().getCanonicalName(), iface.getClass().getCanonicalName());
    }

    public String processValueCase(String value) {
        return this.uppercaseMetaData ? value.toUpperCase() : value;
    }

    public void setUppercaseMetaData(boolean enable) {
        this.uppercaseMetaData = enable;
    }

    public boolean isUppercaseMetaData() {
        return this.uppercaseMetaData;
    }
}

