﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iottwinmaker/IoTTwinMaker_EXPORTS.h>
#include <aws/iottwinmaker/model/SyncJobStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTTwinMaker {
namespace Model {

/**
 * <p>The SyncJob summary.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/SyncJobSummary">AWS
 * API Reference</a></p>
 */
class SyncJobSummary {
 public:
  AWS_IOTTWINMAKER_API SyncJobSummary() = default;
  AWS_IOTTWINMAKER_API SyncJobSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTTWINMAKER_API SyncJobSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTTWINMAKER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The SyncJob summary ARN.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  SyncJobSummary& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the workspace that contains the sync job.</p>
   */
  inline const Aws::String& GetWorkspaceId() const { return m_workspaceId; }
  inline bool WorkspaceIdHasBeenSet() const { return m_workspaceIdHasBeenSet; }
  template <typename WorkspaceIdT = Aws::String>
  void SetWorkspaceId(WorkspaceIdT&& value) {
    m_workspaceIdHasBeenSet = true;
    m_workspaceId = std::forward<WorkspaceIdT>(value);
  }
  template <typename WorkspaceIdT = Aws::String>
  SyncJobSummary& WithWorkspaceId(WorkspaceIdT&& value) {
    SetWorkspaceId(std::forward<WorkspaceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The sync source.</p>
   */
  inline const Aws::String& GetSyncSource() const { return m_syncSource; }
  inline bool SyncSourceHasBeenSet() const { return m_syncSourceHasBeenSet; }
  template <typename SyncSourceT = Aws::String>
  void SetSyncSource(SyncSourceT&& value) {
    m_syncSourceHasBeenSet = true;
    m_syncSource = std::forward<SyncSourceT>(value);
  }
  template <typename SyncSourceT = Aws::String>
  SyncJobSummary& WithSyncSource(SyncSourceT&& value) {
    SetSyncSource(std::forward<SyncSourceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The SyncJob summaries status.</p>
   */
  inline const SyncJobStatus& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = SyncJobStatus>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = SyncJobStatus>
  SyncJobSummary& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The creation date and time.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDateTime() const { return m_creationDateTime; }
  inline bool CreationDateTimeHasBeenSet() const { return m_creationDateTimeHasBeenSet; }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  void SetCreationDateTime(CreationDateTimeT&& value) {
    m_creationDateTimeHasBeenSet = true;
    m_creationDateTime = std::forward<CreationDateTimeT>(value);
  }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  SyncJobSummary& WithCreationDateTime(CreationDateTimeT&& value) {
    SetCreationDateTime(std::forward<CreationDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The update date and time.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdateDateTime() const { return m_updateDateTime; }
  inline bool UpdateDateTimeHasBeenSet() const { return m_updateDateTimeHasBeenSet; }
  template <typename UpdateDateTimeT = Aws::Utils::DateTime>
  void SetUpdateDateTime(UpdateDateTimeT&& value) {
    m_updateDateTimeHasBeenSet = true;
    m_updateDateTime = std::forward<UpdateDateTimeT>(value);
  }
  template <typename UpdateDateTimeT = Aws::Utils::DateTime>
  SyncJobSummary& WithUpdateDateTime(UpdateDateTimeT&& value) {
    SetUpdateDateTime(std::forward<UpdateDateTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::String m_workspaceId;
  bool m_workspaceIdHasBeenSet = false;

  Aws::String m_syncSource;
  bool m_syncSourceHasBeenSet = false;

  SyncJobStatus m_status;
  bool m_statusHasBeenSet = false;

  Aws::Utils::DateTime m_creationDateTime{};
  bool m_creationDateTimeHasBeenSet = false;

  Aws::Utils::DateTime m_updateDateTime{};
  bool m_updateDateTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTTwinMaker
}  // namespace Aws
