﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/proton/Proton_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Proton {
namespace Model {

/**
 * <p>A search filter for environment templates.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/EnvironmentTemplateFilter">AWS
 * API Reference</a></p>
 */
class EnvironmentTemplateFilter {
 public:
  AWS_PROTON_API EnvironmentTemplateFilter() = default;
  AWS_PROTON_API EnvironmentTemplateFilter(Aws::Utils::Json::JsonView jsonValue);
  AWS_PROTON_API EnvironmentTemplateFilter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PROTON_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Include <code>majorVersion</code> to filter search for a major version.</p>
   */
  inline const Aws::String& GetMajorVersion() const { return m_majorVersion; }
  inline bool MajorVersionHasBeenSet() const { return m_majorVersionHasBeenSet; }
  template <typename MajorVersionT = Aws::String>
  void SetMajorVersion(MajorVersionT&& value) {
    m_majorVersionHasBeenSet = true;
    m_majorVersion = std::forward<MajorVersionT>(value);
  }
  template <typename MajorVersionT = Aws::String>
  EnvironmentTemplateFilter& WithMajorVersion(MajorVersionT&& value) {
    SetMajorVersion(std::forward<MajorVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Include <code>templateName</code> to filter search for a template name.</p>
   */
  inline const Aws::String& GetTemplateName() const { return m_templateName; }
  inline bool TemplateNameHasBeenSet() const { return m_templateNameHasBeenSet; }
  template <typename TemplateNameT = Aws::String>
  void SetTemplateName(TemplateNameT&& value) {
    m_templateNameHasBeenSet = true;
    m_templateName = std::forward<TemplateNameT>(value);
  }
  template <typename TemplateNameT = Aws::String>
  EnvironmentTemplateFilter& WithTemplateName(TemplateNameT&& value) {
    SetTemplateName(std::forward<TemplateNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_majorVersion;
  bool m_majorVersionHasBeenSet = false;

  Aws::String m_templateName;
  bool m_templateNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace Proton
}  // namespace Aws
