﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/iotwireless/IoTWireless_EXPORTS.h>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTWireless {
namespace Model {

/**
 * <p>Sidewalk object for creating a device profile.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/SidewalkCreateDeviceProfile">AWS
 * API Reference</a></p>
 */
class SidewalkCreateDeviceProfile {
 public:
  AWS_IOTWIRELESS_API SidewalkCreateDeviceProfile() = default;
  AWS_IOTWIRELESS_API SidewalkCreateDeviceProfile(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTWIRELESS_API SidewalkCreateDeviceProfile& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTWIRELESS_API Aws::Utils::Json::JsonValue Jsonize() const;
};

}  // namespace Model
}  // namespace IoTWireless
}  // namespace Aws
