from datetime import datetime
from typing import Any, Dict, List, Optional, Union

from github.AuthorizationApplication import AuthorizationApplication
from github.GithubObject import CompletableGithubObject, _NotSetType

class Authorization(CompletableGithubObject):
    def __repr__(self) -> str: ...
    def _initAttributes(self) -> None: ...
    def _useAttributes(self, attributes: Dict[str, Any]) -> None: ...
    @property
    def app(self) -> AuthorizationApplication: ...
    @property
    def created_at(self) -> datetime: ...
    def delete(self) -> None: ...
    def edit(
        self,
        scopes: Union[_NotSetType, List[str]] = ...,
        add_scopes: Union[_NotSetType, List[str]] = ...,
        remove_scopes: Union[_NotSetType, List[str]] = ...,
        note: Union[_NotSetType, str] = ...,
        note_url: Union[_NotSetType, str] = ...,
    ) -> None: ...
    @property
    def id(self) -> int: ...
    @property
    def note(self) -> Optional[str]: ...
    @property
    def note_url(self) -> Optional[str]: ...
    @property
    def scopes(self) -> List[str]: ...
    @property
    def token(self) -> str: ...
    @property
    def updated_at(self) -> datetime: ...
    @property
    def url(self) -> str: ...
