/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression.operators.relational;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.schema.Column;

public class FullTextSearch
extends ASTNodeAccessImpl
implements Expression {
    private ExpressionList<Column> _matchColumns;
    private Expression _againstValue;
    private String _searchModifier;

    public ExpressionList<Column> getMatchColumns() {
        return this._matchColumns;
    }

    public void setMatchColumns(ExpressionList<Column> columns) {
        this._matchColumns = columns;
    }

    public Expression getAgainstValue() {
        return this._againstValue;
    }

    public void setAgainstValue(StringValue val) {
        this._againstValue = val;
    }

    public void setAgainstValue(JdbcNamedParameter val) {
        this._againstValue = val;
    }

    public void setAgainstValue(JdbcParameter val) {
        this._againstValue = val;
    }

    public String getSearchModifier() {
        return this._searchModifier;
    }

    public void setSearchModifier(String val) {
        this._searchModifier = val;
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    @Override
    public String toString() {
        Object columnsListCommaSeperated = "";
        Iterator iterator = this._matchColumns.iterator();
        while (iterator.hasNext()) {
            Column col = (Column)iterator.next();
            columnsListCommaSeperated = (String)columnsListCommaSeperated + col.getFullyQualifiedName();
            if (!iterator.hasNext()) continue;
            columnsListCommaSeperated = (String)columnsListCommaSeperated + ",";
        }
        return "MATCH (" + (String)columnsListCommaSeperated + ") AGAINST (" + this._againstValue + (String)(this._searchModifier != null ? " " + this._searchModifier : "") + ")";
    }

    public FullTextSearch withMatchColumns(ExpressionList<Column> matchColumns) {
        this.setMatchColumns(matchColumns);
        return this;
    }

    public FullTextSearch withAgainstValue(StringValue againstValue) {
        this.setAgainstValue(againstValue);
        return this;
    }

    public FullTextSearch withSearchModifier(String searchModifier) {
        this.setSearchModifier(searchModifier);
        return this;
    }

    public FullTextSearch addMatchColumns(Column ... matchColumns) {
        return this.addMatchColumns(Arrays.asList(matchColumns));
    }

    public FullTextSearch addMatchColumns(Collection<? extends Column> matchColumns) {
        ExpressionList collection = Optional.ofNullable(this.getMatchColumns()).orElseGet(() -> new ExpressionList((Expression[])new Column[0]));
        collection.addAll(matchColumns);
        return this.withMatchColumns(collection);
    }
}

