/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class UnmodifiableMap<K, V> {
    private static final UnmodifiableMap<?, ?> EMPTY = new UnmodifiableMap(Collections.emptyMap());
    private final Map<K, V> map;

    public static <K, V> UnmodifiableMap<K, V> emptyMap() {
        return EMPTY;
    }

    private UnmodifiableMap(Map<K, V> map) {
        this.map = map;
    }

    public UnmodifiableMap<K, V> combine(UnmodifiableMap<K, V> other) {
        if (this.map.isEmpty()) {
            return other;
        }
        if (other.map.isEmpty()) {
            return this;
        }
        HashMap<K, V> result = new HashMap<K, V>(this.map.size() + other.map.size());
        result.putAll(this.map);
        result.putAll(other.map);
        return new UnmodifiableMap(result);
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public UnmodifiableMap<K, V> put(Collection<Map.Entry<K, V>> entries) {
        if (entries.isEmpty()) {
            return this;
        }
        HashMap<K, V> result = new HashMap<K, V>(this.map);
        for (Map.Entry<K, V> entry : entries) {
            result.put(entry.getKey(), entry.getValue());
        }
        return new UnmodifiableMap<K, V>(result);
    }

    public UnmodifiableMap<K, V> put(K key, V value) {
        HashMap<K, V> result = new HashMap<K, V>(this.map);
        result.put(key, value);
        return new UnmodifiableMap<K, V>(result);
    }

    public UnmodifiableMap<K, V> remove(Collection<Map.Entry<K, V>> entries) {
        if (entries.isEmpty()) {
            return this;
        }
        HashMap<K, V> result = new HashMap<K, V>(this.map);
        for (Map.Entry<K, V> entry : entries) {
            result.remove(entry.getKey(), entry.getValue());
        }
        return new UnmodifiableMap<K, V>(result);
    }

    public Collection<V> values() {
        return this.map.values();
    }

    public Collection<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }
}

