/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.DTOId;
import org.knopflerfish.framework.Util;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

class NativeRequirement
extends DTOId
implements BundleRequirement {
    final BundleGeneration gen;
    final List<NativeCodeEntry> entries = new ArrayList<NativeCodeEntry>();
    private boolean optional = false;

    NativeRequirement(BundleGeneration gen, String bnc) {
        this.gen = gen;
        List<Util.HeaderEntry> hes = Util.parseManifestHeader("Bundle-NativeCode", bnc, false, false, false);
        Iterator<Util.HeaderEntry> heIt = hes.iterator();
        while (heIt.hasNext()) {
            Util.HeaderEntry he = heIt.next();
            List<String> keys = he.getKeys();
            if ("*".equals(keys.get(0))) {
                if (keys.size() != 1 || heIt.hasNext()) {
                    throw new IllegalArgumentException("Bundle#" + gen.bundle.id + ", Unexpected characters after '*' in " + "Bundle-NativeCode" + " header: " + bnc);
                }
                this.optional = true;
                break;
            }
            List procs = (List)he.getAttributes().get("processor");
            List oses = (List)he.getAttributes().get("osname");
            List vers = (List)he.getAttributes().get("osversion");
            List langs = (List)he.getAttributes().get("language");
            List sfs = (List)he.getAttributes().get("selection-filter");
            String sf = null;
            if (sfs != null) {
                sf = (String)sfs.get(0);
                if (sfs.size() != 1) {
                    throw new IllegalArgumentException("Bundle#" + gen.bundle.id + ", Invalid character after native code selection filter: " + sf);
                }
            }
            try {
                this.entries.add(new NativeCodeEntry(keys, procs, oses, vers, langs, sf));
            }
            catch (InvalidSyntaxException ise) {
                throw new IllegalArgumentException("Bundle does not specify a valid Bundle-NativeCode header. Got exception: " + ise.getMessage());
            }
        }
    }

    List<String> checkNativeCode() throws BundleException {
        List<String> best = null;
        Version bestVer = null;
        boolean bestLang = false;
        Map<String, Object> nca = this.gen.bundle.fwCtx.systemBundle.getNativeCapability().getAttributes();
        for (NativeCodeEntry ne : this.entries) {
            if (ne.filter != null && !ne.filter.matches(nca)) continue;
            if (best != null) {
                boolean verEqual = false;
                if (bestVer != null) {
                    if (ne.minVersion == null) continue;
                    int d = bestVer.compareTo(ne.minVersion);
                    if (d == 0) {
                        verEqual = true;
                    } else if (d > 0) {
                        continue;
                    }
                } else if (ne.minVersion == null) {
                    verEqual = true;
                }
                if (verEqual && (!ne.matchLang || bestLang)) continue;
            }
            best = ne.files;
            bestVer = ne.minVersion;
            bestLang = ne.matchLang;
        }
        if (best == null && !this.optional) {
            StringBuffer sb = new StringBuffer();
            sb.append("Bundle#").append(this.gen.bundle.id);
            sb.append(", no matching native code libraries, filters=[");
            boolean first = true;
            for (NativeCodeEntry ne : this.entries) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(ne.filter);
            }
            sb.append("], attributes: ").append(nca);
            throw new BundleException(sb.toString(), 8);
        }
        return best;
    }

    public String toString() {
        return "NativeRequirement[filter=" + this.getFilter() + "]";
    }

    @Override
    public String getNamespace() {
        return "osgi.native";
    }

    @Override
    public Map<String, String> getDirectives() {
        String filter = this.getFilter();
        if (filter != null) {
            if (this.optional) {
                TreeMap<String, String> res = new TreeMap<String, String>();
                res.put("filter", filter);
                res.put("resolution", "optional");
                return res;
            }
            return Collections.singletonMap("filter", filter);
        }
        Map res = Collections.EMPTY_MAP;
        return res;
    }

    @Override
    public Map<String, Object> getAttributes() {
        Map res = Collections.EMPTY_MAP;
        return res;
    }

    @Override
    public BundleRevision getResource() {
        return this.gen.bundleRevision;
    }

    @Override
    public BundleRevision getRevision() {
        return this.gen.bundleRevision;
    }

    @Override
    public boolean matches(BundleCapability capability) {
        if ("osgi.wiring.package".equals(capability.getNamespace())) {
            for (NativeCodeEntry e : this.entries) {
                if (e.filter != null && !e.filter.matches(capability.getAttributes())) continue;
                return true;
            }
        }
        return false;
    }

    private String getFilter() {
        StringBuffer sb = new StringBuffer();
        int elems = 0;
        for (NativeCodeEntry e : this.entries) {
            if (e.filter == null) continue;
            sb.append(((Object)e.filter).toString());
            ++elems;
        }
        if (elems == 0) {
            return null;
        }
        if (elems > 1) {
            sb.insert(0, "(|");
            sb.append(")");
        }
        return sb.toString();
    }

    class NativeCodeEntry {
        final List<String> files;
        final Filter filter;
        final boolean matchLang;
        final Version minVersion;

        NativeCodeEntry(List<String> files, List<String> procs, List<String> oses, List<String> vers, List<String> langs, String sf) throws InvalidSyntaxException {
            this.files = files;
            boolean bl = this.matchLang = langs != null;
            if (vers != null) {
                Version mv = null;
                ArrayList<VersionRange> vrs = new ArrayList<VersionRange>(vers.size());
                for (String s : vers) {
                    VersionRange vr = new VersionRange(s);
                    if (mv == null || mv.compareTo(vr.getLeft()) > 0) {
                        mv = vr.getLeft();
                    }
                    vrs.add(vr);
                }
                this.minVersion = mv;
                this.filter = this.toFilter(procs, oses, vrs, langs, sf);
            } else {
                this.minVersion = null;
                this.filter = this.toFilter(procs, oses, null, langs, sf);
            }
        }

        private String orString(String key, List<?> vals) {
            if (vals == null) {
                return null;
            }
            StringBuffer sb = new StringBuffer(80);
            if (vals.size() > 1) {
                sb.append("(|");
            }
            for (Object v : vals) {
                if (v instanceof VersionRange) {
                    sb.append(((VersionRange)v).toFilterString(key));
                    continue;
                }
                sb.append('(');
                sb.append(key);
                sb.append("~=");
                sb.append(v.toString());
                sb.append(')');
            }
            if (vals.size() > 1) {
                sb.append(')');
            }
            return sb.toString();
        }

        private int andAdd(StringBuffer sb, String str) {
            if (str == null) {
                return 0;
            }
            sb.append(str);
            return 1;
        }

        private Filter toFilter(List<String> procs, List<String> oses, List<VersionRange> vers, List<String> langs, String sf) throws InvalidSyntaxException {
            StringBuffer sb = new StringBuffer(80);
            int elems = 0;
            elems = this.andAdd(sb, this.orString("osgi.native.processor", procs));
            elems += this.andAdd(sb, this.orString("osgi.native.osname", oses));
            elems += this.andAdd(sb, this.orString("osgi.native.osversion", vers));
            elems += this.andAdd(sb, this.orString("osgi.native.language", langs));
            if ((elems += this.andAdd(sb, sf)) == 0) {
                return null;
            }
            if (elems > 1) {
                sb.insert(0, "(&");
                sb.append(")");
            }
            return FrameworkUtil.createFilter(sb.toString());
        }
    }
}

