# frozen_string_literal: true

class AddVulnerabilityFlagsProjectIdTrigger < Gitlab::Database::Migration[2.2]
  milestone '17.2'

  def up
    install_sharding_key_assignment_trigger(
      table: :vulnerability_flags,
      sharding_key: :project_id,
      parent_table: :vulnerability_occurrences,
      parent_sharding_key: :project_id,
      foreign_key: :vulnerability_occurrence_id
    )
  end

  def down
    remove_sharding_key_assignment_trigger(
      table: :vulnerability_flags,
      sharding_key: :project_id,
      parent_table: :vulnerability_occurrences,
      parent_sharding_key: :project_id,
      foreign_key: :vulnerability_occurrence_id
    )
  end
end
