/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.RebaseTodoLine;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public class RebaseTodoFile {
    private Repository repo;

    public RebaseTodoFile(Repository repo) {
        this.repo = repo;
    }

    public List<RebaseTodoLine> readRebaseTodo(String path, boolean includeComments) throws IOException {
        byte[] buf = IO.readFully(new File(this.repo.getDirectory(), path));
        int ptr = 0;
        int tokenBegin = 0;
        ArrayList<RebaseTodoLine> r = new ArrayList<RebaseTodoLine>();
        while (ptr < buf.length) {
            tokenBegin = ptr;
            ptr = RawParseUtils.nextLF(buf, ptr);
            int lineStart = tokenBegin;
            int lineEnd = ptr - 2;
            if (lineEnd >= 0 && buf[lineEnd] == 13) {
                --lineEnd;
            }
            if (buf[tokenBegin] == 35) {
                if (!includeComments) continue;
                RebaseTodoFile.parseComments(buf, tokenBegin, r, lineEnd);
                continue;
            }
            if ((tokenBegin = RebaseTodoFile.nextParsableToken(buf, tokenBegin, lineEnd)) == -1) {
                if (!includeComments) continue;
                r.add(new RebaseTodoLine(RawParseUtils.decode(buf, lineStart, 1 + lineEnd)));
                continue;
            }
            RebaseTodoLine line = RebaseTodoFile.parseLine(buf, tokenBegin, lineEnd);
            if (line == null) continue;
            r.add(line);
        }
        return r;
    }

    private static void parseComments(byte[] buf, int tokenBegin, List<RebaseTodoLine> r, int lineEnd) {
        block9: {
            RebaseTodoLine line = null;
            String commentString = RawParseUtils.decode(buf, tokenBegin, lineEnd + 1);
            try {
                try {
                    int skip = tokenBegin + 1;
                    skip = RebaseTodoFile.nextParsableToken(buf, skip, lineEnd);
                    if (skip != -1 && (line = RebaseTodoFile.parseLine(buf, skip, lineEnd)) != null) {
                        line.setAction(RebaseTodoLine.Action.COMMENT);
                        line.setComment(commentString);
                    }
                }
                catch (Exception e) {
                    line = null;
                    if (line == null) {
                        line = new RebaseTodoLine(commentString);
                    }
                    r.add(line);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (line == null) {
                    line = new RebaseTodoLine(commentString);
                }
                r.add(line);
                throw throwable;
            }
            if (line == null) {
                line = new RebaseTodoLine(commentString);
            }
            r.add(line);
        }
    }

    private static int nextParsableToken(byte[] buf, int tokenBegin, int lineEnd) {
        while (tokenBegin <= lineEnd && (buf[tokenBegin] == 32 || buf[tokenBegin] == 9 || buf[tokenBegin] == 13)) {
            ++tokenBegin;
        }
        if (tokenBegin > lineEnd) {
            return -1;
        }
        return tokenBegin;
    }

    private static RebaseTodoLine parseLine(byte[] buf, int tokenBegin, int lineEnd) {
        RebaseTodoLine.Action action = null;
        AbbreviatedObjectId commit = null;
        int nextSpace = RawParseUtils.next(buf, tokenBegin, ' ');
        int tokenCount = 0;
        while (tokenCount < 3 && nextSpace <= lineEnd) {
            switch (tokenCount) {
                case 0: {
                    String actionToken = new String(buf, tokenBegin, nextSpace - tokenBegin - 1, StandardCharsets.UTF_8);
                    tokenBegin = nextSpace;
                    action = RebaseTodoLine.Action.parse(actionToken);
                    if (action != null) break;
                    return null;
                }
                case 1: {
                    nextSpace = RawParseUtils.next(buf, tokenBegin, ' ');
                    String commitToken = nextSpace > lineEnd + 1 ? new String(buf, tokenBegin, lineEnd - tokenBegin + 1, StandardCharsets.UTF_8) : new String(buf, tokenBegin, nextSpace - tokenBegin - 1, StandardCharsets.UTF_8);
                    tokenBegin = nextSpace;
                    commit = AbbreviatedObjectId.fromString(commitToken);
                    break;
                }
                case 2: {
                    return new RebaseTodoLine(action, commit, RawParseUtils.decode(buf, tokenBegin, 1 + lineEnd));
                }
            }
            ++tokenCount;
        }
        if (tokenCount == 2) {
            return new RebaseTodoLine(action, commit, "");
        }
        return null;
    }

    public void writeRebaseTodoFile(String path, List<RebaseTodoLine> steps, boolean append) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedOutputStream fw = new BufferedOutputStream(new FileOutputStream(new File(this.repo.getDirectory(), path), append));){
            StringBuilder sb = new StringBuilder();
            for (RebaseTodoLine step : steps) {
                sb.setLength(0);
                if (RebaseTodoLine.Action.COMMENT.equals((Object)step.action)) {
                    sb.append(step.getComment());
                } else {
                    sb.append(step.getAction().toToken());
                    sb.append(" ");
                    sb.append(step.getCommit().name());
                    sb.append(" ");
                    sb.append(step.getShortMessage().trim());
                }
                sb.append('\n');
                ((OutputStream)fw).write(Constants.encode(sb.toString()));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

