/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.Serializable;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.provider.Provider;
import org.gradle.internal.file.PathToFileResolver;

public class DirectoryProviderPathToFileResolver
implements PathToFileResolver {
    private final Provider<Directory> directoryProvider;
    private final PathToFileResolver parentResolver;

    public DirectoryProviderPathToFileResolver(Provider<Directory> directoryProvider, PathToFileResolver parentResolver) {
        this.directoryProvider = directoryProvider;
        this.parentResolver = parentResolver;
    }

    private PathToFileResolver createResolver() {
        return this.parentResolver.newResolver(((Directory)this.directoryProvider.get()).getAsFile());
    }

    public File resolve(Object path) {
        return this.createResolver().resolve(path);
    }

    public PathToFileResolver newResolver(File baseDir) {
        return new DirectoryProviderPathToFileResolver((Provider<Directory>)this.directoryProvider.map(SerializableLambdas.transformer((SerializableLambdas.SerializableTransformer & Serializable)dir -> dir.dir(baseDir.getPath()))), this.parentResolver);
    }

    public boolean canResolveRelativePath() {
        return true;
    }
}

