import { camelCase } from "../core/camelCase.js";

// Matches dashed string for camelizing
var rmsPrefix = /^-ms-/;

// Convert dashed to camelCase, handle vendor prefixes.
// Used by the css & effects modules.
// Support: IE <=9 - 11+
// Microsoft forgot to hump their vendor prefix (trac-9572)
export function cssCamelCase( string ) {
	return camelCase( string.replace( rmsPrefix, "ms-" ) );
}
