/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.storage.implementations;

import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509SKI;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolverException;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolverSpi;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CertsInFilesystemDirectoryResolver
extends StorageResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(CertsInFilesystemDirectoryResolver.class);
    private String merlinsCertificatesDir;
    private List<X509Certificate> certs = new ArrayList<X509Certificate>();

    public CertsInFilesystemDirectoryResolver(String string) throws StorageResolverException {
        this.merlinsCertificatesDir = string;
        this.readCertsFromHarddrive();
    }

    private void readCertsFromHarddrive() throws StorageResolverException {
        File file = new File(this.merlinsCertificatesDir);
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!string.endsWith(".crt")) continue;
                arrayList.add(stringArray[i]);
            }
        }
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new StorageResolverException(certificateException);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            boolean bl;
            block27: {
                String string2 = file.getAbsolutePath() + File.separator + (String)arrayList.get(i);
                bl = false;
                string = null;
                try (InputStream inputStream = Files.newInputStream(Paths.get(string2, new String[0]), new OpenOption[0]);){
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
                    x509Certificate.checkValidity();
                    this.certs.add(x509Certificate);
                    string = x509Certificate.getSubjectX500Principal().getName();
                    bl = true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not add certificate from file " + string2, fileNotFoundException);
                    }
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not add certificate from file " + string2, certificateNotYetValidException);
                    }
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not add certificate from file " + string2, certificateExpiredException);
                    }
                }
                catch (CertificateException certificateException) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not add certificate from file " + string2, certificateException);
                    }
                }
                catch (IOException iOException) {
                    if (!LOG.isDebugEnabled()) break block27;
                    LOG.debug("Could not add certificate from file " + string2, iOException);
                }
            }
            if (!bl) continue;
            LOG.debug("Added certificate: {}", string);
        }
    }

    @Override
    public Iterator<Certificate> getIterator() {
        return new FilesystemIterator(this.certs);
    }

    public static void main(String[] stringArray) throws Exception {
        CertsInFilesystemDirectoryResolver certsInFilesystemDirectoryResolver = new CertsInFilesystemDirectoryResolver("data/ie/baltimore/merlin-examples/merlin-xmldsig-eighteen/certs");
        Iterator<Certificate> iterator = certsInFilesystemDirectoryResolver.getIterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            byte[] byArray = XMLX509SKI.getSKIBytesFromCert(x509Certificate);
            System.out.println();
            System.out.println("Base64(SKI())=                 \"" + XMLUtils.encodeToString(byArray) + "\"");
            System.out.println("cert.getSerialNumber()=        \"" + x509Certificate.getSerialNumber().toString() + "\"");
            System.out.println("cert.getSubjectX500Principal().getName()= \"" + x509Certificate.getSubjectX500Principal().getName() + "\"");
            System.out.println("cert.getIssuerX500Principal().getName()=  \"" + x509Certificate.getIssuerX500Principal().getName() + "\"");
        }
    }

    private static class FilesystemIterator
    implements Iterator<Certificate> {
        private List<X509Certificate> certs;
        private int i;

        public FilesystemIterator(List<X509Certificate> list) {
            this.certs = list;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.certs.size();
        }

        @Override
        public Certificate next() {
            return this.certs.get(this.i++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }
}

