/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.results.FetchBuilderBasicValued;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.internal.complete.EntityResultImpl;
import org.hibernate.query.results.internal.implicit.ImplicitFetchBuilderBasic;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class EntityDomainResultBuilder
implements ResultBuilder {
    private final NavigablePath navigablePath;
    private final EntityMappingType entityDescriptor;
    private final FetchBuilderBasicValued discriminatorFetchBuilder;

    public EntityDomainResultBuilder(EntityMappingType entityDescriptor) {
        this.entityDescriptor = entityDescriptor;
        this.navigablePath = new NavigablePath(entityDescriptor.getEntityName());
        EntityDiscriminatorMapping discriminatorMapping = entityDescriptor.getDiscriminatorMapping();
        this.discriminatorFetchBuilder = discriminatorMapping == null ? null : new ImplicitFetchBuilderBasic(this.navigablePath, discriminatorMapping);
    }

    @Override
    public Class<?> getJavaType() {
        return this.entityDescriptor.getJavaType().getJavaTypeClass();
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }

    public EntityResult buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, DomainResultCreationState domainResultCreationState) {
        return new EntityResultImpl(this.navigablePath, this.entityDescriptor, null, LockMode.NONE, entityResult -> {
            if (this.discriminatorFetchBuilder == null) {
                return null;
            }
            return this.discriminatorFetchBuilder.buildFetch((FetchParent)entityResult, this.navigablePath.append("{discriminator}"), jdbcResultsMetadata, domainResultCreationState);
        }, domainResultCreationState);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityDomainResultBuilder that = (EntityDomainResultBuilder)o;
        return this.entityDescriptor.equals(that.entityDescriptor);
    }

    public int hashCode() {
        return this.entityDescriptor.hashCode();
    }
}

