/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filmlisten.writer;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import mediathek.daten.DatenFilm;
import mediathek.daten.FilmListMetaData;
import mediathek.daten.ListeFilme;
import mediathek.gui.messages.FilmListWriteStartEvent;
import mediathek.gui.messages.FilmListWriteStopEvent;
import mediathek.tool.MessageBus;
import mediathek.tool.datum.DatumFilm;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FilmListWriter {
    private static final String FILMLISTE = "Filmliste";
    private static final Logger logger = LogManager.getLogger();
    private static final String TAG_JSON_LIST = "X";
    private final boolean readable;
    private String sender = "";
    private String thema = "";
    private boolean compressSenderTag = true;
    private boolean compressThemaTag = true;
    private boolean decompressUrls;

    public FilmListWriter(boolean readable) {
        this.readable = readable;
    }

    private JsonGenerator getJsonGenerator(OutputStream os) throws IOException {
        JsonFactory jsonF = new JsonFactory();
        JsonGenerator jg = jsonF.createGenerator(os, JsonEncoding.UTF8);
        if (this.readable) {
            jg = jg.useDefaultPrettyPrinter();
        }
        return jg;
    }

    private void checkOsxCacheDirectory() {
        Path filePath = Paths.get(SystemUtils.USER_HOME + File.separator + "Library/Caches/MediathekView", new String[0]);
        if (Files.notExists(filePath, new LinkOption[0])) {
            try {
                Files.createDirectories(filePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error("checkOsxCacheDirectory", (Throwable)e);
            }
        }
    }

    private void writeFormatHeader(JsonGenerator jg, ListeFilme listeFilme) throws IOException {
        FilmListMetaData meta = listeFilme.getMetaData();
        jg.writeArrayFieldStart(FILMLISTE);
        jg.writeString("");
        jg.writeString(meta.getDatum());
        jg.writeString(meta.getVersion());
        jg.writeString("");
        jg.writeString(meta.getId());
        jg.writeEndArray();
    }

    public void writeFilmList(String datei, ListeFilme listeFilme, IProgressListener progressListener) {
        MessageBus.getMessageBus().publishAsync((Object)new FilmListWriteStartEvent());
        try {
            logger.info("Filme schreiben ({} Filme) :", (Object)listeFilme.size());
            logger.info("   --> Start Schreiben nach: {}", (Object)datei);
            this.sender = "";
            this.thema = "";
            if (SystemUtils.IS_OS_MAC_OSX) {
                this.checkOsxCacheDirectory();
            }
            Path filePath = Paths.get(datei, new String[0]);
            try {
                Files.deleteIfExists(filePath);
            }
            catch (Exception e) {
                logger.warn("error trying to delete file", (Throwable)e);
                logger.trace("Waiting two seconds...");
                TimeUnit.SECONDS.sleep(2L);
            }
            long start = System.nanoTime();
            try (OutputStream fos = Files.newOutputStream(filePath, new OpenOption[0]);
                 BufferedOutputStream bos = new BufferedOutputStream(fos, 65536);
                 JsonGenerator jg = this.getJsonGenerator(bos);){
                jg.writeStartObject();
                this.writeFormatHeader(jg, listeFilme);
                this.writeFormatDescription(jg);
                long filmEntries = listeFilme.size();
                float curEntry = 0.0f;
                if (this.compressSenderTag) {
                    listeFilme.sort(Comparator.comparing(DatenFilm::getSender).thenComparing(DatenFilm::getThema));
                }
                for (DatenFilm datenFilm : listeFilme) {
                    this.writeEntry(datenFilm, jg);
                    if (progressListener == null) continue;
                    progressListener.progress(curEntry / (float)filmEntries);
                    curEntry += 1.0f;
                }
                jg.writeEndObject();
                if (progressListener != null) {
                    progressListener.progress(1.0);
                }
                long end = System.nanoTime();
                logger.info("   --> geschrieben!");
                logger.trace("Write duration: {} ms", (Object)TimeUnit.MILLISECONDS.convert(end - start, TimeUnit.NANOSECONDS));
            }
        }
        catch (Exception ex) {
            logger.error("nach: {}", (Object)datei, (Object)ex);
        }
        MessageBus.getMessageBus().publishAsync((Object)new FilmListWriteStopEvent());
    }

    private void writeDatumLong(DatenFilm datenFilm, JsonGenerator jg) throws IOException {
        DatumFilm filmDate = datenFilm.getDatumFilm();
        if (filmDate.equals(DatumFilm.UNDEFINED_FILM_DATE)) {
            jg.writeString("");
        } else {
            long time_sec = TimeUnit.SECONDS.convert(filmDate.getTime(), TimeUnit.MILLISECONDS);
            String str = String.valueOf(time_sec);
            jg.writeString(str);
        }
    }

    private void writeFilmLength(DatenFilm datenFilm, JsonGenerator jg) throws IOException {
        jg.writeString(datenFilm.getFilmLengthAsString());
    }

    private void writeEntry(DatenFilm film, JsonGenerator jg) throws IOException {
        jg.writeArrayFieldStart(TAG_JSON_LIST);
        this.writeSender(jg, film);
        this.writeThema(jg, film);
        this.writeTitel(jg, film);
        jg.writeString(film.getSendeDatum());
        this.writeZeit(jg, film);
        this.writeFilmLength(film, jg);
        jg.writeString(film.getFileSize().toString());
        jg.writeString(film.getDescription());
        jg.writeString(film.getUrlNormalQuality());
        jg.writeString(film.getWebsiteUrl());
        jg.writeString(film.getSubtitleUrl());
        this.skipEntry(jg);
        this.writeLowQualityUrl(jg, film);
        this.skipEntry(jg);
        this.writeHighQualityUrl(jg, film);
        this.skipEntry(jg);
        this.writeDatumLong(film, jg);
        this.skipEntry(jg);
        if (film.countrySet.isEmpty()) {
            jg.writeString("");
        } else {
            jg.writeString(film.countrySet.stream().map(Enum::toString).collect(Collectors.joining("-")));
        }
        jg.writeString(Boolean.toString(film.isNew()));
        jg.writeEndArray();
    }

    private void writeLowQualityUrl(@NotNull JsonGenerator jg, @NotNull DatenFilm datenFilm) throws IOException {
        String url = datenFilm.getLowQualityUrl();
        if (this.decompressUrls && DatenFilm.isCompressedUrl(url)) {
            url = datenFilm.decompressUrl(url);
        }
        jg.writeString(url);
    }

    private void writeHighQualityUrl(@NotNull JsonGenerator jg, @NotNull DatenFilm datenFilm) throws IOException {
        String url = datenFilm.getHighQualityUrl();
        if (this.decompressUrls && DatenFilm.isCompressedUrl(url)) {
            url = datenFilm.decompressUrl(url);
        }
        jg.writeString(url);
    }

    public void setDecompressUrls(boolean decompressUrls) {
        this.decompressUrls = decompressUrls;
    }

    private void skipEntry(JsonGenerator jg) throws IOException {
        jg.writeString("");
    }

    private void writeTitel(JsonGenerator jg, DatenFilm datenFilm) throws IOException {
        jg.writeString(datenFilm.getTitle());
    }

    private void writeSender(JsonGenerator jg, DatenFilm datenFilm) throws IOException {
        String tempSender = datenFilm.getSender();
        if (this.compressSenderTag) {
            if (tempSender.equals(this.sender)) {
                jg.writeString("");
            } else {
                this.sender = tempSender;
                jg.writeString(tempSender);
            }
        } else {
            jg.writeString(tempSender);
        }
    }

    public void setCompressThemaTag(boolean compressThemaTag) {
        this.compressThemaTag = compressThemaTag;
    }

    public void setCompressSenderTag(boolean compress) {
        this.compressSenderTag = compress;
    }

    private void writeThema(JsonGenerator jg, DatenFilm datenFilm) throws IOException {
        if (this.compressThemaTag) {
            if (datenFilm.getThema().equals(this.thema)) {
                jg.writeString("");
            } else {
                this.thema = datenFilm.getThema();
                jg.writeString(datenFilm.getThema());
            }
        } else {
            jg.writeString(datenFilm.getThema());
        }
    }

    private void writeZeit(JsonGenerator jg, DatenFilm datenFilm) throws IOException {
        String strZeit = datenFilm.getSendeZeit();
        int len = strZeit.length();
        if (strZeit.isEmpty() || len < 8) {
            jg.writeString("");
        } else {
            strZeit = strZeit.substring(0, len - 3);
            jg.writeString(strZeit);
        }
    }

    private void writeFormatDescription(JsonGenerator jg) throws IOException {
        jg.writeArrayFieldStart(FILMLISTE);
        jg.writeString("");
        jg.writeEndArray();
    }

    @FunctionalInterface
    public static interface IProgressListener {
        public void progress(double var1);
    }
}

