/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.XmlCompletionContributor;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlContentDFA;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class XmlSmartCompletionProvider {
    XmlSmartCompletionProvider() {
    }

    public void complete(CompletionParameters parameters, CompletionResultSet result, PsiElement element) {
        if (!XmlCompletionContributor.isXmlNameCompletion(parameters)) {
            return;
        }
        result.stopHere();
        PsiElement psiElement = element.getParent();
        if (!(psiElement instanceof XmlTag)) {
            return;
        }
        XmlTag tag = (XmlTag)psiElement;
        XmlTag parentTag = tag.getParentTag();
        if (parentTag == null) {
            return;
        }
        XmlContentDFA dfa = XmlContentDFA.getContentDFA(parentTag);
        if (dfa == null) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            for (XmlTag subTag : parentTag.getSubTags()) {
                if (subTag == tag) break;
                dfa.transition(subTag);
            }
            List<XmlElementDescriptor> elements = dfa.getPossibleElements();
            for (XmlElementDescriptor elementDescriptor : elements) {
                XmlSmartCompletionProvider.addElementToResult(elementDescriptor, result);
            }
        });
    }

    private static void addElementToResult(@NotNull XmlElementDescriptor descriptor, CompletionResultSet result) {
        String name;
        if (descriptor == null) {
            XmlSmartCompletionProvider.$$$reportNull$$$0(0);
        }
        XmlTagInsertHandler insertHandler = XmlTagInsertHandler.INSTANCE;
        if (descriptor instanceof XmlElementDescriptorImpl && (name = descriptor.getName()) != null) {
            insertHandler = new ExtendedTagInsertHandler(name, ((XmlElementDescriptorImpl)descriptor).getNamespace(), null);
        }
        result.addElement((LookupElement)XmlSmartCompletionProvider.createLookupElement(descriptor).withInsertHandler((InsertHandler)insertHandler));
    }

    public static LookupElementBuilder createLookupElement(@NotNull XmlElementDescriptor descriptor) {
        if (descriptor == null) {
            XmlSmartCompletionProvider.$$$reportNull$$$0(1);
        }
        LookupElementBuilder builder = LookupElementBuilder.create((String)descriptor.getName());
        if (descriptor instanceof XmlElementDescriptorImpl) {
            builder = builder.withTypeText(((XmlElementDescriptorImpl)descriptor).getNamespace(), true);
        }
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "descriptor";
        objectArray2[1] = "com/intellij/codeInsight/completion/XmlSmartCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addElementToResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createLookupElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

