/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.generate;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigElementTypes;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigHeader;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigOption;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigPsiFile;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigSection;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.LightEditActionFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ec4j.core.model.Ec4jPath;
import org.ec4j.core.model.Glob;
import org.editorconfig.configmanagement.export.EditorConfigSettingsWriter;
import org.editorconfig.configmanagement.extended.EditorConfigPropertyKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class EditorConfigGenerateLanguagePropertiesAction
extends CodeInsightAction {
    private static final CodeInsightActionHandler HANDLER = new LanguagePropertiesGenerator();
    private static final Logger LOG = Logger.getInstance(EditorConfigGenerateLanguagePropertiesAction.class);

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        CodeInsightActionHandler codeInsightActionHandler = HANDLER;
        if (codeInsightActionHandler == null) {
            EditorConfigGenerateLanguagePropertiesAction.$$$reportNull$$$0(0);
        }
        return codeInsightActionHandler;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            EditorConfigGenerateLanguagePropertiesAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            EditorConfigGenerateLanguagePropertiesAction.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            EditorConfigGenerateLanguagePropertiesAction.$$$reportNull$$$0(3);
        }
        if (psiFile instanceof EditorConfigPsiFile) {
            PsiElement contextElement;
            int currOffset = editor.getCaretModel().getOffset();
            if (currOffset == psiFile.getTextLength() && currOffset > 0) {
                --currOffset;
            }
            if ((contextElement = psiFile.findElementAt(currOffset)) != null) {
                if (contextElement instanceof PsiWhiteSpace) {
                    PsiElement prev = contextElement.getPrevSibling();
                    return prev != null && (prev.getNode().getElementType() == EditorConfigElementTypes.SECTION || prev.getNode().getElementType() == EditorConfigElementTypes.HEADER || prev instanceof EditorConfigOption);
                }
                if (contextElement.getNode().getElementType() == EditorConfigElementTypes.IDENTIFIER) {
                    return contextElement.getTextRange().getStartOffset() == currOffset;
                }
            }
        }
        return false;
    }

    @TestOnly
    public static void generateProperties(@NotNull Project project, @NotNull Editor editor, @NotNull Language language) {
        if (project == null) {
            EditorConfigGenerateLanguagePropertiesAction.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            EditorConfigGenerateLanguagePropertiesAction.$$$reportNull$$$0(5);
        }
        if (language == null) {
            EditorConfigGenerateLanguagePropertiesAction.$$$reportNull$$$0(6);
        }
        LanguagePropertiesGenerator.generateProperties(project, editor, language);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/generate/EditorConfigGenerateLanguagePropertiesAction";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/generate/EditorConfigGenerateLanguagePropertiesAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    private static class LanguagePropertiesGenerator
    implements CodeInsightActionHandler {
        private LanguagePropertiesGenerator() {
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
            if (project == null) {
                LanguagePropertiesGenerator.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                LanguagePropertiesGenerator.$$$reportNull$$$0(1);
            }
            if (psiFile == null) {
                LanguagePropertiesGenerator.$$$reportNull$$$0(2);
            }
            ListPopup languagePopup = LanguagePropertiesGenerator.createLanguagePopup(project, psiFile, editor);
            languagePopup.showInBestPositionFor(editor);
        }

        private static void generateProperties(@NotNull Project project, @NotNull Editor editor, @NotNull Language language) {
            LanguageCodeStyleSettingsProvider provider;
            if (project == null) {
                LanguagePropertiesGenerator.$$$reportNull$$$0(3);
            }
            if (editor == null) {
                LanguagePropertiesGenerator.$$$reportNull$$$0(4);
            }
            if (language == null) {
                LanguagePropertiesGenerator.$$$reportNull$$$0(5);
            }
            if ((provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)language)) != null) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                try (EditorConfigSettingsWriter writer = new EditorConfigSettingsWriter(project, output, CodeStyle.getSettings((Project)project), false, false).forLanguages(language).forPropertyKinds(EditorConfigPropertyKind.LANGUAGE).withoutHeaders();){
                    writer.writeSettings();
                    writer.flush();
                    String text = new String(output.toByteArray(), StandardCharsets.UTF_8);
                    CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> editor.getDocument().insertString(editor.getCaretModel().getOffset(), (CharSequence)text)));
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        private static ListPopup createLanguagePopup(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor) {
            if (project == null) {
                LanguagePropertiesGenerator.$$$reportNull$$$0(6);
            }
            if (file == null) {
                LanguagePropertiesGenerator.$$$reportNull$$$0(7);
            }
            if (editor == null) {
                LanguagePropertiesGenerator.$$$reportNull$$$0(8);
            }
            DefaultActionGroup languageGroup = new DefaultActionGroup();
            Set<Language> preferredLanguages = LanguagePropertiesGenerator.getPreferredLanguages(file, editor.getCaretModel().getOffset());
            LanguagePropertiesGenerator.getSupportedLanguages().stream().sorted((l1, l2) -> {
                if (preferredLanguages == null) {
                    return 0;
                }
                return (preferredLanguages.contains(l2) ? 1 : 0) - (preferredLanguages.contains(l1) ? 1 : 0);
            }).forEach(language -> languageGroup.add((AnAction)LightEditActionFactory.create((String)language.getDisplayName(), event -> LanguagePropertiesGenerator.generateProperties(project, editor, language))));
            return JBPopupFactory.getInstance().createActionGroupPopup(EditorConfigBundle.message((String)"popup.title.choose.language"), (ActionGroup)languageGroup, DataManager.getInstance().getDataContext((Component)editor.getComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        }

        private static List<Language> getSupportedLanguages() {
            return LanguageCodeStyleSettingsProvider.getAllProviders().stream().filter(provider -> provider.supportsExternalFormats()).map(provider -> provider.getLanguage()).sorted((l1, l2) -> l1.getDisplayName().compareToIgnoreCase(l2.getDisplayName())).collect(Collectors.toList());
        }

        @Nullable
        private static Set<Language> getPreferredLanguages(@NotNull PsiFile file, int offset) {
            EditorConfigHeader header;
            if (file == null) {
                LanguagePropertiesGenerator.$$$reportNull$$$0(9);
            }
            HashSet<Language> languages = new HashSet<Language>();
            int currOffset = offset == file.getTextLength() && offset > 0 ? offset - 1 : offset;
            PsiElement contextElement = file.findElementAt(currOffset);
            if (contextElement != null && (header = LanguagePropertiesGenerator.findHeader(contextElement)) != null) {
                String pattern = header.getText();
                if ("*".equals(pattern = StringUtil.trimEnd((String)StringUtil.trimStart((String)pattern, (String)"["), (String)"]").trim())) {
                    return null;
                }
                for (FileType fileType : FileTypeManager.getInstance().getRegisteredFileTypes()) {
                    String testName;
                    if (!(fileType instanceof LanguageFileType) || !new Glob(pattern).match(Ec4jPath.Ec4jPaths.of(testName = "/a." + fileType.getDefaultExtension()))) continue;
                    languages.add(((LanguageFileType)fileType).getLanguage());
                }
            }
            return languages;
        }

        @Nullable
        private static EditorConfigHeader findHeader(@NotNull PsiElement contextElement) {
            PsiElement prev;
            if (contextElement == null) {
                LanguagePropertiesGenerator.$$$reportNull$$$0(10);
            }
            if (contextElement instanceof PsiWhiteSpace && (prev = contextElement.getPrevSibling()) instanceof EditorConfigSection) {
                return ((EditorConfigSection)prev).getHeader();
            }
            for (PsiElement parent = contextElement.getParent(); parent != null && !(parent instanceof PsiFile); parent = parent.getParent()) {
                if (!(parent instanceof EditorConfigSection)) continue;
                return ((EditorConfigSection)parent).getHeader();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextElement";
                    break;
                }
            }
            objectArray2[1] = "org/editorconfig/configmanagement/generate/EditorConfigGenerateLanguagePropertiesAction$LanguagePropertiesGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invoke";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateProperties";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLanguagePopup";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPreferredLanguages";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findHeader";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

