/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.serialize.options;

import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputFormatState;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public enum SerializationFormat implements OutputFormat
{
    ser("Java serialization", "schemacrawler.tools.formatter.serialize.JavaSerializedCatalog", true),
    json("JavaScript Object Notation (JSON) serialization format", "schemacrawler.tools.formatter.serialize.JsonSerializedCatalog", false),
    yaml("YAML Ain't Markup Language (YAML) serialization format", "schemacrawler.tools.formatter.serialize.YamlSerializedCatalog", false),
    compact_json("Compact JavaScript Object Notation (JSON) serialization format", "schemacrawler.tools.formatter.serialize.CompactSerializedCatalog", false);

    private static final Logger LOGGER;
    private final OutputFormatState outputFormatState;
    private final String serializerClassName;
    private final boolean isBinaryFormat;

    public static SerializationFormat fromFormat(String format) {
        SerializationFormat outputFormat = SerializationFormat.fromFormatOrNull(format);
        if (outputFormat == null) {
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Unknown format <%s>, using default", new Object[]{format}));
            return ser;
        }
        return outputFormat;
    }

    public static boolean isSupportedFormat(String format) {
        return SerializationFormat.fromFormatOrNull(format) != null;
    }

    private static SerializationFormat fromFormatOrNull(String format) {
        if (Utility.isBlank((String)format)) {
            return null;
        }
        for (SerializationFormat outputFormat : SerializationFormat.values()) {
            if (!outputFormat.outputFormatState.isSupportedFormat(format)) continue;
            return outputFormat;
        }
        return null;
    }

    private SerializationFormat(String description, String serializerClassName, boolean isBinaryFormat) {
        this.outputFormatState = new OutputFormatState(this.name(), description, new String[0]);
        this.serializerClassName = serializerClassName;
        this.isBinaryFormat = isBinaryFormat;
    }

    public String getDescription() {
        return this.outputFormatState.getDescription();
    }

    public String getFileExtension() {
        List formats = this.outputFormatState.getFormats();
        return (String)formats.get(formats.size() - 1);
    }

    public String getFormat() {
        return this.outputFormatState.getFormat();
    }

    public List<String> getFormats() {
        return this.outputFormatState.getFormats();
    }

    public String getSerializerClassName() {
        return this.serializerClassName;
    }

    public boolean isBinaryFormat() {
        return this.isBinaryFormat;
    }

    public String toString() {
        return this.outputFormatState.toString();
    }

    static {
        LOGGER = Logger.getLogger(SerializationFormat.class.getName());
    }
}

