/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.contextvars;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.contextvars.Hamt;
import com.oracle.graal.python.builtins.objects.contextvars.HamtIterator;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsContext;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;

public final class PContextIterator
extends PythonBuiltinObject {
    private final ItemKind kind;
    private final HamtIterator it;

    public PContextIterator(Object cls, Shape instanceShape, PContextVarsContext ctx, ItemKind kind) {
        super(cls, instanceShape);
        this.it = new HamtIterator(ctx.contextVarValues);
        this.kind = kind;
    }

    public Object next(PythonLanguage language) {
        Hamt.Entry item = this.it.next();
        return item == null ? null : this.kind.apply(item, language);
    }

    public static enum ItemKind {
        KEYS,
        VALUES,
        ITEMS;


        public Object apply(Hamt.Entry item, PythonLanguage language) {
            switch (this.ordinal()) {
                case 0: {
                    return item.key;
                }
                case 1: {
                    return item.value;
                }
                case 2: {
                    return PFactory.createTuple(language, new Object[]{item.key, item.value});
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)"null ItemKind in PHamtIterator");
        }
    }
}

