/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bytes;

import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.io.ByteArrayOutputStream;

public final class BytesUtils {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final byte[] HEXDIGITS = "0123456789abcdef".getBytes();
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final byte[] NULL_STRING = new byte[]{60, 78, 85, 76, 76, 62};
    static final byte PY_CTF_LOWER = 1;
    static final byte PY_CTF_UPPER = 2;
    static final byte PY_CTF_ALPHA = 3;
    static final byte PY_CTF_DIGIT = 4;
    static final byte PY_CTF_ALNUM = 7;
    static final byte PY_CTF_SPACE = 8;
    static final byte PY_CTF_XDIGIT = 16;
    static final byte[] BYTES_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 0, 0, 0, 0, 0, 0, 0, 18, 18, 18, 18, 18, 18, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 17, 17, 17, 17, 17, 17, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final int[] TO_LOWER = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};
    static final int[] TO_UPPER = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};

    public static int mask(byte c) {
        return c & 0xFF;
    }

    public static boolean isLower(byte c) {
        return (BYTES_TABLE[BytesUtils.mask(c)] & 1) != 0;
    }

    public static boolean isUpper(byte c) {
        return (BYTES_TABLE[BytesUtils.mask(c)] & 2) != 0;
    }

    public static boolean isAlpha(byte c) {
        return (BYTES_TABLE[BytesUtils.mask(c)] & 3) != 0;
    }

    public static boolean isDigit(byte c) {
        return (BYTES_TABLE[BytesUtils.mask(c)] & 4) != 0;
    }

    public static boolean isXDigit(byte c) {
        return (BYTES_TABLE[BytesUtils.mask(c)] & 0x10) != 0;
    }

    public static boolean isAlnum(byte c) {
        return (BYTES_TABLE[BytesUtils.mask(c)] & 7) != 0;
    }

    public static boolean isSpace(byte c) {
        return (BYTES_TABLE[BytesUtils.mask(c)] & 8) != 0;
    }

    public static byte toLower(byte c) {
        return (byte)TO_LOWER[BytesUtils.mask(c)];
    }

    public static byte toUpper(byte c) {
        return (byte)TO_UPPER[BytesUtils.mask(c)];
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static char figureOutQuote(byte[] bytes, int len) {
        int quote = 39;
        for (int i = 0; i < len; ++i) {
            if (bytes[i] == 34) {
                quote = 39;
                break;
            }
            if (bytes[i] != 39) continue;
            quote = 34;
        }
        return (char)quote;
    }

    public static void reprLoop(TruffleStringBuilder sb, byte[] bytes, int len, TruffleStringBuilder.AppendCodePointNode appendCodePointNode) {
        char quote = BytesUtils.figureOutQuote(bytes, len);
        appendCodePointNode.execute(sb, 98, 1, true);
        appendCodePointNode.execute(sb, (int)quote, 1, true);
        for (int i = 0; i < len; ++i) {
            BytesUtils.byteRepr(sb, bytes[i], quote == '\'', appendCodePointNode);
        }
        appendCodePointNode.execute(sb, (int)quote, 1, true);
    }

    @CompilerDirectives.TruffleBoundary
    private static void byteRepr(TruffleStringBuilder sb, byte b, boolean isSingleQuote, TruffleStringBuilder.AppendCodePointNode appendCodePointNode) {
        if (b == 9) {
            appendCodePointNode.execute(sb, 92, 1, true);
            appendCodePointNode.execute(sb, 116, 1, true);
        } else if (b == 10) {
            appendCodePointNode.execute(sb, 92, 1, true);
            appendCodePointNode.execute(sb, 110, 1, true);
        } else if (b == 13) {
            appendCodePointNode.execute(sb, 92, 1, true);
            appendCodePointNode.execute(sb, 114, 1, true);
        } else if (b == 39) {
            if (isSingleQuote) {
                appendCodePointNode.execute(sb, 92, 1, true);
            }
            appendCodePointNode.execute(sb, 39, 1, true);
        } else if (b > 31 && b <= 126) {
            char chr = (char)b;
            if (chr == '\\') {
                appendCodePointNode.execute(sb, 92, 1, true);
            }
            appendCodePointNode.execute(sb, (int)chr, 1, true);
        } else {
            appendCodePointNode.execute(sb, 92, 1, true);
            appendCodePointNode.execute(sb, 120, 1, true);
            appendCodePointNode.execute(sb, (int)HEXDIGITS[b >>> 4 & 0xF], 1, true);
            appendCodePointNode.execute(sb, (int)HEXDIGITS[b & 0xF], 1, true);
        }
    }

    public static void repr(TruffleStringBuilder sb, byte[] bytes, int len, TruffleStringBuilder.AppendCodePointNode appendCodePointNode) {
        for (int i = 0; i < len; ++i) {
            BytesUtils.byteRepr(sb, bytes[i], true, appendCodePointNode);
        }
    }

    public static String bytesRepr(byte[] bytes, int length) {
        CompilerAsserts.neverPartOfCompilation();
        int len = length;
        if (len > bytes.length) {
            len = bytes.length;
        }
        TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
        sb.appendCodePointUncached(98);
        sb.appendCodePointUncached(39);
        BytesUtils.repr(sb, bytes, len, TruffleStringBuilder.AppendCodePointNode.getUncached());
        sb.appendCodePointUncached(39);
        return sb.toStringUncached().toJavaStringUncached();
    }

    public static int unicodeEscape(int codePoint, int startIndex, byte[] buffer) {
        int i = startIndex;
        if (codePoint < 256) {
            if (codePoint >= 32 && codePoint < 127) {
                if (codePoint != 92) {
                    buffer[i++] = (byte)codePoint;
                } else {
                    buffer[i++] = 92;
                    buffer[i++] = 92;
                }
            } else if (codePoint == 9) {
                buffer[i++] = 92;
                buffer[i++] = 116;
            } else if (codePoint == 10) {
                buffer[i++] = 92;
                buffer[i++] = 110;
            } else if (codePoint == 13) {
                buffer[i++] = 92;
                buffer[i++] = 114;
            } else {
                i = BytesUtils.byteEscape(codePoint, i, buffer);
            }
        } else {
            i = BytesUtils.unicodeNonAsciiEscape(codePoint, i, buffer);
        }
        return i;
    }

    public static int byteEscape(int codePoint, int startIndex, byte[] buffer) {
        int i = startIndex;
        buffer[i++] = 92;
        buffer[i++] = 120;
        buffer[i++] = HEXDIGITS[codePoint >> 4 & 0xF];
        buffer[i++] = HEXDIGITS[codePoint & 0xF];
        return i;
    }

    public static int unicodeNonAsciiEscape(int codePoint, int startIndex, byte[] buffer) {
        return BytesUtils.unicodeNonAsciiEscape(codePoint, startIndex, buffer, false);
    }

    public static int unicodeNonAsciiEscape(int codePoint, int startIndex, byte[] buffer, boolean escapeAscii) {
        int i = startIndex;
        if (!escapeAscii && codePoint < 128) {
            buffer[i++] = (byte)codePoint;
        } else if (codePoint < 256) {
            i = BytesUtils.byteEscape(codePoint, startIndex, buffer);
        } else if (codePoint < 65536) {
            buffer[i++] = 92;
            buffer[i++] = 117;
            buffer[i++] = HEXDIGITS[codePoint >> 12 & 0xF];
            buffer[i++] = HEXDIGITS[codePoint >> 8 & 0xF];
            buffer[i++] = HEXDIGITS[codePoint >> 4 & 0xF];
            buffer[i++] = HEXDIGITS[codePoint & 0xF];
        } else {
            buffer[i++] = 92;
            buffer[i++] = 85;
            buffer[i++] = 48;
            buffer[i++] = 48;
            buffer[i++] = HEXDIGITS[codePoint >> 20 & 0xF];
            buffer[i++] = HEXDIGITS[codePoint >> 16 & 0xF];
            buffer[i++] = HEXDIGITS[codePoint >> 12 & 0xF];
            buffer[i++] = HEXDIGITS[codePoint >> 8 & 0xF];
            buffer[i++] = HEXDIGITS[codePoint >> 4 & 0xF];
            buffer[i++] = HEXDIGITS[codePoint & 0xF];
        }
        return i;
    }

    public static int digitValue(byte hexChar) {
        if (BytesUtils.isDigit(hexChar)) {
            return hexChar - 48;
        }
        if (97 <= hexChar && hexChar <= 102) {
            return hexChar - 97 + 10;
        }
        if (65 <= hexChar && hexChar <= 70) {
            return hexChar - 65 + 10;
        }
        return 37;
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static int memchr(byte[] bytes, int start, byte v, int len) {
        for (int i = start; i < start + len; ++i) {
            if (bytes[i] != v) continue;
            return i;
        }
        return -1;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString createASCIIString(byte[] retbuf, TruffleString.FromByteArrayNode fromByteArrayNode, TruffleString.SwitchEncodingNode switchEncodingNode) {
        return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(retbuf, TruffleString.Encoding.US_ASCII), PythonUtils.TS_ENCODING);
    }

    @CompilerDirectives.TruffleBoundary
    public static ByteArrayOutputStream createOutputStream() {
        return new ByteArrayOutputStream();
    }

    @CompilerDirectives.TruffleBoundary
    public static ByteArrayOutputStream createOutputStream(int n) {
        return new ByteArrayOutputStream(n);
    }

    @CompilerDirectives.TruffleBoundary
    public static void append(ByteArrayOutputStream bas, byte[] bytes, int off, int len) {
        bas.write(bytes, off, len);
    }

    @CompilerDirectives.TruffleBoundary
    public static void append(ByteArrayOutputStream bas, byte[] bytes, int len) {
        BytesUtils.append(bas, bytes, 0, len);
    }

    @CompilerDirectives.TruffleBoundary
    public static byte[] toByteArray(ByteArrayOutputStream bas) {
        return bas.toByteArray();
    }
}

