/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.sql.SQLException;
import java.util.Properties;
import org.duckdb.DuckDBConnection;
import org.duckdb.DuckDBResultSetMetaData;
import org.duckdb.DuckDBVector;
import org.duckdb.ProfilerPrintFormat;
import org.duckdb.QueryProgress;

final class DuckDBNative {
    private static final String ARCH_X86_64 = "amd64";
    private static final String ARCH_AARCH64 = "arm64";
    private static final String ARCH_UNIVERSAL = "universal";
    private static final String OS_WINDOWS = "windows";
    private static final String OS_MACOS = "osx";
    private static final String OS_LINUX = "linux";

    DuckDBNative() {
    }

    private static void loadNativeLibrary() throws Exception {
        String libName = DuckDBNative.nativeLibName();
        URL libRes = DuckDBNative.class.getResource("/" + libName);
        if (null != libRes) {
            DuckDBNative.unpackAndLoad(libRes);
            return;
        }
        try {
            System.loadLibrary("duckdb_java");
        }
        catch (UnsatisfiedLinkError e) {
            try {
                DuckDBNative.loadFromCurrentJarDir(libName);
            }
            catch (Throwable t) {
                e.printStackTrace();
                throw new IllegalStateException(t);
            }
        }
    }

    private static String cpuArch() {
        String prop;
        switch (prop = System.getProperty("os.arch").toLowerCase().trim()) {
            case "x86_64": 
            case "amd64": {
                return ARCH_X86_64;
            }
            case "aarch64": 
            case "arm64": {
                return ARCH_AARCH64;
            }
        }
        throw new IllegalStateException("Unsupported system architecture: '" + prop + "'");
    }

    static String osName() {
        String prop = System.getProperty("os.name").toLowerCase().trim();
        if (prop.startsWith(OS_WINDOWS)) {
            return OS_WINDOWS;
        }
        if (prop.startsWith("mac")) {
            return OS_MACOS;
        }
        if (prop.startsWith(OS_LINUX)) {
            return OS_LINUX;
        }
        throw new IllegalStateException("Unsupported OS: '" + prop + "'");
    }

    static String nativeLibName() {
        String os = DuckDBNative.osName();
        String arch = OS_MACOS.equals(os) ? ARCH_UNIVERSAL : DuckDBNative.cpuArch();
        return "libduckdb_java.so_" + os + "_" + arch;
    }

    static Path currentJarDir() throws Exception {
        ProtectionDomain pd = DuckDBNative.class.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        URL loc = cs.getLocation();
        URI uri = loc.toURI();
        Path jarPath = Paths.get(uri);
        Path dirPath = jarPath.getParent();
        return dirPath.toRealPath(new LinkOption[0]);
    }

    private static void unpackAndLoad(URL nativeLibRes) throws IOException {
        Path tmpFile = Files.createTempFile("libduckdb_java", ".so", new FileAttribute[0]);
        try (InputStream is = nativeLibRes.openStream();){
            Files.copy(is, tmpFile, StandardCopyOption.REPLACE_EXISTING);
        }
        tmpFile.toFile().deleteOnExit();
        System.load(tmpFile.toAbsolutePath().toString());
    }

    private static void loadFromCurrentJarDir(String libName) throws Exception {
        Path dir = DuckDBNative.currentJarDir();
        Path libPath = dir.resolve(libName);
        if (!Files.exists(libPath, new LinkOption[0])) {
            throw new FileNotFoundException("DuckDB JNI library not found, path: '" + libPath.toAbsolutePath() + "'");
        }
        System.load(libPath.toAbsolutePath().toString());
    }

    static native ByteBuffer duckdb_jdbc_startup(byte[] var0, boolean var1, Properties var2) throws SQLException;

    static native ByteBuffer duckdb_jdbc_connect(ByteBuffer var0) throws SQLException;

    static native ByteBuffer duckdb_jdbc_create_db_ref(ByteBuffer var0) throws SQLException;

    static native void duckdb_jdbc_destroy_db_ref(ByteBuffer var0) throws SQLException;

    static native void duckdb_jdbc_set_auto_commit(ByteBuffer var0, boolean var1) throws SQLException;

    static native boolean duckdb_jdbc_get_auto_commit(ByteBuffer var0) throws SQLException;

    static native void duckdb_jdbc_disconnect(ByteBuffer var0);

    static native void duckdb_jdbc_set_schema(ByteBuffer var0, String var1);

    static native void duckdb_jdbc_set_catalog(ByteBuffer var0, String var1);

    static native String duckdb_jdbc_get_schema(ByteBuffer var0);

    static native String duckdb_jdbc_get_catalog(ByteBuffer var0);

    static native ByteBuffer duckdb_jdbc_prepare(ByteBuffer var0, byte[] var1) throws SQLException;

    static native void duckdb_jdbc_release(ByteBuffer var0);

    static native DuckDBResultSetMetaData duckdb_jdbc_query_result_meta(ByteBuffer var0) throws SQLException;

    static native DuckDBResultSetMetaData duckdb_jdbc_prepared_statement_meta(ByteBuffer var0) throws SQLException;

    static native ByteBuffer duckdb_jdbc_execute(ByteBuffer var0, Object[] var1) throws SQLException;

    static native void duckdb_jdbc_free_result(ByteBuffer var0);

    static native DuckDBVector[] duckdb_jdbc_fetch(ByteBuffer var0, ByteBuffer var1) throws SQLException;

    static native String[] duckdb_jdbc_cast_result_to_strings(ByteBuffer var0, ByteBuffer var1, long var2) throws SQLException;

    static native int duckdb_jdbc_fetch_size();

    static native long duckdb_jdbc_arrow_stream(ByteBuffer var0, long var1);

    static native void duckdb_jdbc_arrow_register(ByteBuffer var0, long var1, byte[] var3);

    static native ByteBuffer duckdb_jdbc_create_appender(ByteBuffer var0, byte[] var1, byte[] var2) throws SQLException;

    static native void duckdb_jdbc_appender_begin_row(ByteBuffer var0) throws SQLException;

    static native void duckdb_jdbc_appender_end_row(ByteBuffer var0) throws SQLException;

    static native void duckdb_jdbc_appender_flush(ByteBuffer var0) throws SQLException;

    static native void duckdb_jdbc_interrupt(ByteBuffer var0);

    static native QueryProgress duckdb_jdbc_query_progress(ByteBuffer var0);

    static native void duckdb_jdbc_appender_close(ByteBuffer var0) throws SQLException;

    static native void duckdb_jdbc_appender_append_boolean(ByteBuffer var0, boolean var1) throws SQLException;

    static native void duckdb_jdbc_appender_append_byte(ByteBuffer var0, byte var1) throws SQLException;

    static native void duckdb_jdbc_appender_append_short(ByteBuffer var0, short var1) throws SQLException;

    static native void duckdb_jdbc_appender_append_int(ByteBuffer var0, int var1) throws SQLException;

    static native void duckdb_jdbc_appender_append_long(ByteBuffer var0, long var1) throws SQLException;

    static native void duckdb_jdbc_appender_append_float(ByteBuffer var0, float var1) throws SQLException;

    static native void duckdb_jdbc_appender_append_double(ByteBuffer var0, double var1) throws SQLException;

    static native void duckdb_jdbc_appender_append_string(ByteBuffer var0, byte[] var1) throws SQLException;

    static native void duckdb_jdbc_appender_append_bytes(ByteBuffer var0, byte[] var1) throws SQLException;

    static native void duckdb_jdbc_appender_append_timestamp(ByteBuffer var0, long var1) throws SQLException;

    static native void duckdb_jdbc_appender_append_decimal(ByteBuffer var0, BigDecimal var1) throws SQLException;

    static native void duckdb_jdbc_appender_append_null(ByteBuffer var0) throws SQLException;

    static native void duckdb_jdbc_create_extension_type(ByteBuffer var0) throws SQLException;

    protected static native String duckdb_jdbc_get_profiling_information(ByteBuffer var0, ProfilerPrintFormat var1) throws SQLException;

    public static void duckdb_jdbc_create_extension_type(DuckDBConnection conn) throws SQLException {
        DuckDBNative.duckdb_jdbc_create_extension_type(conn.connRef);
    }

    static {
        try {
            DuckDBNative.loadNativeLibrary();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

