/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.collections;

import com.strobel.annotations.Nullable;
import com.strobel.collections.SatelliteCache;
import com.strobel.collections.ThreadLocalCache;
import com.strobel.collections.ThreadLocalIdentityCache;
import com.strobel.collections.TopLevelCache;
import com.strobel.core.VerifyArgument;

public abstract class Cache<K, V> {
    protected Cache() {
    }

    public boolean contains(K key) {
        return this.get(key) != null;
    }

    public boolean contains(K key, V value) {
        V cachedValue = this.get(key);
        return cachedValue != null && cachedValue.equals(value);
    }

    public abstract Cache<K, V> getSatelliteCache();

    public abstract boolean replace(K var1, @Nullable V var2, V var3);

    public abstract V get(K var1);

    public abstract V cache(K var1, V var2);

    public static <K, V> Cache<K, V> createTopLevelCache() {
        return new TopLevelCache();
    }

    public static <K, V> Cache<K, V> createSatelliteCache() {
        return new SatelliteCache();
    }

    public static <K, V> Cache<K, V> createSatelliteCache(Cache<K, V> parent) {
        return new SatelliteCache<K, V>(VerifyArgument.notNull(parent, "parent"));
    }

    public static <K, V> Cache<K, V> createSatelliteIdentityCache() {
        return new SatelliteCache();
    }

    public static <K, V> Cache<K, V> createSatelliteIdentityCache(Cache<K, V> parent) {
        return new SatelliteCache<K, V>(VerifyArgument.notNull(parent, "parent"));
    }

    public static <K, V> Cache<K, V> createThreadLocalCache() {
        return new ThreadLocalCache();
    }

    public static <K, V> Cache<K, V> createThreadLocalIdentityCache() {
        return new ThreadLocalCache();
    }

    public static <K, V> Cache<K, V> createThreadLocalCache(Cache<K, V> parent) {
        return new ThreadLocalCache<K, V>(VerifyArgument.notNull(parent, "parent"));
    }

    public static <K, V> Cache<K, V> createThreadLocalIdentityCache(Cache<K, V> parent) {
        return new ThreadLocalIdentityCache<K, V>(VerifyArgument.notNull(parent, "parent"));
    }
}

