/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import java.util.ArrayList;
import java.util.List;

public class RedshiftTokenizer {
    protected List<String> tokens;

    public RedshiftTokenizer(String string, char delim) {
        this.tokenize(string, delim);
    }

    public int tokenize(String string, char delim) {
        this.tokens = new ArrayList<String>();
        int nest = 0;
        boolean skipChar = false;
        boolean nestedDoubleQuote = false;
        int s = 0;
        for (int p = 0; p < string.length(); ++p) {
            char c = string.charAt(p);
            if (c == '(' || c == '[' || c == '<' || !nestedDoubleQuote && !skipChar && c == '\"') {
                ++nest;
                if (c == '\"') {
                    nestedDoubleQuote = true;
                    skipChar = true;
                }
            }
            if (c == ')' || c == ']' || c == '>' || nestedDoubleQuote && !skipChar && c == '\"') {
                --nest;
                if (c == '\"') {
                    nestedDoubleQuote = false;
                }
            }
            boolean bl = skipChar = c == '\\';
            if (nest != 0 || c != delim) continue;
            this.tokens.add(string.substring(s, p));
            s = p + 1;
        }
        if (s < string.length()) {
            this.tokens.add(string.substring(s));
        }
        return this.tokens.size();
    }

    public int getSize() {
        return this.tokens.size();
    }

    public String getToken(int n) {
        return this.tokens.get(n);
    }

    public RedshiftTokenizer tokenizeToken(int n, char delim) {
        return new RedshiftTokenizer(this.getToken(n), delim);
    }

    public static String remove(String s, String l, String t) {
        if (s.startsWith(l)) {
            s = s.substring(l.length());
        }
        if (s.endsWith(t)) {
            s = s.substring(0, s.length() - t.length());
        }
        return s;
    }

    public void remove(String l, String t) {
        for (int i = 0; i < this.tokens.size(); ++i) {
            this.tokens.set(i, RedshiftTokenizer.remove(this.tokens.get(i), l, t));
        }
    }

    public static String removePara(String s) {
        return RedshiftTokenizer.remove(s, "(", ")");
    }

    public void removePara() {
        this.remove("(", ")");
    }

    public static String removeBox(String s) {
        return RedshiftTokenizer.remove(s, "[", "]");
    }

    public void removeBox() {
        this.remove("[", "]");
    }

    public static String removeAngle(String s) {
        return RedshiftTokenizer.remove(s, "<", ">");
    }

    public void removeAngle() {
        this.remove("<", ">");
    }

    public static String removeCurlyBrace(String s) {
        return RedshiftTokenizer.remove(s, "{", "}");
    }

    public void removeCurlyBrace() {
        this.remove("{", "}");
    }
}

