/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.exceptions.NotLoadedException;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import us.fatehi.utility.property.PropertyName;

class LinterNullColumnsInIndex
extends BaseLinter {
    LinterNullColumnsInIndex(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
    }

    @Override
    public String getSummary() {
        return "unique index with nullable columns";
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        List<Index> nullableColumnsInUniqueIndex = this.findNullableColumnsInUniqueIndex(table.getIndexes());
        for (Index index : nullableColumnsInUniqueIndex) {
            this.addTableLint(table, this.getSummary(), index);
        }
    }

    private List<Index> findNullableColumnsInUniqueIndex(Collection<Index> indexes) {
        ArrayList<Index> nullableColumnsInUniqueIndex = new ArrayList<Index>();
        block2: for (Index index : indexes) {
            if (!index.isUnique()) continue;
            for (IndexColumn indexColumn : index) {
                try {
                    if (!indexColumn.isNullable() || indexColumn.isGenerated()) continue;
                    nullableColumnsInUniqueIndex.add(index);
                    continue block2;
                }
                catch (NotLoadedException e) {
                }
            }
        }
        return nullableColumnsInUniqueIndex;
    }
}

