﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint/Pinpoint_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Pinpoint {
namespace Model {

/**
 * <p>Specifies the subject or body of an email message, represented as textual
 * email data and the applicable character set.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SimpleEmailPart">AWS
 * API Reference</a></p>
 */
class SimpleEmailPart {
 public:
  AWS_PINPOINT_API SimpleEmailPart() = default;
  AWS_PINPOINT_API SimpleEmailPart(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINT_API SimpleEmailPart& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PINPOINT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The applicable character set for the message content.</p>
   */
  inline const Aws::String& GetCharset() const { return m_charset; }
  inline bool CharsetHasBeenSet() const { return m_charsetHasBeenSet; }
  template <typename CharsetT = Aws::String>
  void SetCharset(CharsetT&& value) {
    m_charsetHasBeenSet = true;
    m_charset = std::forward<CharsetT>(value);
  }
  template <typename CharsetT = Aws::String>
  SimpleEmailPart& WithCharset(CharsetT&& value) {
    SetCharset(std::forward<CharsetT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The textual data of the message content.</p>
   */
  inline const Aws::String& GetData() const { return m_data; }
  inline bool DataHasBeenSet() const { return m_dataHasBeenSet; }
  template <typename DataT = Aws::String>
  void SetData(DataT&& value) {
    m_dataHasBeenSet = true;
    m_data = std::forward<DataT>(value);
  }
  template <typename DataT = Aws::String>
  SimpleEmailPart& WithData(DataT&& value) {
    SetData(std::forward<DataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_charset;

  Aws::String m_data;
  bool m_charsetHasBeenSet = false;
  bool m_dataHasBeenSet = false;
};

}  // namespace Model
}  // namespace Pinpoint
}  // namespace Aws
