﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces/WorkSpacesRequest.h>
#include <aws/workspaces/WorkSpaces_EXPORTS.h>

#include <utility>

namespace Aws {
namespace WorkSpaces {
namespace Model {

/**
 */
class GetAccountLinkRequest : public WorkSpacesRequest {
 public:
  AWS_WORKSPACES_API GetAccountLinkRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetAccountLink"; }

  AWS_WORKSPACES_API Aws::String SerializePayload() const override;

  AWS_WORKSPACES_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The identifier of the account to link.</p>
   */
  inline const Aws::String& GetLinkId() const { return m_linkId; }
  inline bool LinkIdHasBeenSet() const { return m_linkIdHasBeenSet; }
  template <typename LinkIdT = Aws::String>
  void SetLinkId(LinkIdT&& value) {
    m_linkIdHasBeenSet = true;
    m_linkId = std::forward<LinkIdT>(value);
  }
  template <typename LinkIdT = Aws::String>
  GetAccountLinkRequest& WithLinkId(LinkIdT&& value) {
    SetLinkId(std::forward<LinkIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the account link</p>
   */
  inline const Aws::String& GetLinkedAccountId() const { return m_linkedAccountId; }
  inline bool LinkedAccountIdHasBeenSet() const { return m_linkedAccountIdHasBeenSet; }
  template <typename LinkedAccountIdT = Aws::String>
  void SetLinkedAccountId(LinkedAccountIdT&& value) {
    m_linkedAccountIdHasBeenSet = true;
    m_linkedAccountId = std::forward<LinkedAccountIdT>(value);
  }
  template <typename LinkedAccountIdT = Aws::String>
  GetAccountLinkRequest& WithLinkedAccountId(LinkedAccountIdT&& value) {
    SetLinkedAccountId(std::forward<LinkedAccountIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_linkId;

  Aws::String m_linkedAccountId;
  bool m_linkIdHasBeenSet = false;
  bool m_linkedAccountIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpaces
}  // namespace Aws
