/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class DoubleValue
extends ASTNodeAccessImpl
implements Expression {
    private Double value;
    private String stringValue;

    public DoubleValue() {
    }

    public DoubleValue(String value) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("value can neither be null nor empty.");
        }
        String val = value;
        if (val.charAt(0) == '+') {
            val = val.substring(1);
        }
        this.value = Double.parseDouble(val);
        this.stringValue = val;
    }

    public DoubleValue(double value) {
        this.value = value;
        this.stringValue = String.valueOf(value);
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(Double d) {
        this.value = d;
        this.stringValue = String.valueOf(this.value);
    }

    @Override
    public String toString() {
        return this.stringValue;
    }

    public DoubleValue withValue(Double value) {
        this.setValue(value);
        return this;
    }
}

